/*
 * Decompiled with CFR 0.152.
 */
package org.egov.wtms.integration;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.egov.infra.filestore.entity.FileStoreMapper;
import org.egov.infra.filestore.service.FileStoreService;
import org.egov.wtms.application.entity.WaterConnectionDetails;
import org.egov.wtms.application.service.WaterConnectionDetailsService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public class WaterChargesThirdPartyService {
    @Autowired
    @Qualifier(value="fileStoreService")
    protected FileStoreService fileStoreService;
    private final WaterConnectionDetailsService waterConnectionDetailsService;

    @Autowired
    public WaterChargesThirdPartyService(WaterConnectionDetailsService waterConnectionDetailsService) {
        this.waterConnectionDetailsService = waterConnectionDetailsService;
    }

    public byte[] getEstimationNotice(String applicationNo) throws IOException {
        WaterConnectionDetails waterConnectionDetails = null;
        if (StringUtils.isNotBlank((CharSequence)applicationNo)) {
            waterConnectionDetails = this.waterConnectionDetailsService.findByApplicationNumber(applicationNo);
        }
        if (waterConnectionDetails != null && waterConnectionDetails.getFileStore() != null) {
            FileStoreMapper fsm = waterConnectionDetails.getFileStore();
            File file = this.fileStoreService.fetch(fsm, "WTMS");
            return FileUtils.readFileToByteArray((File)file);
        }
        return null;
    }

    public Map<String, String> validateWaterConnectionStatus(String applicationNo) {
        WaterConnectionDetails waterConnectionDetails = this.waterConnectionDetailsService.findByApplicationNumber(applicationNo);
        HashMap<String, String> statusCommentsMap = new HashMap<String, String>();
        if (waterConnectionDetails.getStatus().getCode().equals("CREATED") || waterConnectionDetails.getStatus().getCode().equals("VERIFIED") || waterConnectionDetails.getStatus().getCode().equals("ESTIMATIONNOTICEGENERATED") || waterConnectionDetails.getStatus().getCode().equals("ESTIMATIONAMOUNTPAID")) {
            statusCommentsMap.put("status", "OPEN");
            statusCommentsMap.put("comments", waterConnectionDetails.getState().getComments());
            statusCommentsMap.put("updatedBy", waterConnectionDetails.getState().getLastModifiedBy().getName());
        } else if (waterConnectionDetails.getStatus().getCode().equals("SANCTIONED")) {
            statusCommentsMap.put("status", "APPROVED");
            statusCommentsMap.put("comments", waterConnectionDetails.getState().getComments());
            statusCommentsMap.put("updatedBy", waterConnectionDetails.getState().getLastModifiedBy().getName());
        } else if (waterConnectionDetails.getStatus().getCode().equals("CANCELLED")) {
            statusCommentsMap.put("status", "Rejected");
            statusCommentsMap.put("comments", waterConnectionDetails.getState().getComments());
            statusCommentsMap.put("updatedBy", waterConnectionDetails.getState().getLastModifiedBy().getName());
        }
        return statusCommentsMap;
    }
}

