/*
 * Decompiled with CFR 0.152.
 */
package org.egov.wtms.autonumber.impl;

import java.io.Serializable;
import org.egov.infra.persistence.utils.ApplicationSequenceNumberGenerator;
import org.egov.wtms.autonumber.BillReferenceNumberGenerator;
import org.egov.wtms.utils.WaterTaxUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BillReferenceNumberGeneratorImpl
implements BillReferenceNumberGenerator {
    @Autowired
    private ApplicationSequenceNumberGenerator applicationSequenceNumberGenerator;
    @Autowired
    private WaterTaxUtils waterTaxUtils;

    @Override
    public String generateBillNumber(String installmentYear) {
        String sequenceName = "SEQ_BILLNO_" + installmentYear;
        Serializable nextSequence = this.applicationSequenceNumberGenerator.getNextSequence(sequenceName);
        return String.format("%s%06d", this.waterTaxUtils.getCityCode(), nextSequence);
    }
}

