/*
 * Decompiled with CFR 0.152.
 */
package org.egov.wtms.application.service;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.validation.ValidationException;
import org.egov.commons.EgModules;
import org.egov.commons.Installment;
import org.egov.commons.entity.Source;
import org.egov.demand.model.EgDemand;
import org.egov.eis.entity.Assignment;
import org.egov.eis.entity.AssignmentAdaptor;
import org.egov.eis.service.AssignmentService;
import org.egov.eis.service.EisCommonService;
import org.egov.infra.admin.master.entity.User;
import org.egov.infra.admin.master.service.UserService;
import org.egov.infra.config.core.ApplicationThreadLocals;
import org.egov.infra.config.persistence.datasource.routing.annotation.ReadOnly;
import org.egov.infra.elasticsearch.entity.ApplicationIndex;
import org.egov.infra.elasticsearch.entity.enums.ApprovalStatus;
import org.egov.infra.elasticsearch.entity.enums.ClosureStatus;
import org.egov.infra.elasticsearch.service.ApplicationIndexService;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infra.filestore.entity.FileStoreMapper;
import org.egov.infra.filestore.service.FileStoreService;
import org.egov.infra.persistence.entity.enums.UserType;
import org.egov.infra.reporting.engine.ReportOutput;
import org.egov.infra.security.utils.SecurityUtils;
import org.egov.infra.utils.ApplicationNumberGenerator;
import org.egov.infra.workflow.entity.State;
import org.egov.infra.workflow.entity.StateHistory;
import org.egov.infra.workflow.matrix.entity.WorkFlowMatrix;
import org.egov.infra.workflow.service.SimpleWorkflowService;
import org.egov.pims.commons.Position;
import org.egov.ptis.domain.model.AssessmentDetails;
import org.egov.ptis.domain.model.OwnerName;
import org.egov.ptis.domain.model.enums.BasicPropertyStatus;
import org.egov.ptis.domain.service.property.PropertyExternalService;
import org.egov.wtms.application.entity.ApplicationDocuments;
import org.egov.wtms.application.entity.WaterConnection;
import org.egov.wtms.application.entity.WaterConnectionDetails;
import org.egov.wtms.application.repository.WaterConnectionDetailsRepository;
import org.egov.wtms.application.service.ConnectionDemandService;
import org.egov.wtms.application.service.WaterConnectionSmsAndEmailService;
import org.egov.wtms.application.workflow.ApplicationWorkflowCustomDefaultImpl;
import org.egov.wtms.entity.es.WaterChargeDocument;
import org.egov.wtms.masters.entity.ApplicationType;
import org.egov.wtms.masters.entity.DocumentNames;
import org.egov.wtms.masters.entity.DonationDetails;
import org.egov.wtms.masters.entity.WaterRatesDetails;
import org.egov.wtms.masters.entity.enums.ConnectionStatus;
import org.egov.wtms.masters.entity.enums.ConnectionType;
import org.egov.wtms.masters.service.ApplicationProcessTimeService;
import org.egov.wtms.masters.service.ApplicationTypeService;
import org.egov.wtms.masters.service.DocumentNamesService;
import org.egov.wtms.service.es.WaterChargeDocumentService;
import org.egov.wtms.utils.PropertyExtnUtils;
import org.egov.wtms.utils.WaterTaxNumberGenerator;
import org.egov.wtms.utils.WaterTaxUtils;
import org.hibernate.Query;
import org.hibernate.Session;
import org.jfree.util.Log;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.ApplicationContext;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class WaterConnectionDetailsService {
    private static final String WTMS_APPLICATION_VIEW = "/wtms/application/view/%s";
    protected WaterConnectionDetailsRepository waterConnectionDetailsRepository;
    private static final Logger LOG = LoggerFactory.getLogger(WaterConnectionDetailsService.class);
    @PersistenceContext
    private EntityManager entityManager;
    @Autowired
    private UserService userService;
    @Autowired
    private ApplicationNumberGenerator applicationNumberGenerator;
    @Autowired
    private ApplicationTypeService applicationTypeService;
    @Autowired
    @Qualifier(value="workflowService")
    private SimpleWorkflowService<WaterConnectionDetails> waterConnectionWorkflowService;
    @Autowired
    private ApplicationProcessTimeService applicationProcessTimeService;
    @Autowired
    private ApplicationIndexService applicationIndexService;
    @Autowired
    private DocumentNamesService documentNamesService;
    @Autowired
    private ApplicationContext context;
    @Autowired
    private PropertyExtnUtils propertyExtnUtils;
    @Autowired
    private EisCommonService eisCommonService;
    @Autowired
    private SecurityUtils securityUtils;
    @Autowired
    private AssignmentService assignmentService;
    @Autowired
    private WaterTaxNumberGenerator waterTaxNumberGenerator;
    @Autowired
    private WaterChargeDocumentService waterChargeIndexService;
    @Autowired
    private WaterTaxUtils waterTaxUtils;
    @Autowired
    private ConnectionDemandService connectionDemandService;
    @Autowired
    private WaterConnectionSmsAndEmailService waterConnectionSmsAndEmailService;
    @Autowired
    @Qualifier(value="fileStoreService")
    protected FileStoreService fileStoreService;

    @Autowired
    public WaterConnectionDetailsService(WaterConnectionDetailsRepository waterConnectionDetailsRepository) {
        this.waterConnectionDetailsRepository = waterConnectionDetailsRepository;
    }

    public WaterConnectionDetails findBy(Long waterConnectionId) {
        return (WaterConnectionDetails)((Object)this.waterConnectionDetailsRepository.findOne(waterConnectionId));
    }

    public List<WaterConnectionDetails> findAll() {
        return this.waterConnectionDetailsRepository.findAll(new Sort(Sort.Direction.ASC, new String[]{"applicationNumber"}));
    }

    public WaterConnectionDetails findByApplicationNumber(String applicationNumber) {
        return this.waterConnectionDetailsRepository.findByApplicationNumber(applicationNumber);
    }

    public WaterConnectionDetails load(Long id) {
        return (WaterConnectionDetails)((Object)this.waterConnectionDetailsRepository.getOne(id));
    }

    public Session getCurrentSession() {
        return (Session)this.entityManager.unwrap(Session.class);
    }

    public Page<WaterConnectionDetails> getListWaterConnectionDetails(Integer pageNumber, Integer pageSize) {
        PageRequest pageable = new PageRequest(pageNumber - 1, pageSize.intValue(), Sort.Direction.ASC, new String[]{"applicationNumber"});
        return this.waterConnectionDetailsRepository.findAll((Pageable)pageable);
    }

    @Transactional
    public WaterConnectionDetails createNewWaterConnection(WaterConnectionDetails waterConnectionDetails, Long approvalPosition, String approvalComent, String additionalRule, String workFlowAction, String sourceChannel) {
        if (waterConnectionDetails.getApplicationNumber() == null) {
            waterConnectionDetails.setApplicationNumber(this.applicationNumberGenerator.generate());
        }
        waterConnectionDetails.setApplicationDate(new Date());
        Integer appProcessTime = this.applicationProcessTimeService.getApplicationProcessTime(waterConnectionDetails.getApplicationType(), waterConnectionDetails.getCategory());
        if (appProcessTime != null) {
            waterConnectionDetails.setDisposalDate(this.getDisposalDate(waterConnectionDetails, appProcessTime));
        }
        WaterConnectionDetails savedWaterConnectionDetails = (WaterConnectionDetails)((Object)this.waterConnectionDetailsRepository.save((Object)waterConnectionDetails));
        User meesevaUser = this.userService.getUserById(waterConnectionDetails.getCreatedBy().getId());
        if (meesevaUser.getUsername().equals("meeseva")) {
            ApplicationThreadLocals.setUserId((Long)meesevaUser.getId());
            savedWaterConnectionDetails.setCreatedBy(meesevaUser);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(" persisting WaterConnectionDetail object is completed and WorkFlow API Stared ");
        }
        ApplicationWorkflowCustomDefaultImpl applicationWorkflowCustomDefaultImpl = this.getInitialisedWorkFlowBean();
        if (LOG.isDebugEnabled()) {
            LOG.debug("applicationWorkflowCustomDefaultImpl initialization is done");
        }
        applicationWorkflowCustomDefaultImpl.createCommonWorkflowTransition(savedWaterConnectionDetails, approvalPosition, approvalComent, additionalRule, workFlowAction);
        this.updateIndexes(savedWaterConnectionDetails, sourceChannel);
        this.waterConnectionSmsAndEmailService.sendSmsAndEmail(waterConnectionDetails, workFlowAction);
        if (LOG.isDebugEnabled()) {
            LOG.debug("updating water Connection Deatail is completed");
        }
        return savedWaterConnectionDetails;
    }

    @Transactional
    public WaterConnectionDetails createExisting(WaterConnectionDetails waterConnectionDetails) {
        if (waterConnectionDetails.getConnection() != null && waterConnectionDetails.getConnection().getConsumerCode() == null) {
            waterConnectionDetails.getConnection().setConsumerCode(this.waterTaxNumberGenerator.getNextConsumerNumber());
        }
        waterConnectionDetails.getExistingConnection().setWaterConnectionDetails(waterConnectionDetails);
        waterConnectionDetails.setApplicationNumber(waterConnectionDetails.getConnection().getConsumerCode());
        waterConnectionDetails.setApplicationDate(waterConnectionDetails.getExecutionDate());
        waterConnectionDetails.setStatus(this.waterTaxUtils.getStatusByCodeAndModuleType("SANCTIONED", "WATERTAXAPPLICATION"));
        if (waterConnectionDetails.getApplicationType().getCode().equalsIgnoreCase("ADDNLCONNECTION")) {
            WaterConnectionDetails primaryConnectionDetails = this.getPrimaryConnectionDetailsByPropertyIdentifier(waterConnectionDetails.getConnection().getPropertyIdentifier());
            waterConnectionDetails.getConnection().setParentConnection(primaryConnectionDetails.getConnection());
        }
        WaterConnectionDetails savedWaterConnectionDetails = (WaterConnectionDetails)((Object)this.waterConnectionDetailsRepository.save((Object)waterConnectionDetails));
        this.updateConsumerIndex(savedWaterConnectionDetails);
        return savedWaterConnectionDetails;
    }

    public List<ConnectionType> getAllConnectionTypes() {
        return Arrays.asList(ConnectionType.values());
    }

    public Map<String, String> getConnectionTypesMap() {
        LinkedHashMap<String, String> connectionTypeMap = new LinkedHashMap<String, String>(0);
        connectionTypeMap.put(ConnectionType.METERED.toString(), "Metered");
        connectionTypeMap.put(ConnectionType.NON_METERED.toString(), "Non-metered");
        return connectionTypeMap;
    }

    public List<DocumentNames> getAllActiveDocumentNames(ApplicationType applicationType) {
        return this.documentNamesService.getAllActiveDocumentNamesByApplicationType(applicationType);
    }

    public WaterConnectionDetails findByApplicationNumberOrConsumerCodeAndStatus(String number, ConnectionStatus connectionStatus) {
        return this.waterConnectionDetailsRepository.findConnectionDetailsByApplicationNumberOrConsumerCodeAndConnectionStatus(number, number, connectionStatus);
    }

    public WaterConnectionDetails findByApplicationNumberOrConsumerCode(String number) {
        return this.waterConnectionDetailsRepository.findConnectionDetailsByApplicationNumberOrConsumerCode(number, number);
    }

    public WaterConnectionDetails findByConnection(WaterConnection waterConnection) {
        return this.waterConnectionDetailsRepository.findByConnection(waterConnection);
    }

    public WaterConnectionDetails findByConsumerCodeAndConnectionStatus(String consumerCode, ConnectionStatus connectionStatus) {
        return this.waterConnectionDetailsRepository.findConnectionDetailsByConsumerCodeAndConnectionStatus(consumerCode, connectionStatus);
    }

    public WaterConnectionDetails findParentConnectionDetailsByConsumerCodeAndConnectionStatus(String consumerCode, ConnectionStatus connectionStatus) {
        return this.waterConnectionDetailsRepository.findParentConnectionDetailsByConsumerCodeAndConnectionStatus(consumerCode, connectionStatus);
    }

    public WaterConnectionDetails findByOldConsumerNumberAndConnectionStatus(String oldConsumerNumber, ConnectionStatus connectionStatus) {
        return this.waterConnectionDetailsRepository.findByConnectionOldConsumerNumberAndConnectionStatus(oldConsumerNumber, connectionStatus);
    }

    public WaterConnectionDetails getActiveConnectionDetailsByConnection(WaterConnection waterConnection) {
        return this.waterConnectionDetailsRepository.findByConnectionAndConnectionStatus(waterConnection, ConnectionStatus.ACTIVE);
    }

    public WaterConnectionDetails getPrimaryConnectionDetailsByPropertyIdentifier(String propertyIdentifier) {
        return this.waterConnectionDetailsRepository.getPrimaryConnectionDetailsByPropertyID(propertyIdentifier);
    }

    public WaterConnectionDetails getPrimaryConnectionDetailsByPropertyAssessmentNumbers(List<String> propertyIdentifier) {
        String assessmentNumber;
        WaterConnectionDetails waterConnectionDetails = null;
        Iterator<String> iterator = propertyIdentifier.iterator();
        while (iterator.hasNext() && (waterConnectionDetails = this.waterConnectionDetailsRepository.getPrimaryConnectionDetailsByPropertyAssessmentNumber(assessmentNumber = iterator.next())) == null) {
        }
        return waterConnectionDetails;
    }

    public List<WaterConnectionDetails> getChildConnectionDetailsByPropertyID(String propertyIdentifier) {
        return this.waterConnectionDetailsRepository.getChildConnectionDetailsByPropertyID(propertyIdentifier);
    }

    public List<WaterConnectionDetails> getAllConnectionDetailsByParentConnection(Long parentId) {
        return this.waterConnectionDetailsRepository.getAllConnectionDetailsByParentConnection(parentId);
    }

    public List<WaterConnectionDetails> getAllConnectionDetailsExceptInactiveStatusByPropertyID(String propertyIdentifier) {
        return this.waterConnectionDetailsRepository.getAllConnectionDetailsExceptInactiveStatusByPropertyID(propertyIdentifier);
    }

    @ReadOnly
    public List<HashMap<String, Object>> getHistory(WaterConnectionDetails waterConnectionDetails) {
        ArrayList<HashMap<String, Object>> historyTable = new ArrayList<HashMap<String, Object>>(0);
        State state = waterConnectionDetails.getState();
        HashMap<String, Object> map = new HashMap<String, Object>(0);
        if (null != state) {
            map.put("date", state.getDateInfo());
            map.put("comments", state.getComments() != null ? state.getComments() : "");
            map.put("updatedBy", state.getLastModifiedBy().getUsername() + "::" + state.getLastModifiedBy().getName());
            map.put("status", state.getValue());
            Position ownerPosition = state.getOwnerPosition();
            User user = state.getOwnerUser();
            if (null != user) {
                map.put("user", user.getUsername() + "::" + user.getName());
                map.put("department", null != this.eisCommonService.getDepartmentForUser(user.getId()) ? this.eisCommonService.getDepartmentForUser(user.getId()).getName() : "");
            } else if (null != ownerPosition && null != ownerPosition.getDeptDesig()) {
                user = this.eisCommonService.getUserForPosition(ownerPosition.getId(), new Date());
                map.put("user", null != user.getUsername() ? user.getUsername() + "::" + user.getName() : "");
                map.put("department", null != ownerPosition.getDeptDesig().getDepartment() ? ownerPosition.getDeptDesig().getDepartment().getName() : "");
            }
            historyTable.add(map);
            if (!waterConnectionDetails.getStateHistory().isEmpty() && waterConnectionDetails.getStateHistory() != null) {
                Collections.reverse(waterConnectionDetails.getStateHistory());
            }
            for (StateHistory stateHistory : waterConnectionDetails.getStateHistory()) {
                HashMap<String, Object> historyMap = new HashMap<String, Object>(0);
                historyMap.put("date", stateHistory.getDateInfo());
                historyMap.put("comments", stateHistory.getComments() != null ? stateHistory.getComments() : "");
                historyMap.put("updatedBy", stateHistory.getLastModifiedBy().getUsername() + "::" + stateHistory.getLastModifiedBy().getName());
                historyMap.put("status", stateHistory.getValue());
                Position owner = stateHistory.getOwnerPosition();
                user = stateHistory.getOwnerUser();
                if (null != user) {
                    historyMap.put("user", user.getUsername() + "::" + user.getName());
                    historyMap.put("department", null != this.eisCommonService.getDepartmentForUser(user.getId()) ? this.eisCommonService.getDepartmentForUser(user.getId()).getName() : "");
                } else if (null != owner && null != owner.getDeptDesig()) {
                    try {
                        user = this.eisCommonService.getUserForPosition(owner.getId(), stateHistory.getCreatedDate());
                    }
                    catch (ApplicationRuntimeException e) {
                        if (Log.isErrorEnabled()) {
                            Log.error((Object)("Exception while getting history of record :" + (Object)((Object)e)));
                        }
                        throw new ApplicationRuntimeException("err.user.not.found");
                    }
                    historyMap.put("user", null != user.getUsername() ? user.getUsername() + "::" + user.getName() : "");
                    historyMap.put("department", null != owner.getDeptDesig().getDepartment() ? owner.getDeptDesig().getDepartment().getName() : "");
                }
                historyTable.add(historyMap);
            }
        }
        return historyTable;
    }

    @Transactional
    public WaterConnectionDetails updateWaterConnection(WaterConnectionDetails waterConnectionDetails, Long approvalPosition, String approvalComent, String additionalRule, String workFlowAction, String mode, ReportOutput reportOutput, String sourceChannel) throws ValidationException {
        this.applicationStatusChange(waterConnectionDetails, workFlowAction, mode, sourceChannel);
        if ("CLOSUREDIGSIGNPENDING".equals(waterConnectionDetails.getStatus().getCode()) && waterConnectionDetails.getCloseConnectionType() != null && workFlowAction.equals("Approve")) {
            waterConnectionDetails.setApplicationType(this.applicationTypeService.findByCode("CLOSINGCONNECTION"));
            waterConnectionDetails.setCloseApprovalDate(new Date());
        }
        if ("RECONNDIGSIGNPENDING".equals(waterConnectionDetails.getStatus().getCode()) && waterConnectionDetails.getCloseConnectionType().equals("T") && waterConnectionDetails.getReConnectionReason() != null && workFlowAction.equals("Approve")) {
            waterConnectionDetails.setApplicationType(this.applicationTypeService.findByCode("RECONNECTION"));
            waterConnectionDetails.setConnectionStatus(ConnectionStatus.ACTIVE);
            waterConnectionDetails.setReconnectionApprovalDate(new Date());
            if (ConnectionType.NON_METERED.equals((Object)waterConnectionDetails.getConnectionType())) {
                Boolean reconnInSameInstallment;
                Installment nonMeterReconnInstallment;
                if (this.checkTwoDatesAreInSameInstallment(waterConnectionDetails).booleanValue()) {
                    Installment nonMeterCurrentInstallment = this.connectionDemandService.getCurrentInstallment("Property Tax", null, waterConnectionDetails.getReconnectionApprovalDate());
                    Calendar cal = Calendar.getInstance();
                    cal.setTime(nonMeterCurrentInstallment.getToDate());
                    cal.add(5, 1);
                    Date newDateForNextInstall = cal.getTime();
                    nonMeterReconnInstallment = this.connectionDemandService.getCurrentInstallment("Property Tax", null, newDateForNextInstall);
                    reconnInSameInstallment = Boolean.TRUE;
                } else {
                    nonMeterReconnInstallment = this.connectionDemandService.getCurrentInstallment("Property Tax", null, waterConnectionDetails.getReconnectionApprovalDate());
                    reconnInSameInstallment = Boolean.FALSE;
                }
                this.connectionDemandService.updateDemandForNonmeteredConnection(waterConnectionDetails, nonMeterReconnInstallment, reconnInSameInstallment, null);
            }
            this.updateIndexes(waterConnectionDetails, sourceChannel);
        }
        if (ConnectionType.NON_METERED.equals((Object)waterConnectionDetails.getConnectionType()) && "SANCTIONED".equalsIgnoreCase(waterConnectionDetails.getStatus().getCode())) {
            this.connectionDemandService.updateDemandForNonmeteredConnection(waterConnectionDetails, null, null, workFlowAction);
            this.updateIndexes(waterConnectionDetails, sourceChannel);
        }
        if (workFlowAction != null && workFlowAction.equalsIgnoreCase("Sign") && reportOutput != null) {
            String fileName = "SN/" + waterConnectionDetails.getWorkOrderNumber() + ".pdf";
            ByteArrayInputStream fileStream = new ByteArrayInputStream(reportOutput.getReportOutputData());
            FileStoreMapper fileStore = this.fileStoreService.store((InputStream)fileStream, fileName, "application/pdf", "WTMS");
            waterConnectionDetails.setFileStore(fileStore);
        }
        WaterConnectionDetails updatedWaterConnectionDetails = (WaterConnectionDetails)((Object)this.waterConnectionDetailsRepository.save((Object)waterConnectionDetails));
        ApplicationWorkflowCustomDefaultImpl applicationWorkflowCustomDefaultImpl = this.getInitialisedWorkFlowBean();
        if (waterConnectionDetails.getCloseConnectionType() != null) {
            additionalRule = "CLOSECONNECTION";
        }
        if (waterConnectionDetails.getReConnectionReason() != null) {
            additionalRule = "RECONNECTION";
        }
        applicationWorkflowCustomDefaultImpl.createCommonWorkflowTransition(updatedWaterConnectionDetails, approvalPosition, approvalComent, additionalRule, workFlowAction);
        if (waterConnectionDetails.getCloseConnectionType() != null && waterConnectionDetails.getReConnectionReason() == null && waterConnectionDetails.getStatus().getCode().equals("CANCELLED") && waterConnectionDetails.getConnectionStatus().equals((Object)ConnectionStatus.INACTIVE)) {
            waterConnectionDetails.setStatus(this.waterTaxUtils.getStatusByCodeAndModuleType("SANCTIONED", "WATERTAXAPPLICATION"));
            waterConnectionDetails.setConnectionStatus(ConnectionStatus.ACTIVE);
            waterConnectionDetails.setCloseConnectionType(null);
            waterConnectionDetails.setCloseconnectionreason(null);
            waterConnectionDetails.setApplicationType(this.applicationTypeService.findByCode(waterConnectionDetails.getPreviousApplicationType()));
            this.updateIndexes(waterConnectionDetails, sourceChannel);
            updatedWaterConnectionDetails = (WaterConnectionDetails)((Object)this.waterConnectionDetailsRepository.save((Object)waterConnectionDetails));
        }
        if (waterConnectionDetails.getReConnectionReason() != null && waterConnectionDetails.getCloseConnectionType() == "T" && waterConnectionDetails.getStatus().getCode().equals("CANCELLED") && waterConnectionDetails.getConnectionStatus().equals((Object)ConnectionStatus.INACTIVE)) {
            waterConnectionDetails.setStatus(this.waterTaxUtils.getStatusByCodeAndModuleType("CLOSERSANCTIONED", "WATERTAXAPPLICATION"));
            waterConnectionDetails.setConnectionStatus(ConnectionStatus.CLOSED);
            waterConnectionDetails.setReConnectionReason(null);
            waterConnectionDetails.setApplicationType(this.applicationTypeService.findByCode("CLOSINGCONNECTION"));
            this.updateIndexes(waterConnectionDetails, sourceChannel);
            updatedWaterConnectionDetails = (WaterConnectionDetails)((Object)this.waterConnectionDetailsRepository.save((Object)waterConnectionDetails));
        }
        if (!workFlowAction.equalsIgnoreCase("Reject")) {
            this.waterConnectionSmsAndEmailService.sendSmsAndEmail(waterConnectionDetails, workFlowAction);
        }
        this.updateIndexes(waterConnectionDetails, sourceChannel);
        return updatedWaterConnectionDetails;
    }

    public ApplicationWorkflowCustomDefaultImpl getInitialisedWorkFlowBean() {
        ApplicationWorkflowCustomDefaultImpl applicationWorkflowCustomDefaultImpl = null;
        if (null != this.context) {
            applicationWorkflowCustomDefaultImpl = (ApplicationWorkflowCustomDefaultImpl)this.context.getBean("applicationWorkflowCustomDefaultImpl");
        }
        return applicationWorkflowCustomDefaultImpl;
    }

    public Boolean checkTwoDatesAreInSameInstallment(WaterConnectionDetails waterConnectionDetails) {
        Boolean dateInSameInstallment = Boolean.FALSE;
        Installment nonMeterClosedInstallment = this.connectionDemandService.getCurrentInstallment("Property Tax", null, waterConnectionDetails.getCloseApprovalDate());
        Installment nonMeterReconnInstallment = this.connectionDemandService.getCurrentInstallment("Property Tax", null, waterConnectionDetails.getReconnectionApprovalDate());
        if (nonMeterClosedInstallment.getDescription().equals(nonMeterReconnInstallment.getDescription())) {
            dateInSameInstallment = Boolean.TRUE;
        }
        return dateInSameInstallment;
    }

    public void applicationStatusChange(WaterConnectionDetails waterConnectionDetails, String workFlowAction, String mode, String sourceChannel) {
        if (null != waterConnectionDetails && null != waterConnectionDetails.getStatus() && null != waterConnectionDetails.getStatus().getCode()) {
            if (waterConnectionDetails.getStatus().getCode().equals("CREATED") && waterConnectionDetails.getState() != null && "Submit".equals(workFlowAction)) {
                waterConnectionDetails.setStatus(this.waterTaxUtils.getStatusByCodeAndModuleType("VERIFIED", "WATERTAXAPPLICATION"));
            } else if (workFlowAction.equals("Generate Estimation Notice") && waterConnectionDetails.getStatus().getCode().equals("VERIFIED")) {
                waterConnectionDetails.setStatus(this.waterTaxUtils.getStatusByCodeAndModuleType("ESTIMATIONNOTICEGENERATED", "WATERTAXAPPLICATION"));
            } else if (waterConnectionDetails.getStatus().getCode().equals("ESTIMATIONAMOUNTPAID") && workFlowAction.equalsIgnoreCase("Approve")) {
                if (waterConnectionDetails.getConnection().getConsumerCode() == null) {
                    waterConnectionDetails.getConnection().setConsumerCode(this.waterTaxNumberGenerator.getNextConsumerNumber());
                }
                waterConnectionDetails.setStatus(this.waterTaxUtils.getStatusByCodeAndModuleType("DIGITALSIGNATUREPENDING", "WATERTAXAPPLICATION"));
            } else if (workFlowAction.equals("Sign") && waterConnectionDetails.getStatus().getCode().equals("DIGITALSIGNATUREPENDING")) {
                waterConnectionDetails.setStatus(this.waterTaxUtils.getStatusByCodeAndModuleType("APPROVED", "WATERTAXAPPLICATION"));
            } else if (workFlowAction.equals("Generate WorkOrder") && waterConnectionDetails.getStatus().getCode().equals("APPROVED")) {
                waterConnectionDetails.setStatus(this.waterTaxUtils.getStatusByCodeAndModuleType("WORKORDERGENERATED", "WATERTAXAPPLICATION"));
            } else if (workFlowAction.equals("Execute Tap") && "WORKORDERGENERATED".equalsIgnoreCase(waterConnectionDetails.getStatus().getCode())) {
                waterConnectionDetails.setStatus(this.waterTaxUtils.getStatusByCodeAndModuleType("SANCTIONED", "WATERTAXAPPLICATION"));
            } else if ("SANCTIONED".equalsIgnoreCase(waterConnectionDetails.getStatus().getCode()) && waterConnectionDetails.getCloseConnectionType() != null) {
                waterConnectionDetails.setStatus(this.waterTaxUtils.getStatusByCodeAndModuleType("CLOSERINITIATED", "WATERTAXAPPLICATION"));
                this.updateIndexes(waterConnectionDetails, sourceChannel);
            } else if (!"Reject".equals(workFlowAction)) {
                if (!"closeredit".equals(mode) && "CLOSERINITIATED".equalsIgnoreCase(waterConnectionDetails.getStatus().getCode()) && waterConnectionDetails.getCloseConnectionType() != null) {
                    waterConnectionDetails.setStatus(this.waterTaxUtils.getStatusByCodeAndModuleType("CLOSERINPROGRESS", "WATERTAXAPPLICATION"));
                } else if (workFlowAction.equals("Approve") && "CLOSERINPROGRESS".equalsIgnoreCase(waterConnectionDetails.getStatus().getCode()) && waterConnectionDetails.getCloseConnectionType() != null) {
                    waterConnectionDetails.setStatus(this.waterTaxUtils.getStatusByCodeAndModuleType("CLOSUREDIGSIGNPENDING", "WATERTAXAPPLICATION"));
                } else if (workFlowAction.equals("Sign") && "CLOSUREDIGSIGNPENDING".equalsIgnoreCase(waterConnectionDetails.getStatus().getCode()) && waterConnectionDetails.getCloseConnectionType() != null) {
                    waterConnectionDetails.setStatus(this.waterTaxUtils.getStatusByCodeAndModuleType("CLOSERAPPROVED", "WATERTAXAPPLICATION"));
                    this.updateIndexes(waterConnectionDetails, sourceChannel);
                } else if ("CLOSERAPPROVED".equalsIgnoreCase(waterConnectionDetails.getStatus().getCode()) && waterConnectionDetails.getCloseConnectionType() != null) {
                    waterConnectionDetails.setStatus(this.waterTaxUtils.getStatusByCodeAndModuleType("CLOSERSANCTIONED", "WATERTAXAPPLICATION"));
                    this.updateIndexes(waterConnectionDetails, sourceChannel);
                } else if ("CLOSERSANCTIONED".equalsIgnoreCase(waterConnectionDetails.getStatus().getCode()) && waterConnectionDetails.getCloseConnectionType().equals("T")) {
                    waterConnectionDetails.setStatus(this.waterTaxUtils.getStatusByCodeAndModuleType("RECONNECTIONINITIATED", "WATERTAXAPPLICATION"));
                    this.updateIndexes(waterConnectionDetails, sourceChannel);
                } else if (!"Reject".equals(workFlowAction) && !"reconnectioneredit".equals(mode)) {
                    if ("RECONNECTIONINITIATED".equalsIgnoreCase(waterConnectionDetails.getStatus().getCode()) && waterConnectionDetails.getCloseConnectionType().equals("T")) {
                        waterConnectionDetails.setStatus(this.waterTaxUtils.getStatusByCodeAndModuleType("RECONNECTIONINPROGRESS", "WATERTAXAPPLICATION"));
                    } else if (workFlowAction.equals("Approve") && "RECONNECTIONINPROGRESS".equalsIgnoreCase(waterConnectionDetails.getStatus().getCode()) && waterConnectionDetails.getCloseConnectionType().equals("T")) {
                        waterConnectionDetails.setStatus(this.waterTaxUtils.getStatusByCodeAndModuleType("RECONNDIGSIGNPENDING", "WATERTAXAPPLICATION"));
                    } else if (workFlowAction.equals("Sign") && "RECONNDIGSIGNPENDING".equalsIgnoreCase(waterConnectionDetails.getStatus().getCode()) && waterConnectionDetails.getCloseConnectionType().equals("T")) {
                        waterConnectionDetails.setStatus(this.waterTaxUtils.getStatusByCodeAndModuleType("RECONNECTIONAPPROVED", "WATERTAXAPPLICATION"));
                    } else if ("RECONNECTIONAPPROVED".equalsIgnoreCase(waterConnectionDetails.getStatus().getCode()) && waterConnectionDetails.getCloseConnectionType().equals("T")) {
                        waterConnectionDetails.setStatus(this.waterTaxUtils.getStatusByCodeAndModuleType("RECONNECTIONSANCTIONED", "WATERTAXAPPLICATION"));
                    }
                }
            }
        }
    }

    public Long getApprovalPositionByMatrixDesignation(WaterConnectionDetails waterConnectionDetails, Long approvalPosition, String additionalRule, String mode, String workFlowAction) {
        String loggedInUserDesignation = this.waterTaxUtils.loggedInUserDesignation(waterConnectionDetails);
        WorkFlowMatrix wfmatrix = null;
        wfmatrix = !(loggedInUserDesignation == null || "".equals(loggedInUserDesignation) || !loggedInUserDesignation.equalsIgnoreCase("Commissioner") && !loggedInUserDesignation.equalsIgnoreCase("Executive engineer") && !loggedInUserDesignation.equalsIgnoreCase("Municipal Engineer") && !loggedInUserDesignation.equalsIgnoreCase("Superintendent Engineer") && !loggedInUserDesignation.equalsIgnoreCase("Tap Inspector") && (!loggedInUserDesignation.equalsIgnoreCase("Assistant engineer") && !loggedInUserDesignation.equalsIgnoreCase("Assistant executive engineer") || !waterConnectionDetails.getStatus().getCode().equals("VERIFIED") && !waterConnectionDetails.getStatus().getCode().equals("WORKORDERGENERATED") && !waterConnectionDetails.getStatus().getCode().equals("CLOSERINPROGRESS") && !waterConnectionDetails.getStatus().getCode().equals("RECONNECTIONINPROGRESS"))) ? this.waterConnectionWorkflowService.getWfMatrix(waterConnectionDetails.getStateType(), null, null, additionalRule, waterConnectionDetails.getCurrentState().getValue(), null, null, loggedInUserDesignation) : this.waterConnectionWorkflowService.getWfMatrix(waterConnectionDetails.getStateType(), null, null, additionalRule, waterConnectionDetails.getCurrentState().getValue(), null);
        if (waterConnectionDetails.getStatus().getCode().equals("ESTIMATIONNOTICEGENERATED")) {
            approvalPosition = this.waterTaxUtils.getApproverPosition("Senior Assistant,Junior Assistant,Revenue Clerk", waterConnectionDetails);
        }
        if (waterConnectionDetails != null && waterConnectionDetails.getStatus() != null && waterConnectionDetails.getStatus().getCode() != null) {
            Position posobj;
            if (waterConnectionDetails.getStatus().getCode().equals("CREATED") && waterConnectionDetails.getState() != null) {
                approvalPosition = "edit".equals(mode) ? waterConnectionDetails.getState().getOwnerPosition().getId() : this.waterTaxUtils.getApproverPosition(wfmatrix.getNextDesignation(), waterConnectionDetails);
            } else if (waterConnectionDetails.getStatus().getCode().equals("APPROVED") || !"".equals(workFlowAction) && workFlowAction.equals("Reject") && waterConnectionDetails.getStatus().getCode().equals("CLOSERINITIATED") && waterConnectionDetails.getState().getValue().equals("Rejected")) {
                approvalPosition = this.waterTaxUtils.getApproverPosition(wfmatrix.getNextDesignation(), waterConnectionDetails);
            } else if (waterConnectionDetails.getStatus().getCode().equals("DIGITALSIGNATUREPENDING")) {
                approvalPosition = this.waterTaxUtils.getApproverPosition("Senior Assistant,Junior Assistant", waterConnectionDetails);
            } else if (wfmatrix.getNextDesignation() != null && !workFlowAction.equals("Approve") && (waterConnectionDetails.getStatus().getCode().equals("ESTIMATIONAMOUNTPAID") || waterConnectionDetails.getStatus().getCode().equals("VERIFIED") || waterConnectionDetails.getStatus().getCode().equals("CLOSUREDIGSIGNPENDING") || waterConnectionDetails.getStatus().getCode().equals("DIGITALSIGNATUREPENDING") || waterConnectionDetails.getStatus().getCode().equals("RECONNECTIONAPPROVED") || workFlowAction.equals("Reject") && waterConnectionDetails.getStatus().getCode().equals("RECONNECTIONINITIATED") || workFlowAction.equals("Reject") && waterConnectionDetails.getStatus().getCode().equals("RECONNECTIONINITIATED") || workFlowAction.equals("Reject") && waterConnectionDetails.getStatus().getCode().equals("CLOSERINITIATED"))) {
                approvalPosition = this.waterTaxUtils.getApproverPosition(wfmatrix.getNextDesignation(), waterConnectionDetails);
            } else if (wfmatrix.getNextDesignation() != null && (!workFlowAction.equals("Reject") && waterConnectionDetails.getStatus().getCode().equals("CLOSERINITIATED") || !waterConnectionDetails.getState().getValue().equals("Rejected") && !workFlowAction.equals("Reject") && (waterConnectionDetails.getStatus().getCode().equals("RECONNECTIONINITIATED") || waterConnectionDetails.getStatus().getCode().equals("RECONNECTIONINPROGRESS")) || waterConnectionDetails.getStatus().getCode().equals("APPROVED")) && (posobj = this.waterTaxUtils.getCityLevelCommissionerPosition(wfmatrix.getNextDesignation(), waterConnectionDetails.getConnection().getPropertyIdentifier())) != null) {
                approvalPosition = posobj.getId();
            }
        }
        if (workFlowAction.equals("Sign")) {
            approvalPosition = this.waterTaxUtils.getApproverPosition("Senior Assistant,Junior Assistant", waterConnectionDetails);
        }
        if (workFlowAction.equals("Approve") && (waterConnectionDetails.getStatus().getCode().equals("ESTIMATIONAMOUNTPAID") || waterConnectionDetails.getStatus().getCode().equals("CLOSERINPROGRESS") || waterConnectionDetails.getStatus().getCode().equals("RECONNECTIONINPROGRESS") || waterConnectionDetails.getStatus().getCode().equals("APPROVED"))) {
            approvalPosition = waterConnectionDetails.getState().getOwnerPosition().getId();
        }
        return approvalPosition;
    }

    public void updateConsumerIndex(WaterConnectionDetails waterConnectionDetails) {
        AssessmentDetails assessmentDetails = this.propertyExtnUtils.getAssessmentDetailsForFlag(waterConnectionDetails.getConnection().getPropertyIdentifier(), PropertyExternalService.FLAG_FULL_DETAILS, BasicPropertyStatus.ALL);
        BigDecimal amountTodisplayInIndex = this.getTotalAmount(waterConnectionDetails);
        if (waterConnectionDetails.getLegacy().booleanValue()) {
            this.createWaterChargeIndex(waterConnectionDetails, assessmentDetails, amountTodisplayInIndex);
        }
    }

    public WaterChargeDocument createWaterChargeIndex(WaterConnectionDetails waterConnectionDetails, AssessmentDetails assessmentDetails, BigDecimal amountTodisplayInIndex) {
        return this.waterChargeIndexService.createWaterChargeIndex(waterConnectionDetails, assessmentDetails, amountTodisplayInIndex);
    }

    public void updateIndexes(WaterConnectionDetails waterConnectionDetails, String sourceChannel) {
        ApplicationIndex applicationIndex;
        AssessmentDetails assessmentDetails = this.propertyExtnUtils.getAssessmentDetailsForFlag(waterConnectionDetails.getConnection().getPropertyIdentifier(), PropertyExternalService.FLAG_FULL_DETAILS, BasicPropertyStatus.ALL);
        if (LOG.isDebugEnabled()) {
            LOG.debug(" updating Indexes Started... ");
        }
        BigDecimal amountTodisplayInIndex = BigDecimal.ZERO;
        if (waterConnectionDetails.getConnection().getConsumerCode() != null) {
            amountTodisplayInIndex = this.getTotalAmountTillCurrentFinYear(waterConnectionDetails);
        }
        if (waterConnectionDetails.getLegacy().booleanValue() && (null == waterConnectionDetails.getId() || null != waterConnectionDetails.getId() && waterConnectionDetails.getStatus().getCode().equals("SANCTIONED"))) {
            this.createWaterChargeIndex(waterConnectionDetails, assessmentDetails, amountTodisplayInIndex);
            return;
        }
        Iterator ownerNameItr = null;
        if (null != assessmentDetails.getOwnerNames()) {
            ownerNameItr = assessmentDetails.getOwnerNames().iterator();
        }
        StringBuilder consumerName = new StringBuilder();
        StringBuilder mobileNumber = new StringBuilder();
        User user = null;
        StringBuilder aadharNumber = new StringBuilder();
        if (null != ownerNameItr && ownerNameItr.hasNext()) {
            OwnerName primaryOwner = (OwnerName)ownerNameItr.next();
            consumerName.append(primaryOwner.getOwnerName() != null ? primaryOwner.getOwnerName() : "");
            mobileNumber.append(primaryOwner.getMobileNumber() != null ? primaryOwner.getMobileNumber() : "");
            aadharNumber.append(primaryOwner.getAadhaarNumber() != null ? primaryOwner.getAadhaarNumber() : "");
            while (ownerNameItr.hasNext()) {
                OwnerName secondaryOwner = (OwnerName)ownerNameItr.next();
                consumerName.append(',').append(secondaryOwner.getOwnerName() != null ? secondaryOwner.getOwnerName() : "");
                mobileNumber.append(',').append(secondaryOwner.getMobileNumber() != null ? secondaryOwner.getMobileNumber() : "");
                aadharNumber.append(',').append(secondaryOwner.getAadhaarNumber() != null ? secondaryOwner.getAadhaarNumber() : "");
            }
        }
        List<Object> asignList = null;
        if (waterConnectionDetails.getState() != null && waterConnectionDetails.getState().getOwnerPosition() != null) {
            Assignment assignment = this.assignmentService.getPrimaryAssignmentForPositionAndDate(waterConnectionDetails.getState().getOwnerPosition().getId(), new Date());
            if (assignment != null) {
                asignList = new ArrayList<Assignment>();
                asignList.add(assignment);
            } else if (assignment == null) {
                asignList = this.assignmentService.getAssignmentsForPosition(waterConnectionDetails.getState().getOwnerPosition().getId(), new Date());
            }
            if (!asignList.isEmpty()) {
                user = this.userService.getUserById(((Assignment)asignList.get(0)).getEmployee().getId());
            }
        } else {
            user = this.securityUtils.getCurrentUser();
        }
        if ((applicationIndex = this.applicationIndexService.findByApplicationNumber(waterConnectionDetails.getApplicationNumber())) != null && waterConnectionDetails.getStatus().getCode().equals("CREATED")) {
            applicationIndex.setOwnerName(user.getUsername() + "::" + user.getName());
            this.applicationIndexService.updateApplicationIndex(applicationIndex);
        }
        if (applicationIndex != null && null != waterConnectionDetails.getId() && waterConnectionDetails.getStatus() != null && !waterConnectionDetails.getStatus().getCode().equals("CREATED")) {
            if (!(waterConnectionDetails.getStatus() == null || waterConnectionDetails.getStatus().getCode().equals("RECONNECTIONAPPROVED") || waterConnectionDetails.getStatus().getCode().equals("RECONNECTIONSANCTIONED") || waterConnectionDetails.getStatus().getCode().equals("SANCTIONED"))) {
                applicationIndex.setApplicantAddress(assessmentDetails.getPropertyAddress());
                applicationIndex.setApproved(ApprovalStatus.INPROGRESS);
                applicationIndex.setClosed(ClosureStatus.NO);
                applicationIndex.setStatus(waterConnectionDetails.getStatus().getDescription());
                if (!waterConnectionDetails.getStatus().getCode().equals("SANCTIONED")) {
                    applicationIndex.setOwnerName(user.getUsername() + "::" + user.getName());
                }
                applicationIndex.setSla(this.applicationProcessTimeService.getApplicationProcessTime(waterConnectionDetails.getApplicationType(), waterConnectionDetails.getCategory()));
                if (this.waterTaxUtils.isCSCoperator(waterConnectionDetails.getCreatedBy()).booleanValue() && UserType.BUSINESS.equals((Object)waterConnectionDetails.getCreatedBy().getType())) {
                    applicationIndex.setChannel(Source.CSC.toString());
                } else if (sourceChannel == null) {
                    applicationIndex.setChannel("SYSTEM");
                } else {
                    applicationIndex.setChannel(sourceChannel);
                }
                if (waterConnectionDetails.getStatus().getCode().equals("RECONNECTIONSANCTIONED") || waterConnectionDetails.getStatus().getCode().equals("SANCTIONED") || waterConnectionDetails.getStatus().getCode().equals("CLOSERSANCTIONED")) {
                    applicationIndex.setApproved(ApprovalStatus.APPROVED);
                    applicationIndex.setClosed(ClosureStatus.YES);
                }
                if (waterConnectionDetails.getStatus().getCode().equals("CANCELLED")) {
                    applicationIndex.setApproved(ApprovalStatus.REJECTED);
                    applicationIndex.setClosed(ClosureStatus.YES);
                }
                if (waterConnectionDetails.getConnection().getConsumerCode() != null) {
                    applicationIndex.setConsumerCode(waterConnectionDetails.getConnection().getConsumerCode());
                }
                this.applicationIndexService.updateApplicationIndex(applicationIndex);
            }
            if (waterConnectionDetails.getStatus().getCode().equals("SANCTIONED") && waterConnectionDetails.getConnectionStatus().equals((Object)ConnectionStatus.INPROGRESS) && !waterConnectionDetails.getApplicationType().getCode().equalsIgnoreCase("CHANGEOFUSE")) {
                waterConnectionDetails.setConnectionStatus(ConnectionStatus.ACTIVE);
                if (LOG.isDebugEnabled()) {
                    LOG.debug(" updating Consumer Index Started... ");
                }
                if (!waterConnectionDetails.getConnectionStatus().equals((Object)ConnectionStatus.INACTIVE) || !waterConnectionDetails.getConnectionStatus().equals((Object)ConnectionStatus.INPROGRESS)) {
                    this.createWaterChargeIndex(waterConnectionDetails, assessmentDetails, amountTodisplayInIndex);
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug(" updating Consumer Index completed... ");
                }
            }
            if (waterConnectionDetails.getStatus().getCode().equals("SANCTIONED") && waterConnectionDetails.getConnectionStatus().equals((Object)ConnectionStatus.ACTIVE)) {
                this.createWaterChargeIndex(waterConnectionDetails, assessmentDetails, amountTodisplayInIndex);
            }
            if (waterConnectionDetails.getStatus().getCode().equals("CLOSERSANCTIONED") || waterConnectionDetails.getStatus().getCode().equals("CLOSERAPPROVED") && waterConnectionDetails.getConnectionStatus().equals((Object)ConnectionStatus.CLOSED)) {
                this.createWaterChargeIndex(waterConnectionDetails, assessmentDetails, amountTodisplayInIndex);
            }
            if (waterConnectionDetails.getCloseConnectionType() != null && waterConnectionDetails.getCloseConnectionType().equals("T") && (waterConnectionDetails.getStatus().getCode().equals("RECONNECTIONAPPROVED") || waterConnectionDetails.getStatus().getCode().equals("RECONNECTIONSANCTIONED"))) {
                waterConnectionDetails.setConnectionStatus(ConnectionStatus.ACTIVE);
                this.createWaterChargeIndex(waterConnectionDetails, assessmentDetails, amountTodisplayInIndex);
            }
        } else {
            Integer appProcessTime = this.applicationProcessTimeService.getApplicationProcessTime(waterConnectionDetails.getApplicationType(), waterConnectionDetails.getCategory());
            String strQuery = "select md from EgModules md where md.name=:name";
            Query hql = this.getCurrentSession().createQuery("select md from EgModules md where md.name=:name");
            hql.setParameter("name", (Object)"Water Charges");
            if (waterConnectionDetails.getApplicationDate() == null) {
                waterConnectionDetails.setApplicationDate(new Date());
            }
            if (waterConnectionDetails.getApplicationNumber() == null) {
                waterConnectionDetails.setApplicationNumber(waterConnectionDetails.getConnection().getConsumerCode());
            }
            if (applicationIndex == null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug(" updating Application Index creation Started... ");
                }
                String channel = this.waterTaxUtils.isCSCoperator(waterConnectionDetails.getCreatedBy()) != false && UserType.BUSINESS.equals((Object)waterConnectionDetails.getCreatedBy().getType()) ? Source.CSC.toString() : "SYSTEM";
                applicationIndex = ApplicationIndex.builder().withModuleName(((EgModules)hql.uniqueResult()).getName()).withApplicationNumber(waterConnectionDetails.getApplicationNumber()).withApplicationDate(waterConnectionDetails.getApplicationDate()).withApplicationType(waterConnectionDetails.getApplicationType().getName()).withApplicantName(consumerName.toString()).withStatus(waterConnectionDetails.getStatus().getDescription()).withUrl(String.format(WTMS_APPLICATION_VIEW, waterConnectionDetails.getApplicationNumber())).withApplicantAddress(assessmentDetails.getPropertyAddress()).withOwnername(user.getUsername() + "::" + user.getName()).withChannel(sourceChannel != null ? sourceChannel : channel).withMobileNumber(mobileNumber.toString()).withClosed(ClosureStatus.NO).withAadharNumber(aadharNumber.toString()).withApproved(ApprovalStatus.INPROGRESS).withSla(Integer.valueOf(appProcessTime != null ? appProcessTime : 0)).build();
                if (!waterConnectionDetails.getLegacy().booleanValue() && !waterConnectionDetails.getStatus().getCode().equals("SANCTIONED")) {
                    this.applicationIndexService.createApplicationIndex(applicationIndex);
                }
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug(" updating Application Index creation complted... ");
            }
        }
    }

    public Date getDisposalDate(WaterConnectionDetails waterConnectionDetails, Integer appProcessTime) {
        Calendar c = Calendar.getInstance();
        c.setTime(waterConnectionDetails.getApplicationDate());
        c.add(5, appProcessTime);
        return c.getTime();
    }

    public WaterConnectionDetails getParentConnectionDetails(String propertyIdentifier, ConnectionStatus connectionStatus) {
        return this.waterConnectionDetailsRepository.findByConnection_PropertyIdentifierAndConnectionStatusAndConnection_ParentConnectionIsNull(propertyIdentifier, connectionStatus);
    }

    public WaterConnectionDetails getParentConnectionDetailsForParentConnectionNotNull(String consumercode, ConnectionStatus connectionStatus) {
        return this.waterConnectionDetailsRepository.findByConnection_ConsumerCodeAndConnectionStatusAndConnection_ParentConnectionIsNotNull(consumercode, connectionStatus);
    }

    public WaterConnectionDetails getWaterConnectionDetailsByDemand(EgDemand demand) {
        return this.waterConnectionDetailsRepository.findByDemand(demand);
    }

    @Transactional
    public void save(WaterConnectionDetails detail) {
        this.waterConnectionDetailsRepository.save((Object)detail);
    }

    public WaterConnectionDetails getActiveNonHistoryConnectionDetailsByConnection(WaterConnection waterConnection) {
        return this.waterConnectionDetailsRepository.findByConnectionAndConnectionStatusAndIsHistory(waterConnection, ConnectionStatus.ACTIVE, Boolean.FALSE);
    }

    public BigDecimal getTotalAmount(WaterConnectionDetails waterConnectionDetails) {
        EgDemand currentDemand = this.waterTaxUtils.getCurrentDemand(waterConnectionDetails).getDemand();
        BigDecimal balance = BigDecimal.ZERO;
        if (currentDemand != null) {
            List<Object> instVsAmt = this.connectionDemandService.getDmdCollAmtInstallmentWise(currentDemand);
            for (Object object : instVsAmt) {
                Object[] ddObject = (Object[])object;
                BigDecimal dmdAmt = new BigDecimal((Double)ddObject[2]);
                BigDecimal collAmt = BigDecimal.ZERO;
                if (ddObject[2] != null) {
                    collAmt = new BigDecimal((Double)ddObject[3]);
                }
                balance = balance.add(dmdAmt.subtract(collAmt));
            }
        }
        return balance;
    }

    public BigDecimal getTotalAmountTillCurrentFinYear(WaterConnectionDetails waterConnectionDetails) {
        EgDemand currentDemand = this.waterTaxUtils.getCurrentDemand(waterConnectionDetails).getDemand();
        BigDecimal balance = BigDecimal.ZERO;
        if (currentDemand != null) {
            List<Object> instVsAmt = this.connectionDemandService.getDmdCollAmtInstallmentWiseUptoCurrentFinYear(currentDemand, waterConnectionDetails);
            for (Object object : instVsAmt) {
                Object[] ddObject = (Object[])object;
                BigDecimal dmdAmt = new BigDecimal((Double)ddObject[2]);
                BigDecimal collAmt = BigDecimal.ZERO;
                if (ddObject[2] != null) {
                    collAmt = new BigDecimal((Double)ddObject[3]);
                }
                balance = balance.add(dmdAmt.subtract(collAmt));
            }
        }
        if (balance.compareTo(BigDecimal.ZERO) < 0) {
            balance = BigDecimal.ZERO;
        }
        return balance;
    }

    public BigDecimal getCurrentDue(WaterConnectionDetails waterConnectionDetails) {
        EgDemand currentDemand = this.waterTaxUtils.getCurrentDemand(waterConnectionDetails).getDemand();
        BigDecimal balance = BigDecimal.ZERO;
        if (currentDemand != null) {
            List<Object> instVsAmt = this.connectionDemandService.getDmdCollAmtInstallmentWiseUptoCurrentInstallmemt(currentDemand, waterConnectionDetails);
            for (Object object : instVsAmt) {
                Object[] ddObject = (Object[])object;
                BigDecimal dmdAmt = new BigDecimal((Double)ddObject[2]);
                BigDecimal collAmt = BigDecimal.ZERO;
                if (ddObject[2] != null) {
                    collAmt = new BigDecimal((Double)ddObject[3]);
                }
                balance = balance.add(dmdAmt.subtract(collAmt));
            }
        }
        return balance;
    }

    @Transactional(readOnly=true)
    public List<ApplicationDocuments> getApplicationDocForExceptClosureAndReConnection(WaterConnectionDetails waterConnectionDetails) {
        ArrayList<ApplicationDocuments> tempDocList = new ArrayList<ApplicationDocuments>(0);
        if (waterConnectionDetails != null) {
            for (ApplicationDocuments appDoc : waterConnectionDetails.getApplicationDocs()) {
                if (appDoc.getDocumentNames() == null || !appDoc.getDocumentNames().getApplicationType().getCode().equals("NEWCONNECTION") && !appDoc.getDocumentNames().getApplicationType().getCode().equals("ADDNLCONNECTION") && !appDoc.getDocumentNames().getApplicationType().getCode().equals("CHANGEOFUSE")) continue;
                tempDocList.add(appDoc);
            }
        }
        return tempDocList;
    }

    public WaterConnectionDetails createNewWaterConnection(WaterConnectionDetails waterConnectionDetails, Long approvalPosition, String approvalComent, String code, String workFlowAction, HashMap<String, String> meesevaParams, String sourceChannel) {
        return this.createNewWaterConnection(waterConnectionDetails, approvalPosition, approvalComent, code, workFlowAction, sourceChannel);
    }

    public void validateWaterRateAndDonationHeader(WaterConnectionDetails waterConnectionDetails) {
        WaterRatesDetails waterRatesDetails;
        DonationDetails donationDetails = this.connectionDemandService.getDonationDetails(waterConnectionDetails);
        if (donationDetails == null) {
            throw new ValidationException("donation.combination.required");
        }
        if (waterConnectionDetails.getConnectionType().equals((Object)ConnectionType.NON_METERED) && (waterRatesDetails = this.connectionDemandService.getWaterRatesDetailsForDemandUpdate(waterConnectionDetails)) == null) {
            throw new ValidationException("err.water.rate.not.found");
        }
    }

    public String getApprovalPositionOnValidate(Long approvalPositionId) {
        ArrayList<Assignment> assignmentList = new ArrayList<Assignment>();
        if (approvalPositionId != null && approvalPositionId != 0L && approvalPositionId != -1L) {
            Assignment assignmentObj = this.assignmentService.getPrimaryAssignmentForPositionAndDate(approvalPositionId, new Date());
            if (assignmentObj == null) {
                throw new ValidationException("err.user.not.defined");
            }
            assignmentList.add(assignmentObj);
            Gson jsonCreator = new GsonBuilder().registerTypeAdapter(Assignment.class, (Object)new AssignmentAdaptor()).create();
            return jsonCreator.toJson(assignmentList, new TypeToken<Collection<Assignment>>(){}.getType());
        }
        return "[]";
    }

    @Transactional
    public WaterConnectionDetails updateWaterConnectionDetailsWithFileStore(WaterConnectionDetails waterConnectionDetails) {
        return (WaterConnectionDetails)((Object)this.entityManager.merge((Object)waterConnectionDetails));
    }

    public Map<String, String> getNonMeteredConnectionTypesMap() {
        LinkedHashMap<String, String> connectionTypeMap = new LinkedHashMap<String, String>(0);
        connectionTypeMap.put(ConnectionType.NON_METERED.toString(), "Non-metered");
        return connectionTypeMap;
    }

    public BigDecimal getTotalAmountTillPreviousFinYear(WaterConnectionDetails waterConnectionDetails) {
        EgDemand currentDemand = this.waterTaxUtils.getCurrentDemand(waterConnectionDetails).getDemand();
        BigDecimal balance = BigDecimal.ZERO;
        if (currentDemand != null) {
            List<Object> instVsAmt = this.connectionDemandService.getDmdCollAmtInstallmentWiseUptoPreviousFinYear(currentDemand, waterConnectionDetails);
            for (Object object : instVsAmt) {
                Object[] ddObject = (Object[])object;
                BigDecimal dmdAmt = new BigDecimal((Double)ddObject[2]);
                BigDecimal collAmt = BigDecimal.ZERO;
                if (ddObject[2] != null) {
                    collAmt = new BigDecimal((Double)ddObject[3]);
                }
                balance = balance.add(dmdAmt.subtract(collAmt));
            }
        }
        if (balance.compareTo(BigDecimal.ZERO) < 0) {
            balance = BigDecimal.ZERO;
        }
        return balance;
    }

    public BigDecimal getArrearsDemand(WaterConnectionDetails waterConnectionDetails) {
        EgDemand currentDemand = this.waterTaxUtils.getCurrentDemand(waterConnectionDetails).getDemand();
        BigDecimal balance = BigDecimal.ZERO;
        if (currentDemand != null) {
            List<Object> instVsAmt = this.connectionDemandService.getDmdCollAmtInstallmentWiseUptoPreviousFinYear(currentDemand, waterConnectionDetails);
            balance = this.getTotalBalance(instVsAmt);
        }
        if (balance.compareTo(BigDecimal.ZERO) < 0) {
            balance = BigDecimal.ZERO;
        }
        return balance;
    }

    public BigDecimal getTotalDemandTillCurrentFinYear(WaterConnectionDetails waterConnectionDetails) {
        EgDemand currentDemand = this.waterTaxUtils.getCurrentDemand(waterConnectionDetails).getDemand();
        BigDecimal balance = BigDecimal.ZERO;
        if (currentDemand != null) {
            List<Object> instVsAmt = this.connectionDemandService.getDmdCollAmtInstallmentWiseUptoCurrentFinYear(currentDemand, waterConnectionDetails);
            balance = this.getTotalBalance(instVsAmt);
        }
        if (balance.compareTo(BigDecimal.ZERO) < 0) {
            balance = BigDecimal.ZERO;
        }
        return balance;
    }

    public BigDecimal getTotalBalance(List<Object> instVsAmt) {
        BigDecimal balance = BigDecimal.ZERO;
        for (Object object : instVsAmt) {
            Object[] ddObject = (Object[])object;
            if (ddObject[2] == null) continue;
            BigDecimal dmdAmt = new BigDecimal((Double)ddObject[2]);
            balance = balance.add(dmdAmt);
        }
        return balance;
    }

    @Transactional
    public void saveAndFlushWaterConnectionDetail(WaterConnectionDetails waterConnectionDetails) {
        this.waterConnectionDetailsRepository.saveAndFlush((Object)waterConnectionDetails);
    }

    public List<WaterConnectionDetails> getAllConnectionDetailsByPropertyID(String propertyId) {
        return this.waterConnectionDetailsRepository.getAllConnectionDetailsByPropertyID(propertyId);
    }
}

