/*
 * Decompiled with CFR 0.152.
 */
package org.egov.wtms.application.entity;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import org.egov.infra.persistence.entity.AbstractAuditable;
import org.egov.infra.persistence.validator.annotation.Unique;
import org.egov.wtms.masters.entity.MeterCost;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.SafeHtml;

@Entity
@Table(name="egwtr_connection")
@Unique(id="id", tableName="egwtr_connection", columnName={"meterSerialNumber"}, fields={"meterSerialNumber"}, enableDfltMsg=true)
@SequenceGenerator(name="SEQ_EGWTR_CONNECTION", sequenceName="SEQ_EGWTR_CONNECTION", allocationSize=1)
public class WaterConnection
extends AbstractAuditable {
    private static final long serialVersionUID = -361205348191992865L;
    public static final String SEQ_CONNECTION = "SEQ_EGWTR_CONNECTION";
    @Id
    @GeneratedValue(generator="SEQ_EGWTR_CONNECTION", strategy=GenerationType.SEQUENCE)
    private Long id;
    @SafeHtml
    @Length(min=3, max=50)
    private String consumerCode;
    @SafeHtml
    @Length(min=3, max=50)
    private String oldConsumerNumber;
    @NotNull
    @SafeHtml
    @Length(min=3, max=50)
    private String propertyIdentifier;
    private String bpaIdentifier;
    @SafeHtml
    @Column(name="meterserialnumber", unique=true)
    @Length(min=3, max=50)
    private String meterSerialNumber;
    @ManyToOne
    @JoinColumn(name="parentConnection")
    private WaterConnection parentConnection;
    @ManyToOne
    @JoinColumn(name="meter")
    private MeterCost meter;
    private Long initialReading;
    @SafeHtml
    @Length(min=3, max=50)
    private String duplicateConsumerNumber;
    @SafeHtml
    @Length(min=3, max=50)
    private String oldPropertyIdentifier;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getConsumerCode() {
        return this.consumerCode;
    }

    public void setConsumerCode(String consumerCode) {
        this.consumerCode = consumerCode;
    }

    public String getPropertyIdentifier() {
        return this.propertyIdentifier;
    }

    public void setPropertyIdentifier(String propertyIdentifier) {
        this.propertyIdentifier = propertyIdentifier;
    }

    public String getBpaIdentifier() {
        return this.bpaIdentifier;
    }

    public void setBpaIdentifier(String bpaIdentifier) {
        this.bpaIdentifier = bpaIdentifier;
    }

    public String getMeterSerialNumber() {
        return this.meterSerialNumber;
    }

    public void setMeterSerialNumber(String meterSerialNumber) {
        this.meterSerialNumber = meterSerialNumber;
    }

    public WaterConnection getParentConnection() {
        return this.parentConnection;
    }

    public void setParentConnection(WaterConnection parentConnection) {
        this.parentConnection = parentConnection;
    }

    public MeterCost getMeter() {
        return this.meter;
    }

    public void setMeter(MeterCost meter) {
        this.meter = meter;
    }

    public Long getInitialReading() {
        return this.initialReading;
    }

    public void setInitialReading(Long initialReading) {
        this.initialReading = initialReading;
    }

    public String getOldConsumerNumber() {
        return this.oldConsumerNumber;
    }

    public void setOldConsumerNumber(String oldConsumerNumber) {
        this.oldConsumerNumber = oldConsumerNumber;
    }

    public String getDuplicateConsumerNumber() {
        return this.duplicateConsumerNumber;
    }

    public void setDuplicateConsumerNumber(String duplicateConsumerNumber) {
        this.duplicateConsumerNumber = duplicateConsumerNumber;
    }

    public String getOldPropertyIdentifier() {
        return this.oldPropertyIdentifier;
    }

    public void setOldPropertyIdentifier(String oldPropertyIdentifier) {
        this.oldPropertyIdentifier = oldPropertyIdentifier;
    }
}

