/*
 * Decompiled with CFR 0.152.
 */
package org.egov.wtms.utils;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.egov.commons.EgwStatus;
import org.egov.commons.Installment;
import org.egov.commons.dao.InstallmentDao;
import org.egov.commons.entity.Source;
import org.egov.demand.model.EgDemand;
import org.egov.eis.entity.Assignment;
import org.egov.eis.service.AssignmentService;
import org.egov.eis.service.DesignationService;
import org.egov.eis.service.PositionMasterService;
import org.egov.infra.admin.master.entity.AppConfigValues;
import org.egov.infra.admin.master.entity.Boundary;
import org.egov.infra.admin.master.entity.Department;
import org.egov.infra.admin.master.entity.Module;
import org.egov.infra.admin.master.entity.Role;
import org.egov.infra.admin.master.entity.User;
import org.egov.infra.admin.master.service.AppConfigValueService;
import org.egov.infra.admin.master.service.BoundaryService;
import org.egov.infra.admin.master.service.CityService;
import org.egov.infra.admin.master.service.DepartmentService;
import org.egov.infra.admin.master.service.ModuleService;
import org.egov.infra.admin.master.service.UserService;
import org.egov.infra.config.core.ApplicationThreadLocals;
import org.egov.infra.filestore.service.FileStoreService;
import org.egov.infra.notification.service.NotificationService;
import org.egov.infra.security.utils.SecurityUtils;
import org.egov.infra.workflow.entity.State;
import org.egov.infra.workflow.entity.StateHistory;
import org.egov.infstr.services.PersistenceService;
import org.egov.pims.commons.Designation;
import org.egov.pims.commons.Position;
import org.egov.ptis.domain.entity.property.BasicPropertyImpl;
import org.egov.ptis.domain.model.AssessmentDetails;
import org.egov.ptis.domain.model.enums.BasicPropertyStatus;
import org.egov.ptis.domain.service.property.PropertyExternalService;
import org.egov.wtms.application.entity.WaterConnectionDetails;
import org.egov.wtms.application.entity.WaterDemandConnection;
import org.egov.wtms.application.service.WaterConnectionDetailsService;
import org.egov.wtms.application.service.WaterDemandConnectionService;
import org.egov.wtms.masters.entity.enums.ConnectionStatus;
import org.egov.wtms.utils.PropertyExtnUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.MessageSource;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.ModelAttribute;

@Service
public class WaterTaxUtils {
    @Autowired
    @Qualifier(value="fileStoreService")
    protected FileStoreService fileStoreService;
    @Autowired
    private AppConfigValueService appConfigValuesService;
    @Autowired
    private CityService cityService;
    @Autowired
    private SecurityUtils securityUtils;
    @Autowired
    private AssignmentService assignmentService;
    @Autowired
    private DesignationService designationService;
    @Autowired
    private DepartmentService departmentService;
    @Autowired
    @Qualifier(value="persistenceService")
    private PersistenceService persistenceService;
    @Autowired
    private BoundaryService boundaryService;
    @Autowired
    private PropertyExtnUtils propertyExtnUtils;
    @Autowired
    private PositionMasterService positionMasterService;
    @Autowired
    private NotificationService notificationService;
    @Autowired
    @Qualifier(value="parentMessageSource")
    private MessageSource wcmsMessageSource;
    @Autowired
    private UserService userService;
    @Autowired
    private WaterConnectionDetailsService waterConnectionDetailsService;
    @Autowired
    private WaterDemandConnectionService waterDemandConnectionService;
    @Autowired
    private ModuleService moduleService;
    @Autowired
    private InstallmentDao installmentDao;

    public List<AppConfigValues> getAppConfigValueByModuleNameAndKeyName(String moduleName, String keyName) {
        return this.appConfigValuesService.getConfigValuesByModuleAndKey(moduleName, keyName);
    }

    public String loggedInUserDesignation(WaterConnectionDetails waterConnectionDetails) {
        String loggedInUserDesignation = "";
        User user = this.securityUtils.getCurrentUser();
        if (waterConnectionDetails.getState() != null && waterConnectionDetails.getState().getOwnerPosition() != null) {
            List loggedInUserAssign = this.assignmentService.getAssignmentByPositionAndUserAsOnDate(((Position)waterConnectionDetails.getState().getOwnerPosition()).getId(), user.getId(), new Date());
            loggedInUserDesignation = !loggedInUserAssign.isEmpty() ? ((Assignment)loggedInUserAssign.get(0)).getDesignation().getName() : null;
        }
        return loggedInUserDesignation;
    }

    public Boolean getCurrentUserRole() {
        Boolean cscUserRole = Boolean.FALSE;
        User currentUser = null;
        currentUser = ApplicationThreadLocals.getUserId() != null ? this.userService.getUserById(ApplicationThreadLocals.getUserId()) : this.securityUtils.getCurrentUser();
        for (Role userrole : currentUser.getRoles()) {
            if (!userrole.getName().equals("CSC Operator")) continue;
            cscUserRole = Boolean.TRUE;
            break;
        }
        return cscUserRole;
    }

    public Boolean isCSCoperator(User currentUser) {
        Boolean cscUserRole = Boolean.FALSE;
        if (currentUser != null) {
            for (Role userrole : currentUser.getRoles()) {
                if (!userrole.getName().equals("CSC Operator")) continue;
                cscUserRole = Boolean.TRUE;
                break;
            }
        }
        return cscUserRole;
    }

    public Boolean isSmsEnabled() {
        AppConfigValues appConfigValue = this.getAppConfigValueByModuleNameAndKeyName("Water Tax Management", "SENDSMSFORWATERTAX").get(0);
        return "YES".equalsIgnoreCase(appConfigValue.getValue());
    }

    public String getDepartmentForWorkFlow() {
        String department = "";
        List<AppConfigValues> appConfigValue = this.getAppConfigValueByModuleNameAndKeyName("Water Tax Management", "DEPARTMENTFORWORKFLOW");
        if (null != appConfigValue && !appConfigValue.isEmpty()) {
            department = appConfigValue.get(0).getValue();
        }
        return department;
    }

    public String getDesignationForThirdPartyUser() {
        String designation = "";
        List<AppConfigValues> appConfigValue = this.getAppConfigValueByModuleNameAndKeyName("Water Tax Management", "CLERKDESIGNATIONFORCSCOPERATOR");
        if (null != appConfigValue && !appConfigValue.isEmpty()) {
            designation = appConfigValue.get(0).getValue();
        }
        return designation;
    }

    public List<AppConfigValues> getThirdPartyUserRoles() {
        List<AppConfigValues> appConfigValueList = this.getAppConfigValueByModuleNameAndKeyName("Water Tax Management", "ROLEFORNONEMPLOYEEINWATERTAX");
        return !appConfigValueList.isEmpty() ? appConfigValueList : null;
    }

    public List<AppConfigValues> getUserRolesForLoggedInUser() {
        List appConfigValueList = this.appConfigValuesService.getConfigValuesByModuleAndKeyByValueAsc("Water Tax Management", "RolesForSearchWAterTaxConnection");
        return !appConfigValueList.isEmpty() ? appConfigValueList : null;
    }

    public Boolean getAppconfigValueForSchedulearEnabled() {
        Boolean schedularEnabled = Boolean.FALSE;
        AppConfigValues appConfigValueObj = (AppConfigValues)this.appConfigValuesService.getConfigValuesByModuleAndKeyByValueAsc("Water Tax Management", "ENABLEBILLSCHEDULAR").get(0);
        if (appConfigValueObj != null && appConfigValueObj.getValue() != null && appConfigValueObj.getValue().equals("YES")) {
            schedularEnabled = Boolean.TRUE;
        }
        return schedularEnabled;
    }

    public Boolean getCurrentUserRole(User currentUser) {
        Boolean applicationByOthers = false;
        block0: for (Role userrole : currentUser.getRoles()) {
            for (AppConfigValues appconfig : this.getThirdPartyUserRoles()) {
                if (userrole == null || !userrole.getName().equals(appconfig.getValue())) continue;
                applicationByOthers = true;
                continue block0;
            }
        }
        return applicationByOthers;
    }

    public Boolean isMeesevaUser(User user) {
        for (Role role : user.getRoles()) {
            if (role == null || !role.getName().equalsIgnoreCase("MeeSeva Operator")) continue;
            return true;
        }
        return false;
    }

    public Boolean isEmailEnabled() {
        AppConfigValues appConfigValue = this.getAppConfigValueByModuleNameAndKeyName("Water Tax Management", "SENDEMAILFORWATERTAX").get(0);
        return "YES".equalsIgnoreCase(appConfigValue.getValue());
    }

    public Boolean isNewConnectionAllowedIfPTDuePresent() {
        AppConfigValues appConfigValue = this.getAppConfigValueByModuleNameAndKeyName("Water Tax Management", "NEWCONNECTIONALLOWEDIFPTDUE").get(0);
        return "YES".equalsIgnoreCase(appConfigValue.getValue());
    }

    public Boolean isMultipleNewConnectionAllowedForPID() {
        AppConfigValues appConfigValue = this.getAppConfigValueByModuleNameAndKeyName("Water Tax Management", "MULTIPLENEWCONNECTIONFORPID").get(0);
        return "YES".equalsIgnoreCase(appConfigValue.getValue());
    }

    public Boolean isConnectionAllowedIfWTDuePresent(String connectionType) {
        Boolean isAllowed = false;
        List<AppConfigValues> appConfigValue = this.getAppConfigValueByModuleNameAndKeyName("Water Tax Management", connectionType);
        if (null != appConfigValue && !appConfigValue.isEmpty()) {
            return "YES".equalsIgnoreCase(appConfigValue.get(0).getValue());
        }
        return isAllowed;
    }

    public String documentRequiredForBPLCategory() {
        String documentName = null;
        List<AppConfigValues> appConfigValue = this.getAppConfigValueByModuleNameAndKeyName("Water Tax Management", "DOCUMENTREQUIREDFORBPL");
        if (appConfigValue != null && !appConfigValue.isEmpty()) {
            documentName = appConfigValue.get(0).getValue();
        }
        return documentName;
    }

    public String getMunicipalityName() {
        return ApplicationThreadLocals.getMunicipalityName();
    }

    public String getCityCode() {
        return this.cityService.getCityByURL(ApplicationThreadLocals.getDomainName()).getCode();
    }

    public String smsAndEmailBodyByCodeAndArgsForRejection(String code, String approvalComment, String applicantName) {
        Locale locale = LocaleContextHolder.getLocale();
        return this.wcmsMessageSource.getMessage(code, (Object[])new String[]{applicantName, approvalComment, this.getMunicipalityName()}, locale);
    }

    public String emailBodyforApprovalEmailByCodeAndArgs(String code, WaterConnectionDetails waterConnectionDetails, String applicantName) {
        Locale locale = LocaleContextHolder.getLocale();
        return this.wcmsMessageSource.getMessage(code, (Object[])new String[]{applicantName, waterConnectionDetails.getApplicationNumber(), waterConnectionDetails.getConnection().getConsumerCode(), this.getMunicipalityName()}, locale);
    }

    public String emailSubjectforEmailByCodeAndArgs(String code, String applicationNumber) {
        Locale locale = LocaleContextHolder.getLocale();
        return this.wcmsMessageSource.getMessage(code, (Object[])new String[]{applicationNumber}, locale);
    }

    public void sendSMSOnWaterConnection(String mobileNumber, String smsBody) {
        this.notificationService.sendSMS(mobileNumber, smsBody);
    }

    public void sendEmailOnWaterConnection(String email, String emailBody, String emailSubject) {
        this.notificationService.sendEmail(email, emailSubject, emailBody);
    }

    public Position getCityLevelCommissionerPosition(String commissionerDesgn, String assessmentNumber) {
        Designation desgnObj = this.designationService.getDesignationByName(commissionerDesgn);
        if ("Commissioner".equals(commissionerDesgn)) {
            Department deptObj = this.departmentService.getDepartmentByName("Administration");
            List assignlist = null;
            assignlist = this.assignmentService.getAssignmentsByDeptDesigAndDates(deptObj.getId(), desgnObj.getId(), new Date(), new Date());
            if (assignlist.isEmpty()) {
                assignlist = this.assignmentService.getAllPositionsByDepartmentAndDesignationForGivenRange(null, desgnObj.getId(), new Date());
            }
            if (assignlist.isEmpty()) {
                assignlist = this.assignmentService.getAllActiveAssignments(desgnObj.getId());
            }
            return ((Assignment)assignlist.get(0)).getPosition();
        }
        return this.getZonalLevelClerkForLoggedInUser(assessmentNumber);
    }

    public String getApproverUserName(Long approvalPosition) {
        Assignment assignment = null;
        if (approvalPosition != null) {
            assignment = this.assignmentService.getPrimaryAssignmentForPositionAndDate(approvalPosition, new Date());
        }
        return assignment != null ? assignment.getEmployee().getUsername() : "";
    }

    public String getApproverName(Long approvalPosition) {
        Assignment assignment = null;
        List asignList = null;
        if (approvalPosition != null) {
            assignment = this.assignmentService.getPrimaryAssignmentForPositionAndDate(approvalPosition, new Date());
        }
        if (assignment != null) {
            asignList = new ArrayList<Assignment>();
            asignList.add(assignment);
        } else {
            asignList = this.assignmentService.getAssignmentsForPosition(approvalPosition, new Date());
        }
        return !asignList.isEmpty() ? ((Assignment)asignList.get(0)).getEmployee().getName() : "";
    }

    public EgwStatus getStatusByCodeAndModuleType(String code, String moduleName) {
        return (EgwStatus)this.persistenceService.find("from EgwStatus where moduleType=? and code=?", new Object[]{moduleName, code});
    }

    public String getRevenueWardForConsumerCode(String code, WaterConnectionDetails waterConnectionDetails) {
        BasicPropertyImpl basicPropertyImpl = null;
        basicPropertyImpl = waterConnectionDetails != null && waterConnectionDetails.getConnectionStatus().equals((Object)ConnectionStatus.ACTIVE) ? (BasicPropertyImpl)this.persistenceService.find("from BasicPropertyImpl bp where bp.upicNo in(select conn.propertyIdentifier from WaterConnection conn where conn.consumerCode = ?)", new Object[]{code}) : (BasicPropertyImpl)this.persistenceService.find("from BasicPropertyImpl bp where bp.upicNo in(select conn.propertyIdentifier from WaterConnection conn where conn.id in(select conndet.connection from WaterConnectionDetails conndet where conndet.applicationNumber = ?))", new Object[]{code});
        return basicPropertyImpl != null && basicPropertyImpl.getPropertyID() != null && basicPropertyImpl.getPropertyID().getWard() != null ? basicPropertyImpl.getPropertyID().getWard().getName() : "";
    }

    public Long getApproverPosition(String designationName, WaterConnectionDetails waterConnectionDetails) {
        List stateHistoryList = waterConnectionDetails.getStateHistory();
        Long approverPosition = 0L;
        String[] desgnArray = designationName.split(",");
        User currentUser = null;
        waterConnectionDetails.getState().getValue();
        if (Source.MEESEVA.equals((Object)waterConnectionDetails.getSource()) && ("CLOSUREDIGSIGNPENDING".equals(waterConnectionDetails.getStatus().getCode()) || "RECONNDIGSIGNPENDING".equals(waterConnectionDetails.getStatus().getCode()) || "DIGITALSIGNATUREPENDING".equals(waterConnectionDetails.getStatus().getCode()))) {
            desgnArray = "Senior Assistant,Junior Assistant".split(",");
            approverPosition = this.getApprovalPositionFromStateHistory(waterConnectionDetails, desgnArray);
        } else if (stateHistoryList != null && !stateHistoryList.isEmpty()) {
            currentUser = this.userService.getUserById(waterConnectionDetails.getCreatedBy().getId());
            if (currentUser != null && waterConnectionDetails.getLegacy().equals(true)) {
                for (Role userrole : currentUser.getRoles()) {
                    Position positionuser;
                    if (!userrole.getName().equals("SYSTEM") && !"Water Tax Approver".equalsIgnoreCase(userrole.getName()) && !"MeeSeva Operator".equalsIgnoreCase(userrole.getName()) || (positionuser = this.getZonalLevelClerkForLoggedInUser(waterConnectionDetails.getConnection().getPropertyIdentifier())) == null) continue;
                    approverPosition = positionuser.getId();
                    break;
                }
            } else {
                approverPosition = this.getApprovalPositionFromStateHistory(waterConnectionDetails, desgnArray);
            }
        } else {
            currentUser = this.userService.getUserById(waterConnectionDetails.getCreatedBy().getId());
            if (currentUser != null && waterConnectionDetails.getLegacy().equals(true)) {
                for (Role userrole : currentUser.getRoles()) {
                    Position positionuser;
                    if (!userrole.getName().equals("SYSTEM") || (positionuser = this.getZonalLevelClerkForLoggedInUser(waterConnectionDetails.getConnection().getPropertyIdentifier())) == null) continue;
                    approverPosition = positionuser.getId();
                    break;
                }
            } else {
                Position posObjToClerk = this.positionMasterService.getCurrentPositionForUser(waterConnectionDetails.getCreatedBy().getId());
                if (posObjToClerk != null) {
                    approverPosition = posObjToClerk.getId();
                }
            }
        }
        return approverPosition;
    }

    @Transactional(readOnly=true)
    public Position getZonalLevelClerkForLoggedInUser(String asessmentNumber) {
        AssessmentDetails assessmentDetails = this.propertyExtnUtils.getAssessmentDetailsForFlag(asessmentNumber, PropertyExternalService.FLAG_FULL_DETAILS, BasicPropertyStatus.ALL);
        Assignment assignmentObj = null;
        Boundary boundaryObj = this.boundaryService.getBoundaryById(assessmentDetails.getBoundaryDetails().getAdminWardId());
        assignmentObj = this.getUserPositionByZone(asessmentNumber, assessmentDetails, boundaryObj);
        return assignmentObj != null ? assignmentObj.getPosition() : null;
    }

    @Transactional(readOnly=true)
    public Assignment getUserPositionByZone(String asessmentNumber, AssessmentDetails assessmentDetails, Boundary boundaryObj) {
        String designationStr = this.getDesignationForThirdPartyUser();
        String departmentStr = this.getDepartmentForWorkFlow();
        String[] department = departmentStr.split(",");
        String[] designation = designationStr.split(",");
        List assignment = new ArrayList();
        for (String dept : department) {
            for (String desg : designation) {
                assignment = this.assignmentService.findByDepartmentDesignationAndBoundary(this.departmentService.getDepartmentByName(dept).getId(), this.designationService.getDesignationByName(desg).getId(), boundaryObj.getId());
                if (assignment.isEmpty()) {
                    if (boundaryObj.getParent() != null && boundaryObj.getParent().getBoundaryType() != null && boundaryObj.getParent().getBoundaryType().equals((Object)"Zone") && (assignment = this.assignmentService.findByDeptDesgnAndParentAndActiveChildBoundaries(this.departmentService.getDepartmentByName(dept).getId(), this.designationService.getDesignationByName(desg).getId(), boundaryObj.getParent().getId())).isEmpty() && boundaryObj.getParent() != null && boundaryObj.getParent().getParent() != null && boundaryObj.getParent().getParent().getBoundaryType().getName().equals("City")) {
                        assignment = this.assignmentService.findByDeptDesgnAndParentAndActiveChildBoundaries(this.departmentService.getDepartmentByName(dept).getId(), this.designationService.getDesignationByName(desg).getId(), boundaryObj.getParent().getParent().getId());
                    }
                    if (assignment.isEmpty() && boundaryObj.getParent() != null && boundaryObj.getParent().getBoundaryType().getName().equals("City")) {
                        assignment = this.assignmentService.findByDeptDesgnAndParentAndActiveChildBoundaries(this.departmentService.getDepartmentByName(dept).getId(), this.designationService.getDesignationByName(desg).getId(), boundaryObj.getParent().getId());
                    }
                }
                if (!assignment.isEmpty()) break;
            }
            if (!assignment.isEmpty()) break;
        }
        return !assignment.isEmpty() ? (Assignment)assignment.get(0) : null;
    }

    @ModelAttribute(value="checkOperator")
    public Boolean checkCollectionOperatorRole() {
        User userObj;
        Boolean isCSCOperator = false;
        if (ApplicationThreadLocals.getUserId() != null && (userObj = this.userService.getUserById(ApplicationThreadLocals.getUserId())) != null) {
            for (Role role : userObj.getRoles()) {
                if (role == null || !role.getName().contains("Collection Operator")) continue;
                isCSCOperator = true;
                break;
            }
        }
        return isCSCOperator;
    }

    public List<Installment> getInstallmentListByStartDate(Date startDate) {
        return this.persistenceService.findAllByNamedQuery("INSTALLMENTLISTBY_MODULE_AND_STARTYEAR", new Object[]{startDate, startDate, "Property Tax"});
    }

    public List<Installment> getInstallmentsForCurrYear(Date currDate) {
        Module module = this.moduleService.getModuleByName("Property Tax");
        return this.installmentDao.getAllInstallmentsByModuleAndStartDate(module, currDate);
    }

    public List<Installment> getMonthlyInstallments(Date executionDate) {
        Module module = this.moduleService.getModuleByName("Water Tax Management");
        return this.installmentDao.getInstallmentsByModuleForGivenDateAndInstallmentType(module, executionDate, "Monthly");
    }

    public Double waterConnectionDue(long parentId) {
        BigDecimal waterTaxDueforParent = BigDecimal.ZERO;
        List<WaterConnectionDetails> waterConnectionDetails = this.waterConnectionDetailsService.getAllConnectionDetailsByParentConnection(parentId);
        for (WaterConnectionDetails waterconnectiondetails : waterConnectionDetails) {
            waterTaxDueforParent = waterTaxDueforParent.add(this.waterConnectionDetailsService.getTotalAmount(waterconnectiondetails));
        }
        return waterTaxDueforParent.doubleValue();
    }

    public WaterDemandConnection getCurrentDemand(WaterConnectionDetails waterConnectionDetails) {
        WaterDemandConnection waterdemandConnection = new WaterDemandConnection();
        List<WaterDemandConnection> waterDemandConnectionList = this.waterDemandConnectionService.findByWaterConnectionDetails(waterConnectionDetails);
        for (WaterDemandConnection waterDemandConnection : waterDemandConnectionList) {
            if (!waterDemandConnection.getDemand().getIsHistory().equalsIgnoreCase("N")) continue;
            waterdemandConnection = waterDemandConnection;
            break;
        }
        return waterdemandConnection;
    }

    public List<EgDemand> getAllDemand(WaterConnectionDetails waterConnectionDetails) {
        ArrayList<EgDemand> demandList = new ArrayList<EgDemand>();
        List<WaterDemandConnection> waterDemandConnectionList = this.waterDemandConnectionService.findByWaterConnectionDetails(waterConnectionDetails);
        for (WaterDemandConnection waterDemandConnection : waterDemandConnectionList) {
            demandList.add(waterDemandConnection.getDemand());
        }
        return demandList;
    }

    public Boolean getCitizenUserRole() {
        Boolean citizenrole = Boolean.FALSE;
        if (ApplicationThreadLocals.getUserId() != null) {
            User currentUser = this.userService.getUserById(ApplicationThreadLocals.getUserId());
            if (currentUser.getUsername().equals("anonymous")) {
                citizenrole = Boolean.TRUE;
            }
            for (Role userrole : currentUser.getRoles()) {
                if (userrole == null || !userrole.getName().equals("CITIZEN")) continue;
                citizenrole = Boolean.TRUE;
                break;
            }
        } else {
            citizenrole = Boolean.TRUE;
        }
        return citizenrole;
    }

    public Boolean isDigitalSignatureEnabled() {
        List<AppConfigValues> appConfigValue = this.getAppConfigValueByModuleNameAndKeyName("Water Tax Management", "ENABLEDIGITALSIGNATURE");
        if (null != appConfigValue && !appConfigValue.isEmpty()) {
            return "YES".equalsIgnoreCase(appConfigValue.get(0).getValue());
        }
        return false;
    }

    public Boolean isLoggedInUserJuniorOrSeniorAssistant(Long userid) {
        Boolean isJrAsstOrSrAsst = Boolean.FALSE;
        String designationStr = this.getDesignationForAppInitiator();
        String[] desgnArray = designationStr.split(",");
        if (desgnArray != null) {
            List assignmentList = this.assignmentService.getAllActiveEmployeeAssignmentsByEmpId(userid);
            block0: for (Assignment assignment : assignmentList) {
                for (String str : desgnArray) {
                    if (!assignment.getDesignation().getName().equalsIgnoreCase(str)) continue;
                    isJrAsstOrSrAsst = Boolean.TRUE;
                    continue block0;
                }
            }
        } else {
            isJrAsstOrSrAsst = Boolean.FALSE;
        }
        return isJrAsstOrSrAsst;
    }

    public String getDesignationForAppInitiator() {
        List appConfigValue = this.appConfigValuesService.getConfigValuesByModuleAndKey("Water Tax Management", "WCMSDESIGNATIONFORINITIATOR");
        return !appConfigValue.isEmpty() ? ((AppConfigValues)appConfigValue.get(0)).getValue() : null;
    }

    public Boolean isCitizenPortalUser(User user) {
        for (Role role : user.getRoles()) {
            if (role == null || !role.getName().equalsIgnoreCase("CITIZEN")) continue;
            return true;
        }
        return false;
    }

    public Source setSourceOfConnection(User user) {
        Source source = null;
        if (this.isCitizenPortalUser(user).booleanValue()) {
            source = Source.CITIZENPORTAL;
        }
        return source;
    }

    public Boolean isAnonymousUser(User user) {
        return "anonymous".equalsIgnoreCase(user.getName());
    }

    public Boolean isSuperUser(User user) {
        for (Role role : user.getRoles()) {
            if (role == null || !role.getName().equalsIgnoreCase("SYSTEM")) continue;
            return true;
        }
        return false;
    }

    public Boolean isCurrentUserCitizenRole() {
        Boolean citizenUserRole = Boolean.FALSE;
        User currentUser = null;
        currentUser = ApplicationThreadLocals.getUserId() != null ? this.userService.getUserById(ApplicationThreadLocals.getUserId()) : this.securityUtils.getCurrentUser();
        for (Role userrole : currentUser.getRoles()) {
            if (!userrole.getName().equals("CITIZEN")) continue;
            citizenUserRole = Boolean.TRUE;
            break;
        }
        return citizenUserRole;
    }

    public Long getApprovalPositionFromStateHistory(WaterConnectionDetails waterConnectionDetails, String[] desgnArray) {
        Long approverPosition = 0L;
        List stateHistoryList = waterConnectionDetails.getStateHistory();
        for (StateHistory stateHistory : stateHistoryList) {
            if (stateHistory.getOwnerPosition() == null) continue;
            List assignmentList = this.assignmentService.getAssignmentsForPosition((Long)stateHistory.getOwnerPosition().getId(), new Date());
            block1: for (Assignment assgn : assignmentList) {
                String[] stringArray = desgnArray;
                int n = stringArray.length;
                for (int i = 0; i < n; ++i) {
                    String str = stringArray[i];
                    if (!assgn.getDesignation().getName().equalsIgnoreCase(str)) continue;
                    approverPosition = (Long)stateHistory.getOwnerPosition().getId();
                    continue block1;
                }
            }
            if (approverPosition == 0L) continue;
            break;
        }
        if (approverPosition == 0L) {
            State stateObj = waterConnectionDetails.getState();
            List assignmentList = this.assignmentService.getAssignmentsForPosition((Long)stateObj.getOwnerPosition().getId(), new Date());
            block3: for (Assignment assgn : assignmentList) {
                for (String str : desgnArray) {
                    if (!assgn.getDesignation().getName().equalsIgnoreCase(str)) continue;
                    approverPosition = (Long)stateObj.getOwnerPosition().getId();
                    continue block3;
                }
            }
        }
        return approverPosition;
    }

    public boolean reassignEnabled() {
        List appConfigValues = this.appConfigValuesService.getConfigValuesByModuleAndKey("Water Tax Management", "REASSIGNMENT");
        return !appConfigValues.isEmpty() && "Yes".equalsIgnoreCase(((AppConfigValues)appConfigValues.get(0)).getValue());
    }

    public Boolean isRoleAdmin(User user) {
        for (Role role : user.getRoles()) {
            if (role == null || !role.getName().equalsIgnoreCase("Property Administrator")) continue;
            return true;
        }
        return false;
    }
}

