/*
 * Decompiled with CFR 0.152.
 */
package org.egov.wtms.service.es;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.egov.commons.CFinancialYear;
import org.egov.commons.service.CFinancialYearService;
import org.egov.infra.config.core.ApplicationThreadLocals;
import org.egov.infra.utils.DateUtils;
import org.egov.ptis.domain.entity.es.BillCollectorIndex;
import org.egov.ptis.domain.model.ErrorDetails;
import org.egov.wtms.bean.dashboard.TaxPayerResponseDetails;
import org.egov.wtms.bean.dashboard.WaterChargeDashBoardRequest;
import org.egov.wtms.bean.dashboard.WaterChargeDashBoardResponse;
import org.egov.wtms.bean.dashboard.WaterTaxDefaulters;
import org.egov.wtms.bean.dashboard.WaterTaxPayerDetails;
import org.egov.wtms.entity.es.WaterChargeDocument;
import org.egov.wtms.repository.es.WaterChargeDocumentRepository;
import org.egov.wtms.service.es.WaterChargeCollectionDocService;
import org.egov.wtms.utils.constants.WaterTaxConstants;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.aggregations.AbstractAggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.Aggregations;
import org.elasticsearch.search.aggregations.bucket.terms.StringTerms;
import org.elasticsearch.search.aggregations.bucket.terms.Terms;
import org.elasticsearch.search.aggregations.bucket.terms.TermsBuilder;
import org.elasticsearch.search.aggregations.metrics.sum.Sum;
import org.elasticsearch.search.sort.FieldSortBuilder;
import org.elasticsearch.search.sort.SortBuilder;
import org.elasticsearch.search.sort.SortOrder;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.elasticsearch.core.ElasticsearchTemplate;
import org.springframework.data.elasticsearch.core.query.NativeSearchQuery;
import org.springframework.data.elasticsearch.core.query.NativeSearchQueryBuilder;
import org.springframework.data.elasticsearch.core.query.SearchQuery;
import org.springframework.stereotype.Service;

@Service
public class WaterChargeElasticSearchService {
    private static final Logger LOGGER = LoggerFactory.getLogger(WaterChargeElasticSearchService.class);
    private final WaterChargeDocumentRepository waterChargeIndexRepository;
    private static final String TOTAL_COLLECTION = "total_collection";
    private static final String AGGREGATION_FIELD = "by_aggregationField";
    private static final String TOTAL_DEMAND = "totalDemand";
    private static final String TOTALDEMAND = "totaldemand";
    @Autowired
    private ElasticsearchTemplate elasticsearchTemplate;
    @Autowired
    private CFinancialYearService cFinancialYearService;
    @Autowired
    private WaterChargeCollectionDocService waterChargeCollDocService;

    @Autowired
    public WaterChargeElasticSearchService(WaterChargeDocumentRepository waterChargeIndexRepository) {
        this.waterChargeIndexRepository = waterChargeIndexRepository;
    }

    public Page<WaterChargeDocument> findByConsumercode(String consumerCode) {
        return this.waterChargeIndexRepository.findByConsumerCodeAndCityName(consumerCode, ApplicationThreadLocals.getCityName(), (Pageable)new PageRequest(0, 10));
    }

    public BigDecimal getTotalDemand() {
        NativeSearchQuery searchQuery = new NativeSearchQueryBuilder().withIndices(new String[]{"waterchargeconsumer"}).addAggregation((AbstractAggregationBuilder)AggregationBuilders.sum((String)TOTAL_DEMAND).field(TOTAL_DEMAND)).build();
        Aggregations aggregations = (Aggregations)this.elasticsearchTemplate.query((SearchQuery)searchQuery, response -> response.getAggregations());
        Sum aggr = (Sum)aggregations.get(TOTAL_DEMAND);
        return BigDecimal.valueOf(aggr.getValue()).setScale(0, 4);
    }

    public List<WaterChargeDashBoardResponse> getConsolidatedDemandInfo(WaterChargeDashBoardRequest waterChargedashBoardRequest) {
        Date toDate;
        Date fromDate;
        ArrayList<WaterChargeDashBoardResponse> collectionIndexDetailsList = new ArrayList<WaterChargeDashBoardResponse>();
        WaterChargeDashBoardResponse collectionIndexDetails = new WaterChargeDashBoardResponse();
        if (StringUtils.isNotBlank((CharSequence)waterChargedashBoardRequest.getFromDate()) && StringUtils.isNotBlank((CharSequence)waterChargedashBoardRequest.getToDate())) {
            fromDate = DateUtils.getDate((String)waterChargedashBoardRequest.getFromDate(), (String)"yyyy-MM-dd");
            toDate = org.apache.commons.lang3.time.DateUtils.addDays((Date)DateUtils.getDate((String)waterChargedashBoardRequest.getToDate(), (String)"yyyy-MM-dd"), (int)1);
        } else {
            fromDate = new DateTime().withMonthOfYear(4).dayOfMonth().withMinimumValue().toDate();
            toDate = org.apache.commons.lang3.time.DateUtils.addDays((Date)new Date(), (int)1);
        }
        Long startTime = System.currentTimeMillis();
        BigDecimal totalDemand = this.getTotalDemandBasedOnInputFilters(waterChargedashBoardRequest);
        Long timeTaken = System.currentTimeMillis() - startTime;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Time taken by getTotalDemandBasedOnInputFilters() is (millisecs) : " + timeTaken);
        }
        startTime = System.currentTimeMillis();
        int noOfMonths = DateUtils.noOfMonthsBetween((Date)fromDate, (Date)toDate) + 1;
        collectionIndexDetails.setTotalDmd(totalDemand);
        BigDecimal proportionalDemand = totalDemand.divide(BigDecimal.valueOf(12L), 4).multiply(BigDecimal.valueOf(noOfMonths));
        collectionIndexDetails.setCurrentYearTillDateDmd(proportionalDemand.setScale(0, 4));
        collectionIndexDetails.setPerformance(collectionIndexDetails.getCurrentYearTillDateColl().multiply(WaterTaxConstants.BIGDECIMAL_100).divide(proportionalDemand, 1, 4));
        BigDecimal variation = collectionIndexDetails.getLastYearTillDateColl().compareTo(BigDecimal.ZERO) == 0 ? WaterTaxConstants.BIGDECIMAL_100 : collectionIndexDetails.getCurrentYearTillDateColl().subtract(collectionIndexDetails.getLastYearTillDateColl()).multiply(WaterTaxConstants.BIGDECIMAL_100).divide(collectionIndexDetails.getLastYearTillDateColl(), 1, 4);
        collectionIndexDetails.setLastYearVar(variation);
        timeTaken = System.currentTimeMillis() - startTime;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Time taken for setting values in getConsolidatedDemandInfo() is (millisecs) : " + timeTaken);
        }
        ErrorDetails errorDetails = new ErrorDetails();
        errorDetails.setErrorCode("WTMS-REST-0");
        errorDetails.setErrorMessage("SUCCESS");
        collectionIndexDetails.setErrorDetails(errorDetails);
        collectionIndexDetailsList.add(collectionIndexDetails);
        return collectionIndexDetailsList;
    }

    public BigDecimal getTotalDemandBasedOnInputFilters(WaterChargeDashBoardRequest waterChargedashBoardRequest) {
        BoolQueryBuilder boolQuery = this.waterChargeCollDocService.prepareWhereClause(waterChargedashBoardRequest, null);
        NativeSearchQuery searchQueryColl = new NativeSearchQueryBuilder().withIndices(new String[]{"waterchargeconsumer"}).withQuery((QueryBuilder)boolQuery).addAggregation((AbstractAggregationBuilder)AggregationBuilders.sum((String)TOTAL_DEMAND).field(TOTAL_DEMAND)).build();
        Aggregations collAggr = (Aggregations)this.elasticsearchTemplate.query((SearchQuery)searchQueryColl, response -> response.getAggregations());
        Sum aggr = (Sum)collAggr.get(TOTAL_DEMAND);
        return BigDecimal.valueOf(aggr.getValue()).setScale(0, 4);
    }

    public TaxPayerResponseDetails getTopTenTaxPerformers(WaterChargeDashBoardRequest waterChargedashBoardRequest) {
        List<WaterTaxPayerDetails> taxAchievers;
        List<WaterTaxPayerDetails> taxProducers;
        TaxPayerResponseDetails topTaxPerformers = new TaxPayerResponseDetails();
        if (StringUtils.isNotBlank((CharSequence)waterChargedashBoardRequest.getType()) && waterChargedashBoardRequest.getType().equalsIgnoreCase("billcollector")) {
            List<WaterTaxPayerDetails> wardWiseTaxProducers = this.returnUlbWiseAggregationResults(waterChargedashBoardRequest, "waterchargeconsumer", false, TOTAL_COLLECTION, 250, true);
            HashMap<String, WaterTaxPayerDetails> wardWiseTaxPayersDetails = new HashMap<String, WaterTaxPayerDetails>();
            LinkedHashMap<String, List<WaterTaxPayerDetails>> billCollectorWiseMap = new LinkedHashMap<String, List<WaterTaxPayerDetails>>();
            ArrayList<WaterTaxPayerDetails> taxPayerDetailsList = new ArrayList<WaterTaxPayerDetails>();
            ArrayList<WaterTaxPayerDetails> billCollectorWiseTaxPayerDetails = new ArrayList<WaterTaxPayerDetails>();
            this.prepareWardWiseTaxPayerDetails(wardWiseTaxProducers, wardWiseTaxPayersDetails);
            this.prepareBillCollectorWiseMapData(waterChargedashBoardRequest, wardWiseTaxPayersDetails, billCollectorWiseMap, taxPayerDetailsList);
            this.prepareTaxersInfoForBillCollectors(waterChargedashBoardRequest, billCollectorWiseMap, billCollectorWiseTaxPayerDetails);
            taxProducers = this.getTaxPayersForBillCollector(true, wardWiseTaxProducers, billCollectorWiseTaxPayerDetails, true);
            taxAchievers = this.getTaxPayersForBillCollector(true, wardWiseTaxProducers, billCollectorWiseTaxPayerDetails, false);
        } else {
            taxProducers = this.returnUlbWiseAggregationResults(waterChargedashBoardRequest, "waterchargeconsumer", false, TOTAL_COLLECTION, 10, false);
            taxAchievers = this.returnUlbWiseAggregationResults(waterChargedashBoardRequest, "waterchargeconsumer", false, TOTAL_COLLECTION, 120, false);
        }
        topTaxPerformers.setProducers(taxProducers);
        topTaxPerformers.setAchievers(taxAchievers);
        return topTaxPerformers;
    }

    private void prepareWardWiseTaxPayerDetails(List<WaterTaxPayerDetails> wardWiseTaxProducers, Map<String, WaterTaxPayerDetails> wardWiseTaxPayersDetails) {
        for (WaterTaxPayerDetails taxPayers : wardWiseTaxProducers) {
            wardWiseTaxPayersDetails.put(taxPayers.getWardName(), taxPayers);
        }
    }

    public TaxPayerResponseDetails getBottomTenTaxPerformers(WaterChargeDashBoardRequest waterChargedashBoardRequest) {
        List<WaterTaxPayerDetails> taxAchievers;
        List<WaterTaxPayerDetails> taxProducers;
        TaxPayerResponseDetails topTaxPerformers = new TaxPayerResponseDetails();
        if (StringUtils.isNotBlank((CharSequence)waterChargedashBoardRequest.getType()) && waterChargedashBoardRequest.getType().equalsIgnoreCase("billcollector")) {
            List<WaterTaxPayerDetails> wardWiseTaxProducers = this.returnUlbWiseAggregationResults(waterChargedashBoardRequest, "waterchargeconsumer", false, TOTAL_COLLECTION, 250, true);
            HashMap<String, WaterTaxPayerDetails> wardWiseTaxPayersDetails = new HashMap<String, WaterTaxPayerDetails>();
            LinkedHashMap<String, List<WaterTaxPayerDetails>> billCollectorWiseMap = new LinkedHashMap<String, List<WaterTaxPayerDetails>>();
            ArrayList<WaterTaxPayerDetails> taxPayerDetailsList = new ArrayList<WaterTaxPayerDetails>();
            ArrayList<WaterTaxPayerDetails> billCollectorWiseTaxPayerDetails = new ArrayList<WaterTaxPayerDetails>();
            this.prepareWardWiseTaxPayerDetails(wardWiseTaxProducers, wardWiseTaxPayersDetails);
            this.prepareBillCollectorWiseMapData(waterChargedashBoardRequest, wardWiseTaxPayersDetails, billCollectorWiseMap, taxPayerDetailsList);
            this.prepareTaxersInfoForBillCollectors(waterChargedashBoardRequest, billCollectorWiseMap, billCollectorWiseTaxPayerDetails);
            taxProducers = this.getTaxPayersForBillCollector(true, wardWiseTaxProducers, billCollectorWiseTaxPayerDetails, true);
            taxAchievers = this.getTaxPayersForBillCollector(true, wardWiseTaxProducers, billCollectorWiseTaxPayerDetails, false);
        } else {
            taxProducers = this.returnUlbWiseAggregationResults(waterChargedashBoardRequest, "waterchargeconsumer", true, TOTAL_COLLECTION, 10, false);
            taxAchievers = this.returnUlbWiseAggregationResults(waterChargedashBoardRequest, "waterchargeconsumer", true, TOTAL_COLLECTION, 120, false);
        }
        topTaxPerformers.setProducers(taxProducers);
        topTaxPerformers.setAchievers(taxAchievers);
        return topTaxPerformers;
    }

    public List<WaterTaxPayerDetails> returnUlbWiseAggregationResults(WaterChargeDashBoardRequest waterChargedashBoardRequest, String indexName, Boolean order, String orderingAggregationName, int size, boolean isBillCollectorWise) {
        NativeSearchQuery searchQueryColl;
        AggregationBuilder aggregation;
        ArrayList<WaterTaxPayerDetails> taxPayers = new ArrayList<WaterTaxPayerDetails>();
        Map<Object, Object> wardWiseBillCollectors = new HashMap();
        BoolQueryBuilder boolQuery = this.waterChargeCollDocService.prepareWhereClause(waterChargedashBoardRequest, null);
        CFinancialYear currFinYear = this.cFinancialYearService.getCurrentFinancialYear();
        String groupingField = StringUtils.isNotBlank((CharSequence)waterChargedashBoardRequest.getUlbCode()) || StringUtils.isNotBlank((CharSequence)waterChargedashBoardRequest.getType()) && (waterChargedashBoardRequest.getType().equals("ward") || waterChargedashBoardRequest.getType().equals("billcollector")) ? "revenueWard" : "cityName";
        Long startTime = System.currentTimeMillis();
        if (!isBillCollectorWise) {
            aggregation = ((TermsBuilder)((TermsBuilder)AggregationBuilders.terms((String)AGGREGATION_FIELD).field(groupingField)).size(size).order(Terms.Order.aggregation((String)orderingAggregationName, (boolean)order)).subAggregation((AbstractAggregationBuilder)AggregationBuilders.sum((String)TOTALDEMAND).field(TOTAL_DEMAND))).subAggregation((AbstractAggregationBuilder)AggregationBuilders.sum((String)TOTAL_COLLECTION).field("totalCollection"));
            searchQueryColl = new NativeSearchQueryBuilder().withIndices(new String[]{indexName}).withQuery((QueryBuilder)boolQuery).addAggregation((AbstractAggregationBuilder)aggregation).build();
        } else {
            aggregation = ((TermsBuilder)((TermsBuilder)AggregationBuilders.terms((String)AGGREGATION_FIELD).field(groupingField)).size(250).subAggregation((AbstractAggregationBuilder)AggregationBuilders.sum((String)TOTALDEMAND).field(TOTAL_DEMAND))).subAggregation((AbstractAggregationBuilder)AggregationBuilders.sum((String)TOTAL_COLLECTION).field("totalCollection"));
            searchQueryColl = new NativeSearchQueryBuilder().withIndices(new String[]{indexName}).withQuery((QueryBuilder)boolQuery).withPageable((Pageable)new PageRequest(0, 250)).addAggregation((AbstractAggregationBuilder)aggregation).build();
        }
        Aggregations collAggr = (Aggregations)this.elasticsearchTemplate.query((SearchQuery)searchQueryColl, response -> response.getAggregations());
        if ("ward".equalsIgnoreCase(waterChargedashBoardRequest.getType())) {
            wardWiseBillCollectors = this.waterChargeCollDocService.getWardWiseBillCollectors(waterChargedashBoardRequest);
        }
        Long timeTaken = System.currentTimeMillis() - startTime;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Time taken by ulbWiseAggregations is (millisecs) : " + timeTaken);
        }
        startTime = System.currentTimeMillis();
        Date fromDate = DateUtils.startOfDay((Date)currFinYear.getStartingDate());
        Date toDate = org.apache.commons.lang3.time.DateUtils.addDays((Date)new Date(), (int)1);
        Date lastYearFromDate = org.apache.commons.lang3.time.DateUtils.addYears((Date)fromDate, (int)-1);
        Date lastYearToDate = org.apache.commons.lang3.time.DateUtils.addYears((Date)toDate, (int)-1);
        StringTerms totalAmountAggr = (StringTerms)collAggr.get(AGGREGATION_FIELD);
        for (Terms.Bucket entry : totalAmountAggr.getBuckets()) {
            WaterTaxPayerDetails taxDetail = new WaterTaxPayerDetails();
            taxDetail.setRegionName(waterChargedashBoardRequest.getRegionName());
            taxDetail.setDistrictName(waterChargedashBoardRequest.getDistrictName());
            taxDetail.setUlbGrade(waterChargedashBoardRequest.getUlbGrade());
            String fieldName = String.valueOf(entry.getKey());
            if (groupingField.equals("revenueWard")) {
                taxDetail.setWardName(fieldName);
                if ("ward".equalsIgnoreCase(waterChargedashBoardRequest.getType()) && !wardWiseBillCollectors.isEmpty()) {
                    taxDetail.setBillCollector(wardWiseBillCollectors.get(fieldName) == null ? "" : ((BillCollectorIndex)wardWiseBillCollectors.get(fieldName)).getBillCollector());
                }
            } else {
                taxDetail.setUlbName(fieldName);
            }
            int noOfMonths = DateUtils.noOfMonthsBetween((Date)fromDate, (Date)toDate) + 1;
            Sum totalDemandAggregation = (Sum)entry.getAggregations().get(TOTALDEMAND);
            Sum totalCollectionAggregation = (Sum)entry.getAggregations().get(TOTAL_COLLECTION);
            BigDecimal totalDemandValue = BigDecimal.valueOf(totalDemandAggregation.getValue()).setScale(0, 4);
            BigDecimal totalCollections = BigDecimal.valueOf(totalCollectionAggregation.getValue()).setScale(0, 4);
            BigDecimal proportionalDemand = totalDemandValue.divide(BigDecimal.valueOf(12L), 4).multiply(BigDecimal.valueOf(noOfMonths));
            taxDetail.setTotalDmd(totalDemandValue);
            taxDetail.setCurrentYearTillDateColl(totalCollections);
            taxDetail.setCurrentYearTillDateDmd(proportionalDemand);
            taxDetail.setAchievement(totalCollections.multiply(WaterTaxConstants.BIGDECIMAL_100).divide(proportionalDemand, 1, 4));
            taxDetail.setCurrentYearTillDateBalDmd(proportionalDemand.subtract(totalCollections));
            BigDecimal lastYearCollection = this.waterChargeCollDocService.getCollectionBetweenDates(waterChargedashBoardRequest, lastYearFromDate, lastYearToDate, fieldName);
            BigDecimal variation = BigDecimal.ZERO;
            taxDetail.setLastYearTillDateColl(lastYearCollection);
            if (lastYearCollection.compareTo(BigDecimal.ZERO) == 0) {
                variation = WaterTaxConstants.BIGDECIMAL_100;
            } else if (totalCollections.compareTo(BigDecimal.ZERO) > 0) {
                variation = taxDetail.getCurrentYearTillDateColl().subtract(taxDetail.getLastYearTillDateColl()).multiply(WaterTaxConstants.BIGDECIMAL_100).divide(taxDetail.getLastYearTillDateColl(), 1, 4);
            }
            taxDetail.setLastYearVar(variation);
            taxPayers.add(taxDetail);
        }
        timeTaken = System.currentTimeMillis() - startTime;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Time taken for setting values in returnUlbWiseAggregationResults() is (millisecs) : " + timeTaken);
        }
        return this.returnTopResults(taxPayers, size, order);
    }

    private List<WaterTaxPayerDetails> returnTopResults(List<WaterTaxPayerDetails> taxPayers, int size, Boolean order) {
        if (size > 10) {
            if (order.booleanValue()) {
                Collections.sort(taxPayers);
            } else {
                Collections.sort(taxPayers, Collections.reverseOrder());
            }
            return taxPayers.subList(0, taxPayers.size() < 10 ? taxPayers.size() : 10);
        }
        return taxPayers;
    }

    private void prepareBillCollectorWiseMapData(WaterChargeDashBoardRequest collectionDetailsRequest, Map<String, WaterTaxPayerDetails> wardWiseTaxPayersDetails, Map<String, List<WaterTaxPayerDetails>> billCollectorWiseMap, List<WaterTaxPayerDetails> taxPayerDetailsList) {
        List<BillCollectorIndex> billCollectorsList = this.waterChargeCollDocService.getBillCollectorDetails(collectionDetailsRequest);
        for (BillCollectorIndex billCollIndex : billCollectorsList) {
            if (wardWiseTaxPayersDetails.get(billCollIndex.getRevenueWard()) == null || !StringUtils.isNotBlank((CharSequence)billCollIndex.getRevenueWard())) continue;
            String billCollectorNameNumber = billCollIndex.getBillCollector();
            if (billCollectorWiseMap.isEmpty()) {
                taxPayerDetailsList.add(wardWiseTaxPayersDetails.get(billCollIndex.getRevenueWard()));
                billCollectorWiseMap.put(billCollectorNameNumber, taxPayerDetailsList);
                continue;
            }
            if (!billCollectorWiseMap.containsKey(billCollectorNameNumber)) {
                taxPayerDetailsList = new ArrayList<WaterTaxPayerDetails>();
                taxPayerDetailsList.add(wardWiseTaxPayersDetails.get(billCollIndex.getRevenueWard()));
                billCollectorWiseMap.put(billCollectorNameNumber, taxPayerDetailsList);
                continue;
            }
            billCollectorWiseMap.get(billCollectorNameNumber).add(wardWiseTaxPayersDetails.get(billCollIndex.getRevenueWard()));
        }
    }

    private List<WaterTaxPayerDetails> getTaxPayersForBillCollector(boolean order, List<WaterTaxPayerDetails> wardWiseTaxProducers, List<WaterTaxPayerDetails> billCollectorWiseTaxPayerDetails, boolean isForProducers) {
        HashMap<BigDecimal, WaterTaxPayerDetails> sortedTaxersMap = new HashMap<BigDecimal, WaterTaxPayerDetails>();
        if (isForProducers) {
            for (WaterTaxPayerDetails payerDetails : billCollectorWiseTaxPayerDetails) {
                sortedTaxersMap.put(payerDetails.getCurrentYearTillDateColl(), payerDetails);
            }
        } else {
            for (WaterTaxPayerDetails payerDetails : billCollectorWiseTaxPayerDetails) {
                sortedTaxersMap.put(payerDetails.getAchievement(), payerDetails);
            }
        }
        ArrayList sortedList = new ArrayList(sortedTaxersMap.keySet());
        if (order) {
            Collections.sort(sortedList);
        } else {
            Collections.sort(sortedList, Collections.reverseOrder());
        }
        ArrayList<WaterTaxPayerDetails> taxersResult = new ArrayList<WaterTaxPayerDetails>();
        for (BigDecimal amount : sortedList) {
            taxersResult.add((WaterTaxPayerDetails)sortedTaxersMap.get(amount));
        }
        if (taxersResult.size() > 10) {
            return taxersResult.subList(0, taxersResult.size() < 10 ? taxersResult.size() : 10);
        }
        return taxersResult;
    }

    private void prepareTaxersInfoForBillCollectors(WaterChargeDashBoardRequest waterChargedashBoardRequest, Map<String, List<WaterTaxPayerDetails>> billCollectorWiseMap, List<WaterTaxPayerDetails> billCollectorWiseWaterTaxPayerDetails) {
        for (Map.Entry<String, List<WaterTaxPayerDetails>> entry : billCollectorWiseMap.entrySet()) {
            WaterTaxPayerDetails waterTaxPayerDetails = new WaterTaxPayerDetails();
            BigDecimal cytdColl = BigDecimal.ZERO;
            BigDecimal lytdColl = BigDecimal.ZERO;
            BigDecimal cytdDmd = BigDecimal.ZERO;
            BigDecimal totalDmd = BigDecimal.ZERO;
            for (WaterTaxPayerDetails taxPayer : entry.getValue()) {
                totalDmd = totalDmd.add(taxPayer.getTotalDmd() == null ? BigDecimal.ZERO : taxPayer.getTotalDmd());
                cytdColl = cytdColl.add(taxPayer.getCurrentYearTillDateColl() == null ? BigDecimal.ZERO : taxPayer.getCurrentYearTillDateColl());
                cytdDmd = cytdDmd.add(taxPayer.getCurrentYearTillDateDmd() == null ? BigDecimal.ZERO : taxPayer.getCurrentYearTillDateDmd());
                lytdColl = lytdColl.add(taxPayer.getLastYearTillDateColl() == null ? BigDecimal.ZERO : taxPayer.getLastYearTillDateColl());
            }
            waterTaxPayerDetails.setBillCollector(entry.getKey());
            waterTaxPayerDetails.setRegionName(waterChargedashBoardRequest.getRegionName());
            waterTaxPayerDetails.setDistrictName(waterChargedashBoardRequest.getDistrictName());
            waterTaxPayerDetails.setUlbGrade(waterChargedashBoardRequest.getUlbGrade());
            waterTaxPayerDetails.setCurrentYearTillDateColl(cytdColl);
            waterTaxPayerDetails.setCurrentYearTillDateDmd(cytdDmd);
            waterTaxPayerDetails.setCurrentYearTillDateBalDmd(cytdDmd.subtract(cytdColl));
            waterTaxPayerDetails.setTotalDmd(totalDmd);
            waterTaxPayerDetails.setLastYearTillDateColl(lytdColl);
            waterTaxPayerDetails.setAchievement(cytdColl.multiply(WaterTaxConstants.BIGDECIMAL_100).divide(cytdDmd, 1, 4));
            if (lytdColl.compareTo(BigDecimal.ZERO) > 0) {
                cytdColl.subtract(lytdColl).multiply(WaterTaxConstants.BIGDECIMAL_100).divide(lytdColl, 1, 4);
            }
            billCollectorWiseWaterTaxPayerDetails.add(waterTaxPayerDetails);
        }
    }

    public List<WaterTaxDefaulters> getTopDefaulters(WaterChargeDashBoardRequest waterChargeDefaultersRequest) {
        Long startTime = System.currentTimeMillis();
        BoolQueryBuilder boolQuery = this.filterBasedOnRequest(waterChargeDefaultersRequest);
        boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)"status", (Object)"ACTIVE"));
        NativeSearchQuery searchQuery = new NativeSearchQueryBuilder().withIndices(new String[]{"waterchargeconsumer"}).withQuery((QueryBuilder)boolQuery).withSort((SortBuilder)new FieldSortBuilder("waterTaxDue").order(SortOrder.DESC)).withPageable((Pageable)new PageRequest(0, 100)).build();
        Page waterChargeRecords = this.elasticsearchTemplate.queryForPage((SearchQuery)searchQuery, WaterChargeDocument.class);
        Long timeTaken = System.currentTimeMillis() - startTime;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Time taken by defaulters aggregation is   (millisecs) " + timeTaken);
        }
        ArrayList<WaterTaxDefaulters> taxDefaulters = new ArrayList<WaterTaxDefaulters>();
        startTime = System.currentTimeMillis();
        for (WaterChargeDocument waterChargedoc : waterChargeRecords) {
            WaterTaxDefaulters taxDfaulter = new WaterTaxDefaulters();
            taxDfaulter.setOwnerName(waterChargedoc.getConsumerName());
            taxDfaulter.setConnectionType(waterChargedoc.getUsage());
            taxDfaulter.setUlbName(waterChargedoc.getCityName());
            taxDfaulter.setBalance(BigDecimal.valueOf(waterChargedoc.getWaterTaxDue()));
            taxDfaulter.setPeriod(StringUtils.isBlank((CharSequence)waterChargedoc.getDuePeriod()) ? "" : waterChargedoc.getDuePeriod());
            taxDefaulters.add(taxDfaulter);
        }
        timeTaken = System.currentTimeMillis() - startTime;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Time taken for setting values in getTopDefaulters() is  (millisecs) : " + timeTaken);
        }
        return taxDefaulters;
    }

    private BoolQueryBuilder filterBasedOnRequest(WaterChargeDashBoardRequest waterChargeDefaultersRequest) {
        BoolQueryBuilder boolQuery = QueryBuilders.boolQuery().filter((QueryBuilder)QueryBuilders.rangeQuery((String)TOTAL_DEMAND).from(0).to(null));
        if (StringUtils.isNotBlank((CharSequence)waterChargeDefaultersRequest.getRegionName())) {
            boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)"regionName", (Object)waterChargeDefaultersRequest.getRegionName()));
        }
        if (StringUtils.isNotBlank((CharSequence)waterChargeDefaultersRequest.getDistrictName())) {
            boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)"districtName", (Object)waterChargeDefaultersRequest.getDistrictName()));
        }
        if (StringUtils.isNotBlank((CharSequence)waterChargeDefaultersRequest.getUlbCode())) {
            boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)"cityCode", (Object)waterChargeDefaultersRequest.getUlbCode()));
        }
        if (StringUtils.isNotBlank((CharSequence)waterChargeDefaultersRequest.getUlbGrade())) {
            boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)"cityGrade", (Object)waterChargeDefaultersRequest.getUlbGrade()));
        }
        if (StringUtils.isNotBlank((CharSequence)waterChargeDefaultersRequest.getWardName())) {
            boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)"revenueWard", (Object)waterChargeDefaultersRequest.getWardName()));
        }
        boolQuery = this.filterBoolQueryByTypeForDefaulters(waterChargeDefaultersRequest, boolQuery);
        return boolQuery;
    }

    protected BoolQueryBuilder filterBoolQueryByTypeForDefaulters(WaterChargeDashBoardRequest waterChargeDefaultersRequest, BoolQueryBuilder boolQuery) {
        if (StringUtils.isNotBlank((CharSequence)waterChargeDefaultersRequest.getType())) {
            if (waterChargeDefaultersRequest.getType().equalsIgnoreCase("region") && StringUtils.isNotBlank((CharSequence)waterChargeDefaultersRequest.getRegionName())) {
                boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)"regionName", (Object)waterChargeDefaultersRequest.getRegionName()));
            } else if (waterChargeDefaultersRequest.getType().equalsIgnoreCase("district") && StringUtils.isNotBlank((CharSequence)waterChargeDefaultersRequest.getDistrictName())) {
                boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)"districtName", (Object)waterChargeDefaultersRequest.getDistrictName()));
            } else if (waterChargeDefaultersRequest.getType().equalsIgnoreCase("city") && StringUtils.isNotBlank((CharSequence)waterChargeDefaultersRequest.getUlbCode())) {
                boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)"cityCode", (Object)waterChargeDefaultersRequest.getUlbCode()));
            } else if (waterChargeDefaultersRequest.getType().equalsIgnoreCase("grade") && StringUtils.isNotBlank((CharSequence)waterChargeDefaultersRequest.getUlbGrade())) {
                boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)"cityGrade", (Object)waterChargeDefaultersRequest.getUlbGrade()));
            }
        }
        return boolQuery;
    }
}

