/*
 * Decompiled with CFR 0.152.
 */
package org.egov.wtms.service.es;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.egov.commons.CFinancialYear;
import org.egov.commons.dao.FinancialYearDAO;
import org.egov.commons.service.CFinancialYearService;
import org.egov.infra.admin.master.entity.es.CityIndex;
import org.egov.infra.utils.DateUtils;
import org.egov.ptis.domain.entity.es.BillCollectorIndex;
import org.egov.wtms.bean.dashboard.WaterChargeConnectionTypeResponse;
import org.egov.wtms.bean.dashboard.WaterChargeDashBoardRequest;
import org.egov.wtms.bean.dashboard.WaterChargeDashBoardResponse;
import org.egov.wtms.utils.constants.WaterTaxConstants;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.aggregations.AbstractAggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.Aggregations;
import org.elasticsearch.search.aggregations.bucket.histogram.DateHistogramBuilder;
import org.elasticsearch.search.aggregations.bucket.histogram.DateHistogramInterval;
import org.elasticsearch.search.aggregations.bucket.histogram.Histogram;
import org.elasticsearch.search.aggregations.bucket.terms.StringTerms;
import org.elasticsearch.search.aggregations.bucket.terms.Terms;
import org.elasticsearch.search.aggregations.bucket.terms.TermsBuilder;
import org.elasticsearch.search.aggregations.metrics.sum.Sum;
import org.elasticsearch.search.aggregations.metrics.valuecount.ValueCount;
import org.elasticsearch.search.sort.FieldSortBuilder;
import org.elasticsearch.search.sort.SortBuilder;
import org.elasticsearch.search.sort.SortOrder;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.elasticsearch.core.ElasticsearchTemplate;
import org.springframework.data.elasticsearch.core.query.NativeSearchQuery;
import org.springframework.data.elasticsearch.core.query.NativeSearchQueryBuilder;
import org.springframework.data.elasticsearch.core.query.SearchQuery;
import org.springframework.stereotype.Service;

@Service
public class WaterChargeCollectionDocService {
    private static final Logger LOGGER = LoggerFactory.getLogger(WaterChargeCollectionDocService.class);
    private static final String CNSUMER_CODEINDEX = "consumerCode";
    private static final String RECEIPT_COUNT_INDEX = "receipt_count";
    private static final String RECEIPT_DATEINDEX = "receiptDate";
    private static final String COLLECTION_TOTAL = "collectiontotal";
    private static final String BILLING_SERVICE = "billingService";
    private static final String TOTAL_AMOUNT = "totalAmount";
    private static final String CANCELLED = "Cancelled";
    private static final String STATUS = "status";
    private static final String TOTAL_DEMAND = "totalDemand";
    private static final String TOTALDEMAND = "totaldemand";
    private static final String BY_CITY = "by_city";
    private static final String CITYCODE = "cityCode";
    private static final String AGGR_DATE = "date_agg";
    private static final String CONN_STATUS = "ACTIVE";
    @Autowired
    private CFinancialYearService cFinancialYearService;
    @Autowired
    private ElasticsearchTemplate elasticsearchTemplate;
    @Autowired
    private FinancialYearDAO financialYearDAO;

    public BigDecimal getConsolidatedCollForYears(Date fromDate, Date toDate, String billingService) {
        BoolQueryBuilder queryBuilder = QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.rangeQuery((String)RECEIPT_DATEINDEX).gte(WaterTaxConstants.DATEFORMATTER_YYYY_MM_DD.format(fromDate)).lte(WaterTaxConstants.DATEFORMATTER_YYYY_MM_DD.format(toDate)).includeUpper(false)).must((QueryBuilder)QueryBuilders.matchQuery((String)BILLING_SERVICE, (Object)billingService)).mustNot((QueryBuilder)QueryBuilders.matchQuery((String)STATUS, (Object)CANCELLED));
        NativeSearchQuery searchQueryColl = new NativeSearchQueryBuilder().withIndices(new String[]{"receipts"}).withQuery((QueryBuilder)queryBuilder).addAggregation((AbstractAggregationBuilder)AggregationBuilders.sum((String)COLLECTION_TOTAL).field(TOTAL_AMOUNT)).build();
        Aggregations collAggr = (Aggregations)this.elasticsearchTemplate.query((SearchQuery)searchQueryColl, response -> response.getAggregations());
        Sum aggr = (Sum)collAggr.get(COLLECTION_TOTAL);
        return BigDecimal.valueOf(aggr.getValue()).setScale(0, 4);
    }

    public Map<String, BigDecimal> getFinYearsCollByService(String billingService) {
        HashMap<String, BigDecimal> consolidatedCollValues = new HashMap<String, BigDecimal>();
        CFinancialYear currFinYear = this.cFinancialYearService.getCurrentFinancialYear();
        consolidatedCollValues.put("cytdColln", this.getConsolidatedCollForYears(currFinYear.getStartingDate(), org.apache.commons.lang3.time.DateUtils.addDays((Date)new Date(), (int)1), billingService));
        consolidatedCollValues.put("lytdColln", this.getConsolidatedCollForYears(org.apache.commons.lang3.time.DateUtils.addYears((Date)currFinYear.getStartingDate(), (int)-1), org.apache.commons.lang3.time.DateUtils.addDays((Date)org.apache.commons.lang3.time.DateUtils.addYears((Date)new Date(), (int)-1), (int)1), billingService));
        return consolidatedCollValues;
    }

    public BoolQueryBuilder prepareWhereClause(WaterChargeDashBoardRequest collectionDetailsRequest, String indexName) {
        BoolQueryBuilder boolQuery = QueryBuilders.boolQuery();
        if (indexName == null) {
            boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.rangeQuery((String)TOTAL_DEMAND).from(0).to(null));
        } else if ("waterchargeconsumer".equals(indexName)) {
            boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.rangeQuery((String)TOTAL_DEMAND).from(0).to(null));
        } else if (indexName.equals("receipts")) {
            boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)BILLING_SERVICE, (Object)"Water Charges"));
        }
        if (boolQuery != null) {
            if (StringUtils.isNotBlank((CharSequence)collectionDetailsRequest.getRegionName())) {
                boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)"regionName", (Object)collectionDetailsRequest.getRegionName()));
            }
            if (StringUtils.isNotBlank((CharSequence)collectionDetailsRequest.getDistrictName())) {
                boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)"districtName", (Object)collectionDetailsRequest.getDistrictName()));
            }
            if (StringUtils.isNotBlank((CharSequence)collectionDetailsRequest.getUlbGrade())) {
                boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)"cityGrade", (Object)collectionDetailsRequest.getUlbGrade()));
            }
            if (StringUtils.isNotBlank((CharSequence)collectionDetailsRequest.getUlbCode())) {
                boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)CITYCODE, (Object)collectionDetailsRequest.getUlbCode()));
            }
        }
        return boolQuery;
    }

    public BigDecimal getTotalDemandBasedOnInputFilters(WaterChargeDashBoardRequest collectionDetailsRequest) {
        BoolQueryBuilder boolQuery = this.prepareWhereClause(collectionDetailsRequest, null);
        NativeSearchQuery searchQueryColl = new NativeSearchQueryBuilder().withIndices(new String[]{"waterchargeconsumer"}).withQuery((QueryBuilder)boolQuery).addAggregation((AbstractAggregationBuilder)AggregationBuilders.sum((String)TOTAL_DEMAND).field(TOTAL_DEMAND)).build();
        Aggregations collAggr = (Aggregations)this.elasticsearchTemplate.query((SearchQuery)searchQueryColl, response -> response.getAggregations());
        Sum aggr = (Sum)collAggr.get(TOTAL_DEMAND);
        return BigDecimal.valueOf(aggr.getValue()).setScale(0, 4);
    }

    public List<WaterChargeDashBoardResponse> getFullCollectionIndexDtls(WaterChargeDashBoardRequest collectionDetailsRequest) {
        Date toDate;
        Date fromDate;
        ArrayList<WaterChargeDashBoardResponse> collectionIndexDetailsList = new ArrayList<WaterChargeDashBoardResponse>();
        WaterChargeDashBoardResponse collectionIndexDetails = new WaterChargeDashBoardResponse();
        Long startTime = System.currentTimeMillis();
        CFinancialYear financialyear = this.financialYearDAO.getFinancialYearByDate(new Date());
        if (StringUtils.isNotBlank((CharSequence)collectionDetailsRequest.getFromDate()) && StringUtils.isNotBlank((CharSequence)collectionDetailsRequest.getToDate())) {
            fromDate = DateUtils.getDate((String)collectionDetailsRequest.getFromDate(), (String)"yyyy-MM-dd");
            toDate = org.apache.commons.lang3.time.DateUtils.addDays((Date)DateUtils.getDate((String)collectionDetailsRequest.getToDate(), (String)"yyyy-MM-dd"), (int)1);
        } else {
            fromDate = new Date();
            toDate = DateUtils.addDays((Date)new Date(), (int)1);
        }
        BigDecimal todayColl = this.getCollectionBetweenDates(collectionDetailsRequest, fromDate, toDate, null);
        collectionIndexDetails.setTodayColl(todayColl);
        todayColl = this.getCollectionBetweenDates(collectionDetailsRequest, org.apache.commons.lang3.time.DateUtils.addYears((Date)fromDate, (int)-1), org.apache.commons.lang3.time.DateUtils.addYears((Date)toDate, (int)-1), null);
        collectionIndexDetails.setLastYearTodayColl(todayColl);
        if (StringUtils.isNotBlank((CharSequence)collectionDetailsRequest.getFromDate()) && StringUtils.isNotBlank((CharSequence)collectionDetailsRequest.getToDate())) {
            fromDate = DateUtils.getDate((String)collectionDetailsRequest.getFromDate(), (String)"yyyy-MM-dd");
            toDate = org.apache.commons.lang3.time.DateUtils.addDays((Date)DateUtils.getDate((String)collectionDetailsRequest.getToDate(), (String)"yyyy-MM-dd"), (int)1);
        } else {
            fromDate = DateUtils.startOfDay((Date)financialyear.getStartingDate());
            toDate = org.apache.commons.lang3.time.DateUtils.addDays((Date)new Date(), (int)1);
        }
        BigDecimal tillDateColl = this.getCollectionBetweenDates(collectionDetailsRequest, fromDate, toDate, null);
        collectionIndexDetails.setCurrentYearTillDateColl(tillDateColl);
        tillDateColl = this.getCollectionBetweenDates(collectionDetailsRequest, org.apache.commons.lang3.time.DateUtils.addYears((Date)fromDate, (int)-1), org.apache.commons.lang3.time.DateUtils.addYears((Date)toDate, (int)-1), null);
        collectionIndexDetails.setLastYearTillDateColl(tillDateColl);
        Long timeTaken = System.currentTimeMillis() - startTime;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Time taken by getCompleteCollectionIndexDetails() is (millisecs) : " + timeTaken);
        }
        if (StringUtils.isNotBlank((CharSequence)collectionDetailsRequest.getFromDate()) && StringUtils.isNotBlank((CharSequence)collectionDetailsRequest.getToDate())) {
            fromDate = DateUtils.getDate((String)collectionDetailsRequest.getFromDate(), (String)"yyyy-MM-dd");
            toDate = org.apache.commons.lang3.time.DateUtils.addDays((Date)DateUtils.getDate((String)collectionDetailsRequest.getToDate(), (String)"yyyy-MM-dd"), (int)1);
        } else {
            fromDate = DateUtils.startOfDay((Date)financialyear.getStartingDate());
            toDate = org.apache.commons.lang3.time.DateUtils.addDays((Date)new Date(), (int)1);
        }
        BigDecimal totalDemand = this.getTotalDemandBasedOnInputFilters(collectionDetailsRequest);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Time taken by getTotalDemandBasedOnInputFilters() is (millisecs): " + timeTaken);
        }
        int noOfMonths = DateUtils.noOfMonthsBetween((Date)fromDate, (Date)toDate) + 1;
        collectionIndexDetails.setTotalDmd(totalDemand);
        this.prepareCollectionIndexDetails(collectionIndexDetails, totalDemand, noOfMonths);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Time taken for setting values in getConsolidatedDemandInfo() is (millisecs): " + timeTaken);
        }
        collectionIndexDetailsList.add(collectionIndexDetails);
        return collectionIndexDetailsList;
    }

    public List<WaterChargeConnectionTypeResponse> getFullCollectionIndexDtlsForCOnnectionType(WaterChargeDashBoardRequest collectionDetailsRequest) {
        Date toDate;
        Date fromDate;
        ArrayList<WaterChargeConnectionTypeResponse> collectionIndexDetailsList = new ArrayList<WaterChargeConnectionTypeResponse>();
        WaterChargeConnectionTypeResponse collectionIndexDetails = new WaterChargeConnectionTypeResponse();
        Long startTime = System.currentTimeMillis();
        CFinancialYear financialyear = this.cFinancialYearService.getCurrentFinancialYear();
        if (StringUtils.isNotBlank((CharSequence)collectionDetailsRequest.getFromDate()) && StringUtils.isNotBlank((CharSequence)collectionDetailsRequest.getToDate())) {
            fromDate = DateUtils.getDate((String)collectionDetailsRequest.getFromDate(), (String)"yyyy-MM-dd");
            toDate = org.apache.commons.lang3.time.DateUtils.addDays((Date)DateUtils.getDate((String)collectionDetailsRequest.getToDate(), (String)"yyyy-MM-dd"), (int)1);
        } else {
            fromDate = new Date();
            toDate = org.apache.commons.lang3.time.DateUtils.addDays((Date)new Date(), (int)1);
        }
        BigDecimal todayColl = this.getCollectionBetweenDates(collectionDetailsRequest, fromDate, toDate, null);
        collectionIndexDetails.setTodayColl(todayColl);
        todayColl = this.getCollectionBetweenDates(collectionDetailsRequest, org.apache.commons.lang3.time.DateUtils.addYears((Date)fromDate, (int)-1), org.apache.commons.lang3.time.DateUtils.addYears((Date)toDate, (int)-1), null);
        collectionIndexDetails.setLastYearTodayColl(todayColl);
        if (StringUtils.isNotBlank((CharSequence)collectionDetailsRequest.getFromDate()) && StringUtils.isNotBlank((CharSequence)collectionDetailsRequest.getToDate())) {
            fromDate = DateUtils.getDate((String)collectionDetailsRequest.getFromDate(), (String)"yyyy-MM-dd");
            toDate = org.apache.commons.lang3.time.DateUtils.addDays((Date)DateUtils.getDate((String)collectionDetailsRequest.getToDate(), (String)"yyyy-MM-dd"), (int)1);
        } else {
            fromDate = DateUtils.startOfDay((Date)financialyear.getStartingDate());
            toDate = org.apache.commons.lang3.time.DateUtils.addDays((Date)new Date(), (int)1);
        }
        BigDecimal tillDateColl = this.getCollectionBetweenDates(collectionDetailsRequest, fromDate, toDate, null);
        collectionIndexDetails.setCurrentYearTillDateColl(tillDateColl);
        tillDateColl = this.getCollectionBetweenDates(collectionDetailsRequest, org.apache.commons.lang3.time.DateUtils.addYears((Date)fromDate, (int)-1), org.apache.commons.lang3.time.DateUtils.addYears((Date)toDate, (int)-1), null);
        collectionIndexDetails.setLastYearTillDateColl(tillDateColl);
        Long timeTaken = System.currentTimeMillis() - startTime;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Time taken by getCompleteCollectionIndexDetails() is (millisecs) : " + timeTaken);
        }
        if (StringUtils.isNotBlank((CharSequence)collectionDetailsRequest.getFromDate()) && StringUtils.isNotBlank((CharSequence)collectionDetailsRequest.getToDate())) {
            fromDate = DateUtils.getDate((String)collectionDetailsRequest.getFromDate(), (String)"yyyy-MM-dd");
            toDate = org.apache.commons.lang3.time.DateUtils.addDays((Date)DateUtils.getDate((String)collectionDetailsRequest.getToDate(), (String)"yyyy-MM-dd"), (int)1);
        } else {
            fromDate = DateUtils.startOfDay((Date)financialyear.getStartingDate());
            toDate = org.apache.commons.lang3.time.DateUtils.addDays((Date)new Date(), (int)1);
        }
        BigDecimal totalDemand = this.getTotalDemandBasedOnInputFilters(collectionDetailsRequest);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Time taken by getTotalDemandBasedOnInputFilters() is (millisecs): " + timeTaken);
        }
        int noOfMonths = DateUtils.noOfMonthsBetween((Date)fromDate, (Date)toDate) + 1;
        collectionIndexDetails.setTotalDmd(totalDemand);
        BigDecimal proportionalDemand = totalDemand.divide(BigDecimal.valueOf(12L), 4).multiply(BigDecimal.valueOf(noOfMonths));
        if (proportionalDemand.compareTo(BigDecimal.ZERO) > 0) {
            collectionIndexDetails.setCurrentYearTillDateDmd(proportionalDemand.setScale(0, 4));
        }
        if (proportionalDemand.compareTo(BigDecimal.ZERO) > 0) {
            collectionIndexDetails.setPerformance(collectionIndexDetails.getCurrentYearTillDateColl().multiply(WaterTaxConstants.BIGDECIMAL_100).divide(proportionalDemand, 1, 4));
        }
        BigDecimal variation = collectionIndexDetails.getLastYearTillDateColl().compareTo(BigDecimal.ZERO) == 0 ? WaterTaxConstants.BIGDECIMAL_100 : collectionIndexDetails.getCurrentYearTillDateColl().subtract(collectionIndexDetails.getLastYearTillDateColl()).multiply(WaterTaxConstants.BIGDECIMAL_100).divide(collectionIndexDetails.getLastYearTillDateColl(), 1, 4);
        collectionIndexDetails.setLastYearVar(variation);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Time taken for setting values in getConsolidatedDemandInfo() is (millisecs): " + timeTaken);
        }
        collectionIndexDetailsList.add(collectionIndexDetails);
        return collectionIndexDetailsList;
    }

    private void prepareCollectionIndexDetails(WaterChargeDashBoardResponse collectionIndexDetails, BigDecimal totalDemand, int noOfMonths) {
        BigDecimal proportionalDemand = totalDemand.divide(BigDecimal.valueOf(12L), 4).multiply(BigDecimal.valueOf(noOfMonths));
        if (proportionalDemand.compareTo(BigDecimal.ZERO) > 0) {
            collectionIndexDetails.setCurrentYearTillDateDmd(proportionalDemand.setScale(0, 4));
        }
        if (proportionalDemand.compareTo(BigDecimal.ZERO) > 0) {
            collectionIndexDetails.setPerformance(collectionIndexDetails.getCurrentYearTillDateColl().multiply(WaterTaxConstants.BIGDECIMAL_100).divide(proportionalDemand, 1, 4));
        }
        BigDecimal variation = collectionIndexDetails.getLastYearTillDateColl().compareTo(BigDecimal.ZERO) == 0 ? WaterTaxConstants.BIGDECIMAL_100 : collectionIndexDetails.getCurrentYearTillDateColl().subtract(collectionIndexDetails.getLastYearTillDateColl()).multiply(WaterTaxConstants.BIGDECIMAL_100).divide(collectionIndexDetails.getLastYearTillDateColl(), 1, 4);
        collectionIndexDetails.setLastYearVar(variation);
    }

    public BigDecimal getCollectionBetweenDates(WaterChargeDashBoardRequest collectionDetailsRequest, Date fromDate, Date toDate, String cityName) {
        Long startTime = System.currentTimeMillis();
        BoolQueryBuilder boolQuery = this.prepareWhereClause(collectionDetailsRequest, "receipts");
        boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.rangeQuery((String)RECEIPT_DATEINDEX).gte(WaterTaxConstants.DATEFORMATTER_YYYY_MM_DD.format(fromDate)).lte(WaterTaxConstants.DATEFORMATTER_YYYY_MM_DD.format(toDate)).includeUpper(false)).mustNot((QueryBuilder)QueryBuilders.matchQuery((String)STATUS, (Object)CANCELLED));
        if (StringUtils.isNotBlank((CharSequence)cityName)) {
            boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)"cityName", (Object)cityName));
        }
        NativeSearchQuery searchQueryColl = new NativeSearchQueryBuilder().withIndices(new String[]{"receipts"}).withQuery((QueryBuilder)boolQuery).addAggregation((AbstractAggregationBuilder)AggregationBuilders.sum((String)COLLECTION_TOTAL).field(TOTAL_AMOUNT)).build();
        Aggregations collAggr = (Aggregations)this.elasticsearchTemplate.query((SearchQuery)searchQueryColl, response -> response.getAggregations());
        Sum aggr = (Sum)collAggr.get(COLLECTION_TOTAL);
        Long timeTaken = System.currentTimeMillis() - startTime;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Time taken by getCollectionBetweenDates() is (millisecs) : " + timeTaken);
        }
        return BigDecimal.valueOf(aggr.getValue()).setScale(0, 4);
    }

    public List<WaterChargeDashBoardResponse> getResponseTableData(WaterChargeDashBoardRequest collectionDetailsRequest) {
        Date toDate;
        Date fromDate;
        ArrayList<WaterChargeDashBoardResponse> collIndDataList = new ArrayList<WaterChargeDashBoardResponse>();
        String aggregationField = "regionName";
        Map<Object, Object> wardWiseBillCollectors = new HashMap();
        CFinancialYear financialYear = this.cFinancialYearService.getCurrentFinancialYear();
        if (StringUtils.isNotBlank((CharSequence)collectionDetailsRequest.getType())) {
            if (collectionDetailsRequest.getType().equalsIgnoreCase("region")) {
                aggregationField = "regionName";
            } else if (collectionDetailsRequest.getType().equalsIgnoreCase("district")) {
                aggregationField = "districtName";
            } else if (collectionDetailsRequest.getType().equalsIgnoreCase("ulb")) {
                aggregationField = "cityName";
            } else if (collectionDetailsRequest.getType().equalsIgnoreCase("grade")) {
                aggregationField = "cityGrade";
            } else if (collectionDetailsRequest.getType().equalsIgnoreCase("ward") || collectionDetailsRequest.getType().equalsIgnoreCase("billcollector")) {
                aggregationField = "revenueWard";
            }
        }
        if (StringUtils.isNotBlank((CharSequence)collectionDetailsRequest.getFromDate()) && StringUtils.isNotBlank((CharSequence)collectionDetailsRequest.getToDate())) {
            fromDate = DateUtils.getDate((String)collectionDetailsRequest.getToDate(), (String)"yyyy-MM-dd");
            toDate = org.apache.commons.lang3.time.DateUtils.addDays((Date)DateUtils.getDate((String)collectionDetailsRequest.getToDate(), (String)"yyyy-MM-dd"), (int)1);
        } else {
            fromDate = new Date();
            toDate = org.apache.commons.lang3.time.DateUtils.addDays((Date)new Date(), (int)1);
        }
        Long startTime = System.currentTimeMillis();
        Map<String, BigDecimal> todayCollMap = this.getCollectionAndDemandValues(collectionDetailsRequest, fromDate, toDate, "receipts", TOTAL_AMOUNT, aggregationField);
        if (StringUtils.isNotBlank((CharSequence)collectionDetailsRequest.getFromDate()) && StringUtils.isNotBlank((CharSequence)collectionDetailsRequest.getToDate())) {
            fromDate = DateUtils.getDate((String)collectionDetailsRequest.getFromDate(), (String)"yyyy-MM-dd");
            toDate = org.apache.commons.lang3.time.DateUtils.addDays((Date)DateUtils.getDate((String)collectionDetailsRequest.getToDate(), (String)"yyyy-MM-dd"), (int)1);
        } else {
            fromDate = DateUtils.startOfDay((Date)financialYear.getStartingDate());
            toDate = org.apache.commons.lang3.time.DateUtils.addDays((Date)new Date(), (int)1);
        }
        int noOfMonths = DateUtils.noOfMonthsBetween((Date)fromDate, (Date)toDate) + 1;
        Map<String, BigDecimal> cytdCollMap = this.getCollectionAndDemandValues(collectionDetailsRequest, fromDate, toDate, "receipts", TOTAL_AMOUNT, aggregationField);
        Map<String, BigDecimal> totalDemandMap = this.getCollectionAndDemandValues(collectionDetailsRequest, fromDate, toDate, "waterchargeconsumer", TOTAL_DEMAND, aggregationField);
        Map<String, BigDecimal> currYrTotalDemandMap = this.getCollectionAndDemandValues(collectionDetailsRequest, fromDate, toDate, "waterchargeconsumer", TOTAL_DEMAND, aggregationField);
        Map<String, BigDecimal> lytdCollMap = this.getCollectionAndDemandValues(collectionDetailsRequest, org.apache.commons.lang3.time.DateUtils.addYears((Date)fromDate, (int)-1), org.apache.commons.lang3.time.DateUtils.addYears((Date)toDate, (int)-1), "receipts", TOTAL_AMOUNT, aggregationField);
        if ("ward".equalsIgnoreCase(collectionDetailsRequest.getType())) {
            wardWiseBillCollectors = this.getWardWiseBillCollectors(collectionDetailsRequest);
        }
        Long timeTaken = System.currentTimeMillis() - startTime;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Time taken by getCollectionAndDemandValues() is (millisecs) : " + timeTaken);
        }
        startTime = System.currentTimeMillis();
        for (Map.Entry<String, BigDecimal> entry : cytdCollMap.entrySet()) {
            WaterChargeDashBoardResponse collIndData = new WaterChargeDashBoardResponse();
            String name = entry.getKey();
            if (aggregationField.equals("regionName")) {
                collIndData.setRegionName(name);
            } else if (aggregationField.equals("districtName")) {
                collIndData.setRegionName(collectionDetailsRequest.getRegionName());
                collIndData.setDistrictName(name);
            } else if ("cityName".equals(aggregationField)) {
                collIndData.setUlbName(name);
                collIndData.setDistrictName(collectionDetailsRequest.getDistrictName());
                collIndData.setUlbGrade(collectionDetailsRequest.getUlbGrade());
            } else if (aggregationField.equals("cityGrade")) {
                collIndData.setUlbGrade(name);
            } else if ("revenueWard".equals(aggregationField)) {
                collIndData.setWardName(name);
            }
            if ("ward".equalsIgnoreCase(collectionDetailsRequest.getType()) && !wardWiseBillCollectors.isEmpty()) {
                collIndData.setBillCollector(wardWiseBillCollectors.get(name) == null ? "" : ((BillCollectorIndex)wardWiseBillCollectors.get(name)).getBillCollector());
            }
            collIndData.setTodayColl(todayCollMap.get(name) == null ? BigDecimal.ZERO : todayCollMap.get(name));
            collIndData.setCurrentYearTillDateColl(entry.getValue());
            BigDecimal currentYearTotalDemand = currYrTotalDemandMap.get(name) == null ? BigDecimal.valueOf(0L) : currYrTotalDemandMap.get(name);
            BigDecimal cytdDmd = currentYearTotalDemand.divide(BigDecimal.valueOf(12L), 4).multiply(BigDecimal.valueOf(noOfMonths));
            collIndData.setCurrentYearTillDateDmd(cytdDmd);
            if (cytdDmd != BigDecimal.valueOf(0L)) {
                BigDecimal balance = cytdDmd.subtract(collIndData.getCurrentYearTillDateColl());
                BigDecimal performance = collIndData.getCurrentYearTillDateColl().multiply(WaterTaxConstants.BIGDECIMAL_100).divide(cytdDmd, 1, 4);
                collIndData.setPerformance(performance);
                collIndData.setCurrentYearTillDateBalDmd(balance);
            }
            collIndData.setTotalDmd(totalDemandMap.get(name) == null ? BigDecimal.ZERO : totalDemandMap.get(name));
            collIndData.setLastYearTillDateColl(lytdCollMap.get(name) == null ? BigDecimal.ZERO : lytdCollMap.get(name));
            BigDecimal variance = collIndData.getLastYearTillDateColl().compareTo(BigDecimal.ZERO) == 0 ? WaterTaxConstants.BIGDECIMAL_100 : collIndData.getCurrentYearTillDateColl().subtract(collIndData.getLastYearTillDateColl()).multiply(WaterTaxConstants.BIGDECIMAL_100).divide(collIndData.getLastYearTillDateColl(), 1, 4);
            collIndData.setLastYearVar(variance);
            collIndDataList.add(collIndData);
        }
        timeTaken = System.currentTimeMillis() - startTime;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Time taken for setting values in getResponseTableData() is (millisecs): " + timeTaken);
        }
        return collIndDataList;
    }

    public Map<String, BigDecimal> getCollectionAndDemandValues(WaterChargeDashBoardRequest collectionDetailsRequest, Date fromDate, Date toDate, String indexName, String fieldName, String aggregationField) {
        BoolQueryBuilder boolQuery = this.prepareWhereClause(collectionDetailsRequest, indexName);
        if (indexName.equals("receipts")) {
            boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.rangeQuery((String)RECEIPT_DATEINDEX).gte(WaterTaxConstants.DATEFORMATTER_YYYY_MM_DD.format(fromDate)).lte(WaterTaxConstants.DATEFORMATTER_YYYY_MM_DD.format(toDate)).includeUpper(false)).mustNot((QueryBuilder)QueryBuilders.matchQuery((String)STATUS, (Object)CANCELLED));
        }
        AggregationBuilder aggregation = ((TermsBuilder)AggregationBuilders.terms((String)BY_CITY).field(aggregationField)).size(120).subAggregation((AbstractAggregationBuilder)AggregationBuilders.sum((String)"total").field(fieldName));
        NativeSearchQuery searchQueryColl = new NativeSearchQueryBuilder().withIndices(new String[]{indexName}).withQuery((QueryBuilder)boolQuery).addAggregation((AbstractAggregationBuilder)aggregation).build();
        Aggregations collAggr = (Aggregations)this.elasticsearchTemplate.query((SearchQuery)searchQueryColl, response -> response.getAggregations());
        StringTerms cityAggr = (StringTerms)collAggr.get(BY_CITY);
        HashMap<String, BigDecimal> cytdCollMap = new HashMap<String, BigDecimal>();
        for (Terms.Bucket entry : cityAggr.getBuckets()) {
            Sum aggr = (Sum)entry.getAggregations().get("total");
            cytdCollMap.put(String.valueOf(entry.getKey()), BigDecimal.valueOf(aggr.getValue()).setScale(0, 4));
        }
        return cytdCollMap;
    }

    public List<WaterChargeDashBoardResponse> getMonthwiseCollectionDetails(WaterChargeDashBoardRequest collectionDetailsRequest) {
        Date toDate;
        Date fromDate;
        ArrayList<WaterChargeDashBoardResponse> collTrendsList = new ArrayList<WaterChargeDashBoardResponse>();
        CFinancialYear financialYear = this.cFinancialYearService.getCurrentFinancialYear();
        Date finYearStartDate = financialYear.getStartingDate();
        Date finYearEndDate = financialYear.getEndingDate();
        Map monthValuesMap = DateUtils.getAllMonthsWithFullNames();
        ArrayList yearwiseMonthlyCollList = new ArrayList();
        if (StringUtils.isNotBlank((CharSequence)collectionDetailsRequest.getFromDate()) && StringUtils.isNotBlank((CharSequence)collectionDetailsRequest.getToDate())) {
            fromDate = DateUtils.getDate((String)collectionDetailsRequest.getFromDate(), (String)"yyyy-MM-dd");
            toDate = org.apache.commons.lang3.time.DateUtils.addDays((Date)DateUtils.getDate((String)collectionDetailsRequest.getToDate(), (String)"yyyy-MM-dd"), (int)1);
        } else {
            fromDate = DateUtils.startOfDay((Date)financialYear.getStartingDate());
            toDate = org.apache.commons.lang3.time.DateUtils.addDays((Date)new Date(), (int)1);
        }
        Long startTime = System.currentTimeMillis();
        for (int count = 0; count <= 2; ++count) {
            LinkedHashMap<String, BigDecimal> monthwiseColl = new LinkedHashMap<String, BigDecimal>();
            Aggregations collAggr = this.getMonthwiseCollectionsForConsecutiveYears(collectionDetailsRequest, fromDate, toDate);
            Histogram dateaggs = (Histogram)collAggr.get(AGGR_DATE);
            for (Histogram.Bucket entry : dateaggs.getBuckets()) {
                String[] dateArr = entry.getKeyAsString().split("T");
                Date dateForMonth = DateUtils.getDate((String)dateArr[0], (String)"yyyy-MM-dd");
                Integer month = Integer.valueOf(dateArr[0].split("-", 3)[1]);
                String monthName = (String)monthValuesMap.get(month);
                Sum aggregateSum = (Sum)entry.getAggregations().get("current_total");
                if (!DateUtils.between((Date)dateForMonth, (Date)finYearStartDate, (Date)finYearEndDate) || BigDecimal.valueOf(aggregateSum.getValue()).setScale(0, 4).compareTo(BigDecimal.ZERO) <= 0) continue;
                monthwiseColl.put(monthName, BigDecimal.valueOf(aggregateSum.getValue()).setScale(0, 4));
            }
            yearwiseMonthlyCollList.add(monthwiseColl);
            if (StringUtils.isNotBlank((CharSequence)collectionDetailsRequest.getFromDate()) && StringUtils.isNotBlank((CharSequence)collectionDetailsRequest.getToDate())) {
                fromDate = org.apache.commons.lang3.time.DateUtils.addYears((Date)fromDate, (int)-1);
                toDate = org.apache.commons.lang3.time.DateUtils.addYears((Date)toDate, (int)-1);
            } else {
                fromDate = org.apache.commons.lang3.time.DateUtils.addYears((Date)finYearStartDate, (int)-1);
                toDate = org.apache.commons.lang3.time.DateUtils.addYears((Date)finYearEndDate, (int)-1);
            }
            finYearStartDate = org.apache.commons.lang3.time.DateUtils.addYears((Date)finYearStartDate, (int)-1);
            finYearEndDate = org.apache.commons.lang3.time.DateUtils.addYears((Date)finYearEndDate, (int)-1);
        }
        Long timeTaken = System.currentTimeMillis() - startTime;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Time taken by getMonthwiseCollectionsForConsecutiveYears() for 3 consecutive years is (millisecs): " + timeTaken);
        }
        startTime = System.currentTimeMillis();
        if (StringUtils.isBlank((CharSequence)collectionDetailsRequest.getFromDate()) && StringUtils.isBlank((CharSequence)collectionDetailsRequest.getToDate())) {
            for (Map.Entry entry : DateUtils.getAllFinancialYearMonthsWithFullNames().entrySet()) {
                WaterChargeDashBoardResponse collTrend = new WaterChargeDashBoardResponse();
                collTrend.setMonth((String)entry.getValue());
                collTrend.setCurrentYearColl(((Map)yearwiseMonthlyCollList.get(0)).get(collTrend.getMonth()) == null ? BigDecimal.ZERO : (BigDecimal)((Map)yearwiseMonthlyCollList.get(0)).get(collTrend.getMonth()));
                collTrend.setLastYearColl(((Map)yearwiseMonthlyCollList.get(1)).get(collTrend.getMonth()) == null ? BigDecimal.ZERO : (BigDecimal)((Map)yearwiseMonthlyCollList.get(1)).get(collTrend.getMonth()));
                collTrend.setPreviousYearColl(((Map)yearwiseMonthlyCollList.get(2)).get(collTrend.getMonth()) == null ? BigDecimal.ZERO : (BigDecimal)((Map)yearwiseMonthlyCollList.get(2)).get(collTrend.getMonth()));
                collTrendsList.add(collTrend);
            }
        } else {
            for (Map.Entry entry : ((Map)yearwiseMonthlyCollList.get(0)).entrySet()) {
                WaterChargeDashBoardResponse collTrend = new WaterChargeDashBoardResponse();
                collTrend.setMonth((String)entry.getKey());
                collTrend.setCurrentYearColl((BigDecimal)entry.getValue());
                collTrend.setLastYearColl(((Map)yearwiseMonthlyCollList.get(1)).get(collTrend.getMonth()) == null ? BigDecimal.ZERO : (BigDecimal)((Map)yearwiseMonthlyCollList.get(1)).get(collTrend.getMonth()));
                collTrend.setPreviousYearColl(((Map)yearwiseMonthlyCollList.get(2)).get(collTrend.getMonth()) == null ? BigDecimal.ZERO : (BigDecimal)((Map)yearwiseMonthlyCollList.get(2)).get(collTrend.getMonth()));
                collTrendsList.add(collTrend);
            }
        }
        timeTaken = System.currentTimeMillis() - startTime;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Time taken setting values in getMonthwiseCollectionDetails() is (millisecs) : " + timeTaken);
        }
        return collTrendsList;
    }

    public List<WaterChargeConnectionTypeResponse> getMonthwiseCollectionDetailsForConnectionType(WaterChargeDashBoardRequest collectionDetailsRequest) {
        Date toDate;
        Date fromDate;
        ArrayList<WaterChargeConnectionTypeResponse> collTrendsList = new ArrayList<WaterChargeConnectionTypeResponse>();
        CFinancialYear financialYear = this.cFinancialYearService.getCurrentFinancialYear();
        Date finYearStartDate = financialYear.getStartingDate();
        Date finYearEndDate = financialYear.getEndingDate();
        Map monthValuesMap = DateUtils.getAllMonthsWithFullNames();
        ArrayList yearwiseMonthlyCollList = new ArrayList();
        ArrayList yearwiseMonthlyCommercialCollList = new ArrayList();
        if (StringUtils.isNotBlank((CharSequence)collectionDetailsRequest.getFromDate()) && StringUtils.isNotBlank((CharSequence)collectionDetailsRequest.getToDate())) {
            fromDate = DateUtils.getDate((String)collectionDetailsRequest.getFromDate(), (String)"yyyy-MM-dd");
            toDate = org.apache.commons.lang3.time.DateUtils.addDays((Date)DateUtils.getDate((String)collectionDetailsRequest.getToDate(), (String)"yyyy-MM-dd"), (int)1);
        } else {
            fromDate = DateUtils.startOfDay((Date)financialYear.getStartingDate());
            toDate = org.apache.commons.lang3.time.DateUtils.addDays((Date)new Date(), (int)1);
        }
        Long startTime = System.currentTimeMillis();
        for (int count = 0; count <= 2; ++count) {
            Sum aggregateSum;
            String monthName;
            Integer month;
            Date dateForMonth;
            String[] dateArr;
            LinkedHashMap<String, BigDecimal> monthwiseColl = new LinkedHashMap<String, BigDecimal>();
            Aggregations collAggr = this.getMonthwiseCollectionsForConsecutiveYearsTemp(collectionDetailsRequest, fromDate, toDate, "RESIDENTIAL");
            Aggregations collAggrComm = this.getMonthwiseCollectionsForConsecutiveYearsTemp(collectionDetailsRequest, fromDate, toDate, "COMMERCIAL");
            if (collAggr != null) {
                Histogram dateaggs = (Histogram)collAggr.get(AGGR_DATE);
                for (Histogram.Bucket entry : dateaggs.getBuckets()) {
                    dateArr = entry.getKeyAsString().split("T");
                    dateForMonth = DateUtils.getDate((String)dateArr[0], (String)"yyyy-MM-dd");
                    month = Integer.valueOf(dateArr[0].split("-", 3)[1]);
                    monthName = (String)monthValuesMap.get(month);
                    aggregateSum = (Sum)entry.getAggregations().get("current_total");
                    if (!DateUtils.between((Date)dateForMonth, (Date)finYearStartDate, (Date)finYearEndDate) || BigDecimal.valueOf(aggregateSum.getValue()).setScale(0, 4).compareTo(BigDecimal.ZERO) <= 0) continue;
                    monthwiseColl.put(monthName, BigDecimal.valueOf(aggregateSum.getValue()).setScale(0, 4));
                }
            }
            yearwiseMonthlyCollList.add(monthwiseColl);
            LinkedHashMap<String, BigDecimal> monthwiseColl2 = new LinkedHashMap<String, BigDecimal>();
            if (collAggrComm != null) {
                Histogram commdateaggs = (Histogram)collAggrComm.get(AGGR_DATE);
                for (Histogram.Bucket entry : commdateaggs.getBuckets()) {
                    dateArr = entry.getKeyAsString().split("T");
                    dateForMonth = DateUtils.getDate((String)dateArr[0], (String)"yyyy-MM-dd");
                    month = Integer.valueOf(dateArr[0].split("-", 3)[1]);
                    monthName = (String)monthValuesMap.get(month);
                    aggregateSum = (Sum)entry.getAggregations().get("current_total");
                    if (!DateUtils.between((Date)dateForMonth, (Date)finYearStartDate, (Date)finYearEndDate) || BigDecimal.valueOf(aggregateSum.getValue()).setScale(0, 4).compareTo(BigDecimal.ZERO) <= 0) continue;
                    monthwiseColl2.put(monthName, BigDecimal.valueOf(aggregateSum.getValue()).setScale(0, 4));
                }
            }
            yearwiseMonthlyCommercialCollList.add(monthwiseColl2);
            if (StringUtils.isNotBlank((CharSequence)collectionDetailsRequest.getFromDate()) && StringUtils.isNotBlank((CharSequence)collectionDetailsRequest.getToDate())) {
                fromDate = org.apache.commons.lang3.time.DateUtils.addYears((Date)fromDate, (int)-1);
                toDate = org.apache.commons.lang3.time.DateUtils.addYears((Date)toDate, (int)-1);
            } else {
                fromDate = org.apache.commons.lang3.time.DateUtils.addYears((Date)finYearStartDate, (int)-1);
                toDate = org.apache.commons.lang3.time.DateUtils.addYears((Date)finYearEndDate, (int)-1);
            }
            finYearStartDate = org.apache.commons.lang3.time.DateUtils.addYears((Date)finYearStartDate, (int)-1);
            finYearEndDate = org.apache.commons.lang3.time.DateUtils.addYears((Date)finYearEndDate, (int)-1);
        }
        Long timeTaken = System.currentTimeMillis() - startTime;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Time taken by getMonthwiseCollectionsForConsecutiveYears() for 3 consecutive years is (millisecs): " + timeTaken);
        }
        if (StringUtils.isBlank((CharSequence)collectionDetailsRequest.getFromDate()) && StringUtils.isBlank((CharSequence)collectionDetailsRequest.getToDate())) {
            for (Map.Entry entry : DateUtils.getAllFinancialYearMonthsWithFullNames().entrySet()) {
                WaterChargeConnectionTypeResponse collTrend = new WaterChargeConnectionTypeResponse();
                collTrend.setMonth((String)entry.getValue());
                collTrend.setCurrentYearResidentialColl(((Map)yearwiseMonthlyCollList.get(0)).get(collTrend.getMonth()) == null ? BigDecimal.ZERO : (BigDecimal)((Map)yearwiseMonthlyCollList.get(0)).get(collTrend.getMonth()));
                collTrend.setLastYearResidentialColl(((Map)yearwiseMonthlyCollList.get(1)).get(collTrend.getMonth()) == null ? BigDecimal.ZERO : (BigDecimal)((Map)yearwiseMonthlyCollList.get(1)).get(collTrend.getMonth()));
                collTrend.setPreviousYearResidentialColl(((Map)yearwiseMonthlyCollList.get(2)).get(collTrend.getMonth()) == null ? BigDecimal.ZERO : (BigDecimal)((Map)yearwiseMonthlyCollList.get(2)).get(collTrend.getMonth()));
                collTrend.setCurrentYearCommercialColl(((Map)yearwiseMonthlyCommercialCollList.get(0)).get(collTrend.getMonth()) == null ? BigDecimal.ZERO : (BigDecimal)((Map)yearwiseMonthlyCommercialCollList.get(0)).get(collTrend.getMonth()));
                collTrend.setLastYearCommercialColl(((Map)yearwiseMonthlyCommercialCollList.get(1)).get(collTrend.getMonth()) == null ? BigDecimal.ZERO : (BigDecimal)((Map)yearwiseMonthlyCommercialCollList.get(1)).get(collTrend.getMonth()));
                collTrend.setPreviousYearCommercialColl(((Map)yearwiseMonthlyCommercialCollList.get(2)).get(collTrend.getMonth()) == null ? BigDecimal.ZERO : (BigDecimal)((Map)yearwiseMonthlyCommercialCollList.get(2)).get(collTrend.getMonth()));
                collTrendsList.add(collTrend);
            }
        } else {
            for (Map.Entry entry : ((Map)yearwiseMonthlyCollList.get(0)).entrySet()) {
                WaterChargeConnectionTypeResponse collTrend = new WaterChargeConnectionTypeResponse();
                collTrend.setMonth((String)entry.getKey());
                collTrend.setCurrentYearResidentialColl((BigDecimal)entry.getValue());
                collTrend.setLastYearResidentialColl(((Map)yearwiseMonthlyCollList.get(1)).get(collTrend.getMonth()) == null ? BigDecimal.ZERO : (BigDecimal)((Map)yearwiseMonthlyCollList.get(1)).get(collTrend.getMonth()));
                collTrend.setPreviousYearResidentialColl(((Map)yearwiseMonthlyCollList.get(2)).get(collTrend.getMonth()) == null ? BigDecimal.ZERO : (BigDecimal)((Map)yearwiseMonthlyCollList.get(2)).get(collTrend.getMonth()));
                collTrend.setCurrentYearCommercialColl(((Map)yearwiseMonthlyCommercialCollList.get(0)).get(collTrend.getMonth()) == null ? BigDecimal.ZERO : (BigDecimal)((Map)yearwiseMonthlyCommercialCollList.get(0)).get(collTrend.getMonth()));
                collTrend.setLastYearCommercialColl(((Map)yearwiseMonthlyCommercialCollList.get(1)).get(collTrend.getMonth()) == null ? BigDecimal.ZERO : (BigDecimal)((Map)yearwiseMonthlyCommercialCollList.get(1)).get(collTrend.getMonth()));
                collTrend.setPreviousYearCommercialColl(((Map)yearwiseMonthlyCommercialCollList.get(2)).get(collTrend.getMonth()) == null ? BigDecimal.ZERO : (BigDecimal)((Map)yearwiseMonthlyCommercialCollList.get(2)).get(collTrend.getMonth()));
                collTrendsList.add(collTrend);
            }
        }
        return collTrendsList;
    }

    private Aggregations getMonthwiseCollectionsForConsecutiveYearsTemp(WaterChargeDashBoardRequest collectionDetailsRequest, Date fromDate, Date toDate, String usageType) {
        BoolQueryBuilder boolQuery = QueryBuilders.boolQuery();
        boolQuery = boolQuery.mustNot((QueryBuilder)QueryBuilders.matchQuery((String)STATUS, (Object)CANCELLED));
        boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)BILLING_SERVICE, (Object)"Water Charges"));
        if ((boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)"consumerType", (Object)usageType))) != null) {
            if (StringUtils.isNotBlank((CharSequence)collectionDetailsRequest.getRegionName())) {
                boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)"regionName", (Object)collectionDetailsRequest.getRegionName()));
            }
            if (StringUtils.isNotBlank((CharSequence)collectionDetailsRequest.getDistrictName())) {
                boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)"districtName", (Object)collectionDetailsRequest.getDistrictName()));
            }
            if (StringUtils.isNotBlank((CharSequence)collectionDetailsRequest.getUlbGrade())) {
                boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)"cityGrade", (Object)collectionDetailsRequest.getUlbGrade()));
            }
            if (StringUtils.isNotBlank((CharSequence)collectionDetailsRequest.getUlbCode())) {
                boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)CITYCODE, (Object)collectionDetailsRequest.getUlbCode()));
            }
        }
        boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.rangeQuery((String)RECEIPT_DATEINDEX).gte(WaterTaxConstants.DATEFORMATTER_YYYY_MM_DD.format(fromDate)).lte(WaterTaxConstants.DATEFORMATTER_YYYY_MM_DD.format(toDate)).includeUpper(false));
        AggregationBuilder monthAggregation = ((DateHistogramBuilder)AggregationBuilders.dateHistogram((String)AGGR_DATE).field(RECEIPT_DATEINDEX)).interval(DateHistogramInterval.MONTH).subAggregation((AbstractAggregationBuilder)AggregationBuilders.sum((String)"current_total").field(TOTAL_AMOUNT));
        NativeSearchQuery searchQueryColl = new NativeSearchQueryBuilder().withIndices(new String[]{"receipts"}).withQuery((QueryBuilder)boolQuery).addAggregation((AbstractAggregationBuilder)monthAggregation).build();
        return (Aggregations)this.elasticsearchTemplate.query((SearchQuery)searchQueryColl, response -> response.getAggregations());
    }

    private Aggregations getMonthwiseCollectionsForConsecutiveYears(WaterChargeDashBoardRequest collectionDetailsRequest, Date fromDate, Date toDate) {
        BoolQueryBuilder boolQuery = this.prepareWhereClause(collectionDetailsRequest, "receipts");
        boolQuery = boolQuery.mustNot((QueryBuilder)QueryBuilders.matchQuery((String)STATUS, (Object)CANCELLED));
        AggregationBuilder monthAggregation = ((DateHistogramBuilder)AggregationBuilders.dateHistogram((String)AGGR_DATE).field(RECEIPT_DATEINDEX)).interval(DateHistogramInterval.MONTH).subAggregation((AbstractAggregationBuilder)AggregationBuilders.sum((String)"current_total").field(TOTAL_AMOUNT));
        NativeSearchQuery searchQueryColl = new NativeSearchQueryBuilder().withIndices(new String[]{"receipts"}).withQuery((QueryBuilder)boolQuery.filter((QueryBuilder)QueryBuilders.rangeQuery((String)RECEIPT_DATEINDEX).gte(WaterTaxConstants.DATEFORMATTER_YYYY_MM_DD.format(fromDate)).lte(WaterTaxConstants.DATEFORMATTER_YYYY_MM_DD.format(toDate)).includeUpper(false))).addAggregation((AbstractAggregationBuilder)monthAggregation).build();
        return (Aggregations)this.elasticsearchTemplate.query((SearchQuery)searchQueryColl, response -> response.getAggregations());
    }

    public List<WaterChargeDashBoardResponse> getTotalReceiptsCount(WaterChargeDashBoardRequest collectionDetailsRequest) {
        Date toDate;
        Date fromDate;
        CFinancialYear financialyear = this.cFinancialYearService.getCurrentFinancialYear();
        ArrayList<WaterChargeDashBoardResponse> receiptDetailsList = new ArrayList<WaterChargeDashBoardResponse>();
        WaterChargeDashBoardResponse receiptDetails = new WaterChargeDashBoardResponse();
        if (StringUtils.isNotBlank((CharSequence)collectionDetailsRequest.getFromDate()) && StringUtils.isNotBlank((CharSequence)collectionDetailsRequest.getToDate())) {
            fromDate = DateUtils.getDate((String)collectionDetailsRequest.getToDate(), (String)"yyyy-MM-dd");
            toDate = org.apache.commons.lang3.time.DateUtils.addDays((Date)DateUtils.getDate((String)collectionDetailsRequest.getToDate(), (String)"yyyy-MM-dd"), (int)1);
        } else {
            fromDate = new Date();
            toDate = org.apache.commons.lang3.time.DateUtils.addDays((Date)new Date(), (int)1);
        }
        Long startTime = System.currentTimeMillis();
        Long receiptsCount = this.getTotalReceiptCountsForDates(collectionDetailsRequest, fromDate, toDate);
        receiptDetails.setTodayRcptsCount(receiptsCount);
        if (StringUtils.isNotBlank((CharSequence)collectionDetailsRequest.getFromDate()) && StringUtils.isNotBlank((CharSequence)collectionDetailsRequest.getToDate())) {
            fromDate = DateUtils.getDate((String)collectionDetailsRequest.getFromDate(), (String)"yyyy-MM-dd");
            toDate = org.apache.commons.lang3.time.DateUtils.addDays((Date)DateUtils.getDate((String)collectionDetailsRequest.getToDate(), (String)"yyyy-MM-dd"), (int)1);
        } else {
            fromDate = DateUtils.startOfDay((Date)financialyear.getStartingDate());
            toDate = org.apache.commons.lang3.time.DateUtils.addDays((Date)new Date(), (int)1);
        }
        receiptsCount = this.getTotalReceiptCountsForDates(collectionDetailsRequest, fromDate, toDate);
        receiptDetails.setCurrentYearTillDateRcptsCount(receiptsCount);
        receiptsCount = this.getTotalReceiptCountsForDates(collectionDetailsRequest, org.apache.commons.lang3.time.DateUtils.addYears((Date)fromDate, (int)-1), org.apache.commons.lang3.time.DateUtils.addYears((Date)toDate, (int)-1));
        receiptDetails.setLastYearTillDateRcptsCount(receiptsCount);
        Long timeTaken = System.currentTimeMillis() - startTime;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Time taken by getTotalReceiptCountsForDates() for all dates is (millisecs) : " + timeTaken);
        }
        receiptDetailsList.add(receiptDetails);
        return receiptDetailsList;
    }

    private Long getTotalReceiptCountsForDates(WaterChargeDashBoardRequest collectionDetailsRequest, Date fromDate, Date toDate) {
        BoolQueryBuilder boolQuery = this.prepareWhereClause(collectionDetailsRequest, "receipts");
        boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.rangeQuery((String)RECEIPT_DATEINDEX).gte(WaterTaxConstants.DATEFORMATTER_YYYY_MM_DD.format(fromDate)).lte(WaterTaxConstants.DATEFORMATTER_YYYY_MM_DD.format(toDate)).includeUpper(false)).mustNot((QueryBuilder)QueryBuilders.matchQuery((String)STATUS, (Object)CANCELLED));
        NativeSearchQuery searchQueryColl = new NativeSearchQueryBuilder().withIndices(new String[]{"receipts"}).withQuery((QueryBuilder)boolQuery).addAggregation((AbstractAggregationBuilder)AggregationBuilders.count((String)RECEIPT_COUNT_INDEX).field(CNSUMER_CODEINDEX)).build();
        Aggregations collCountAggr = (Aggregations)this.elasticsearchTemplate.query((SearchQuery)searchQueryColl, response -> response.getAggregations());
        ValueCount aggr = (ValueCount)collCountAggr.get(RECEIPT_COUNT_INDEX);
        return aggr.getValue();
    }

    public List<WaterChargeDashBoardResponse> getMonthwiseReceiptsTrend(WaterChargeDashBoardRequest waterChargeDashBoardRequest) {
        Date toDate;
        Date fromDate;
        ArrayList<WaterChargeDashBoardResponse> rcptTrendsList = new ArrayList<WaterChargeDashBoardResponse>();
        CFinancialYear financialYear = this.cFinancialYearService.getCurrentFinancialYear();
        Date finYearStartDate = financialYear.getStartingDate();
        Date finYearEndDate = financialYear.getEndingDate();
        Map monthValuesMap = DateUtils.getAllMonthsWithFullNames();
        ArrayList<Map<String, Long>> yearwiseMonthlyCountList = new ArrayList<Map<String, Long>>();
        if (StringUtils.isNotBlank((CharSequence)waterChargeDashBoardRequest.getFromDate()) && StringUtils.isNotBlank((CharSequence)waterChargeDashBoardRequest.getToDate())) {
            fromDate = DateUtils.getDate((String)waterChargeDashBoardRequest.getFromDate(), (String)"yyyy-MM-dd");
            toDate = org.apache.commons.lang3.time.DateUtils.addDays((Date)DateUtils.getDate((String)waterChargeDashBoardRequest.getToDate(), (String)"yyyy-MM-dd"), (int)1);
        } else {
            fromDate = new DateTime().withMonthOfYear(4).dayOfMonth().withMinimumValue().toDate();
            toDate = org.apache.commons.lang3.time.DateUtils.addDays((Date)new Date(), (int)1);
        }
        Long startTime = System.currentTimeMillis();
        for (int count = 0; count <= 2; ++count) {
            LinkedHashMap<String, Long> monthwiseCount = new LinkedHashMap<String, Long>();
            Aggregations collAggregation = this.getReceiptsCountForConsecutiveYears(waterChargeDashBoardRequest, fromDate, toDate);
            Histogram dateaggs = (Histogram)collAggregation.get(AGGR_DATE);
            for (Histogram.Bucket entry : dateaggs.getBuckets()) {
                String[] dateArr = entry.getKeyAsString().split("T");
                Date dateForMonth = DateUtils.getDate((String)dateArr[0], (String)"yyyy-MM-dd");
                Integer month = Integer.valueOf(dateArr[0].split("-", 3)[1]);
                String monthName = (String)monthValuesMap.get(month);
                Long rcptCount = entry.getDocCount();
                if (!DateUtils.between((Date)dateForMonth, (Date)finYearStartDate, (Date)finYearEndDate) || rcptCount <= 0L) continue;
                monthwiseCount.put(monthName, rcptCount);
            }
            yearwiseMonthlyCountList.add(monthwiseCount);
            if (StringUtils.isNotBlank((CharSequence)waterChargeDashBoardRequest.getFromDate()) && StringUtils.isNotBlank((CharSequence)waterChargeDashBoardRequest.getToDate())) {
                fromDate = org.apache.commons.lang3.time.DateUtils.addYears((Date)fromDate, (int)-1);
                toDate = org.apache.commons.lang3.time.DateUtils.addYears((Date)toDate, (int)-1);
            } else {
                fromDate = org.apache.commons.lang3.time.DateUtils.addYears((Date)finYearStartDate, (int)-1);
                toDate = org.apache.commons.lang3.time.DateUtils.addYears((Date)finYearEndDate, (int)-1);
            }
            finYearStartDate = org.apache.commons.lang3.time.DateUtils.addYears((Date)finYearStartDate, (int)-1);
            finYearEndDate = org.apache.commons.lang3.time.DateUtils.addYears((Date)finYearEndDate, (int)-1);
        }
        Long timeTaken = System.currentTimeMillis() - startTime;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Time taken by getReceiptsCountForConsecutiveYears() for 3 consecutive years is (millisecs) : " + timeTaken);
        }
        startTime = System.currentTimeMillis();
        this.prepareReceiptTrendList(waterChargeDashBoardRequest, rcptTrendsList, yearwiseMonthlyCountList);
        timeTaken = System.currentTimeMillis() - startTime;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Time taken foro setting values in getMonthwiseReceiptsTrend() is (millisecs): " + timeTaken);
        }
        return rcptTrendsList;
    }

    private void prepareReceiptTrendList(WaterChargeDashBoardRequest waterChargeDashBoardRequest, List<WaterChargeDashBoardResponse> rcptTrendsList, List<Map<String, Long>> yearwiseMonthlyCountList) {
        if (StringUtils.isBlank((CharSequence)waterChargeDashBoardRequest.getFromDate()) && StringUtils.isBlank((CharSequence)waterChargeDashBoardRequest.getToDate())) {
            for (Map.Entry entry : DateUtils.getAllFinancialYearMonthsWithFullNames().entrySet()) {
                WaterChargeDashBoardResponse rcptsTrend = new WaterChargeDashBoardResponse();
                rcptsTrend.setMonth((String)entry.getValue());
                rcptsTrend.setCurrentYearRcptsCount(yearwiseMonthlyCountList.get(0).get(rcptsTrend.getMonth()) == null ? Long.valueOf(0L) : yearwiseMonthlyCountList.get(0).get(rcptsTrend.getMonth()));
                rcptsTrend.setLastYearRcptsCount(yearwiseMonthlyCountList.get(1).get(rcptsTrend.getMonth()) == null ? Long.valueOf(0L) : yearwiseMonthlyCountList.get(1).get(rcptsTrend.getMonth()));
                rcptsTrend.setPreviousYearRcptsCount(yearwiseMonthlyCountList.get(2).get(rcptsTrend.getMonth()) == null ? Long.valueOf(0L) : yearwiseMonthlyCountList.get(2).get(rcptsTrend.getMonth()));
                rcptTrendsList.add(rcptsTrend);
            }
        } else {
            for (Map.Entry<String, Long> entry : yearwiseMonthlyCountList.get(0).entrySet()) {
                WaterChargeDashBoardResponse rcptsTrend = new WaterChargeDashBoardResponse();
                rcptsTrend.setMonth(entry.getKey());
                rcptsTrend.setCurrentYearRcptsCount(entry.getValue());
                rcptsTrend.setLastYearRcptsCount(yearwiseMonthlyCountList.get(1).get(rcptsTrend.getMonth()) == null ? Long.valueOf(0L) : yearwiseMonthlyCountList.get(1).get(rcptsTrend.getMonth()));
                rcptsTrend.setPreviousYearRcptsCount(yearwiseMonthlyCountList.get(2).get(rcptsTrend.getMonth()) == null ? Long.valueOf(0L) : yearwiseMonthlyCountList.get(2).get(rcptsTrend.getMonth()));
                rcptTrendsList.add(rcptsTrend);
            }
        }
    }

    private Aggregations getReceiptsCountForConsecutiveYears(WaterChargeDashBoardRequest collectionDetailsRequest, Date fromDate, Date toDate) {
        BoolQueryBuilder boolQuery = this.prepareWhereClause(collectionDetailsRequest, "receipts");
        boolQuery = boolQuery.mustNot((QueryBuilder)QueryBuilders.matchQuery((String)STATUS, (Object)CANCELLED));
        AggregationBuilder monthAggregation = ((DateHistogramBuilder)AggregationBuilders.dateHistogram((String)AGGR_DATE).field(RECEIPT_DATEINDEX)).interval(DateHistogramInterval.MONTH).subAggregation((AbstractAggregationBuilder)AggregationBuilders.count((String)RECEIPT_COUNT_INDEX).field("receiptNumber"));
        NativeSearchQuery searchQueryColl = new NativeSearchQueryBuilder().withIndices(new String[]{"receipts"}).withQuery((QueryBuilder)boolQuery.filter((QueryBuilder)QueryBuilders.rangeQuery((String)RECEIPT_DATEINDEX).gte(WaterTaxConstants.DATEFORMATTER_YYYY_MM_DD.format(fromDate)).lte(WaterTaxConstants.DATEFORMATTER_YYYY_MM_DD.format(toDate)).includeUpper(false))).addAggregation((AbstractAggregationBuilder)monthAggregation).build();
        return (Aggregations)this.elasticsearchTemplate.query((SearchQuery)searchQueryColl, response -> response.getAggregations());
    }

    public List<WaterChargeDashBoardResponse> getReceiptTableData(WaterChargeDashBoardRequest collectionDetailsRequest) {
        Date toDate;
        Date fromDate;
        ArrayList<WaterChargeDashBoardResponse> receiptDataList = new ArrayList<WaterChargeDashBoardResponse>();
        String aggregationField = this.getaggregationFiledByType(collectionDetailsRequest);
        CFinancialYear financialyear = this.cFinancialYearService.getCurrentFinancialYear();
        if (StringUtils.isNotBlank((CharSequence)collectionDetailsRequest.getFromDate()) && StringUtils.isNotBlank((CharSequence)collectionDetailsRequest.getToDate())) {
            fromDate = DateUtils.getDate((String)collectionDetailsRequest.getToDate(), (String)"yyyy-MM-dd");
            toDate = org.apache.commons.lang3.time.DateUtils.addDays((Date)DateUtils.getDate((String)collectionDetailsRequest.getToDate(), (String)"yyyy-MM-dd"), (int)1);
        } else {
            fromDate = new Date();
            toDate = org.apache.commons.lang3.time.DateUtils.addDays((Date)new Date(), (int)1);
        }
        Long startTime = System.currentTimeMillis();
        Map<String, BigDecimal> currDayCollMap = this.getCollectionAndDemandCountResults(collectionDetailsRequest, fromDate, toDate, "receipts", CNSUMER_CODEINDEX, aggregationField);
        if (StringUtils.isNotBlank((CharSequence)collectionDetailsRequest.getFromDate()) && StringUtils.isNotBlank((CharSequence)collectionDetailsRequest.getToDate())) {
            fromDate = DateUtils.getDate((String)collectionDetailsRequest.getFromDate(), (String)"yyyy-MM-dd");
            toDate = org.apache.commons.lang3.time.DateUtils.addDays((Date)DateUtils.getDate((String)collectionDetailsRequest.getToDate(), (String)"yyyy-MM-dd"), (int)1);
        } else {
            fromDate = DateUtils.startOfDay((Date)financialyear.getStartingDate());
            toDate = org.apache.commons.lang3.time.DateUtils.addDays((Date)new Date(), (int)1);
        }
        Map<String, BigDecimal> cytdCollMap = this.getCollectionAndDemandCountResults(collectionDetailsRequest, fromDate, toDate, "receipts", CNSUMER_CODEINDEX, aggregationField);
        Map<String, BigDecimal> lytdCollMap = this.getCollectionAndDemandCountResults(collectionDetailsRequest, org.apache.commons.lang3.time.DateUtils.addYears((Date)fromDate, (int)-1), org.apache.commons.lang3.time.DateUtils.addYears((Date)toDate, (int)-1), "receipts", CNSUMER_CODEINDEX, aggregationField);
        Long timeTaken = System.currentTimeMillis() - startTime;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Time taken by getCollectionAndDemandCountResults() is : (millisecs) " + timeTaken);
        }
        startTime = System.currentTimeMillis();
        for (Map.Entry<String, BigDecimal> entry : cytdCollMap.entrySet()) {
            this.prepareReceiptDetailListFromMap(collectionDetailsRequest, receiptDataList, aggregationField, currDayCollMap, lytdCollMap, entry);
        }
        timeTaken = System.currentTimeMillis() - startTime;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Time taken for setting values in getReceiptTableData() is (millisecs): " + timeTaken);
        }
        return receiptDataList;
    }

    private String getaggregationFiledByType(WaterChargeDashBoardRequest collectionDetailsRequest) {
        String aggregationField = "regionName";
        if (StringUtils.isNotBlank((CharSequence)collectionDetailsRequest.getType())) {
            if (collectionDetailsRequest.getType().equalsIgnoreCase("region")) {
                aggregationField = "regionName";
            } else if (collectionDetailsRequest.getType().equalsIgnoreCase("district")) {
                aggregationField = "districtName";
            } else if (collectionDetailsRequest.getType().equalsIgnoreCase("ulb")) {
                aggregationField = "cityName";
            } else if (collectionDetailsRequest.getType().equalsIgnoreCase("grade")) {
                aggregationField = "cityGrade";
            } else if (collectionDetailsRequest.getType().equalsIgnoreCase("ward")) {
                aggregationField = "revenueWard";
            }
        }
        return aggregationField;
    }

    public List<WaterChargeConnectionTypeResponse> getResponseDataForConnectionType(WaterChargeDashBoardRequest collectionDetailsRequest) {
        ArrayList<WaterChargeConnectionTypeResponse> waterchargeConndemandList = new ArrayList<WaterChargeConnectionTypeResponse>();
        String aggregationField = this.getaggregationFiledByType(collectionDetailsRequest);
        Map<String, Long> connectionResidentialcountMap = this.getConnectionCountResults(collectionDetailsRequest, "waterchargeconsumer", CNSUMER_CODEINDEX, aggregationField, "RESIDENTIAL");
        Map<String, BigDecimal> connectionResidentialTotalCollectionMap = this.getSumOfConnectionTotalCollection(collectionDetailsRequest, "receipts", aggregationField, "RESIDENTIAL", null);
        Map<String, BigDecimal> connectionResidentialTotalDemandMap = this.getSumOfConnectionTotalCollection(collectionDetailsRequest, "waterchargeconsumer", aggregationField, "RESIDENTIAL", TOTAL_DEMAND);
        Map<String, Long> connectionCommercialcountMap = this.getConnectionCountResults(collectionDetailsRequest, "waterchargeconsumer", CNSUMER_CODEINDEX, aggregationField, "COMMERCIAL");
        Map<String, BigDecimal> connectionCOmmercialTotalCollectionMap = this.getSumOfConnectionTotalCollection(collectionDetailsRequest, "receipts", aggregationField, "COMMERCIAL", null);
        Map<String, BigDecimal> connectionCOmmercialTotalDemandMap = this.getSumOfConnectionTotalCollection(collectionDetailsRequest, "waterchargeconsumer", aggregationField, "COMMERCIAL", TOTAL_DEMAND);
        for (Map.Entry<String, Long> entry : connectionResidentialcountMap.entrySet()) {
            this.prepareResponseDataForConnectionType(collectionDetailsRequest, waterchargeConndemandList, aggregationField, connectionResidentialTotalDemandMap, connectionCommercialcountMap, connectionCOmmercialTotalDemandMap, entry, connectionResidentialTotalCollectionMap, connectionCOmmercialTotalCollectionMap);
        }
        return waterchargeConndemandList;
    }

    private void prepareResponseDataForConnectionType(WaterChargeDashBoardRequest collectionDetailsRequest, List<WaterChargeConnectionTypeResponse> waterchargeConndemandList, String aggregationField, Map<String, BigDecimal> connectionResidentialTotalDemandMap, Map<String, Long> connectionCommercialcountMap, Map<String, BigDecimal> connectionCOmmercialTotalDemandMap, Map.Entry<String, Long> entry, Map<String, BigDecimal> connectionResidentialTotalCollectionMap, Map<String, BigDecimal> connectionCOmmercialTotalCollectionMap) {
        WaterChargeConnectionTypeResponse receiptData = new WaterChargeConnectionTypeResponse();
        String name = entry.getKey();
        if ("regionName".equals(aggregationField)) {
            receiptData.setRegionName(name);
        } else if ("districtName".equals(aggregationField)) {
            receiptData.setRegionName(collectionDetailsRequest.getRegionName());
            receiptData.setDistrictName(name);
        } else if ("cityName".equals(aggregationField)) {
            receiptData.setUlbName(name);
            receiptData.setDistrictName(collectionDetailsRequest.getDistrictName());
            receiptData.setUlbGrade(collectionDetailsRequest.getUlbGrade());
        } else if ("cityGrade".equals(aggregationField)) {
            receiptData.setUlbGrade(name);
        } else if ("revenueWard".equals(aggregationField)) {
            receiptData.setWardName(name);
        }
        Date fromDate = new DateTime().withMonthOfYear(4).dayOfMonth().withMinimumValue().toDate();
        Date toDate = org.apache.commons.lang3.time.DateUtils.addDays((Date)new Date(), (int)1);
        int noOfMonths = DateUtils.noOfMonthsBetween((Date)fromDate, (Date)toDate) + 1;
        BigDecimal totalResDemandValue = !connectionResidentialTotalDemandMap.isEmpty() && connectionResidentialTotalDemandMap.get(name) != null ? connectionResidentialTotalDemandMap.get(name).setScale(0, 4) : BigDecimal.ZERO;
        BigDecimal totalResCollections = !connectionResidentialTotalCollectionMap.isEmpty() && connectionResidentialTotalCollectionMap.get(name) != null ? connectionResidentialTotalCollectionMap.get(name).setScale(0, 4) : BigDecimal.ZERO;
        BigDecimal proportionalDemand = totalResDemandValue.divide(BigDecimal.valueOf(12L), 4).multiply(BigDecimal.valueOf(noOfMonths));
        receiptData.setResidentialAchievement(totalResCollections.multiply(WaterTaxConstants.BIGDECIMAL_100).divide(proportionalDemand, 1, 4));
        BigDecimal totalCommDemandValue = !connectionCOmmercialTotalDemandMap.isEmpty() && connectionCOmmercialTotalDemandMap.get(name) != null ? connectionCOmmercialTotalDemandMap.get(name).setScale(0, 4) : BigDecimal.ZERO;
        BigDecimal totalCommCollections = !connectionCOmmercialTotalCollectionMap.isEmpty() && connectionCOmmercialTotalCollectionMap.get(name) != null ? connectionCOmmercialTotalCollectionMap.get(name).setScale(0, 4) : BigDecimal.ZERO;
        BigDecimal commproportionalDemand = totalCommDemandValue.divide(BigDecimal.valueOf(12L), 4).multiply(BigDecimal.valueOf(noOfMonths));
        receiptData.setCommercialAchievement(commproportionalDemand.compareTo(BigDecimal.ZERO) > 0 ? totalCommCollections.multiply(WaterTaxConstants.BIGDECIMAL_100).divide(commproportionalDemand, 1, 4) : BigDecimal.ZERO);
        receiptData.setWaterChargeCommercialaverage(connectionCommercialcountMap.get(name) != null ? totalCommDemandValue.divide(BigDecimal.valueOf(connectionCommercialcountMap.get(name)), 1, 4) : BigDecimal.ZERO);
        receiptData.setWaterChargeResidentialaverage(totalResDemandValue.divide(BigDecimal.valueOf(entry.getValue()), 1, 4));
        receiptData.setResidentialConnectionCount(entry.getValue());
        receiptData.setUlbName(name);
        receiptData.setResidentialtotalCollection(!connectionResidentialTotalCollectionMap.isEmpty() && connectionResidentialTotalCollectionMap.get(name) != null ? connectionResidentialTotalCollectionMap.get(name) : BigDecimal.ZERO);
        receiptData.setCommercialConnectionCount(connectionCommercialcountMap.get(name));
        receiptData.setComercialtotalCollection(!connectionCOmmercialTotalCollectionMap.isEmpty() && connectionCOmmercialTotalCollectionMap.get(name) != null ? connectionCOmmercialTotalCollectionMap.get(name) : BigDecimal.ZERO);
        waterchargeConndemandList.add(receiptData);
    }

    private void prepareReceiptDetailListFromMap(WaterChargeDashBoardRequest collectionDetailsRequest, List<WaterChargeDashBoardResponse> receiptDataList, String aggregationField, Map<String, BigDecimal> currDayCollMap, Map<String, BigDecimal> lytdCollMap, Map.Entry<String, BigDecimal> entry) {
        WaterChargeDashBoardResponse receiptData = new WaterChargeDashBoardResponse();
        String name = entry.getKey();
        if ("regionName".equals(aggregationField)) {
            receiptData.setRegionName(name);
        } else if ("districtName".equals(aggregationField)) {
            receiptData.setRegionName(collectionDetailsRequest.getRegionName());
            receiptData.setDistrictName(name);
        } else if ("cityName".equals(aggregationField)) {
            receiptData.setUlbName(name);
            receiptData.setDistrictName(collectionDetailsRequest.getDistrictName());
            receiptData.setUlbGrade(collectionDetailsRequest.getUlbGrade());
        } else if ("cityGrade".equals(aggregationField)) {
            receiptData.setUlbGrade(name);
        } else if ("revenueWard".equals(aggregationField)) {
            receiptData.setWardName(name);
        }
        receiptData.setCurrentYearTillDateColl(entry.getValue());
        receiptData.setCurrDayColl(currDayCollMap.get(name) == null ? BigDecimal.valueOf(0L) : currDayCollMap.get(name));
        receiptData.setLastYearTillDateColl(lytdCollMap.get(name) == null ? BigDecimal.valueOf(0L) : lytdCollMap.get(name));
        BigDecimal variance = receiptData.getLastYearTillDateColl().compareTo(BigDecimal.ZERO) == 0 ? WaterTaxConstants.BIGDECIMAL_100 : receiptData.getCurrentYearTillDateColl().subtract(receiptData.getLastYearTillDateColl()).multiply(WaterTaxConstants.BIGDECIMAL_100).divide(receiptData.getLastYearTillDateColl(), 1, 4);
        receiptData.setLastYearVar(variance);
        receiptDataList.add(receiptData);
    }

    public Map<String, BigDecimal> getCollectionAndDemandCountResults(WaterChargeDashBoardRequest collectionDetailsRequest, Date fromDate, Date toDate, String indexName, String fieldName, String aggregationField) {
        BoolQueryBuilder boolQuery = this.prepareWhereClause(collectionDetailsRequest, indexName);
        if (indexName.equals("receipts")) {
            boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.rangeQuery((String)RECEIPT_DATEINDEX).gte(WaterTaxConstants.DATEFORMATTER_YYYY_MM_DD.format(fromDate)).lte(WaterTaxConstants.DATEFORMATTER_YYYY_MM_DD.format(toDate)).includeUpper(false)).mustNot((QueryBuilder)QueryBuilders.matchQuery((String)STATUS, (Object)CANCELLED));
        }
        AggregationBuilder aggregation = ((TermsBuilder)AggregationBuilders.terms((String)BY_CITY).field(aggregationField)).size(120).subAggregation((AbstractAggregationBuilder)AggregationBuilders.count((String)"total_count").field(fieldName));
        NativeSearchQuery searchQueryColl = new NativeSearchQueryBuilder().withIndices(new String[]{indexName}).withQuery((QueryBuilder)boolQuery).addAggregation((AbstractAggregationBuilder)aggregation).build();
        Aggregations collAggr = (Aggregations)this.elasticsearchTemplate.query((SearchQuery)searchQueryColl, response -> response.getAggregations());
        StringTerms cityAggr = (StringTerms)collAggr.get(BY_CITY);
        HashMap<String, BigDecimal> cytdCollMap = new HashMap<String, BigDecimal>();
        for (Terms.Bucket entry : cityAggr.getBuckets()) {
            ValueCount aggr = (ValueCount)entry.getAggregations().get("total_count");
            cytdCollMap.put(String.valueOf(entry.getKey()), BigDecimal.valueOf(aggr.getValue()).setScale(0, 4));
        }
        return cytdCollMap;
    }

    public Map<String, Long> getConnectionCountResults(WaterChargeDashBoardRequest collectionDetailsRequest, String indexName, String fieldName, String aggregationField, String connectionTypeField) {
        BoolQueryBuilder boolQuery = this.prepareWhereClause(collectionDetailsRequest, indexName);
        if (indexName.equals("waterchargeconsumer")) {
            boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)STATUS, (Object)CONN_STATUS));
        }
        boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)"usage", (Object)connectionTypeField));
        AggregationBuilder aggregation = ((TermsBuilder)AggregationBuilders.terms((String)BY_CITY).field(aggregationField)).size(120).subAggregation((AbstractAggregationBuilder)AggregationBuilders.count((String)"total_count").field(fieldName));
        NativeSearchQuery searchQueryColl = new NativeSearchQueryBuilder().withIndices(new String[]{indexName}).withQuery((QueryBuilder)boolQuery).addAggregation((AbstractAggregationBuilder)aggregation).build();
        Aggregations collAggr = (Aggregations)this.elasticsearchTemplate.query((SearchQuery)searchQueryColl, response -> response.getAggregations());
        StringTerms cityAggr = (StringTerms)collAggr.get(BY_CITY);
        HashMap<String, Long> totalconnectionMap = new HashMap<String, Long>();
        for (Terms.Bucket entry : cityAggr.getBuckets()) {
            ValueCount aggr = (ValueCount)entry.getAggregations().get("total_count");
            totalconnectionMap.put(String.valueOf(entry.getKey()), aggr.getValue());
        }
        return totalconnectionMap;
    }

    public Map<String, BigDecimal> getSumOfConnectionTotalCollection(WaterChargeDashBoardRequest collectionDetailsRequest, String indexName, String aggregationField, String connectionTypeField, String totalagrregatefild) {
        BoolQueryBuilder boolQuery = this.prepareWhereClause(collectionDetailsRequest, indexName);
        if (indexName.equals("waterchargeconsumer")) {
            boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)STATUS, (Object)CONN_STATUS));
            boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)"usage", (Object)connectionTypeField));
        } else {
            boolQuery = boolQuery.mustNot((QueryBuilder)QueryBuilders.matchQuery((String)STATUS, (Object)CANCELLED));
            boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)"consumerType", (Object)connectionTypeField));
        }
        AggregationBuilder aggregation = totalagrregatefild == null ? ((TermsBuilder)AggregationBuilders.terms((String)BY_CITY).field(aggregationField)).size(120).subAggregation((AbstractAggregationBuilder)AggregationBuilders.sum((String)TOTALDEMAND).field(TOTAL_AMOUNT)) : ((TermsBuilder)AggregationBuilders.terms((String)BY_CITY).field(aggregationField)).size(120).subAggregation((AbstractAggregationBuilder)AggregationBuilders.sum((String)TOTALDEMAND).field(TOTAL_DEMAND));
        NativeSearchQuery searchQueryColl = new NativeSearchQueryBuilder().withIndices(new String[]{indexName}).withQuery((QueryBuilder)boolQuery).addAggregation((AbstractAggregationBuilder)aggregation).build();
        Aggregations collAggr = (Aggregations)this.elasticsearchTemplate.query((SearchQuery)searchQueryColl, response -> response.getAggregations());
        StringTerms cityAggr = (StringTerms)collAggr.get(BY_CITY);
        HashMap<String, BigDecimal> totalconnectionTotalDemandMap = new HashMap<String, BigDecimal>();
        for (Terms.Bucket entry : cityAggr.getBuckets()) {
            Sum aggr = (Sum)entry.getAggregations().get(TOTALDEMAND);
            totalconnectionTotalDemandMap.put(String.valueOf(entry.getKey()), BigDecimal.valueOf(aggr.getValue()).setScale(0, 4));
        }
        return totalconnectionTotalDemandMap;
    }

    public List<BillCollectorIndex> getBillCollectorDetails(WaterChargeDashBoardRequest collectionDetailsRequest) {
        NativeSearchQuery searchQueryColl = new NativeSearchQueryBuilder().withIndices(new String[]{"billcollector"}).withFields(new String[]{"billCollector", "revenueWard"}).withQuery((QueryBuilder)QueryBuilders.boolQuery().filter((QueryBuilder)QueryBuilders.matchQuery((String)CITYCODE, (Object)collectionDetailsRequest.getUlbCode()))).withSort((SortBuilder)new FieldSortBuilder("billCollector").order(SortOrder.ASC)).withPageable((Pageable)new PageRequest(0, 250)).build();
        return this.elasticsearchTemplate.queryForList((SearchQuery)searchQueryColl, BillCollectorIndex.class);
    }

    public Map<String, BillCollectorIndex> getWardWiseBillCollectors(WaterChargeDashBoardRequest collectionDetailsRequest) {
        HashMap<String, BillCollectorIndex> wardWiseBillCollectors = new HashMap<String, BillCollectorIndex>();
        for (BillCollectorIndex billCollector : this.getBillCollectorDetails(collectionDetailsRequest)) {
            wardWiseBillCollectors.put(billCollector.getRevenueWard(), billCollector);
        }
        return wardWiseBillCollectors;
    }

    public List<WaterChargeDashBoardResponse> getResponseTableDataForBillCollector(WaterChargeDashBoardRequest collectionDetailsRequest) {
        HashMap<String, WaterChargeDashBoardResponse> wardReceiptDetails = new HashMap<String, WaterChargeDashBoardResponse>();
        LinkedHashMap billCollectorWiseMap = new LinkedHashMap();
        ArrayList<WaterChargeDashBoardResponse> billCollectorWiseTableData = new ArrayList<WaterChargeDashBoardResponse>();
        for (WaterChargeDashBoardResponse tableData : this.getResponseTableData(collectionDetailsRequest)) {
            wardReceiptDetails.put(tableData.getWardName(), tableData);
        }
        List<BillCollectorIndex> billCollectorsList = this.getBillCollectorDetails(collectionDetailsRequest);
        for (BillCollectorIndex billCollectorIndex : billCollectorsList) {
            ArrayList collDetails = new ArrayList();
            if (wardReceiptDetails.get(billCollectorIndex.getRevenueWard()) == null || !StringUtils.isNotBlank((CharSequence)billCollectorIndex.getRevenueWard())) continue;
            if (billCollectorWiseMap.isEmpty() || !billCollectorWiseMap.isEmpty() && !billCollectorWiseMap.containsKey(billCollectorIndex.getBillCollector())) {
                collDetails.add(wardReceiptDetails.get(billCollectorIndex.getRevenueWard()));
                billCollectorWiseMap.put(billCollectorIndex.getBillCollector(), collDetails);
                continue;
            }
            ((List)billCollectorWiseMap.get(billCollectorIndex.getBillCollector())).add(wardReceiptDetails.get(billCollectorIndex.getRevenueWard()));
        }
        for (Map.Entry entry : billCollectorWiseMap.entrySet()) {
            WaterChargeDashBoardResponse collTableData = new WaterChargeDashBoardResponse();
            BigDecimal currDayColl = BigDecimal.ZERO;
            BigDecimal cytdColl = BigDecimal.ZERO;
            BigDecimal lytdColl = BigDecimal.ZERO;
            BigDecimal cytdDmd = BigDecimal.ZERO;
            BigDecimal performance = BigDecimal.ZERO;
            BigDecimal totalDmd = BigDecimal.ZERO;
            BigDecimal variance = BigDecimal.ZERO;
            for (WaterChargeDashBoardResponse tableData : (List)entry.getValue()) {
                currDayColl = currDayColl.add(tableData.getTodayColl() == null ? BigDecimal.ZERO : tableData.getTodayColl());
                cytdColl = cytdColl.add(tableData.getCurrentYearTillDateColl() == null ? BigDecimal.ZERO : tableData.getCurrentYearTillDateColl());
                cytdDmd = cytdDmd.add(tableData.getCurrentYearTillDateDmd() == null ? BigDecimal.ZERO : tableData.getCurrentYearTillDateDmd());
                totalDmd = totalDmd.add(tableData.getTotalDmd() == null ? BigDecimal.ZERO : tableData.getTotalDmd());
                lytdColl = lytdColl.add(tableData.getLastYearTillDateColl() == null ? BigDecimal.ZERO : tableData.getLastYearTillDateColl());
            }
            collTableData.setBillCollector((String)entry.getKey());
            collTableData.setTodayColl(currDayColl);
            collTableData.setCurrentYearTillDateColl(cytdColl);
            collTableData.setCurrentYearTillDateDmd(cytdDmd);
            collTableData.setCurrentYearTillDateBalDmd(cytdDmd.subtract(cytdColl));
            collTableData.setTotalDmd(totalDmd);
            collTableData.setLastYearTillDateColl(lytdColl);
            if (cytdDmd != BigDecimal.valueOf(0L)) {
                performance = collTableData.getCurrentYearTillDateColl().multiply(WaterTaxConstants.BIGDECIMAL_100).divide(cytdDmd, 1, 4);
                collTableData.setPerformance(performance);
            }
            variance = collTableData.getLastYearTillDateColl().compareTo(BigDecimal.ZERO) == 0 ? WaterTaxConstants.BIGDECIMAL_100 : collTableData.getCurrentYearTillDateColl().subtract(collTableData.getLastYearTillDateColl()).multiply(WaterTaxConstants.BIGDECIMAL_100).divide(collTableData.getLastYearTillDateColl(), 1, 4);
            collTableData.setLastYearVar(variance);
            billCollectorWiseTableData.add(collTableData);
        }
        return billCollectorWiseTableData;
    }

    public List<WaterChargeDashBoardResponse> getWardWiseTableDataAcrossCities(WaterChargeDashBoardRequest waterChargeDashBoardRequest, Iterable<CityIndex> cities) {
        ArrayList<WaterChargeDashBoardResponse> citywiseTableData = new ArrayList<WaterChargeDashBoardResponse>();
        List<Object> wardWiseData = new ArrayList();
        for (CityIndex city : cities) {
            String cityName = city.getName();
            waterChargeDashBoardRequest.setUlbCode(city.getCitycode());
            waterChargeDashBoardRequest.setType("ward");
            String regionName = city.getRegionname();
            String districtName = city.getDistrictname();
            String ulbGrade = city.getCitygrade();
            wardWiseData = this.getResponseTableData(waterChargeDashBoardRequest);
            for (WaterChargeDashBoardResponse waterChargeDashBoardResponse : wardWiseData) {
                waterChargeDashBoardResponse.setUlbName(cityName);
                waterChargeDashBoardResponse.setRegionName(regionName);
                waterChargeDashBoardResponse.setDistrictName(districtName);
                waterChargeDashBoardResponse.setUlbGrade(ulbGrade);
            }
            citywiseTableData.addAll(wardWiseData);
        }
        return citywiseTableData;
    }
}

