/*
 * Decompiled with CFR 0.152.
 */
package org.egov.wtms.service.dashboard;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.egov.infra.admin.master.entity.es.CityIndex;
import org.egov.infra.admin.master.service.es.CityIndexService;
import org.egov.infra.rest.client.SimpleRestClient;
import org.egov.infra.web.utils.WebUtils;
import org.egov.ptis.bean.dashboard.StateCityInfo;
import org.egov.wtms.bean.dashboard.TaxPayerResponseDetails;
import org.egov.wtms.bean.dashboard.WaterChargeConnectionTypeResponse;
import org.egov.wtms.bean.dashboard.WaterChargeDashBoardRequest;
import org.egov.wtms.bean.dashboard.WaterChargeDashBoardResponse;
import org.egov.wtms.bean.dashboard.WaterTaxDefaulters;
import org.egov.wtms.service.es.WaterChargeCollectionDocService;
import org.egov.wtms.service.es.WaterChargeElasticSearchService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class WaterChargeDashboardService {
    @Autowired
    private WaterChargeCollectionDocService waterChargeCollDocService;
    @Autowired
    private WaterChargeElasticSearchService waterChargeElasticSearchService;
    @Autowired
    private SimpleRestClient simpleRestClient;
    @Autowired
    private CityIndexService cityIndexService;

    public BigDecimal getWaterChargeTotalDemand(HttpServletRequest request) {
        String wtmsRestURL = String.format("%s/wtms/rest/watertax/totaldemandamount/", WebUtils.extractRequestDomainURL((HttpServletRequest)request, (boolean)false));
        HashMap waterTaxInfo = this.simpleRestClient.getRESTResponseAsMap(wtmsRestURL);
        return waterTaxInfo.get("currentDemand") == null ? BigDecimal.ZERO : new BigDecimal((Double)waterTaxInfo.get("currentDemand"));
    }

    public Map<String, List<WaterChargeDashBoardResponse>> getCollectionIndexDetails(WaterChargeDashBoardRequest waterChargeDashBoardRequest) {
        List<WaterChargeDashBoardResponse> collIndexData;
        HashMap<String, List<WaterChargeDashBoardResponse>> responsemap = new HashMap<String, List<WaterChargeDashBoardResponse>>();
        List<WaterChargeDashBoardResponse> collectionTotalResponseList = this.waterChargeCollDocService.getFullCollectionIndexDtls(waterChargeDashBoardRequest);
        List<WaterChargeDashBoardResponse> collectionTrends = this.waterChargeCollDocService.getMonthwiseCollectionDetails(waterChargeDashBoardRequest);
        if (StringUtils.isNotBlank((CharSequence)waterChargeDashBoardRequest.getType()) && waterChargeDashBoardRequest.getType().equalsIgnoreCase("billcollector")) {
            collIndexData = this.waterChargeCollDocService.getResponseTableDataForBillCollector(waterChargeDashBoardRequest);
        } else if ("allwards".equalsIgnoreCase(waterChargeDashBoardRequest.getType())) {
            Iterable cities = this.cityIndexService.findAll();
            collIndexData = this.waterChargeCollDocService.getWardWiseTableDataAcrossCities(waterChargeDashBoardRequest, cities);
        } else {
            collIndexData = this.waterChargeCollDocService.getResponseTableData(waterChargeDashBoardRequest);
        }
        responsemap.put("collectionWtTotal", collectionTotalResponseList);
        responsemap.put("collTrends", collectionTrends);
        responsemap.put("responseDetails", collIndexData);
        return responsemap;
    }

    public Map<String, List<WaterChargeConnectionTypeResponse>> getCollectionTypeIndexDetails(WaterChargeDashBoardRequest waterChargeDashBoardRequest) {
        HashMap<String, List<WaterChargeConnectionTypeResponse>> responsemap = new HashMap<String, List<WaterChargeConnectionTypeResponse>>();
        List<WaterChargeConnectionTypeResponse> collectionTotalResponseList = this.waterChargeCollDocService.getFullCollectionIndexDtlsForCOnnectionType(waterChargeDashBoardRequest);
        List<WaterChargeConnectionTypeResponse> collectionTrends = this.waterChargeCollDocService.getMonthwiseCollectionDetailsForConnectionType(waterChargeDashBoardRequest);
        List<WaterChargeConnectionTypeResponse> collIndexData = this.waterChargeCollDocService.getResponseDataForConnectionType(waterChargeDashBoardRequest);
        responsemap.put("collectionWtTotal", collectionTotalResponseList);
        responsemap.put("collTrends", collectionTrends);
        responsemap.put("responseDetails", collIndexData);
        return responsemap;
    }

    public Map<String, List<WaterChargeDashBoardResponse>> getReceiptDetails(WaterChargeDashBoardRequest collectionDetailsRequest) {
        HashMap<String, List<WaterChargeDashBoardResponse>> finalReceiptCountForwaterTaxMap = new HashMap<String, List<WaterChargeDashBoardResponse>>();
        List<WaterChargeDashBoardResponse> receiptDetailsList = this.waterChargeCollDocService.getTotalReceiptsCount(collectionDetailsRequest);
        List<WaterChargeDashBoardResponse> receiptTrends = this.waterChargeCollDocService.getMonthwiseReceiptsTrend(collectionDetailsRequest);
        List<WaterChargeDashBoardResponse> receiptTableData = this.waterChargeCollDocService.getReceiptTableData(collectionDetailsRequest);
        finalReceiptCountForwaterTaxMap.put("receiptDetailsCount", receiptDetailsList);
        finalReceiptCountForwaterTaxMap.put("receiptTrends", receiptTrends);
        finalReceiptCountForwaterTaxMap.put("receiptTableData", receiptTableData);
        return finalReceiptCountForwaterTaxMap;
    }

    public TaxPayerResponseDetails getTopTenTaxProducers(WaterChargeDashBoardRequest collectionDetailsRequest) {
        return this.waterChargeElasticSearchService.getTopTenTaxPerformers(collectionDetailsRequest);
    }

    public TaxPayerResponseDetails getBottomTenTaxProducers(WaterChargeDashBoardRequest waterChargeDashBoardRequest) {
        return this.waterChargeElasticSearchService.getBottomTenTaxPerformers(waterChargeDashBoardRequest);
    }

    public List<WaterTaxDefaulters> getTaxDefaulters(WaterChargeDashBoardRequest waterChargeDashBoardRequest) {
        return this.waterChargeElasticSearchService.getTopDefaulters(waterChargeDashBoardRequest);
    }

    public List<StateCityInfo> getStateCityDetails() {
        ArrayList<StateCityInfo> stateCityDetails = new ArrayList<StateCityInfo>();
        Iterable cities = this.cityIndexService.findAll();
        for (CityIndex city : cities) {
            StateCityInfo cityInfo = new StateCityInfo();
            cityInfo.setRegion(city.getRegionname());
            cityInfo.setDistrict(city.getDistrictname());
            cityInfo.setCity(city.getName());
            cityInfo.setGrade(city.getCitygrade());
            cityInfo.setUlbCode(city.getCitycode());
            stateCityDetails.add(cityInfo);
        }
        return stateCityDetails;
    }
}

