/*
 * Decompiled with CFR 0.152.
 */
package org.egov.wtms.masters.service;

import java.util.List;
import org.egov.wtms.masters.entity.Penalty;
import org.egov.wtms.masters.repository.PenaltyRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class PenaltyService {
    private final PenaltyRepository penaltyRepository;

    @Autowired
    public PenaltyService(PenaltyRepository penaltyRepository) {
        this.penaltyRepository = penaltyRepository;
    }

    public Penalty findBy(Long penaltyId) {
        return (Penalty)((Object)this.penaltyRepository.findOne(penaltyId));
    }

    @Transactional
    public Penalty createPenalty(Penalty penalty) {
        return (Penalty)((Object)this.penaltyRepository.save((Object)penalty));
    }

    @Transactional
    public void updatePenalty(Penalty penalty) {
        this.penaltyRepository.save((Object)penalty);
    }

    public List<Penalty> findAll() {
        return this.penaltyRepository.findAll(new Sort(Sort.Direction.ASC, new String[]{"penaltyType"}));
    }

    public List<Penalty> findAllByPenaltyType(String penaltyType) {
        return this.penaltyRepository.findAllByPenaltyType(penaltyType);
    }

    public Penalty load(Long id) {
        return (Penalty)((Object)this.penaltyRepository.getOne(id));
    }

    public Page<Penalty> getListOfPenalty(Integer pageNumber, Integer pageSize) {
        PageRequest pageable = new PageRequest(pageNumber - 1, pageSize.intValue(), Sort.Direction.ASC, new String[]{"penaltyType"});
        return this.penaltyRepository.findAll((Pageable)pageable);
    }
}

