/*
 * Decompiled with CFR 0.152.
 */
package org.egov.wtms.masters.service;

import java.util.List;
import org.egov.wtms.masters.entity.ApplicationType;
import org.egov.wtms.masters.repository.ApplicationTypeRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class ApplicationTypeService {
    private final ApplicationTypeRepository applicationTypeRepository;

    @Autowired
    public ApplicationTypeService(ApplicationTypeRepository applicationTypeRepository) {
        this.applicationTypeRepository = applicationTypeRepository;
    }

    public ApplicationType findBy(Long applicationTypeId) {
        return (ApplicationType)((Object)this.applicationTypeRepository.findOne(applicationTypeId));
    }

    @Transactional
    public ApplicationType createApplicationType(ApplicationType applicationType) {
        return (ApplicationType)((Object)this.applicationTypeRepository.save((Object)applicationType));
    }

    @Transactional
    public void updateApplicationType(ApplicationType applicationType) {
        this.applicationTypeRepository.save((Object)applicationType);
    }

    public List<ApplicationType> findAll() {
        return this.applicationTypeRepository.findAll(new Sort(Sort.Direction.ASC, new String[]{"name"}));
    }

    public List<ApplicationType> findAllByNameLike(String name) {
        return this.applicationTypeRepository.findByNameContainingIgnoreCase(name);
    }

    public ApplicationType findByName(String name) {
        return this.applicationTypeRepository.findByName(name);
    }

    public ApplicationType load(Long id) {
        return (ApplicationType)((Object)this.applicationTypeRepository.getOne(id));
    }

    public Page<ApplicationType> getListOfApplicationTypes(Integer pageNumber, Integer pageSize) {
        PageRequest pageable = new PageRequest(pageNumber - 1, pageSize.intValue(), Sort.Direction.ASC, new String[]{"name"});
        return this.applicationTypeRepository.findAll((Pageable)pageable);
    }

    @Transactional(readOnly=true)
    public ApplicationType findByCode(String code) {
        return this.applicationTypeRepository.findByCode(code);
    }

    public List<ApplicationType> getActiveApplicationTypes() {
        return this.applicationTypeRepository.findByActiveTrue();
    }
}

