/*
 * Decompiled with CFR 0.152.
 */
package org.egov.wtms.masters.entity;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import org.egov.infra.persistence.entity.AbstractAuditable;
import org.egov.wtms.masters.entity.PipeSize;
import org.egov.wtms.masters.entity.UsageType;
import org.egov.wtms.masters.entity.WaterRatesDetails;
import org.egov.wtms.masters.entity.WaterSource;
import org.egov.wtms.masters.entity.enums.ConnectionType;
import org.hibernate.envers.AuditOverride;
import org.hibernate.envers.AuditOverrides;
import org.hibernate.envers.Audited;

@Entity
@Table(name="egwtr_water_rates_header")
@SequenceGenerator(name="SEQ_EGWTR_WATER_RATES_HEADER", sequenceName="SEQ_EGWTR_WATER_RATES_HEADER", allocationSize=1)
@AuditOverrides(value={@AuditOverride(forClass=AbstractAuditable.class, name="lastModifiedBy"), @AuditOverride(forClass=AbstractAuditable.class, name="lastModifiedDate")})
public class WaterRatesHeader
extends AbstractAuditable {
    private static final long serialVersionUID = -2596548687171468023L;
    public static final String SEQ_WATERRATESHEADER = "SEQ_EGWTR_WATER_RATES_HEADER";
    @Id
    @GeneratedValue(generator="SEQ_EGWTR_WATER_RATES_HEADER", strategy=GenerationType.SEQUENCE)
    private Long id;
    @Enumerated(value=EnumType.STRING)
    @NotNull
    @Audited
    private ConnectionType connectionType;
    @ManyToOne
    @NotNull
    @JoinColumn(name="usagetype", nullable=false)
    @Audited
    private UsageType usageType;
    @ManyToOne
    @NotNull
    @JoinColumn(name="watersource", nullable=false)
    @Audited
    private WaterSource waterSource;
    @ManyToOne
    @NotNull
    @JoinColumn(name="pipesize", nullable=false)
    @Audited
    private PipeSize pipeSize;
    @Audited
    private boolean active;
    @OneToMany(mappedBy="waterRatesHeader", fetch=FetchType.LAZY, orphanRemoval=true, cascade={CascadeType.ALL})
    @Audited
    private List<WaterRatesDetails> waterRatesDetails = new ArrayList<WaterRatesDetails>();

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public ConnectionType getConnectionType() {
        return this.connectionType;
    }

    public void setConnectionType(ConnectionType connectionType) {
        this.connectionType = connectionType;
    }

    public UsageType getUsageType() {
        return this.usageType;
    }

    public void setUsageType(UsageType usageType) {
        this.usageType = usageType;
    }

    public WaterSource getWaterSource() {
        return this.waterSource;
    }

    public void setWaterSource(WaterSource waterSource) {
        this.waterSource = waterSource;
    }

    public PipeSize getPipeSize() {
        return this.pipeSize;
    }

    public void setPipeSize(PipeSize pipeSize) {
        this.pipeSize = pipeSize;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public List<WaterRatesDetails> getWaterRatesDetails() {
        return this.waterRatesDetails;
    }

    public void setWaterRatesDetails(List<WaterRatesDetails> waterRatesDetails) {
        this.waterRatesDetails.clear();
        this.waterRatesDetails.addAll(waterRatesDetails);
    }

    public void addWaterRatesDetails(WaterRatesDetails waterRatesDetail) {
        this.waterRatesDetails.add(waterRatesDetail);
    }
}

