/*
 * Decompiled with CFR 0.152.
 */
package org.egov.wtms.masters.entity;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import java.lang.reflect.Type;
import java.util.List;
import org.egov.infra.web.support.json.adapter.DataTableJsonAdapter;
import org.egov.infra.web.support.ui.DataTable;
import org.egov.wtms.masters.entity.UsageSlab;

public class UsageSlabJsonAdapter
implements DataTableJsonAdapter<UsageSlab> {
    public JsonElement serialize(DataTable<UsageSlab> usageSlabData, Type type, JsonSerializationContext jsc) {
        List usageSlabs = usageSlabData.getData();
        JsonArray usageSlabJsonArray = new JsonArray();
        for (UsageSlab usageSlab : usageSlabs) {
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("usage", usageSlab.getUsage());
            jsonObject.addProperty("slabName", usageSlab.getSlabName());
            jsonObject.addProperty("fromVolume", (Number)usageSlab.getFromVolume());
            jsonObject.addProperty("toVolume", (Number)usageSlab.getToVolume());
            if (usageSlab.isActive()) {
                jsonObject.addProperty("active", "ACTIVE");
            } else {
                jsonObject.addProperty("active", "INACTIVE");
            }
            jsonObject.addProperty("id", (Number)usageSlab.getId());
            usageSlabJsonArray.add((JsonElement)jsonObject);
        }
        return this.enhance((JsonElement)usageSlabJsonArray, usageSlabData);
    }
}

