/*
 * Decompiled with CFR 0.152.
 */
package org.egov.wtms.masters.entity;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import javax.persistence.OrderBy;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import org.egov.infra.persistence.entity.AbstractAuditable;
import org.egov.infra.persistence.validator.annotation.Unique;
import org.egov.wtms.masters.entity.MeteredRatesDetail;
import org.hibernate.envers.AuditOverride;
import org.hibernate.envers.AuditOverrides;
import org.hibernate.envers.Audited;
import org.hibernate.validator.constraints.SafeHtml;

@Entity
@Table(name="egwtr_metered_rates")
@Unique(id="id", enableDfltMsg=true)
@SequenceGenerator(name="SEQ_EGWTR_METERED_RATES", sequenceName="SEQ_EGWTR_METERED_RATES", allocationSize=1)
@AuditOverrides(value={@AuditOverride(forClass=AbstractAuditable.class, name="lastModifiedBy"), @AuditOverride(forClass=AbstractAuditable.class, name="lastModifiedDate")})
public class MeteredRates
extends AbstractAuditable {
    private static final long serialVersionUID = -8414053050863709827L;
    public static final String SEQ_METERED_RATES = "SEQ_EGWTR_METERED_RATES";
    @Id
    @GeneratedValue(generator="SEQ_EGWTR_METERED_RATES", strategy=GenerationType.SEQUENCE)
    private Long id;
    @NotNull
    @SafeHtml
    @Audited
    private String slabName;
    @Audited
    @OneToMany(mappedBy="meteredRate", fetch=FetchType.LAZY, cascade={CascadeType.ALL}, orphanRemoval=true, targetEntity=MeteredRatesDetail.class)
    @OrderBy(value="id")
    private List<MeteredRatesDetail> ratesDetail = new ArrayList<MeteredRatesDetail>(0);

    public String getSlabName() {
        return this.slabName;
    }

    public void setSlabName(String slabName) {
        this.slabName = slabName;
    }

    public List<MeteredRatesDetail> getRatesDetail() {
        return this.ratesDetail;
    }

    public void setRatesDetail(List<MeteredRatesDetail> ratesDetail) {
        this.ratesDetail = ratesDetail;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }
}

