/*
 * Decompiled with CFR 0.152.
 */
package org.egov.wtms.config;

import java.util.HashMap;
import javax.sql.DataSource;
import org.egov.infra.config.scheduling.QuartzSchedulerConfiguration;
import org.egov.infra.config.scheduling.SchedulerConfigCondition;
import org.egov.wtms.scheduler.BulkWaterConnBillGenerationJob;
import org.quartz.Trigger;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.quartz.CronTriggerFactoryBean;
import org.springframework.scheduling.quartz.JobDetailFactoryBean;
import org.springframework.scheduling.quartz.SchedulerFactoryBean;

@Configuration
@Conditional(value={SchedulerConfigCondition.class})
public class WtmsSchedulerConfiguration
extends QuartzSchedulerConfiguration {
    @Bean(destroyMethod="destroy")
    public SchedulerFactoryBean wtmsScheduler(DataSource dataSource) {
        SchedulerFactoryBean wtmsScheduler = this.createScheduler(dataSource);
        wtmsScheduler.setSchedulerName("wtms-scheduler");
        wtmsScheduler.setAutoStartup(true);
        wtmsScheduler.setOverwriteExistingJobs(true);
        wtmsScheduler.setTriggers(new Trigger[]{this.wtmsBulkBillGenerationCronTrigger0().getObject(), this.wtmsBulkBillGenerationCronTrigger1().getObject(), this.wtmsBulkBillGenerationCronTrigger2().getObject(), this.wtmsBulkBillGenerationCronTrigger3().getObject(), this.wtmsBulkBillGenerationCronTrigger4().getObject(), this.wtmsBulkBillGenerationCronTrigger5().getObject(), this.wtmsBulkBillGenerationCronTrigger6().getObject(), this.wtmsBulkBillGenerationCronTrigger7().getObject(), this.wtmsBulkBillGenerationCronTrigger8().getObject(), this.wtmsBulkBillGenerationCronTrigger9().getObject()});
        return wtmsScheduler;
    }

    @Bean(value={"bulkWaterConnBillGenerationJob0"})
    public BulkWaterConnBillGenerationJob bulkWaterConnBillGenerationJob0() {
        BulkWaterConnBillGenerationJob bulkWaterConnBillGenerationJob = new BulkWaterConnBillGenerationJob();
        bulkWaterConnBillGenerationJob.setBillsCount(50);
        bulkWaterConnBillGenerationJob.setModulo(0);
        return bulkWaterConnBillGenerationJob;
    }

    @Bean(value={"bulkWaterConnBillGenerationJob1"})
    public BulkWaterConnBillGenerationJob bulkWaterConnBillGenerationJob1() {
        BulkWaterConnBillGenerationJob bulkWaterConnBillGenerationJob = new BulkWaterConnBillGenerationJob();
        bulkWaterConnBillGenerationJob.setBillsCount(50);
        bulkWaterConnBillGenerationJob.setModulo(1);
        return bulkWaterConnBillGenerationJob;
    }

    @Bean(value={"bulkWaterConnBillGenerationJob2"})
    public BulkWaterConnBillGenerationJob bulkWaterConnBillGenerationJob2() {
        BulkWaterConnBillGenerationJob bulkWaterConnBillGenerationJob = new BulkWaterConnBillGenerationJob();
        bulkWaterConnBillGenerationJob.setBillsCount(50);
        bulkWaterConnBillGenerationJob.setModulo(2);
        return bulkWaterConnBillGenerationJob;
    }

    @Bean(value={"bulkWaterConnBillGenerationJob3"})
    public BulkWaterConnBillGenerationJob bulkWaterConnBillGenerationJob3() {
        BulkWaterConnBillGenerationJob bulkWaterConnBillGenerationJob = new BulkWaterConnBillGenerationJob();
        bulkWaterConnBillGenerationJob.setBillsCount(50);
        bulkWaterConnBillGenerationJob.setModulo(3);
        return bulkWaterConnBillGenerationJob;
    }

    @Bean(value={"bulkWaterConnBillGenerationJob4"})
    public BulkWaterConnBillGenerationJob bulkWaterConnBillGenerationJob4() {
        BulkWaterConnBillGenerationJob bulkWaterConnBillGenerationJob = new BulkWaterConnBillGenerationJob();
        bulkWaterConnBillGenerationJob.setBillsCount(50);
        bulkWaterConnBillGenerationJob.setModulo(4);
        return bulkWaterConnBillGenerationJob;
    }

    @Bean(value={"bulkWaterConnBillGenerationJob5"})
    public BulkWaterConnBillGenerationJob bulkWaterConnBillGenerationJob5() {
        BulkWaterConnBillGenerationJob bulkWaterConnBillGenerationJob = new BulkWaterConnBillGenerationJob();
        bulkWaterConnBillGenerationJob.setBillsCount(50);
        bulkWaterConnBillGenerationJob.setModulo(5);
        return bulkWaterConnBillGenerationJob;
    }

    @Bean(value={"bulkWaterConnBillGenerationJob6"})
    public BulkWaterConnBillGenerationJob bulkWaterConnBillGenerationJob6() {
        BulkWaterConnBillGenerationJob bulkWaterConnBillGenerationJob = new BulkWaterConnBillGenerationJob();
        bulkWaterConnBillGenerationJob.setBillsCount(50);
        bulkWaterConnBillGenerationJob.setModulo(6);
        return bulkWaterConnBillGenerationJob;
    }

    @Bean(value={"bulkWaterConnBillGenerationJob7"})
    public BulkWaterConnBillGenerationJob bulkWaterConnBillGenerationJob7() {
        BulkWaterConnBillGenerationJob bulkWaterConnBillGenerationJob = new BulkWaterConnBillGenerationJob();
        bulkWaterConnBillGenerationJob.setBillsCount(50);
        bulkWaterConnBillGenerationJob.setModulo(7);
        return bulkWaterConnBillGenerationJob;
    }

    @Bean(value={"bulkWaterConnBillGenerationJob8"})
    public BulkWaterConnBillGenerationJob bulkWaterConnBillGenerationJob8() {
        BulkWaterConnBillGenerationJob bulkWaterConnBillGenerationJob = new BulkWaterConnBillGenerationJob();
        bulkWaterConnBillGenerationJob.setBillsCount(50);
        bulkWaterConnBillGenerationJob.setModulo(8);
        return bulkWaterConnBillGenerationJob;
    }

    @Bean(value={"bulkWaterConnBillGenerationJob9"})
    public BulkWaterConnBillGenerationJob bulkWaterConnBillGenerationJob9() {
        BulkWaterConnBillGenerationJob bulkWaterConnBillGenerationJob = new BulkWaterConnBillGenerationJob();
        bulkWaterConnBillGenerationJob.setBillsCount(50);
        bulkWaterConnBillGenerationJob.setModulo(9);
        return bulkWaterConnBillGenerationJob;
    }

    @Bean
    public JobDetailFactoryBean wtmsBulkBillGenerationJobDetail0() {
        return this.createJobDetailFactory(0);
    }

    @Bean
    public JobDetailFactoryBean wtmsBulkBillGenerationJobDetail1() {
        return this.createJobDetailFactory(1);
    }

    @Bean
    public JobDetailFactoryBean wtmsBulkBillGenerationJobDetail2() {
        return this.createJobDetailFactory(2);
    }

    @Bean
    public JobDetailFactoryBean wtmsBulkBillGenerationJobDetail3() {
        return this.createJobDetailFactory(3);
    }

    @Bean
    public JobDetailFactoryBean wtmsBulkBillGenerationJobDetail4() {
        return this.createJobDetailFactory(4);
    }

    @Bean
    public JobDetailFactoryBean wtmsBulkBillGenerationJobDetail5() {
        return this.createJobDetailFactory(5);
    }

    @Bean
    public JobDetailFactoryBean wtmsBulkBillGenerationJobDetail6() {
        return this.createJobDetailFactory(6);
    }

    @Bean
    public JobDetailFactoryBean wtmsBulkBillGenerationJobDetail7() {
        return this.createJobDetailFactory(7);
    }

    @Bean
    public JobDetailFactoryBean wtmsBulkBillGenerationJobDetail8() {
        return this.createJobDetailFactory(8);
    }

    @Bean
    public JobDetailFactoryBean wtmsBulkBillGenerationJobDetail9() {
        return this.createJobDetailFactory(9);
    }

    @Bean
    public CronTriggerFactoryBean wtmsBulkBillGenerationCronTrigger0() {
        return this.createCronTrigger(this.wtmsBulkBillGenerationJobDetail0(), 0);
    }

    @Bean
    public CronTriggerFactoryBean wtmsBulkBillGenerationCronTrigger1() {
        return this.createCronTrigger(this.wtmsBulkBillGenerationJobDetail1(), 1);
    }

    @Bean
    public CronTriggerFactoryBean wtmsBulkBillGenerationCronTrigger2() {
        return this.createCronTrigger(this.wtmsBulkBillGenerationJobDetail2(), 2);
    }

    @Bean
    public CronTriggerFactoryBean wtmsBulkBillGenerationCronTrigger3() {
        return this.createCronTrigger(this.wtmsBulkBillGenerationJobDetail3(), 3);
    }

    @Bean
    public CronTriggerFactoryBean wtmsBulkBillGenerationCronTrigger4() {
        return this.createCronTrigger(this.wtmsBulkBillGenerationJobDetail4(), 4);
    }

    @Bean
    public CronTriggerFactoryBean wtmsBulkBillGenerationCronTrigger5() {
        return this.createCronTrigger(this.wtmsBulkBillGenerationJobDetail5(), 5);
    }

    @Bean
    public CronTriggerFactoryBean wtmsBulkBillGenerationCronTrigger6() {
        return this.createCronTrigger(this.wtmsBulkBillGenerationJobDetail6(), 6);
    }

    @Bean
    public CronTriggerFactoryBean wtmsBulkBillGenerationCronTrigger7() {
        return this.createCronTrigger(this.wtmsBulkBillGenerationJobDetail7(), 7);
    }

    @Bean
    public CronTriggerFactoryBean wtmsBulkBillGenerationCronTrigger8() {
        return this.createCronTrigger(this.wtmsBulkBillGenerationJobDetail8(), 8);
    }

    @Bean
    public CronTriggerFactoryBean wtmsBulkBillGenerationCronTrigger9() {
        return this.createCronTrigger(this.wtmsBulkBillGenerationJobDetail9(), 9);
    }

    private JobDetailFactoryBean createJobDetailFactory(int modulo) {
        JobDetailFactoryBean wtmsBulkBillGenerationJobDetail = new JobDetailFactoryBean();
        wtmsBulkBillGenerationJobDetail.setGroup("WTMS_JOB_GROUP");
        wtmsBulkBillGenerationJobDetail.setName("WTMS_BULK_BILL_GEN_" + modulo + "_JOB");
        wtmsBulkBillGenerationJobDetail.setDurability(true);
        wtmsBulkBillGenerationJobDetail.setJobClass(BulkWaterConnBillGenerationJob.class);
        wtmsBulkBillGenerationJobDetail.setRequestsRecovery(true);
        HashMap<String, String> jobDetailMap = new HashMap<String, String>();
        jobDetailMap.put("jobBeanName", "bulkWaterConnBillGenerationJob" + modulo);
        jobDetailMap.put("userName", "system");
        jobDetailMap.put("cityDataRequired", "true");
        jobDetailMap.put("moduleName", "wtms");
        wtmsBulkBillGenerationJobDetail.setJobDataAsMap(jobDetailMap);
        return wtmsBulkBillGenerationJobDetail;
    }

    private CronTriggerFactoryBean createCronTrigger(JobDetailFactoryBean jobDetail, int modulo) {
        CronTriggerFactoryBean bulkBillGenerationCron = new CronTriggerFactoryBean();
        bulkBillGenerationCron.setJobDetail(jobDetail.getObject());
        bulkBillGenerationCron.setGroup("WTMS_TRIGGER_GROUP");
        bulkBillGenerationCron.setName("WTMS_BULK_BILL_GEN_" + modulo + "_TRIGGER");
        bulkBillGenerationCron.setCronExpression("0 30 17 * * ? 2050");
        bulkBillGenerationCron.setMisfireInstruction(2);
        return bulkBillGenerationCron;
    }
}

