/*
 * Decompiled with CFR 0.152.
 */
package org.egov.wtms.autonumber.impl;

import java.io.Serializable;
import org.egov.infra.persistence.utils.ApplicationSequenceNumberGenerator;
import org.egov.wtms.autonumber.WorkOrderNumberGenerator;
import org.egov.wtms.utils.WaterTaxUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class WorkOrderNumberGeneratorImpl
implements WorkOrderNumberGenerator {
    private static final String WORKORDER_NUMBER_SEQ_PREFIX = "SEQ_WORKORDER_NUMBER";
    @Autowired
    private ApplicationSequenceNumberGenerator applicationSequenceNumberGenerator;
    @Autowired
    private WaterTaxUtils waterTaxUtils;

    @Override
    public String generateWorkOrderNumber() {
        String sequenceName = WORKORDER_NUMBER_SEQ_PREFIX;
        Serializable nextSequence = this.applicationSequenceNumberGenerator.getNextSequence(WORKORDER_NUMBER_SEQ_PREFIX);
        return String.format("%s%06d", this.waterTaxUtils.getCityCode(), nextSequence);
    }
}

