/*
 * Decompiled with CFR 0.152.
 */
package org.egov.wtms.autonumber.impl;

import java.io.Serializable;
import org.egov.infra.persistence.utils.ApplicationSequenceNumberGenerator;
import org.egov.wtms.autonumber.EstimationNumberGenerator;
import org.egov.wtms.utils.WaterTaxUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class EstimationNumberGeneratorImpl
implements EstimationNumberGenerator {
    private static final String ESTIMATION_NUMBER_SEQ_PREFIX = "SEQ_ESTIMATION_NUMBER";
    private static final String ESTIMATION_NUMBER = "EN-";
    @Autowired
    private ApplicationSequenceNumberGenerator applicationSequenceNumberGenerator;
    @Autowired
    private WaterTaxUtils waterTaxUtils;

    @Override
    public String generateEstimationNumber() {
        String sequenceName = ESTIMATION_NUMBER_SEQ_PREFIX;
        Serializable nextSequence = this.applicationSequenceNumberGenerator.getNextSequence(ESTIMATION_NUMBER_SEQ_PREFIX);
        return String.format("%s%s%06d", ESTIMATION_NUMBER, this.waterTaxUtils.getCityCode(), nextSequence);
    }
}

