/*
 * Decompiled with CFR 0.152.
 */
package org.egov.wtms.application.workflow;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import org.egov.demand.model.EgDemand;
import org.egov.eis.entity.Assignment;
import org.egov.eis.service.AssignmentService;
import org.egov.eis.service.PositionMasterService;
import org.egov.infra.admin.master.entity.Role;
import org.egov.infra.admin.master.entity.User;
import org.egov.infra.admin.master.service.UserService;
import org.egov.infra.security.utils.SecurityUtils;
import org.egov.infra.workflow.entity.OwnerGroup;
import org.egov.infra.workflow.entity.StateHistory;
import org.egov.infra.workflow.matrix.entity.WorkFlowMatrix;
import org.egov.infra.workflow.service.SimpleWorkflowService;
import org.egov.pims.commons.Position;
import org.egov.ptis.domain.model.AssessmentDetails;
import org.egov.ptis.domain.model.enums.BasicPropertyStatus;
import org.egov.ptis.domain.service.property.PropertyExternalService;
import org.egov.wtms.application.entity.WaterConnectionDetails;
import org.egov.wtms.application.entity.WaterDemandConnection;
import org.egov.wtms.application.repository.WaterConnectionDetailsRepository;
import org.egov.wtms.application.service.WaterConnectionDetailsService;
import org.egov.wtms.application.service.WaterConnectionSmsAndEmailService;
import org.egov.wtms.application.service.WaterDemandConnectionService;
import org.egov.wtms.application.workflow.ApplicationWorkflowCustom;
import org.egov.wtms.masters.entity.enums.ConnectionStatus;
import org.egov.wtms.service.es.WaterChargeDocumentService;
import org.egov.wtms.utils.PropertyExtnUtils;
import org.egov.wtms.utils.WaterTaxUtils;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public abstract class ApplicationWorkflowCustomImpl
implements ApplicationWorkflowCustom {
    private static final Logger LOG = LoggerFactory.getLogger(ApplicationWorkflowCustomImpl.class);
    @Autowired
    private WaterConnectionDetailsRepository waterConnectionDetailsRepository;
    @Autowired
    private PropertyExtnUtils propertyExtnUtils;
    @Autowired
    private SecurityUtils securityUtils;
    @Autowired
    private WaterDemandConnectionService waterDemandConnectionService;
    @Autowired
    private AssignmentService assignmentService;
    @Autowired
    private PositionMasterService positionMasterService;
    @Autowired
    private WaterTaxUtils waterTaxUtils;
    @Autowired
    private WaterChargeDocumentService waterChargeIndexService;
    @Autowired
    private UserService userService;
    @Autowired
    private WaterConnectionSmsAndEmailService waterConnectionSmsAndEmailService;
    @Autowired
    @Qualifier(value="workflowService")
    private SimpleWorkflowService<WaterConnectionDetails> waterConnectionWorkflowService;
    @Autowired
    private WaterConnectionDetailsService waterConnectionDetailsService;

    @Override
    public void createCommonWorkflowTransition(WaterConnectionDetails waterConnectionDetails, Long approvalPosition, String approvalComent, String additionalRule, String workFlowAction) {
        WaterDemandConnection waterDemandConnection;
        EgDemand demand;
        Boolean recordCreatedByRoleAdmin;
        Boolean recordCreatedBySuperUser;
        Boolean recordCreatedByAnonymousUser;
        Boolean recordCreatedBYCitizenPortal;
        Boolean recordCreatedBYNonEmployee;
        if (LOG.isDebugEnabled()) {
            LOG.debug(" Create WorkFlow Transition Started  ...");
        }
        User user = this.securityUtils.getCurrentUser();
        DateTime currentDate = new DateTime();
        Assignment userAssignment = this.assignmentService.getPrimaryAssignmentForUser(user.getId());
        Position pos = null;
        Assignment wfInitiator = null;
        if (user != null && user.getId() != waterConnectionDetails.getCreatedBy().getId() && ("CLOSINGCONNECTION".equalsIgnoreCase(waterConnectionDetails.getApplicationType().getCode()) || "RECONNECTION".equalsIgnoreCase(waterConnectionDetails.getApplicationType().getCode()))) {
            recordCreatedBYNonEmployee = this.waterTaxUtils.getCurrentUserRole(user);
            recordCreatedBYCitizenPortal = this.waterTaxUtils.isCitizenPortalUser(user);
            recordCreatedByAnonymousUser = this.waterTaxUtils.isAnonymousUser(user);
            recordCreatedBySuperUser = this.waterTaxUtils.isSuperUser(user);
            recordCreatedByRoleAdmin = this.waterTaxUtils.isRoleAdmin(user);
        } else {
            recordCreatedBYNonEmployee = this.waterTaxUtils.getCurrentUserRole(waterConnectionDetails.getCreatedBy());
            recordCreatedBYCitizenPortal = this.waterTaxUtils.isCitizenPortalUser(this.userService.getUserById(waterConnectionDetails.getCreatedBy().getId()));
            recordCreatedByAnonymousUser = this.waterTaxUtils.isAnonymousUser(this.userService.getUserById(waterConnectionDetails.getCreatedBy().getId()));
            recordCreatedBySuperUser = this.waterTaxUtils.isSuperUser(this.userService.getUserById(waterConnectionDetails.getCreatedBy().getId()));
            recordCreatedByRoleAdmin = this.waterTaxUtils.isRoleAdmin(this.userService.getUserById(waterConnectionDetails.getCreatedBy().getId()));
        }
        String currState = "";
        String loggedInUserDesignation = this.waterTaxUtils.loggedInUserDesignation(waterConnectionDetails);
        String natureOfwork = this.getNatureOfTask(waterConnectionDetails);
        if (recordCreatedBYNonEmployee.booleanValue() || recordCreatedBYCitizenPortal.booleanValue() || recordCreatedByAnonymousUser.booleanValue() || recordCreatedBySuperUser.booleanValue() || recordCreatedByRoleAdmin.booleanValue()) {
            Object assignmentList;
            currState = "Created";
            if (!waterConnectionDetails.getStateHistory().isEmpty() && (wfInitiator = this.assignmentService.getPrimaryAssignmentForPositon(((Position)((StateHistory)waterConnectionDetails.getStateHistory().get(0)).getOwnerPosition()).getId())) == null && !(assignmentList = this.assignmentService.getAssignmentsForPosition(((Position)((StateHistory)waterConnectionDetails.getStateHistory().get(0)).getOwnerPosition()).getId())).isEmpty()) {
                wfInitiator = (Assignment)assignmentList.get(0);
            }
        } else if (null != waterConnectionDetails.getId()) {
            User currentUser = this.userService.getUserById(waterConnectionDetails.getCreatedBy().getId());
            if (currentUser != null && waterConnectionDetails.getLegacy().equals(true)) {
                for (Role userrole : currentUser.getRoles()) {
                    List assignmentList;
                    Position positionuser;
                    if (!userrole.getName().equals("SYSTEM") && !"Water Tax Approver".equals(userrole.getName()) || (positionuser = this.waterTaxUtils.getZonalLevelClerkForLoggedInUser(waterConnectionDetails.getConnection().getPropertyIdentifier())) == null) continue;
                    wfInitiator = this.assignmentService.getPrimaryAssignmentForPositionAndDate(positionuser.getId(), new Date());
                    if (wfInitiator == null && !(assignmentList = this.assignmentService.getAssignmentsForPosition(positionuser.getId())).isEmpty()) {
                        wfInitiator = (Assignment)assignmentList.get(0);
                    }
                    break;
                }
            } else {
                List assignmtList;
                wfInitiator = this.assignmentService.getPrimaryAssignmentForUser(waterConnectionDetails.getCreatedBy().getId());
                if (wfInitiator == null && !(assignmtList = this.assignmentService.getAllActiveEmployeeAssignmentsByEmpId(waterConnectionDetails.getCreatedBy().getId())).isEmpty()) {
                    wfInitiator = (Assignment)assignmtList.get(0);
                }
            }
        }
        if (workFlowAction != null && "Cancel".equalsIgnoreCase(workFlowAction)) {
            waterConnectionDetails.setConnectionStatus(ConnectionStatus.INACTIVE);
            demand = this.waterTaxUtils.getCurrentDemand(waterConnectionDetails).getDemand();
            if (demand != null) {
                waterDemandConnection = this.waterDemandConnectionService.findByWaterConnectionDetailsAndDemand(waterConnectionDetails, demand);
                demand.setIsHistory("Y");
                demand.setModifiedDate(new Date());
                waterDemandConnection.setDemand(demand);
                this.waterDemandConnectionService.updateWaterDemandConnection(waterDemandConnection);
            }
            waterConnectionDetails.setStatus(this.waterTaxUtils.getStatusByCodeAndModuleType("CANCELLED", "WATERTAXAPPLICATION"));
            waterConnectionDetails.transition().end().withSenderName(user.getUsername() + "::" + user.getName()).withComments(approvalComent).withOwner((OwnerGroup)((Position)null)).withDateInfo(currentDate.toDate()).withNatureOfTask(natureOfwork).withNextAction("END");
            this.waterConnectionDetailsRepository.save((Object)waterConnectionDetails);
            this.waterConnectionSmsAndEmailService.sendSmsAndEmailOnRejection(waterConnectionDetails, approvalComent);
            this.waterConnectionDetailsService.updateIndexes(waterConnectionDetails, null);
        } else if ("Reject".equalsIgnoreCase(workFlowAction)) {
            if (wfInitiator != null && wfInitiator.equals((Object)userAssignment)) {
                waterConnectionDetails.setConnectionStatus(ConnectionStatus.INACTIVE);
                if (waterConnectionDetails.getStatus() != null && waterConnectionDetails.getStatus().getCode().equals("ESTIMATIONNOTICEGENERATED") && (demand = this.waterTaxUtils.getCurrentDemand(waterConnectionDetails).getDemand()) != null) {
                    waterDemandConnection = this.waterDemandConnectionService.findByWaterConnectionDetailsAndDemand(waterConnectionDetails, demand);
                    demand.setIsHistory("Y");
                    demand.setModifiedDate(new Date());
                    waterDemandConnection.setDemand(demand);
                    this.waterDemandConnectionService.updateWaterDemandConnection(waterDemandConnection);
                }
                waterConnectionDetails.setStatus(this.waterTaxUtils.getStatusByCodeAndModuleType("CANCELLED", "WATERTAXAPPLICATION"));
                waterConnectionDetails.transition().end().withSenderName(user.getUsername() + "::" + user.getName()).withComments(approvalComent).withDateInfo(currentDate.toDate()).withNatureOfTask(natureOfwork).withNextAction("END");
                this.waterConnectionSmsAndEmailService.sendSmsAndEmailOnRejection(waterConnectionDetails, approvalComent);
                this.waterConnectionDetailsService.updateIndexes(waterConnectionDetails, null);
            } else {
                String stateValue = "Rejected";
                waterConnectionDetails.transition().progressWithStateCopy().withSenderName(user.getUsername() + "::" + user.getName()).withComments(approvalComent).withStateValue("Rejected").withDateInfo(currentDate.toDate()).withOwner(wfInitiator != null && wfInitiator.getPosition() != null ? wfInitiator.getPosition() : null).withNextAction("Application Rejected").withNatureOfTask(natureOfwork);
            }
        } else {
            if (null != approvalPosition && approvalPosition != -1L && !approvalPosition.equals(0L)) {
                pos = this.positionMasterService.getPositionById(approvalPosition);
            }
            WorkFlowMatrix wfmatrix = null;
            if (null == waterConnectionDetails.getState()) {
                wfmatrix = this.waterConnectionWorkflowService.getWfMatrix(waterConnectionDetails.getStateType(), null, null, additionalRule, currState, null);
                waterConnectionDetails.transition().start().withSenderName(user.getUsername() + "::" + user.getName()).withComments(approvalComent).withStateValue(wfmatrix.getNextState()).withDateInfo(new Date()).withOwner((OwnerGroup)pos).withNextAction(wfmatrix.getNextAction()).withNatureOfTask(natureOfwork);
            } else if ("Sign".equalsIgnoreCase(workFlowAction)) {
                waterConnectionDetails.transition().end().withSenderName(user.getUsername() + "::" + user.getName()).withComments(approvalComent).withDateInfo(currentDate.toDate()).withNatureOfTask(natureOfwork).withNextAction("END");
            } else if ("Execute Tap".equalsIgnoreCase(workFlowAction)) {
                if (null != workFlowAction && !workFlowAction.isEmpty() && workFlowAction.equalsIgnoreCase("Execute Tap") && waterConnectionDetails.getApplicationType().getCode().equalsIgnoreCase("CHANGEOFUSE")) {
                    WaterConnectionDetails connectionToBeDeactivated = this.waterConnectionDetailsRepository.findConnectionDetailsByConsumerCodeAndConnectionStatus(waterConnectionDetails.getConnection().getConsumerCode(), ConnectionStatus.ACTIVE);
                    connectionToBeDeactivated.setConnectionStatus(ConnectionStatus.INACTIVE);
                    connectionToBeDeactivated.setIsHistory(true);
                    this.waterConnectionDetailsRepository.saveAndFlush((Object)connectionToBeDeactivated);
                }
                wfmatrix = this.waterConnectionWorkflowService.getWfMatrix(waterConnectionDetails.getStateType(), null, null, additionalRule, waterConnectionDetails.getCurrentState().getValue(), null, null, loggedInUserDesignation);
                AssessmentDetails assessmentDetailsFullFlag = this.propertyExtnUtils.getAssessmentDetailsForFlag(waterConnectionDetails.getConnection().getPropertyIdentifier(), PropertyExternalService.FLAG_FULL_DETAILS, BasicPropertyStatus.ALL);
                waterConnectionDetails.setStatus(this.waterTaxUtils.getStatusByCodeAndModuleType("SANCTIONED", "WATERTAXAPPLICATION"));
                waterConnectionDetails.setConnectionStatus(ConnectionStatus.ACTIVE);
                this.waterConnectionDetailsService.updateIndexes(waterConnectionDetails, null);
                if (waterConnectionDetails.getApplicationType().getCode().equalsIgnoreCase("CHANGEOFUSE")) {
                    BigDecimal amountTodisplayInIndex = this.waterConnectionDetailsService.getTotalAmount(waterConnectionDetails);
                    waterConnectionDetails.setConnectionStatus(ConnectionStatus.ACTIVE);
                    this.waterChargeIndexService.createWaterChargeIndex(waterConnectionDetails, assessmentDetailsFullFlag, amountTodisplayInIndex);
                }
                if (wfmatrix.getNextAction().equalsIgnoreCase("END")) {
                    waterConnectionDetails.transition().end().withSenderName(user.getUsername() + "::" + user.getName()).withComments(approvalComent).withDateInfo(currentDate.toDate()).withNatureOfTask(natureOfwork).withNextAction("END");
                }
            } else if (null != approvalComent && "Receipt Cancelled".equalsIgnoreCase(approvalComent)) {
                wfmatrix = this.waterConnectionWorkflowService.getWfMatrix(waterConnectionDetails.getStateType(), null, null, additionalRule, "Asst engg approved", null);
                waterConnectionDetails.transition().progressWithStateCopy().withSenderName(user.getUsername() + "::" + user.getName()).withComments(approvalComent).withStateValue(wfmatrix.getNextState()).withDateInfo(currentDate.toDate()).withOwner((OwnerGroup)pos).withNextAction(wfmatrix.getNextAction()).withNatureOfTask(natureOfwork);
            } else if ((additionalRule.equals("CLOSECONNECTION") || additionalRule.equals("RECONNECTION")) && (waterConnectionDetails.getCurrentState().getValue().equals("Closed") || waterConnectionDetails.getCurrentState().getValue().equals("END"))) {
                wfmatrix = currState != null && (this.waterTaxUtils.getCurrentUserRole() != false || this.waterTaxUtils.isCurrentUserCitizenRole() != false || this.waterTaxUtils.isMeesevaUser(this.securityUtils.getCurrentUser()) != false || this.waterTaxUtils.isAnonymousUser(this.securityUtils.getCurrentUser()) != false) ? this.waterConnectionWorkflowService.getWfMatrix(waterConnectionDetails.getStateType(), null, null, additionalRule, currState, null) : this.waterConnectionWorkflowService.getWfMatrix(waterConnectionDetails.getStateType(), null, null, additionalRule, null, null);
                if (wfmatrix != null && !wfmatrix.getNextAction().equalsIgnoreCase("END")) {
                    waterConnectionDetails.transition().reopen().withSenderName(user.getUsername() + "::" + user.getName()).withComments(approvalComent).withStateValue(wfmatrix.getNextState()).withDateInfo(currentDate.toDate()).withOwner((OwnerGroup)pos).withNextAction(wfmatrix.getNextAction()).withNatureOfTask(natureOfwork);
                }
            } else {
                wfmatrix = this.getloggedinUserDesignationForEstimationAndWorkOrderGeneratedStatus(waterConnectionDetails, loggedInUserDesignation) ? this.getMatrixbyStatusAndLoggedInUser(waterConnectionDetails, additionalRule, workFlowAction, loggedInUserDesignation) : this.waterConnectionWorkflowService.getWfMatrix(waterConnectionDetails.getStateType(), null, null, additionalRule, waterConnectionDetails.getCurrentState().getValue(), null, null);
                if ((additionalRule.equals("CLOSECONNECTION") || additionalRule.equals("RECONNECTION")) && wfmatrix != null && wfmatrix.getNextAction().equalsIgnoreCase("END")) {
                    waterConnectionDetails.transition().end().withSenderName(user.getUsername() + "::" + user.getName()).withComments(approvalComent).withDateInfo(currentDate.toDate()).withNatureOfTask(natureOfwork).withNextAction("END");
                } else {
                    waterConnectionDetails.transition().progressWithStateCopy().withSenderName(user.getUsername() + "::" + user.getName()).withComments(approvalComent).withStateValue(wfmatrix.getNextState()).withDateInfo(currentDate.toDate()).withOwner((OwnerGroup)pos).withNextAction(wfmatrix.getNextAction()).withNatureOfTask(natureOfwork);
                }
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(" WorkFlow Transition Completed  ...");
        }
    }

    protected WorkFlowMatrix getMatrixbyStatusAndLoggedInUser(WaterConnectionDetails waterConnectionDetails, String additionalRule, String workFlowAction, String loggedInUserDesignation) {
        WorkFlowMatrix wfmatrix = null;
        if (workFlowAction.equals("Forward") && waterConnectionDetails.getStatus().getCode().equals("DIGITALSIGNATUREPENDING") && loggedInUserDesignation.equalsIgnoreCase("Deputy Executive engineer")) {
            wfmatrix = this.waterConnectionWorkflowService.getWfMatrix(waterConnectionDetails.getStateType(), null, null, additionalRule, "Deputy Engineer Approved", null, null, loggedInUserDesignation);
        }
        if (wfmatrix == null && workFlowAction.equals("Forward") && waterConnectionDetails.getStatus().getCode().equals("DIGITALSIGNATUREPENDING") && (loggedInUserDesignation.equalsIgnoreCase("Municipal Engineer") || loggedInUserDesignation.equalsIgnoreCase("Superintendent Engineer") || loggedInUserDesignation.equalsIgnoreCase("Executive engineer"))) {
            wfmatrix = this.waterConnectionWorkflowService.getWfMatrix(waterConnectionDetails.getStateType(), null, null, additionalRule, "Engineer Executive Forwarded", null, null, loggedInUserDesignation);
        } else if (workFlowAction.equals("Forward") && waterConnectionDetails.getStatus().getCode().equals("ESTIMATIONAMOUNTPAID") && (loggedInUserDesignation.equalsIgnoreCase("Municipal Engineer") || loggedInUserDesignation.equalsIgnoreCase("Deputy Executive engineer") || loggedInUserDesignation.equalsIgnoreCase("Assistant engineer") || loggedInUserDesignation.equalsIgnoreCase("Assistant executive engineer") || loggedInUserDesignation.equalsIgnoreCase("Superintendent Engineer") || loggedInUserDesignation.equalsIgnoreCase("Executive engineer") || loggedInUserDesignation.equalsIgnoreCase("Tap Inspector"))) {
            wfmatrix = this.waterConnectionWorkflowService.getWfMatrix(waterConnectionDetails.getStateType(), null, null, additionalRule, "Application Approval Pending", null, null, loggedInUserDesignation);
        } else if (workFlowAction.equals("Approve") && waterConnectionDetails.getStatus().getCode().equals("DIGITALSIGNATUREPENDING") && (loggedInUserDesignation.equalsIgnoreCase("Municipal Engineer") || loggedInUserDesignation.equalsIgnoreCase("Superintendent Engineer") || loggedInUserDesignation.equalsIgnoreCase("Executive engineer"))) {
            wfmatrix = this.waterConnectionWorkflowService.getWfMatrix(waterConnectionDetails.getStateType(), null, null, additionalRule, "Engineer Executive Forwarded", null, null, loggedInUserDesignation);
        } else if (wfmatrix == null && (waterConnectionDetails.getApplicationType().getCode().equals("NEWCONNECTION") || waterConnectionDetails.getApplicationType().getCode().equals("CHANGEOFUSE") || waterConnectionDetails.getApplicationType().getCode().equals("ADDNLCONNECTION")) && workFlowAction.equals("Sign")) {
            wfmatrix = this.waterConnectionWorkflowService.getWfMatrix(waterConnectionDetails.getStateType(), null, null, additionalRule, "Commissioner Approved", null, null, loggedInUserDesignation);
        }
        if (wfmatrix == null && "Forward".equalsIgnoreCase(workFlowAction)) {
            if (waterConnectionDetails.getStatus().getCode().equals("CLOSERINPROGRESS")) {
                wfmatrix = this.waterConnectionWorkflowService.getWfMatrix(waterConnectionDetails.getStateType(), null, null, additionalRule, "Close forwared By Approver", null, null, loggedInUserDesignation);
            }
            if (waterConnectionDetails.getStatus().getCode().equals("RECONNECTIONINPROGRESS")) {
                wfmatrix = this.waterConnectionWorkflowService.getWfMatrix(waterConnectionDetails.getStateType(), null, null, additionalRule, "ReConn forwared By Approver", null, null, loggedInUserDesignation);
            }
        }
        if (wfmatrix == null && ("Approve".equalsIgnoreCase(workFlowAction) || "Forward".equalsIgnoreCase(workFlowAction)) && (loggedInUserDesignation.equalsIgnoreCase("Municipal Engineer") || loggedInUserDesignation.equalsIgnoreCase("Deputy Executive engineer") || loggedInUserDesignation.equalsIgnoreCase("Superintendent Engineer") || loggedInUserDesignation.equalsIgnoreCase("Executive engineer") || loggedInUserDesignation.equalsIgnoreCase("Commissioner"))) {
            if (waterConnectionDetails.getStatus().getCode().equals("CLOSUREDIGSIGNPENDING")) {
                wfmatrix = this.waterConnectionWorkflowService.getWfMatrix(waterConnectionDetails.getStateType(), null, null, additionalRule, "Close approve By Comm", null, null, loggedInUserDesignation);
            }
            if (waterConnectionDetails.getStatus().getCode().equals("RECONNDIGSIGNPENDING")) {
                wfmatrix = this.waterConnectionWorkflowService.getWfMatrix(waterConnectionDetails.getStateType(), null, null, additionalRule, "Reconnection approve By Comm", null, null, loggedInUserDesignation);
            }
        }
        if (wfmatrix == null && waterConnectionDetails.getStatus().getCode().equals("VERIFIED") && (loggedInUserDesignation.equalsIgnoreCase("Assistant executive engineer") || loggedInUserDesignation.equalsIgnoreCase("Tap Inspector"))) {
            wfmatrix = this.waterConnectionWorkflowService.getWfMatrix(waterConnectionDetails.getStateType(), null, null, additionalRule, waterConnectionDetails.getCurrentState().getValue(), null, null, null);
        }
        if (wfmatrix == null) {
            wfmatrix = this.waterConnectionWorkflowService.getWfMatrix(waterConnectionDetails.getStateType(), null, null, additionalRule, waterConnectionDetails.getCurrentState().getValue(), null, null, loggedInUserDesignation);
        }
        return wfmatrix;
    }

    protected boolean getloggedinUserDesignationForEstimationAndWorkOrderGeneratedStatus(WaterConnectionDetails waterConnectionDetails, String loggedInUserDesignation) {
        return loggedInUserDesignation != null && !"".equals(loggedInUserDesignation) && (loggedInUserDesignation.equals("Commissioner") || loggedInUserDesignation.equalsIgnoreCase("Executive engineer") || loggedInUserDesignation.equalsIgnoreCase("Municipal Engineer") || loggedInUserDesignation.equalsIgnoreCase("Superintendent Engineer") || loggedInUserDesignation.equalsIgnoreCase("Tap Inspector") || loggedInUserDesignation.equalsIgnoreCase("Assistant engineer") || loggedInUserDesignation.equalsIgnoreCase("Deputy Executive engineer") || loggedInUserDesignation.equalsIgnoreCase("Assistant executive engineer"));
    }

    public String getNatureOfTask(WaterConnectionDetails waterConnectionDetails) {
        String wfTypeDisplayName = "Water Tap Connection";
        if (waterConnectionDetails.getStatus().getCode().equals("CLOSERINPROGRESS") || waterConnectionDetails.getStatus().getCode().equals("CLOSERINITIATED") || waterConnectionDetails.getStatus().getCode().equals("CLOSUREDIGSIGNPENDING") || waterConnectionDetails.getStatus().getCode().equals("CLOSERAPPROVED") || waterConnectionDetails.getStatus().getCode().equals("CLOSERSANCTIONED")) {
            return "Closure Water Tap Connection";
        }
        if (waterConnectionDetails.getStatus().getCode().equals("RECONNECTIONINITIATED") || waterConnectionDetails.getStatus().getCode().equals("RECONNECTIONINPROGRESS") || waterConnectionDetails.getStatus().getCode().equals("RECONNECTIONAPPROVED") || waterConnectionDetails.getStatus().getCode().equals("RECONNDIGSIGNPENDING") || waterConnectionDetails.getStatus().getCode().equals("RECONNECTIONSANCTIONED")) {
            return "Reconnection Water Tap Connection";
        }
        if (waterConnectionDetails.getApplicationType().getCode().equals("NEWCONNECTION")) {
            return "New Water Tap Connection";
        }
        if (waterConnectionDetails.getApplicationType().getCode().equals("ADDNLCONNECTION")) {
            return "Additional Water Tap Connection";
        }
        if (waterConnectionDetails.getApplicationType().getCode().equals("CHANGEOFUSE")) {
            return "Change Of Usage Water Tap Connection";
        }
        return waterConnectionDetails.getApplicationType().getName() + " " + "Water Tap Connection";
    }
}

