/*
 * Decompiled with CFR 0.152.
 */
package org.egov.wtms.application.service.collection;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.apache.commons.lang3.time.DateUtils;
import org.egov.collection.integration.models.BillAccountDetails;
import org.egov.commons.CFinancialYear;
import org.egov.commons.Installment;
import org.egov.commons.dao.FinancialYearDAO;
import org.egov.demand.dao.DemandGenericDao;
import org.egov.demand.dao.EgBillDao;
import org.egov.demand.interfaces.BillServiceInterface;
import org.egov.demand.interfaces.Billable;
import org.egov.demand.model.EgBill;
import org.egov.demand.model.EgBillDetails;
import org.egov.demand.model.EgDemand;
import org.egov.demand.model.EgDemandDetails;
import org.egov.demand.model.EgDemandReason;
import org.egov.infra.admin.master.service.ModuleService;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infstr.services.PersistenceService;
import org.egov.ptis.client.util.PropertyTaxUtil;
import org.egov.wtms.application.entity.WaterConnectionDetails;
import org.egov.wtms.application.service.ConnectionDemandService;
import org.egov.wtms.application.service.WaterConnectionDetailsService;
import org.egov.wtms.application.service.collection.DemandComparatorByOrderId;
import org.egov.wtms.application.service.collection.WaterConnectionBillable;
import org.egov.wtms.masters.entity.enums.ConnectionStatus;
import org.egov.wtms.masters.entity.enums.ConnectionType;
import org.egov.wtms.utils.constants.WaterTaxConstants;
import org.hibernate.Query;
import org.hibernate.Session;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class ConnectionBillService
extends BillServiceInterface {
    private static final Logger LOG = LoggerFactory.getLogger(ConnectionBillService.class);
    private static final String ACTIVE = "ACTIVE";
    private static final String STRING_WCMS_FUCNTION_CODE = "5100";
    @PersistenceContext
    private EntityManager entityManager;
    @Autowired
    private EgBillDao egBillDAO;
    @Autowired
    private ApplicationContext context;
    @Autowired
    private ModuleService moduleService;
    @Autowired
    private ConnectionDemandService connectionDemandService;
    @Autowired
    private WaterConnectionDetailsService waterConnectionDetailsService;
    @Autowired
    private DemandGenericDao demandGenericDAO;
    @Autowired
    private FinancialYearDAO financialYearDAO;
    @Autowired
    private PropertyTaxUtil propertyTaxUtil;
    @Autowired
    @Qualifier(value="persistenceService")
    private PersistenceService persistenceService;

    public Session getCurrentSession() {
        return (Session)this.entityManager.unwrap(Session.class);
    }

    public List<EgBillDetails> getBilldetails(Billable billObj) {
        ArrayList<EgBillDetails> billDetails = new ArrayList<EgBillDetails>();
        EgDemand demand = billObj.getCurrentDemand();
        Date currentDate = new Date();
        HashMap installmentWise = new HashMap();
        TreeSet<Installment> sortedInstallmentSet = new TreeSet<Installment>();
        DemandComparatorByOrderId demandComparatorByOrderId = new DemandComparatorByOrderId();
        ArrayList orderedDetailsList = new ArrayList();
        Installment currInstallment = this.connectionDemandService.getCurrentInstallment("Water Tax Management", "Yearly", new Date());
        CFinancialYear finYear = this.financialYearDAO.getFinancialYearByDate(new Date());
        new TreeMap();
        for (EgDemandDetails demandDetail : demand.getEgDemandDetails()) {
            Installment installment = demandDetail.getEgDemandReason().getEgInstallmentMaster();
            if (installmentWise.get(installment) == null) {
                ArrayList<EgDemandDetails> detailsList = new ArrayList<EgDemandDetails>();
                detailsList.add(demandDetail);
                installmentWise.put(demandDetail.getEgDemandReason().getEgInstallmentMaster(), detailsList);
                sortedInstallmentSet.add(installment);
                continue;
            }
            ((List)installmentWise.get(demandDetail.getEgDemandReason().getEgInstallmentMaster())).add(demandDetail);
        }
        for (Installment i : sortedInstallmentSet) {
            List installmentWiseDetails = (List)installmentWise.get(i);
            Collections.sort(installmentWiseDetails, demandComparatorByOrderId);
            orderedDetailsList.addAll(installmentWiseDetails);
        }
        int i = 1;
        WaterConnectionDetails waterConnectionDetails = this.waterConnectionDetailsService.getWaterConnectionDetailsByDemand(demand);
        for (EgDemandDetails demandDetail : orderedDetailsList) {
            EgDemandReason reason = demandDetail.getEgDemandReason();
            Installment installment = demandDetail.getEgDemandReason().getEgInstallmentMaster();
            if (!demandDetail.getEgDemandReason().getEgDemandReasonMaster().getIsDebit().equalsIgnoreCase("N") || demandDetail.getAmount().compareTo(demandDetail.getAmtCollected()) <= 0) continue;
            EgBillDetails billdetail = new EgBillDetails();
            if (demandDetail.getAmount() != null) {
                billdetail.setDrAmount(BigDecimal.ZERO);
                billdetail.setCrAmount(demandDetail.getAmount().subtract(demandDetail.getAmtCollected()));
            }
            if (LOG.isInfoEnabled()) {
                LOG.info("demandDetail.getEgDemandReason()" + demandDetail.getEgDemandReason().getEgDemandReasonMaster().getReasonMaster() + " glcodeerror" + demandDetail.getEgDemandReason().getGlcodeId());
            }
            billdetail.setGlcode(demandDetail.getEgDemandReason().getGlcodeId().getGlcode());
            billdetail.setEgDemandReason(demandDetail.getEgDemandReason());
            billdetail.setAdditionalFlag(Integer.valueOf(1));
            billdetail.setCreateDate(currentDate);
            billdetail.setModifiedDate(currentDate);
            billdetail.setOrderNo(Integer.valueOf(i++));
            billdetail.setDescription(reason.getEgDemandReasonMaster().getReasonMaster() + " - " + installment.getDescription() + " # " + billObj.getCurrentDemand().getEgInstallmentMaster().getDescription());
            billdetail.setFunctionCode(STRING_WCMS_FUCNTION_CODE);
            if (waterConnectionDetails != null && waterConnectionDetails.getConnectionType().equals((Object)ConnectionType.NON_METERED)) {
                if (billdetail.getDescription().contains("Advance")) {
                    billdetail.setPurpose(BillAccountDetails.PURPOSE.ADVANCE_AMOUNT.toString());
                } else if (billdetail.getEgDemandReason().getEgInstallmentMaster().getToDate().compareTo(finYear.getStartingDate()) < 0) {
                    billdetail.setPurpose(BillAccountDetails.PURPOSE.ARREAR_AMOUNT.toString());
                } else if (billdetail.getEgDemandReason().getEgInstallmentMaster().getFromDate().compareTo(finYear.getStartingDate()) >= 0 && billdetail.getEgDemandReason().getEgInstallmentMaster().getFromDate().compareTo(finYear.getEndingDate()) < 0) {
                    billdetail.setPurpose(BillAccountDetails.PURPOSE.CURRENT_AMOUNT.toString());
                } else {
                    billdetail.setPurpose(BillAccountDetails.PURPOSE.OTHERS.toString());
                }
            }
            if (waterConnectionDetails != null && waterConnectionDetails.getConnectionType().equals((Object)ConnectionType.METERED)) {
                billdetail.setPurpose(BillAccountDetails.PURPOSE.OTHERS.toString());
            }
            if (currInstallment != null && installment.getFromDate().before(currInstallment.getToDate())) {
                billdetail.setAdditionalFlag(Integer.valueOf(1));
            } else {
                billdetail.setAdditionalFlag(Integer.valueOf(0));
            }
            billDetails.add(billdetail);
        }
        if (waterConnectionDetails != null && waterConnectionDetails.getConnectionType().equals((Object)ConnectionType.NON_METERED)) {
            HashMap<String, Installment> currInstallments = new HashMap<String, Installment>();
            Installment currFirstHalf = (Installment)this.propertyTaxUtil.getInstallmentsForCurrYear(new Date()).get("Current 1st Half");
            Installment currSecondHalf = (Installment)this.propertyTaxUtil.getInstallmentsForCurrYear(new Date()).get("Current 2nd Half");
            currInstallments.put("Current 1st Half", currFirstHalf);
            currInstallments.put("Current 2nd Half", currSecondHalf);
            Date advanceStartDate = DateUtils.addYears((Date)((Installment)currInstallments.get("Current 1st Half")).getFromDate(), (int)1);
            List<Installment> advanceInstallments = this.getAdvanceInstallmentsList(advanceStartDate);
            BigDecimal currentInstDemand = BigDecimal.ZERO;
            for (EgDemandDetails dmdDet : demand.getEgDemandDetails()) {
                if (!dmdDet.getInstallmentStartDate().equals(((Installment)currInstallments.get("Current 2nd Half")).getFromDate())) continue;
                currentInstDemand = currentInstDemand.add(dmdDet.getAmount());
            }
            if (ConnectionStatus.ACTIVE.equals((Object)waterConnectionDetails.getConnectionStatus())) {
                this.createAdvanceBillDetails(billDetails, currentInstDemand, demand, billObj, advanceInstallments, (Installment)currInstallments.get("Current 2nd Half"));
            }
        }
        return billDetails;
    }

    private void createAdvanceBillDetails(List<EgBillDetails> billDetails, BigDecimal currentInstallmentDemand, EgDemand demand, Billable billable, List<Installment> advanceInstallments, Installment dmdDetInstallment) {
        BigDecimal advanceCollection = this.demandGenericDAO.getBalanceByDmdMasterCodeInst(demand, "WTADVANCE", this.moduleService.getModuleByName("Water Tax Management"), dmdDetInstallment);
        CFinancialYear finYear = this.financialYearDAO.getFinancialYearByDate(new Date());
        if (advanceCollection.compareTo(BigDecimal.ZERO) < 0) {
            advanceCollection = advanceCollection.abs();
        }
        BigDecimal partiallyCollectedAmount = BigDecimal.ZERO;
        if (currentInstallmentDemand.compareTo(BigDecimal.ZERO) > 0) {
            partiallyCollectedAmount = advanceCollection.remainder(currentInstallmentDemand);
        }
        if (currentInstallmentDemand.compareTo(BigDecimal.ZERO) > 0) {
            Integer noOfAdvancesPaid = advanceCollection.subtract(partiallyCollectedAmount).divide(currentInstallmentDemand).intValue();
            if (LOG.isDebugEnabled()) {
                LOG.debug("getBilldetails - advanceCollection = " + advanceCollection + ", noOfAdvancesPaid=" + noOfAdvancesPaid);
            }
            Installment installment = null;
            int j = billDetails.size() + 1;
            if (noOfAdvancesPaid < WaterTaxConstants.MAX_ADVANCES_ALLOWED) {
                for (int i = noOfAdvancesPaid.intValue(); i < advanceInstallments.size(); ++i) {
                    installment = advanceInstallments.get(i);
                    EgDemandReason reasonmaster = this.connectionDemandService.getDemandReasonByCodeAndInstallment("WTADVANCE", installment);
                    if (reasonmaster == null) continue;
                    EgBillDetails billdetail = new EgBillDetails();
                    billdetail.setDrAmount(BigDecimal.ZERO);
                    billdetail.setCrAmount(currentInstallmentDemand);
                    billdetail.setGlcode("3504106");
                    billdetail.setEgDemandReason(reasonmaster);
                    billdetail.setCreateDate(new Date());
                    billdetail.setModifiedDate(new Date());
                    j = billDetails.size() + 1;
                    billdetail.setOrderNo(Integer.valueOf(j));
                    billdetail.setDescription(reasonmaster.getEgDemandReasonMaster().getReasonMaster() + " - " + installment.getDescription());
                    if (billdetail.getDescription().contains("Advance")) {
                        billdetail.setPurpose(BillAccountDetails.PURPOSE.ADVANCE_AMOUNT.toString());
                    } else if (billdetail.getEgDemandReason().getEgInstallmentMaster().getToDate().compareTo(finYear.getStartingDate()) < 0) {
                        billdetail.setPurpose(BillAccountDetails.PURPOSE.ARREAR_AMOUNT.toString());
                    } else if (billdetail.getEgDemandReason().getEgInstallmentMaster().getFromDate().compareTo(finYear.getStartingDate()) >= 0 && billdetail.getEgDemandReason().getEgInstallmentMaster().getToDate().compareTo(finYear.getEndingDate()) >= 0) {
                        billdetail.setPurpose(BillAccountDetails.PURPOSE.CURRENT_AMOUNT.toString());
                    } else {
                        billdetail.setPurpose(BillAccountDetails.PURPOSE.OTHERS.toString());
                    }
                    billdetail.setFunctionCode(STRING_WCMS_FUCNTION_CODE);
                    billdetail.setAdditionalFlag(Integer.valueOf(0));
                    billDetails.add(billdetail);
                }
            }
        } else if (LOG.isDebugEnabled()) {
            LOG.debug("getBillDetails - All advances are paid...");
        }
    }

    public void cancelBill() {
    }

    public EgBill updateBillWithLatest(Long billId) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("updateBillWithLatest billId " + billId);
        }
        EgBill bill = this.egBillDAO.findById(billId, false);
        if (LOG.isDebugEnabled()) {
            LOG.debug("updateBillWithLatest old bill " + bill);
        }
        if (bill == null) {
            throw new ApplicationRuntimeException("No bill found with bill reference no :" + billId);
        }
        bill.getEgBillDetails().clear();
        WaterConnectionBillable waterConnectionBillable = (WaterConnectionBillable)((Object)this.context.getBean("waterConnectionBillable"));
        waterConnectionBillable.setWaterConnectionDetails(this.waterConnectionDetailsService.findByApplicationNumberOrConsumerCodeAndStatus(bill.getConsumerId().trim().toUpperCase(), ConnectionStatus.ACTIVE));
        List<EgBillDetails> egBillDetails = this.getBilldetails(waterConnectionBillable);
        for (EgBillDetails billDetail : egBillDetails) {
            bill.addEgBillDetails(billDetail);
            billDetail.setEgBill(bill);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Bill update with bill details for water charges " + bill.getConsumerId() + " as billdetails " + egBillDetails);
        }
        return bill;
    }

    public List<Installment> getAdvanceInstallmentsList(Date startDate) {
        ArrayList<Installment> advanceInstallments = new ArrayList();
        String query = "select inst from Installment inst where inst.module.name = 'Property Tax' and inst.fromDate >= :startdate order by inst.fromDate asc ";
        advanceInstallments = this.getCurrentSession().createQuery("select inst from Installment inst where inst.module.name = 'Property Tax' and inst.fromDate >= :startdate order by inst.fromDate asc ").setParameter("startdate", (Object)startDate).setMaxResults(WaterTaxConstants.MAX_ADVANCES_ALLOWED.intValue()).list();
        return advanceInstallments;
    }

    public HashMap<String, Integer> generateOrderForDemandDetails(Set<EgDemandDetails> demandDetails, Billable billable, List<Installment> advanceInstallments, Map<String, Installment> currInstallments) {
        TreeMap<Date, String> instReasonMap = new TreeMap<Date, String>();
        HashMap<String, Integer> orderMap = new HashMap<String, Integer>();
        Date key = null;
        DateTime dateTime = null;
        for (Installment inst : advanceInstallments) {
            dateTime = new DateTime((Object)inst.getInstallmentYear());
            key = this.getOrder(inst.getInstallmentYear(), WaterTaxConstants.DEMAND_REASON_ORDER_MAP.get("WTADVANCE"));
            instReasonMap.put(key, dateTime.getMonthOfYear() + "/" + dateTime.getYear() + "-" + "WTADVANCE");
        }
        int order = 1;
        LinkedHashMap installmentAndReason = new LinkedHashMap();
        for (Map.Entry entry : instReasonMap.entrySet()) {
            String[] split = ((String)entry.getValue()).split("-");
            if (installmentAndReason.get(split[0]) == null) {
                HashMap reason = new HashMap();
                reason.put(split[1], entry.getValue());
                installmentAndReason.put(split[0], reason);
                continue;
            }
            ((Map)installmentAndReason.get(split[0])).put(split[1], entry.getValue());
        }
        for (String installmentYear : installmentAndReason.keySet()) {
            for (String reasonCode : WaterTaxConstants.ORDERED_DEMAND_RSNS_LIST) {
                if (((Map)installmentAndReason.get(installmentYear)).get(reasonCode) == null) continue;
                orderMap.put((String)((Map)installmentAndReason.get(installmentYear)).get(reasonCode), order++);
            }
        }
        return orderMap;
    }

    public Date getOrder(Date date, int reasonOrder) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(5, reasonOrder);
        return calendar.getTime();
    }

    public EgBill getBillByConsumerCode(String consumerCode) {
        EgBill egBill = null;
        StringBuilder queryString = new StringBuilder();
        queryString.append(" select distinct bill From EgBill bill,EgBillType billtype,WaterConnection conn,WaterConnectionDetails connDet,EgwStatus status,WaterDemandConnection conndem  , EgDemand demd ").append("where billtype.id=bill.egBillType and billtype.code= 'MANUAL'").append(" and bill.consumerId = conn.consumerCode ").append(" and conn.id=connDet.connection ").append(" and connDet.id=conndem.waterConnectionDetails ").append(" and demd.id=bill.egDemand ").append(" and demd.id=conndem.demand ").append(" and connDet.connectionType='Non-metered'").append(" and demd.isHistory = 'N'").append(" and bill.is_Cancelled='N'").append(" and bill.serviceCode='WT'").append(" and connDet.connectionStatus='ACTIVE'").append(" and connDet.status=status.id ").append(" and status.moduletype='WATERTAXAPPLICATION'").append(" and status.code='SANCTIONED'").append(" and conn.consumerCode =:consumerCode ").append(" order by bill.id desc ");
        Query query = this.persistenceService.getSession().createQuery(queryString.toString()).setString("consumerCode", consumerCode);
        List egBilltemp = query.list();
        if (!egBilltemp.isEmpty()) {
            egBill = (EgBill)egBilltemp.get(0);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("query to get Bill for is {}. for consumer No {}. ", (Object)queryString.toString(), (Object)consumerCode);
        }
        return egBill;
    }
}

