/*
 * Decompiled with CFR 0.152.
 */
package org.egov.wtms.application.service;

import java.math.BigInteger;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.egov.infra.config.persistence.datasource.routing.annotation.ReadOnly;
import org.egov.wtms.application.entity.SearchNoticeDetails;
import org.egov.wtms.masters.entity.enums.ConnectionStatus;
import org.hibernate.SQLQuery;
import org.hibernate.Session;
import org.hibernate.transform.AliasToBeanResultTransformer;
import org.hibernate.transform.ResultTransformer;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class SearchNoticeService {
    private static final String WARD = "ward";
    private static final String ZONE = "zone";
    private static final String CONSUMERCODE = "consumerCode";
    private static final String HOUSENUMBER = "houseNumber";
    private static final String ASSESSMENT_NUMBER = "assessmentNumber";
    private static final String CONNECTION_TYPE = "connectionType";
    private static final String APPLICATION_TYPE = "applicationType";
    private static final String PROPERTY_TYPE = "propertyType";
    @PersistenceContext
    private EntityManager entityManager;
    private static final Logger LOGGER = Logger.getLogger(SearchNoticeService.class);

    @ReadOnly
    public List<SearchNoticeDetails> getBillReportDetails(SearchNoticeDetails searchNoticeDetails, String zone, String ward, String propertyType, String applicationType, String connectionType, String consumerCode, String houseNumber, String assessmentNumber, String fromDate, String toDate) {
        long startTime = System.currentTimeMillis();
        StringBuilder queryStr = new StringBuilder();
        queryStr.append("select distinct dcbinfo.hscno as \"hscNo\", dcbinfo.username as \"ownerName\",dcbinfo.propertyid as \"assessmentNo\",dcbinfo.demanddocumentnumber as \"fileStoreID\",");
        queryStr.append("dcbinfo.houseno as \"houseNumber\" , localboundary.localname as \"locality\", dcbinfo.applicationtype as \"applicationType\" , ");
        queryStr.append(" dcbinfo.connectiontype as  \"connectionType\" , bill.bill_no as \"billNo\" , bill.issue_date as \"billDate\" from egwtr_mv_bill_view dcbinfo");
        queryStr.append(" INNER JOIN eg_boundary wardboundary on dcbinfo.wardid = wardboundary.id INNER JOIN eg_boundary localboundary on dcbinfo.locality = localboundary.id");
        queryStr.append(" INNER JOIN eg_bill bill on dcbinfo.hscno = bill.consumer_id and dcbinfo.demand= bill.id_demand");
        queryStr.append(" INNER JOIN eg_boundary zoneboundary on dcbinfo.zoneid = zoneboundary.id ");
        queryStr.append(" where dcbinfo.connectionstatus = '" + ConnectionStatus.ACTIVE.toString() + "' ");
        queryStr.append(" and bill.module_id = (select id from eg_module where name ='Water Tax Management')");
        queryStr.append(" and bill.id_bill_type = (select id from eg_bill_type  where code ='MANUAL')");
        queryStr.append(" and bill.is_cancelled ='N' ");
        if (ward != null && !ward.isEmpty()) {
            queryStr.append(" and wardboundary.name =:ward");
        }
        if (zone != null && !zone.isEmpty()) {
            queryStr.append(" and zoneboundary.name =:zone");
        }
        if (consumerCode != null && !consumerCode.isEmpty()) {
            queryStr.append(" and dcbinfo.hscno =:consumerCode");
        }
        if (assessmentNumber != null && !assessmentNumber.isEmpty()) {
            queryStr.append(" and dcbinfo.propertyid =:assessmentNumber");
        }
        if (houseNumber != null && !houseNumber.isEmpty()) {
            queryStr.append(" and dcbinfo.houseno =:houseNumber");
        }
        if (connectionType != null && !connectionType.isEmpty()) {
            queryStr.append(" and dcbinfo.connectiontype =:connectionType");
        }
        if (applicationType != null && !applicationType.isEmpty()) {
            queryStr.append(" and dcbinfo.applicationtype =:applicationType");
        }
        if (propertyType != null && !propertyType.isEmpty()) {
            queryStr.append(" and dcbinfo.propertytype =:propertyType");
        }
        SQLQuery query = ((Session)this.entityManager.unwrap(Session.class)).createSQLQuery(queryStr.toString());
        if (StringUtils.isNotBlank((String)ward)) {
            query.setParameter(WARD, (Object)ward);
        }
        if (StringUtils.isNotBlank((String)zone)) {
            query.setParameter(ZONE, (Object)zone);
        }
        if (StringUtils.isNotBlank((String)consumerCode)) {
            query.setParameter(CONSUMERCODE, (Object)consumerCode);
        }
        if (StringUtils.isNotBlank((String)assessmentNumber)) {
            query.setParameter(HOUSENUMBER, (Object)houseNumber);
        }
        if (StringUtils.isNotBlank((String)assessmentNumber)) {
            query.setParameter(ASSESSMENT_NUMBER, (Object)assessmentNumber);
        }
        if (StringUtils.isNotBlank((String)connectionType)) {
            query.setParameter(CONNECTION_TYPE, (Object)connectionType);
        }
        if (StringUtils.isNotBlank((String)applicationType)) {
            query.setParameter(APPLICATION_TYPE, (Object)applicationType);
        }
        if (StringUtils.isNotBlank((String)propertyType)) {
            query.setParameter(PROPERTY_TYPE, (Object)propertyType);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("GenerateConnectionBill -- Search Result " + queryStr.toString()));
        }
        query.setResultTransformer((ResultTransformer)new AliasToBeanResultTransformer(SearchNoticeDetails.class));
        long endTime = System.currentTimeMillis();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("GenerateBill | SearchResult | Time taken(ms) " + (endTime - startTime)));
            LOGGER.debug((Object)"Exit from SearchResult method");
        }
        return query.list();
    }

    @ReadOnly
    public List<SearchNoticeDetails> getSanctionOrderDetails(SearchNoticeDetails searchNoticeDetails, String zone, String ward, String propertyType, String applicationType, String connectionType, String consumerCode, String houseNumber, String assessmentNumber, String fromDate, String toDate) {
        String formattedFromDate = null;
        String formattedToDate = null;
        String[] arr = null;
        if (StringUtils.isNotBlank((String)fromDate)) {
            arr = fromDate.split("/");
            formattedFromDate = arr[2] + "-" + arr[1] + "-" + arr[0];
        }
        if (StringUtils.isNotBlank((String)toDate)) {
            arr = toDate.split("/");
            formattedToDate = arr[2] + "-" + arr[1] + "-" + arr[0];
        }
        StringBuilder queryString = new StringBuilder();
        queryString.append("select distinct dcbinfo.hscno as \"hscNo\", dcbinfo.username as \"ownerName\", dcbinfo.propertyid as \"assessmentNo\", ");
        queryString.append("dcbinfo.houseno as \"houseNumber\", localboundary.localname as \"locality\", dcbinfo.applicationtype as \"applicationType\" , ");
        queryString.append("dcbinfo.workorderdate as \"workOrderDate\", dcbinfo.workordernumber as \"workOrderNumber\", ");
        queryString.append("dcbinfo.connectiontype as \"connectionType\" from egwtr_mv_conn_view dcbinfo ");
        queryString.append("INNER JOIN eg_boundary zoneboundary on dcbinfo.zoneid=zoneboundary.id ");
        queryString.append(" INNER JOIN eg_boundary wardboundary on dcbinfo.wardid = wardboundary.id INNER JOIN eg_boundary localboundary on dcbinfo.locality = localboundary.id");
        if (ward != null && !ward.isEmpty()) {
            queryString.append(" and wardboundary.name =:ward");
        }
        if (zone != null && !zone.isEmpty()) {
            queryString.append(" and zoneboundary.name =:zone");
        }
        if (consumerCode != null && !consumerCode.isEmpty()) {
            queryString.append(" and dcbinfo.hscno =:consumerCode");
        }
        if (assessmentNumber != null && !assessmentNumber.isEmpty()) {
            queryString.append(" and dcbinfo.propertyid =:assessmentNumber");
        }
        if (houseNumber != null && !houseNumber.isEmpty()) {
            queryString.append(" and dcbinfo.houseno =:houseNumber");
        }
        if (connectionType != null && !connectionType.isEmpty()) {
            queryString.append(" and dcbinfo.connectiontype =:connectionType");
        }
        if (applicationType != null && !applicationType.isEmpty()) {
            queryString.append(" and dcbinfo.applicationtype =:applicationType");
        }
        if (propertyType != null && !propertyType.isEmpty()) {
            queryString.append(" and dcbinfo.propertytype =:propertyType");
        }
        if (formattedFromDate != null && !formattedFromDate.isEmpty()) {
            queryString.append(" and dcbinfo.workorderdate >=:formattedFromDate");
        }
        if (formattedToDate != null && !formattedToDate.isEmpty()) {
            queryString.append(" and dcbinfo.workorderdate <=:formattedToDate");
        }
        SQLQuery query = ((Session)this.entityManager.unwrap(Session.class)).createSQLQuery(queryString.toString());
        if (StringUtils.isNotBlank((String)ward)) {
            query.setParameter(WARD, (Object)ward);
        }
        if (StringUtils.isNotBlank((String)zone)) {
            query.setParameter(ZONE, (Object)zone);
        }
        if (StringUtils.isNotBlank((String)consumerCode)) {
            query.setParameter(CONSUMERCODE, (Object)consumerCode);
        }
        if (StringUtils.isNotBlank((String)assessmentNumber)) {
            query.setParameter(ASSESSMENT_NUMBER, (Object)assessmentNumber);
        }
        if (StringUtils.isNotBlank((String)houseNumber)) {
            query.setParameter(HOUSENUMBER, (Object)houseNumber);
        }
        if (StringUtils.isNotBlank((String)connectionType)) {
            query.setParameter(CONNECTION_TYPE, (Object)connectionType);
        }
        if (StringUtils.isNotBlank((String)applicationType)) {
            query.setParameter(APPLICATION_TYPE, (Object)applicationType);
        }
        if (StringUtils.isNotBlank((String)propertyType)) {
            query.setParameter(PROPERTY_TYPE, (Object)propertyType);
        }
        if (StringUtils.isNotBlank((String)formattedFromDate)) {
            query.setParameter("formattedFromDate", (Object)formattedFromDate);
        }
        if (StringUtils.isNotBlank((String)formattedToDate)) {
            query.setParameter("formattedToDate", (Object)formattedToDate);
        }
        query.setResultTransformer((ResultTransformer)new AliasToBeanResultTransformer(SearchNoticeDetails.class));
        return query.list();
    }

    public List<Long> getDocuments(String consumerCode, String applicationType) {
        StringBuilder queryStr = new StringBuilder();
        queryStr.append("select filestore.filestoreid from eg_filestoremap filestore,egwtr_documents conndoc,egwtr_application_documents appD,egwtr_connectiondetails conndet,egwtr_connection  conn , egwtr_demand_connection demcon ,eg_demand dem,eg_bill bill, eg_bill_type billtype,egwtr_document_names docName where filestore.id=conndoc.filestoreid and conndet.connection=conn.id and conndet.id=appD.connectiondetailsid and appD.documentnamesid=docName.id and  bill.id_demand =demcon.demand and billtype.id = bill.id_bill_type and bill.service_code='WT' and conndoc.applicationdocumentsid=appD.id   and  demcon.connectiondetails=conndet.id and demcon.demand = dem.id and appD.documentnumber=bill.bill_no and bill.is_cancelled='N' and billtype.code='MANUAL' and dem.is_history ='N' and  docName.documentname='DemandBill'  ");
        queryStr.append(" and conn.consumercode=:consumerCode");
        queryStr.append(" and docName.applicationtype in(select id from egwtr_application_type where name =:applicationType)");
        queryStr.append(" order by appD.id desc ");
        SQLQuery query = ((Session)this.entityManager.unwrap(Session.class)).createSQLQuery(queryStr.toString());
        if (StringUtils.isNotBlank((String)consumerCode)) {
            query.setParameter(CONSUMERCODE, (Object)consumerCode);
        }
        if (StringUtils.isNotBlank((String)applicationType)) {
            query.setParameter(APPLICATION_TYPE, (Object)applicationType);
        }
        List waterChargesDocumentsList = query.list();
        return waterChargesDocumentsList;
    }

    public long getTotalCountofBills(String zone, String ward, String propertyType, String applicationType, String connectionType, String consumerCode, String houseNumber, String assessmentNumber) {
        StringBuilder queryStr = new StringBuilder();
        queryStr.append("select count(distinct dcbinfo.hscno)  from egwtr_mv_bill_view dcbinfo INNER JOIN eg_boundary wardboundary on dcbinfo.wardid = wardboundary.id INNER JOIN eg_boundary localboundary on dcbinfo.locality = localboundary.id INNER JOIN eg_bill bill on dcbinfo.hscno = bill.consumer_id and dcbinfo.demand= bill.id_demand INNER JOIN eg_boundary zoneboundary on dcbinfo.zoneid = zoneboundary.id ");
        queryStr.append(" where dcbinfo.connectionstatus = '" + ConnectionStatus.ACTIVE.toString() + "' ");
        queryStr.append(" and bill.module_id = (select id from eg_module where name ='Water Tax Management')");
        queryStr.append(" and bill.id_bill_type = (select id from eg_bill_type  where code ='MANUAL')");
        queryStr.append(" and bill.is_cancelled ='N' ");
        if (ward != null && !ward.isEmpty()) {
            queryStr.append(" and wardboundary.name =:ward");
        }
        if (zone != null && !zone.isEmpty()) {
            queryStr.append(" and zoneboundary.name =:zone");
        }
        if (consumerCode != null && !consumerCode.isEmpty()) {
            queryStr.append(" and dcbinfo.hscno =:consumerCode");
        }
        if (assessmentNumber != null && !assessmentNumber.isEmpty()) {
            queryStr.append(" and dcbinfo.propertyid =:assessmentNumber");
        }
        if (houseNumber != null && !houseNumber.isEmpty()) {
            queryStr.append(" and dcbinfo.houseno =:houseNumber");
        }
        if (connectionType != null && !connectionType.isEmpty()) {
            queryStr.append(" and dcbinfo.connectiontype =:connectionType");
        }
        if (applicationType != null && !applicationType.isEmpty()) {
            queryStr.append(" and dcbinfo.applicationtype =:applicationType");
        }
        if (propertyType != null && !propertyType.isEmpty()) {
            queryStr.append(" and dcbinfo.propertytype =:propertyType");
        }
        SQLQuery query = ((Session)this.entityManager.unwrap(Session.class)).createSQLQuery(queryStr.toString());
        if (StringUtils.isNotBlank((String)ward)) {
            query.setParameter(WARD, (Object)ward);
        }
        if (StringUtils.isNotBlank((String)zone)) {
            query.setParameter(ZONE, (Object)zone);
        }
        if (StringUtils.isNotBlank((String)consumerCode)) {
            query.setParameter(CONSUMERCODE, (Object)consumerCode);
        }
        if (StringUtils.isNotBlank((String)assessmentNumber)) {
            query.setParameter(ASSESSMENT_NUMBER, (Object)assessmentNumber);
        }
        if (StringUtils.isNotBlank((String)houseNumber)) {
            query.setParameter(HOUSENUMBER, (Object)houseNumber);
        }
        if (StringUtils.isNotBlank((String)connectionType)) {
            query.setParameter(CONNECTION_TYPE, (Object)connectionType);
        }
        if (StringUtils.isNotBlank((String)applicationType)) {
            query.setParameter(APPLICATION_TYPE, (Object)applicationType);
        }
        if (StringUtils.isNotBlank((String)propertyType)) {
            query.setParameter(PROPERTY_TYPE, (Object)propertyType);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("GenerateConnectionBill -- count Result " + queryStr.toString()));
        }
        return ((BigInteger)query.uniqueResult()).longValue();
    }
}

