/*
 * Decompiled with CFR 0.152.
 */
package org.egov.wtms.application.service;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.WordUtils;
import org.egov.eis.entity.Assignment;
import org.egov.eis.service.AssignmentService;
import org.egov.infra.admin.master.entity.User;
import org.egov.infra.admin.master.service.UserService;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infra.filestore.entity.FileStoreMapper;
import org.egov.infra.filestore.service.FileStoreService;
import org.egov.infra.reporting.engine.ReportFormat;
import org.egov.infra.reporting.engine.ReportOutput;
import org.egov.infra.reporting.engine.ReportRequest;
import org.egov.infra.reporting.engine.ReportService;
import org.egov.infra.security.utils.SecurityUtils;
import org.egov.infra.utils.DateUtils;
import org.egov.infra.utils.NumberToWordConverter;
import org.egov.pims.commons.Position;
import org.egov.ptis.domain.model.AssessmentDetails;
import org.egov.ptis.domain.model.OwnerName;
import org.egov.ptis.domain.model.enums.BasicPropertyStatus;
import org.egov.ptis.domain.service.property.PropertyExternalService;
import org.egov.wtms.application.entity.WaterConnectionDetails;
import org.egov.wtms.utils.PropertyExtnUtils;
import org.egov.wtms.utils.WaterTaxUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Service;

@Service
public class ReportGenerationService {
    public static final String ESTIMATION_NOTICE = "estimationNotice";
    @Autowired
    @Qualifier(value="parentMessageSource")
    private MessageSource wcmsMessageSource;
    @Autowired
    private PropertyExtnUtils propertyExtnUtils;
    @Autowired
    private SecurityUtils securityUtils;
    @Autowired
    private ReportService reportService;
    @Autowired
    private WaterTaxUtils waterTaxUtils;
    @Autowired
    private AssignmentService assignmentService;
    @Autowired
    private UserService userService;
    @Autowired
    @Qualifier(value="fileStoreService")
    protected FileStoreService fileStoreService;

    public ReportOutput getReportOutput(WaterConnectionDetails connectionDetails, String workFlowAction, String cityMunicipalityName, String districtName) {
        HashMap<String, Object> reportParams = new HashMap<String, Object>(0);
        ReportRequest reportInput = null;
        ReportOutput reportOutput = null;
        if (null != connectionDetails) {
            List assignmentList;
            Assignment assignment;
            User user;
            Iterator iterator;
            AssessmentDetails assessmentDetails = this.propertyExtnUtils.getAssessmentDetailsForFlag(connectionDetails.getConnection().getPropertyIdentifier(), PropertyExternalService.FLAG_FULL_DETAILS, BasicPropertyStatus.ALL);
            SimpleDateFormat formatter = new SimpleDateFormat("dd/MM/yyyy");
            String propAddress = assessmentDetails.getPropertyAddress();
            String[] doorno = null;
            double total = 0.0;
            if (null != propAddress && !propAddress.isEmpty()) {
                doorno = propAddress.split(",");
            }
            String ownerName = "";
            Set ownerNames = assessmentDetails.getOwnerNames();
            if (null != ownerNames && !ownerNames.isEmpty() && (iterator = assessmentDetails.getOwnerNames().iterator()).hasNext()) {
                OwnerName names = (OwnerName)iterator.next();
                ownerName = names.getOwnerName();
            }
            List assignList = this.assignmentService.findPrimaryAssignmentForDesignationName("Commissioner");
            String commissionerName = "";
            if (!assignList.isEmpty()) {
                commissionerName = ((Assignment)assignList.get(0)).getEmployee().getName();
            }
            if ("NEWCONNECTION".equalsIgnoreCase(connectionDetails.getApplicationType().getCode())) {
                reportParams.put("applicationtype", this.wcmsMessageSource.getMessage("msg.new.watertap.conn", null, null));
            } else if ("ADDNLCONNECTION".equalsIgnoreCase(connectionDetails.getApplicationType().getCode())) {
                reportParams.put("applicationtype", this.wcmsMessageSource.getMessage("msg.add.watertap.conn", null, null));
            } else {
                reportParams.put("applicationtype", this.wcmsMessageSource.getMessage("msg.changeofuse.watertap.conn", null, null));
            }
            reportParams.put("conntitle", WordUtils.capitalize((String)connectionDetails.getApplicationType().getName()));
            reportParams.put("municipality", cityMunicipalityName);
            reportParams.put("district", districtName);
            reportParams.put("purpose", connectionDetails.getUsageType().getName());
            if (null != workFlowAction) {
                if (workFlowAction.equalsIgnoreCase("Generate WorkOrder") || workFlowAction.equalsIgnoreCase("Sign")) {
                    reportParams.put("workOrderDate", formatter.format(connectionDetails.getWorkOrderDate()));
                    reportParams.put("workOrderNo", connectionDetails.getWorkOrderNumber());
                    if (workFlowAction.equalsIgnoreCase("Sign")) {
                        user = this.securityUtils.getCurrentUser();
                        reportParams.put("userId", user.getId());
                    }
                }
                if (workFlowAction.equalsIgnoreCase("Preview")) {
                    reportParams.put("workOrderDate", "");
                    reportParams.put("workOrderNo", "");
                }
            }
            if ((assignment = this.assignmentService.getPrimaryAssignmentForUser((user = this.securityUtils.getCurrentUser()).getId())) == null && !(assignmentList = this.assignmentService.findByEmployeeAndGivenDate(user.getId(), new Date())).isEmpty()) {
                assignment = (Assignment)assignmentList.get(0);
            }
            String userDesignation = null;
            userDesignation = assignment != null && assignment.getDesignation().getName().equals("Commissioner") ? assignment.getDesignation().getName() : null;
            reportParams.put("workFlowAction", workFlowAction);
            reportParams.put("consumerNumber", connectionDetails.getConnection().getConsumerCode());
            reportParams.put("applicantName", WordUtils.capitalize((String)ownerName));
            reportParams.put("address", propAddress);
            reportParams.put("doorno", doorno != null ? doorno[0] : "");
            reportParams.put("userSignature", this.securityUtils.getCurrentUser().getSignature() != null ? new ByteArrayInputStream(this.securityUtils.getCurrentUser().getSignature()) : null);
            reportParams.put("applicationDate", formatter.format(connectionDetails.getApplicationDate()));
            reportParams.put("donationCharges", connectionDetails.getDonationCharges());
            reportParams.put("securityDeposit", connectionDetails.getFieldInspectionDetails().getSecurityDeposit());
            reportParams.put("roadCuttingCharges", connectionDetails.getFieldInspectionDetails().getRoadCuttingCharges());
            reportParams.put("superVisionCharges", connectionDetails.getFieldInspectionDetails().getSupervisionCharges());
            reportParams.put("locality", assessmentDetails.getBoundaryDetails().getLocalityName());
            total = connectionDetails.getDonationCharges() + connectionDetails.getFieldInspectionDetails().getSecurityDeposit() + connectionDetails.getFieldInspectionDetails().getRoadCuttingCharges() + connectionDetails.getFieldInspectionDetails().getSupervisionCharges();
            reportParams.put("total", total);
            reportParams.put("commissionerName", commissionerName);
            reportParams.put("designation", userDesignation);
            reportInput = new ReportRequest("connectionWorkOrder", (Object)connectionDetails, reportParams);
        }
        reportOutput = this.reportService.createReport(reportInput);
        return reportOutput;
    }

    public ReportOutput generateReconnectionReport(WaterConnectionDetails waterConnectionDetails, String workFlowAction, String cityMunicipalityName, String districtName) {
        HashMap<String, Object> reportParams = new HashMap<String, Object>();
        ReportRequest reportInput = null;
        ReportOutput reportOutput = null;
        if (waterConnectionDetails != null) {
            if (waterConnectionDetails.getReconnectionFileStore() != null) {
                FileStoreMapper fmp = waterConnectionDetails.getReconnectionFileStore();
                File file = this.fileStoreService.fetch(fmp, "WTMS");
                reportOutput = new ReportOutput();
                try {
                    reportOutput.setReportOutputData(FileUtils.readFileToByteArray((File)file));
                    reportOutput.setReportFormat(ReportFormat.PDF);
                }
                catch (IOException e) {
                    throw new ApplicationRuntimeException("Exception in generating work order notice" + e);
                }
            } else {
                SimpleDateFormat formatter = new SimpleDateFormat("dd/MM/yyyy");
                Assignment assignment = null;
                User user = null;
                AssessmentDetails assessmentDetails = this.propertyExtnUtils.getAssessmentDetailsForFlag(waterConnectionDetails.getConnection().getPropertyIdentifier(), PropertyExternalService.FLAG_FULL_DETAILS, BasicPropertyStatus.ALL);
                String[] doorNo = assessmentDetails.getPropertyAddress().split(",");
                String ownerName = "";
                Iterator iterator = assessmentDetails.getOwnerNames().iterator();
                if (iterator.hasNext()) {
                    OwnerName names = (OwnerName)iterator.next();
                    ownerName = names.getOwnerName();
                }
                List<Object> asignList = new ArrayList<Assignment>();
                Position approverPos = this.waterTaxUtils.getCityLevelCommissionerPosition("Commissioner", waterConnectionDetails.getConnection().getPropertyIdentifier());
                if (approverPos != null) {
                    assignment = this.assignmentService.getPrimaryAssignmentForPositionAndDate(approverPos.getId(), new Date());
                    if (assignment != null && assignment.getEmployee() != null) {
                        asignList = new ArrayList();
                        asignList.add(assignment);
                    } else if (assignment == null) {
                        asignList = this.assignmentService.getAssignmentsForPosition(approverPos.getId(), new Date());
                    }
                    if (!asignList.isEmpty()) {
                        user = this.userService.getUserById(((Assignment)asignList.get(0)).getEmployee().getId());
                    }
                }
                reportParams.put("applicationType", WordUtils.capitalize((String)"Re-Connection"));
                reportParams.put("cityName", cityMunicipalityName);
                reportParams.put("district", districtName);
                reportParams.put("applicationDate", formatter.format(waterConnectionDetails.getApplicationDate()));
                reportParams.put("reconnApprovalDate", formatter.format(waterConnectionDetails.getReconnectionApprovalDate() != null ? waterConnectionDetails.getReconnectionApprovalDate() : new Date()));
                reportParams.put("applicantName", ownerName);
                reportParams.put("consumerCode", waterConnectionDetails.getConnection().getConsumerCode());
                reportParams.put("commissionerName", user != null && user.getUsername() != null ? user.getName() : ownerName);
                reportParams.put("address", assessmentDetails.getPropertyAddress());
                reportParams.put("houseNo", doorNo[0]);
                reportParams.put("usersignature", this.securityUtils.getCurrentUser().getSignature() != null ? new ByteArrayInputStream(this.securityUtils.getCurrentUser().getSignature()) : null);
                user = this.securityUtils.getCurrentUser();
                reportParams.put("userId", user.getId());
                reportParams.put("workFlowAction", workFlowAction);
                reportInput = new ReportRequest("ReconnacknowlgementNotice", (Object)waterConnectionDetails, reportParams);
                reportOutput = this.reportService.createReport(reportInput);
            }
        }
        return reportOutput;
    }

    public ReportOutput generateClosureConnectionReport(WaterConnectionDetails waterConnectionDetails, String workFlowAction, String cityMunicipalityName, String districtName) {
        HashMap<String, Object> reportParams = new HashMap<String, Object>();
        ReportRequest reportInput = null;
        ReportOutput reportOutput = null;
        if (waterConnectionDetails != null) {
            if (waterConnectionDetails.getClosureFileStore() != null) {
                FileStoreMapper fmp = waterConnectionDetails.getClosureFileStore();
                File file = this.fileStoreService.fetch(fmp, "WTMS");
                reportOutput = new ReportOutput();
                try {
                    reportOutput.setReportOutputData(FileUtils.readFileToByteArray((File)file));
                    reportOutput.setReportFormat(ReportFormat.PDF);
                }
                catch (IOException e) {
                    throw new ApplicationRuntimeException("Exception in generating work order notice" + e);
                }
            } else {
                SimpleDateFormat formatter = new SimpleDateFormat("dd/MM/yyyy");
                AssessmentDetails assessmentDetails = this.propertyExtnUtils.getAssessmentDetailsForFlag(waterConnectionDetails.getConnection().getPropertyIdentifier(), PropertyExternalService.FLAG_FULL_DETAILS, BasicPropertyStatus.ALL);
                String[] doorNo = assessmentDetails.getPropertyAddress().split(",");
                StringBuilder ownerName = new StringBuilder();
                for (OwnerName names : assessmentDetails.getOwnerNames()) {
                    if (assessmentDetails.getOwnerNames().size() > 1) {
                        ownerName.append(", ");
                    }
                    ownerName.append(names.getOwnerName());
                }
                reportParams.put("applicationType", WordUtils.capitalize((String)"Closure Of Connection"));
                reportParams.put("cityName", cityMunicipalityName);
                reportParams.put("district", districtName);
                reportParams.put("applicationDate", formatter.format(waterConnectionDetails.getApplicationDate()));
                reportParams.put("applicantName", ownerName);
                reportParams.put("consumerCode", waterConnectionDetails.getConnection().getConsumerCode());
                reportParams.put("address", assessmentDetails.getPropertyAddress());
                reportParams.put("houseNo", doorNo[0]);
                reportParams.put("usersignature", this.securityUtils.getCurrentUser().getSignature() != null ? new ByteArrayInputStream(this.securityUtils.getCurrentUser().getSignature()) : null);
                reportParams.put("closeApprovalDate", formatter.format(waterConnectionDetails.getCloseApprovalDate() != null ? waterConnectionDetails.getCloseApprovalDate() : new Date()));
                reportParams.put("closeConnectionType", waterConnectionDetails.getCloseConnectionType().equals("T") ? "Temporary" : "Permanent");
                User user = this.securityUtils.getCurrentUser();
                reportParams.put("userId", user.getId());
                reportParams.put("workFlowAction", workFlowAction);
                reportInput = new ReportRequest("CloserConnectionAcknowldgemt", waterConnectionDetails.getEstimationDetails(), reportParams);
                reportOutput = this.reportService.createReport(reportInput);
            }
        }
        return reportOutput;
    }

    public ReportOutput generateEstimationNoticeReport(WaterConnectionDetails waterConnectionDetails, String cityMunicipalityName, String districtName) {
        ReportRequest reportInput = null;
        if (waterConnectionDetails != null) {
            HashMap<String, Object> reportParams = new HashMap<String, Object>();
            AssessmentDetails assessmentDetails = this.propertyExtnUtils.getAssessmentDetailsForFlag(waterConnectionDetails.getConnection().getPropertyIdentifier(), PropertyExternalService.FLAG_FULL_DETAILS, BasicPropertyStatus.ACTIVE);
            String[] doorNo = assessmentDetails.getPropertyAddress().split(",");
            StringBuilder ownerName = new StringBuilder();
            for (OwnerName names : assessmentDetails.getOwnerNames()) {
                if (assessmentDetails.getOwnerNames().size() > 1) {
                    ownerName.append(", ");
                }
                ownerName.append(names.getOwnerName());
            }
            reportParams.put("applicationType", WordUtils.capitalize((String)waterConnectionDetails.getApplicationType().getName()));
            reportParams.put("cityName", cityMunicipalityName);
            reportParams.put("district", districtName);
            reportParams.put("estimationDate", DateUtils.toDefaultDateFormat((Date)waterConnectionDetails.getFieldInspectionDetails().getCreatedDate()));
            reportParams.put("estimationNumber", waterConnectionDetails.getEstimationNumber());
            reportParams.put("donationCharges", waterConnectionDetails.getDonationCharges());
            double totalCharges = waterConnectionDetails.getDonationCharges() + waterConnectionDetails.getFieldInspectionDetails().getSupervisionCharges() + waterConnectionDetails.getFieldInspectionDetails().getRoadCuttingCharges() + waterConnectionDetails.getFieldInspectionDetails().getSecurityDeposit();
            reportParams.put("totalCharges", totalCharges);
            reportParams.put("applicationDate", DateUtils.toDefaultDateFormat((Date)waterConnectionDetails.getApplicationDate()));
            reportParams.put("applicantName", ownerName.toString());
            reportParams.put("address", assessmentDetails.getPropertyAddress());
            reportParams.put("houseNo", doorNo[0]);
            reportParams.put("propertyID", waterConnectionDetails.getConnection().getPropertyIdentifier());
            reportParams.put("amountInWords", this.getTotalAmntInWords(totalCharges));
            reportParams.put("securityDeposit", waterConnectionDetails.getFieldInspectionDetails().getSecurityDeposit());
            reportParams.put("roadCuttingCharges", waterConnectionDetails.getFieldInspectionDetails().getRoadCuttingCharges());
            reportParams.put("superVisionCharges", waterConnectionDetails.getFieldInspectionDetails().getSupervisionCharges());
            reportInput = new ReportRequest(ESTIMATION_NOTICE, (Object)waterConnectionDetails, reportParams);
        }
        ReportOutput reportOutput = this.reportService.createReport(reportInput);
        return reportOutput;
    }

    public String getTotalAmntInWords(Double totalCharges) {
        return NumberToWordConverter.amountInWordsWithCircumfix((BigDecimal)BigDecimal.valueOf(totalCharges));
    }
}

