/*
 * Decompiled with CFR 0.152.
 */
package org.egov.wtms.application.service;

import java.util.HashMap;
import org.egov.commons.entity.Source;
import org.egov.infra.security.utils.SecurityUtils;
import org.egov.wtms.application.entity.WaterConnectionDetails;
import org.egov.wtms.application.repository.WaterConnectionDetailsRepository;
import org.egov.wtms.application.service.WaterConnectionDetailsService;
import org.egov.wtms.application.workflow.ApplicationWorkflowCustomDefaultImpl;
import org.egov.wtms.utils.WaterTaxUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class ReconnectionService {
    @Autowired
    private WaterConnectionDetailsRepository waterConnectionDetailsRepository;
    @Autowired
    private WaterConnectionDetailsService waterConnectionDetailsService;
    @Autowired
    private WaterTaxUtils waterTaxUtils;
    @Autowired
    private SecurityUtils securityUtils;
    public static final String CHANGEOFUSEALLOWEDIFWTDUE = "CHANGEOFUSEALLOWEDIFWTDUE";

    @Transactional
    public WaterConnectionDetails updateReConnection(WaterConnectionDetails waterConnectionDetails, Long approvalPosition, String approvalComent, String additionalRule, String workFlowAction, String sourceChannel) {
        this.waterConnectionDetailsService.applicationStatusChange(waterConnectionDetails, workFlowAction, "");
        WaterConnectionDetails savedwaterConnectionDetails = (WaterConnectionDetails)((Object)this.waterConnectionDetailsRepository.save((Object)waterConnectionDetails));
        ApplicationWorkflowCustomDefaultImpl applicationWorkflowCustomDefaultImpl = this.waterConnectionDetailsService.getInitialisedWorkFlowBean();
        additionalRule = "RECONNECTION";
        applicationWorkflowCustomDefaultImpl.createCommonWorkflowTransition(savedwaterConnectionDetails, approvalPosition, approvalComent, additionalRule, workFlowAction);
        if (waterConnectionDetails.getSource() != null && Source.CITIZENPORTAL.toString().equalsIgnoreCase(waterConnectionDetails.getSource().toString()) && this.waterConnectionDetailsService.getPortalInbox(waterConnectionDetails.getApplicationNumber()) != null) {
            this.waterConnectionDetailsService.updatePortalMessage(waterConnectionDetails);
        } else if (this.waterTaxUtils.isCitizenPortalUser(this.securityUtils.getCurrentUser()).booleanValue()) {
            this.waterConnectionDetailsService.pushPortalMessage(savedwaterConnectionDetails);
        }
        this.waterConnectionDetailsService.updateIndexes(savedwaterConnectionDetails, sourceChannel);
        return savedwaterConnectionDetails;
    }

    public WaterConnectionDetails updateReConnection(WaterConnectionDetails closeConnection, Long approvalPosition, String approvalComent, String additionalRule, String workFlowAction, HashMap<String, String> meesevaParams, String sourceChannel) {
        return this.updateReConnection(closeConnection, approvalPosition, approvalComent, additionalRule, workFlowAction, sourceChannel);
    }
}

