/*
 * Decompiled with CFR 0.152.
 */
package org.egov.wtms.application.service;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.egov.eis.service.AssignmentService;
import org.egov.eis.service.PositionMasterService;
import org.egov.infra.admin.master.service.AppConfigValueService;
import org.egov.infra.config.core.ApplicationThreadLocals;
import org.egov.infra.workflow.entity.OwnerGroup;
import org.egov.pims.commons.Position;
import org.egov.wtms.application.entity.WaterConnectionDetails;
import org.egov.wtms.application.service.WaterConnectionDetailsService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ReassignmentService {
    private static final String REASSIGNMENT = "REASSIGNMENT";
    @Autowired
    private AppConfigValueService appConfigValuesService;
    @Autowired
    private PositionMasterService positionMasterService;
    @Autowired
    private AssignmentService assignmentService;
    @Autowired
    private WaterConnectionDetailsService waterConnectionDetailsService;

    public Map<String, String> employeePositionMap() {
        List assignmentsList = this.assignmentService.findByDepartmentCodeAndDesignationCode("ENG", Arrays.asList("JASST", "SASST"));
        Long positionId = this.positionMasterService.getCurrentPositionForUser(ApplicationThreadLocals.getUserId()).getId();
        assignmentsList.removeIf(assignment -> assignment.getPosition().getId().equals(positionId));
        return assignmentsList.stream().collect(Collectors.toMap(assignment -> assignment.getPosition().getId().toString(), assignment -> new StringBuffer().append(assignment.getEmployee().getName()).append('-').append(assignment.getPosition().getName()).toString()));
    }

    @Transactional
    public Boolean updateReassignedWaterChargeApplication(Long approverPositionId, Long connectionDetailId) {
        WaterConnectionDetails waterConnectionDetails = this.waterConnectionDetailsService.findBy(connectionDetailId);
        Position position = this.positionMasterService.getPositionById(approverPositionId);
        if (waterConnectionDetails != null) {
            waterConnectionDetails.changeProcessOwner((OwnerGroup)position);
            waterConnectionDetails.changeProcessInitiator((OwnerGroup)position);
            this.waterConnectionDetailsService.save(waterConnectionDetails);
            this.waterConnectionDetailsService.updateIndexes(waterConnectionDetails, waterConnectionDetails.getSource() != null ? waterConnectionDetails.getSource().toString() : null);
        }
        return true;
    }
}

