/*
 * Decompiled with CFR 0.152.
 */
package org.egov.wtms.application.service;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.egov.ptis.domain.model.AssessmentDetails;
import org.egov.ptis.domain.model.enums.BasicPropertyStatus;
import org.egov.ptis.domain.service.property.PropertyExternalService;
import org.egov.wtms.application.entity.ApplicationDocuments;
import org.egov.wtms.application.entity.WaterConnection;
import org.egov.wtms.application.entity.WaterConnectionDetails;
import org.egov.wtms.application.service.ConnectionDetailService;
import org.egov.wtms.application.service.WaterConnectionDetailsService;
import org.egov.wtms.application.service.WaterConnectionService;
import org.egov.wtms.masters.entity.ConnectionCategory;
import org.egov.wtms.masters.entity.enums.ConnectionStatus;
import org.egov.wtms.masters.entity.enums.ConnectionType;
import org.egov.wtms.masters.service.ConnectionCategoryService;
import org.egov.wtms.utils.PropertyExtnUtils;
import org.egov.wtms.utils.WaterTaxUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.validation.BindingResult;

@Service
@Transactional(readOnly=true)
public class NewConnectionService {
    private static final String ERROR_REQUIRED = "err.required";
    private static final String CONNECTION_PROPERTYID = "connection.propertyIdentifier";
    @Autowired
    private WaterConnectionDetailsService waterConnectionDetailsService;
    @Autowired
    @Qualifier(value="parentMessageSource")
    private MessageSource wcmsMessageSource;
    @Autowired
    private WaterTaxUtils waterTaxUtils;
    @Autowired
    private PropertyExtnUtils propertyExtnUtils;
    @Autowired
    private ConnectionDetailService connectionDetailService;
    @Autowired
    private ConnectionCategoryService connectionCategoryService;
    @Autowired
    private WaterConnectionService waterConnectionService;
    @Autowired
    private WaterConnectionDetailsService waterConnectionDtlsService;

    public String checkConnectionPresentForProperty(String propertyID) {
        WaterConnectionDetails waterConnectionDetails;
        String validationMessage = "";
        if (!this.waterTaxUtils.isMultipleNewConnectionAllowedForPID().booleanValue() && (waterConnectionDetails = this.waterConnectionDetailsService.getPrimaryConnectionDetailsByPropertyIdentifier(propertyID)) != null) {
            if (waterConnectionDetails.getConnectionStatus().equals((Object)ConnectionStatus.ACTIVE)) {
                validationMessage = this.wcmsMessageSource.getMessage("err.validate.newconnection.active", (Object[])new String[]{waterConnectionDetails.getConnection().getConsumerCode(), propertyID}, null);
            } else if (waterConnectionDetails.getConnectionStatus().equals((Object)ConnectionStatus.INPROGRESS)) {
                validationMessage = this.wcmsMessageSource.getMessage("err.validate.newconnection.application.inprocess", (Object[])new String[]{propertyID, waterConnectionDetails.getApplicationNumber()}, null);
            } else if (waterConnectionDetails.getConnectionStatus().equals((Object)ConnectionStatus.DISCONNECTED)) {
                validationMessage = this.wcmsMessageSource.getMessage("err.validate.newconnection.disconnected", (Object[])new String[]{waterConnectionDetails.getConnection().getConsumerCode(), propertyID}, null);
            } else if (waterConnectionDetails.getConnectionStatus().equals((Object)ConnectionStatus.CLOSED)) {
                validationMessage = this.wcmsMessageSource.getMessage("err.validate.newconnection.closed", (Object[])new String[]{waterConnectionDetails.getConnection().getConsumerCode(), propertyID}, null);
            } else if (waterConnectionDetails.getConnectionStatus().equals((Object)ConnectionStatus.HOLDING)) {
                validationMessage = this.wcmsMessageSource.getMessage("err.validate.newconnection.holding", (Object[])new String[]{waterConnectionDetails.getConnection().getConsumerCode(), propertyID}, null);
            }
        }
        return validationMessage;
    }

    public String checkValidPropertyAssessmentNumber(String asessmentNumber) {
        String errorMessage = "";
        AssessmentDetails assessmentDetails = this.propertyExtnUtils.getAssessmentDetailsForFlag(asessmentNumber, PropertyExternalService.FLAG_FULL_DETAILS, BasicPropertyStatus.ACTIVE);
        errorMessage = this.validateProperty(assessmentDetails);
        if (errorMessage.isEmpty()) {
            errorMessage = this.validatePTDue(asessmentNumber, assessmentDetails);
        }
        return errorMessage;
    }

    public String checkValidPropertyForDataEntry(String asessmentNumber) {
        String errorMessage = "";
        AssessmentDetails assessmentDetails = this.propertyExtnUtils.getAssessmentDetailsForFlag(asessmentNumber, PropertyExternalService.FLAG_FULL_DETAILS, BasicPropertyStatus.ACTIVE);
        errorMessage = this.validateProperty(assessmentDetails);
        return errorMessage;
    }

    private String validateProperty(AssessmentDetails assessmentDetails) {
        String errorMessage = "";
        if (assessmentDetails.getErrorDetails() != null && assessmentDetails.getErrorDetails().getErrorCode() != null) {
            errorMessage = assessmentDetails.getErrorDetails().getErrorMessage();
        }
        return errorMessage;
    }

    private String validatePTDue(String asessmentNumber, AssessmentDetails assessmentDetails) {
        String errorMessage = "";
        if (assessmentDetails.getPropertyDetails() != null && assessmentDetails.getPropertyDetails().getTaxDue() != null && assessmentDetails.getPropertyDetails().getTaxDue().doubleValue() > 0.0 && !this.waterTaxUtils.isNewConnectionAllowedIfPTDuePresent().booleanValue()) {
            errorMessage = this.wcmsMessageSource.getMessage("err.validate.property.taxdue", (Object[])new String[]{assessmentDetails.getPropertyDetails().getTaxDue().toString(), asessmentNumber, "new"}, null);
        }
        return errorMessage;
    }

    public void validateDocuments(List<ApplicationDocuments> applicationDocs, ApplicationDocuments applicationDocument, int i, BindingResult resultBinder, Long categoryId, String documentRequired) {
        ConnectionCategory connectionCategory = this.connectionCategoryService.findOne(categoryId);
        if (connectionCategory != null && documentRequired != null && connectionCategory.getCode().equalsIgnoreCase("BPL") && documentRequired.equalsIgnoreCase(applicationDocument.getDocumentNames().getDocumentName())) {
            this.validateDocumentsForBPLCategory(applicationDocs, applicationDocument, resultBinder, i);
        } else {
            this.validateDocumentsRequired(applicationDocument, resultBinder, i);
            if (this.connectionDetailService.validApplicationDocument(applicationDocument)) {
                applicationDocs.add(applicationDocument);
            }
        }
    }

    public void validateDocumentsRequired(ApplicationDocuments applicationDocument, BindingResult resultBinder, int i) {
        String fieldError;
        if (applicationDocument.getDocumentNumber() == null && applicationDocument.getDocumentDate() != null) {
            fieldError = "applicationDocs[" + i + "].documentNumber";
            resultBinder.rejectValue(fieldError, "documentNumber.required");
        }
        if (applicationDocument.getDocumentNumber() != null && applicationDocument.getDocumentDate() == null) {
            fieldError = "applicationDocs[" + i + "].documentDate";
            resultBinder.rejectValue(fieldError, "documentDate.required");
        }
        if (applicationDocument.getDocumentNumber() != null && applicationDocument.getDocumentDate() != null) {
            Iterator stream = null;
            if (ArrayUtils.isNotEmpty((Object[])applicationDocument.getFiles())) {
                stream = Arrays.asList(applicationDocument.getFiles()).stream().filter(file -> !file.isEmpty()).iterator();
            }
            if (stream == null) {
                String fieldError2 = "applicationDocs[" + i + "].files";
                resultBinder.rejectValue(fieldError2, "files.required");
            }
        }
    }

    public void validateDocumentsForBPLCategory(List<ApplicationDocuments> applicationDocs, ApplicationDocuments applicationDocument, BindingResult resultBinder, int i) {
        String fieldError;
        if (applicationDocument.getDocumentNumber() == null) {
            fieldError = "applicationDocs[" + i + "].documentNumber";
            resultBinder.rejectValue(fieldError, "documentNumber.required");
        }
        if (applicationDocument.getDocumentDate() == null) {
            fieldError = "applicationDocs[" + i + "].documentDate";
            resultBinder.rejectValue(fieldError, "documentDate.required");
        }
        if (ArrayUtils.isNotEmpty((Object[])applicationDocument.getFiles())) {
            Iterator stream = Arrays.asList(applicationDocument.getFiles()).stream().filter(file -> !file.isEmpty()).iterator();
            if (stream != null && this.connectionDetailService.validApplicationDocument(applicationDocument)) {
                applicationDocs.add(applicationDocument);
            }
        } else {
            String fieldError2 = "applicationDocs[" + i + "].files";
            resultBinder.rejectValue(fieldError2, "files.required");
        }
    }

    public void validateExisting(WaterConnectionDetails waterConnectionDetails, BindingResult errors) {
        if (waterConnectionDetails.getConnection() != null) {
            WaterConnection validateWaterConnDet = null;
            if (waterConnectionDetails.getConnection().getOldConsumerNumber() != null) {
                validateWaterConnDet = this.waterConnectionService.findByConsumerCode(waterConnectionDetails.getConnection().getOldConsumerNumber());
            }
            if (validateWaterConnDet != null && !waterConnectionDetails.getConnection().getId().equals(validateWaterConnDet.getId())) {
                errors.rejectValue("connection.consumerCode", "err.exist.consumerCode");
            }
        }
        if (waterConnectionDetails.getConnectionType() != null && waterConnectionDetails.getConnectionType() == ConnectionType.METERED) {
            this.validateMeterConnectionDetails(waterConnectionDetails, errors);
        }
    }

    public void validateMeterConnectionDetails(WaterConnectionDetails waterConnectionDetails, BindingResult errors) {
        WaterConnectionDetails validateExistWaterConnectionDet;
        if (waterConnectionDetails.getConnection().getConsumerCode() != null && (validateExistWaterConnectionDet = this.waterConnectionDtlsService.findByApplicationNumberOrConsumerCode(waterConnectionDetails.getConnection().getConsumerCode())) != null && !validateExistWaterConnectionDet.getId().equals(waterConnectionDetails.getId())) {
            errors.rejectValue("connection.consumerCode", "err.exist.consumerCode");
        }
        if (waterConnectionDetails.getExecutionDate() == null) {
            errors.rejectValue("executionDate", ERROR_REQUIRED);
        }
        if (waterConnectionDetails.getExistingConnection().getMeterNo() == null) {
            errors.rejectValue("existingConnection.meterNo", ERROR_REQUIRED);
        }
        if (waterConnectionDetails.getExistingConnection().getPreviousReading() == null) {
            errors.rejectValue("existingConnection.previousReading", ERROR_REQUIRED);
        }
        if (waterConnectionDetails.getExistingConnection().getReadingDate() == null) {
            errors.rejectValue("existingConnection.readingDate", ERROR_REQUIRED);
        }
        if (waterConnectionDetails.getExistingConnection().getCurrentReading() == null) {
            errors.rejectValue("existingConnection.currentReading", ERROR_REQUIRED);
        }
    }

    public void validatePropertyIDForDataEntry(WaterConnectionDetails waterConnectionDetails, BindingResult errors) {
        if (waterConnectionDetails.getConnection() != null && waterConnectionDetails.getConnection().getPropertyIdentifier() != null && !"".equals(waterConnectionDetails.getConnection().getPropertyIdentifier())) {
            String errorMessage = this.checkValidPropertyForDataEntry(waterConnectionDetails.getConnection().getPropertyIdentifier());
            if (errorMessage != null && !"".equals(errorMessage)) {
                errors.rejectValue(CONNECTION_PROPERTYID, errorMessage, errorMessage);
            } else if (waterConnectionDetails.getId() == null && waterConnectionDetails.getApplicationType().getCode().equalsIgnoreCase("NEWCONNECTION")) {
                errorMessage = this.checkConnectionPresentForProperty(waterConnectionDetails.getConnection().getPropertyIdentifier());
            }
            if (errorMessage != null && !"".equals(errorMessage)) {
                errors.rejectValue(CONNECTION_PROPERTYID, errorMessage, errorMessage);
            }
        }
    }

    public void validatePropertyID(WaterConnectionDetails waterConnectionDetails, BindingResult errors) {
        if (waterConnectionDetails.getConnection() != null && waterConnectionDetails.getConnection().getPropertyIdentifier() != null && !"".equals(waterConnectionDetails.getConnection().getPropertyIdentifier())) {
            String errorMessage = this.checkValidPropertyAssessmentNumber(waterConnectionDetails.getConnection().getPropertyIdentifier());
            if (errorMessage != null && !"".equals(errorMessage)) {
                errors.rejectValue(CONNECTION_PROPERTYID, errorMessage, errorMessage);
            } else {
                errorMessage = this.checkConnectionPresentForProperty(waterConnectionDetails.getConnection().getPropertyIdentifier());
                if (errorMessage != null && !"".equals(errorMessage)) {
                    errors.rejectValue(CONNECTION_PROPERTYID, errorMessage, errorMessage);
                }
            }
        }
    }
}

