/*
 * Decompiled with CFR 0.152.
 */
package org.egov.wtms.application.service;

import java.math.BigDecimal;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.egov.dcb.bean.DCBDisplayInfo;
import org.egov.infra.config.persistence.datasource.routing.annotation.ReadOnly;
import org.egov.infra.utils.DateUtils;
import org.egov.wtms.application.entity.DonationChargesDCBReportSearch;
import org.egov.wtms.application.entity.WaterChargesReceiptInfo;
import org.egov.wtms.reports.entity.DCBReportResult;
import org.hibernate.SQLQuery;
import org.hibernate.Session;
import org.hibernate.transform.AliasToBeanResultTransformer;
import org.hibernate.transform.ResultTransformer;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class CurrentDcbService {
    public static final String ZONEWISE = "zone";
    public static final String WARDWISE = "ward";
    public static final String BLOCKWISE = "block";
    public static final String LOCALITYWISE = "locality";
    public static final String PROPERTY = "property";
    @PersistenceContext
    private EntityManager entityManager;

    public Session getCurrentSession() {
        return (Session)this.entityManager.unwrap(Session.class);
    }

    public DCBDisplayInfo getDcbDispInfo() {
        DCBDisplayInfo dcbDispInfo = new DCBDisplayInfo();
        ArrayList<String> reasonMasterCodes = new ArrayList<String>(0);
        ArrayList reasonCategoryCodes = new ArrayList(0);
        reasonMasterCodes.add("WTAXCHARGES");
        dcbDispInfo.setReasonCategoryCodes(reasonCategoryCodes);
        dcbDispInfo.setReasonMasterCodes(reasonMasterCodes);
        return dcbDispInfo;
    }

    public List<WaterChargesReceiptInfo> getMigratedReceipttDetails(String consumerNumber) throws ParseException {
        StringBuilder queryStr = new StringBuilder();
        queryStr.append("select distinct(i_bookno) as \"bookNumber\", cast(i_ctrrcptno as varchar) as \"receiptNumber\",dt_ctrrcptdt as \"receiptDate\",dt_paidfrmprddt as \"fromDate\",dt_paidtoprddt as \"toDate\",d_crr+d_arr as \"receiptAmount\" from wt_wtchrgrcpt_tbl where i_csmrno =" + consumerNumber + " order by dt_ctrrcptdt desc");
        SQLQuery finalQuery = this.getCurrentSession().createSQLQuery(queryStr.toString());
        finalQuery.setResultTransformer((ResultTransformer)new AliasToBeanResultTransformer(WaterChargesReceiptInfo.class));
        return finalQuery.list();
    }

    public SQLQuery getMigratedReceiptDetails(Long connectiondetails) throws ParseException {
        StringBuilder queryStr = new StringBuilder();
        queryStr.append("select distinct(booknumber) as \"bookNumber\", receiptnumber as \"receiptNumber\",receiptdate as \"receiptDate\",fromdate as \"fromDate\",todate as \"toDate\",cast(amount as numeric(18,2)) as \"receiptAmount\" from egwtr_legacy_receipts where connectiondetails =" + connectiondetails);
        SQLQuery finalQuery = this.getCurrentSession().createSQLQuery(queryStr.toString());
        finalQuery.setResultTransformer((ResultTransformer)new AliasToBeanResultTransformer(WaterChargesReceiptInfo.class));
        return finalQuery;
    }

    @ReadOnly
    public List<DCBReportResult> getReportResult(String paramList, String connectionType, String mode, String reportType) {
        StringBuilder selectQry1 = new StringBuilder();
        StringBuilder selectQry2 = new StringBuilder();
        StringBuilder whereQry = new StringBuilder();
        StringBuilder groupByQry = new StringBuilder();
        selectQry2.append("  cast(SUM(arr_demand) as bigint) AS arr_demand,cast(SUM(curr_demand) as bigint) AS curr_demand,cast(SUM(arr_coll) as bigint) AS arr_coll,cast(SUM(curr_coll) as bigint) AS curr_coll,cast(SUM(arr_balance) as bigint) AS arr_balance,cast(SUM(curr_balance) as bigint) AS curr_balance ");
        StringBuilder fromQry = new StringBuilder(" from egwtr_mv_dcb_view dcbinfo,eg_boundary boundary ");
        if (ZONEWISE.equalsIgnoreCase(mode)) {
            selectQry1.append("select  distinct cast(dcbinfo.zoneid as integer) as \"zoneid\",boundary.name as \"boundaryName\", count(hscno) as countofconsumerno,");
            groupByQry.append(" group by dcbinfo.zoneid,boundary.name order by boundary.name");
            whereQry.append(" where dcbinfo.zoneid=boundary.id ");
            if (paramList != null && !"".equalsIgnoreCase(paramList)) {
                whereQry = whereQry.append(" and dcbinfo.zoneid in (" + paramList + ")");
            }
        } else if (WARDWISE.equalsIgnoreCase(mode)) {
            selectQry1.append("select distinct cast(dcbinfo.wardid as integer) as \"wardid\",boundary.name as \"boundaryName\",count(hscno) as countofconsumerno, ");
            groupByQry.append(" group by dcbinfo.wardid,boundary.name order by boundary.name");
            whereQry.append(" where dcbinfo.wardid=boundary.id ");
            if (paramList != null && !paramList.equalsIgnoreCase("") && reportType.equalsIgnoreCase("wardWise")) {
                whereQry = whereQry.append(" and dcbinfo.wardid in (" + paramList + ")");
            }
            if (paramList != null && !paramList.equalsIgnoreCase("") && !reportType.equalsIgnoreCase("wardWise")) {
                whereQry = whereQry.append(" and dcbinfo.zoneid in (" + paramList + ")");
            }
        } else if (BLOCKWISE.equalsIgnoreCase(mode)) {
            selectQry1.append("select  distinct cast(dcbinfo.block as integer) as \"wardid\",boundary.name as \"boundaryName\", count(hscno) as countofconsumerno,");
            groupByQry.append(" group by dcbinfo.block,boundary.name order by boundary.name");
            whereQry.append(" where dcbinfo.block=boundary.id ");
            if (paramList != null && !paramList.equalsIgnoreCase("") && reportType.equalsIgnoreCase("blockWise")) {
                whereQry = whereQry.append(" and dcbinfo.block in (" + paramList + ")");
            }
            if (paramList != null && !paramList.equalsIgnoreCase("") && !reportType.equalsIgnoreCase("blockWise")) {
                whereQry = whereQry.append(" and dcbinfo.wardid in (" + paramList + ")");
            }
        } else if (LOCALITYWISE.equalsIgnoreCase(mode)) {
            selectQry1.append("select  distinct cast(dcbinfo.locality as integer) as \"locality\",boundary.name as \"boundaryName\",dcbinfo.username as \"username\", count(hscno) as countofconsumerno, ");
            groupByQry.append(" group by dcbinfo.locality,boundary.name,dcbinfo.username order by boundary.name");
            whereQry.append(" where dcbinfo.locality=boundary.id and dcbinfo.locality in (" + paramList + ")");
        } else if (PROPERTY.equalsIgnoreCase(mode)) {
            selectQry1.append("select distinct dcbinfo.hscno as hscno,dcbinfo.propertyid as \"propertyid\" ,dcbinfo.username as \"username\", ");
            fromQry = new StringBuilder(" from egwtr_mv_dcb_view dcbinfo ");
            groupByQry.append("group by dcbinfo.hscno,dcbinfo.propertyid,dcbinfo.username ");
            whereQry.append(" where dcbinfo.hscno is not null  ");
            whereQry = paramList != null && !paramList.equalsIgnoreCase("") && reportType.equalsIgnoreCase("localityWise") ? whereQry.append(" and dcbinfo.locality in (" + paramList + ")") : whereQry.append(" and dcbinfo.block in (" + paramList + ")");
        }
        if (!"".equalsIgnoreCase(connectionType)) {
            whereQry.append(" and dcbinfo.connectiontype = '" + connectionType + "'");
        }
        whereQry.append(" and dcbinfo.connectionstatus = 'ACTIVE'");
        StringBuilder query = selectQry1.append((CharSequence)selectQry2).append((CharSequence)fromQry).append((CharSequence)whereQry).append((CharSequence)groupByQry);
        SQLQuery sqlQuery = ((Session)this.entityManager.unwrap(Session.class)).createSQLQuery(query.toString());
        sqlQuery.setResultTransformer((ResultTransformer)new AliasToBeanResultTransformer(DCBReportResult.class));
        return sqlQuery.list();
    }

    public List<Object[]> getDonationDCBReportDetails(DonationChargesDCBReportSearch chargesDCBReportSearch) {
        StringBuilder selectQuery = new StringBuilder();
        StringBuilder fromQuery = new StringBuilder();
        StringBuilder whereQuery = new StringBuilder();
        selectQuery.append("select consumernumber, propertyid, username, mobileno, address, donation_demand, donation_coll, donation_balance");
        fromQuery = new StringBuilder(" from egwtr_mv_donation_dcb_view ");
        whereQuery.append(" where donation_demand is not null ");
        if (chargesDCBReportSearch.getFromDate() != null) {
            whereQuery.append(" and applicationdate >= '" + chargesDCBReportSearch.getFromDate() + "' ");
        }
        if (chargesDCBReportSearch.getToDate() != null) {
            whereQuery.append(" and applicationdate <= '" + DateUtils.endOfDay((Date)chargesDCBReportSearch.getToDate()) + "' ");
        }
        if (chargesDCBReportSearch.getFromAmount() != null && !chargesDCBReportSearch.getFromAmount().equals(BigDecimal.ZERO)) {
            whereQuery.append(" and donation_demand >= " + chargesDCBReportSearch.getFromAmount());
        }
        if (chargesDCBReportSearch.getToAmount() != null && !chargesDCBReportSearch.getToAmount().equals(BigDecimal.ZERO)) {
            whereQuery.append(" and donation_demand <= " + chargesDCBReportSearch.getToAmount());
        }
        if (chargesDCBReportSearch.getPendingForPaymentOnly() != null && chargesDCBReportSearch.getPendingForPaymentOnly().booleanValue()) {
            whereQuery.append(" and (donation_demand-donation_coll) >0 ");
        } else {
            whereQuery.append(" and (donation_demand-donation_coll) >=0 ");
        }
        selectQuery = selectQuery.append((CharSequence)fromQuery).append((CharSequence)whereQuery);
        SQLQuery sqlQuery = ((Session)this.entityManager.unwrap(Session.class)).createSQLQuery(selectQuery.toString());
        return sqlQuery.list();
    }
}

