/*
 * Decompiled with CFR 0.152.
 */
package org.egov.wtms.application.service;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.egov.commons.Installment;
import org.egov.commons.dao.InstallmentHibDao;
import org.egov.demand.model.EgDemand;
import org.egov.ptis.client.util.PropertyTaxUtil;
import org.egov.wtms.application.entity.ApplicationDocuments;
import org.egov.wtms.application.entity.WaterConnection;
import org.egov.wtms.application.entity.WaterConnectionDetails;
import org.egov.wtms.application.repository.WaterConnectionDetailsRepository;
import org.egov.wtms.application.repository.WaterConnectionRepository;
import org.egov.wtms.application.rest.WaterChargesDetails;
import org.egov.wtms.application.rest.WaterTaxDue;
import org.egov.wtms.application.service.ConnectionDemandService;
import org.egov.wtms.application.service.WaterConnectionDetailsService;
import org.egov.wtms.application.service.WaterConnectionService;
import org.egov.wtms.masters.entity.ApplicationType;
import org.egov.wtms.masters.entity.WaterTaxDetailRequest;
import org.egov.wtms.masters.entity.enums.ConnectionStatus;
import org.egov.wtms.masters.service.ApplicationTypeService;
import org.egov.wtms.utils.WaterTaxUtils;
import org.hibernate.Session;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class ConnectionDetailService {
    @PersistenceContext
    private EntityManager entityManager;
    @Autowired
    private InstallmentHibDao installmentDao;
    @Autowired
    private WaterConnectionDetailsRepository waterConnectionDetailsRepository;
    @Autowired
    private WaterConnectionRepository waterConnectionRepository;
    @Autowired
    private ConnectionDemandService connectionDemandService;
    @Autowired
    private WaterConnectionService waterConnectionService;
    @Autowired
    private ApplicationTypeService applicationTypeService;
    @Autowired
    private WaterConnectionDetailsService waterConnectionDetailsService;
    @Autowired
    private WaterTaxUtils waterTaxUtils;
    @Autowired
    private PropertyTaxUtil propertyTaxUtil;

    public Session getCurrentSession() {
        return (Session)this.entityManager.unwrap(Session.class);
    }

    public WaterTaxDue getDueDetailsByConsumerCode(String consumerCode) {
        WaterTaxDue waterTaxDue = new WaterTaxDue();
        ArrayList<String> consumerCodes = new ArrayList<String>();
        WaterConnectionDetails waterConnectionDetails = this.waterConnectionDetailsService.findByApplicationNumberOrConsumerCode(consumerCode);
        if (null != waterConnectionDetails) {
            this.getDueInfo(waterConnectionDetails);
            consumerCodes.add(waterConnectionDetails.getConnection().getConsumerCode());
            waterTaxDue.setConsumerCode(consumerCodes);
            waterTaxDue.setPropertyID(waterConnectionDetails.getConnection().getPropertyIdentifier());
            waterTaxDue.setConnectionCount(consumerCodes.size());
            waterTaxDue.setIsSuccess(true);
        } else {
            waterTaxDue.setIsSuccess(false);
            waterTaxDue.setConsumerCode(Collections.emptyList());
            waterTaxDue.setConnectionCount(0);
            waterTaxDue.setErrorCode("WTAX100");
            waterTaxDue.setErrorMessage("Water Connection details with Consumer code " + consumerCode + " does not exist");
        }
        return waterTaxDue;
    }

    public WaterTaxDue getDueDetailsByPropertyId(String propertyIdentifier) {
        WaterTaxDue waterTaxDue;
        BigDecimal arrDmd = new BigDecimal(0);
        BigDecimal arrColl = new BigDecimal(0);
        BigDecimal currDmd = new BigDecimal(0);
        BigDecimal currColl = new BigDecimal(0);
        BigDecimal totalDue = new BigDecimal(0);
        BigDecimal currentInstDue = new BigDecimal(0);
        List<WaterConnection> waterConnections = this.waterConnectionService.findByPropertyIdentifier(propertyIdentifier);
        if (waterConnections.isEmpty()) {
            waterTaxDue = new WaterTaxDue();
            waterTaxDue.setConsumerCode(Collections.emptyList());
            waterTaxDue.setConnectionCount(0);
            waterTaxDue.setIsSuccess(false);
            waterTaxDue.setErrorCode("WTAX101");
            waterTaxDue.setErrorMessage("Water Connection details with Assessment Number " + propertyIdentifier + " does not exist");
        } else {
            waterTaxDue = new WaterTaxDue();
            ArrayList<String> consumerCodes = new ArrayList<String>();
            for (WaterConnection connection : waterConnections) {
                WaterConnectionDetails waterConnectionDetails;
                if (connection.getConsumerCode() == null || (waterConnectionDetails = this.waterConnectionDetailsService.findByConsumerCodeAndConnectionStatus(connection.getConsumerCode(), ConnectionStatus.ACTIVE)) == null) continue;
                waterTaxDue = this.getDueInfo(waterConnectionDetails);
                waterTaxDue.setPropertyID(propertyIdentifier);
                consumerCodes.add(connection.getConsumerCode());
                arrDmd = arrDmd.add(waterTaxDue.getArrearDemand());
                arrColl = arrColl.add(waterTaxDue.getArrearCollection());
                currDmd = currDmd.add(waterTaxDue.getCurrentDemand());
                currColl = currColl.add(waterTaxDue.getCurrentCollection());
                currentInstDue = currentInstDue.add(waterTaxDue.getCurrentInstDemand());
                totalDue = totalDue.add(waterTaxDue.getTotalTaxDue());
            }
            waterTaxDue.setArrearDemand(arrDmd);
            waterTaxDue.setArrearCollection(arrColl);
            waterTaxDue.setCurrentDemand(currDmd);
            waterTaxDue.setCurrentCollection(currColl);
            waterTaxDue.setTotalTaxDue(totalDue);
            waterTaxDue.setCurrentInstDemand(currentInstDue);
            waterTaxDue.setConsumerCode(consumerCodes);
            waterTaxDue.setConnectionCount(waterConnections.size());
            waterTaxDue.setIsSuccess(true);
        }
        List<WaterConnectionDetails> connectionDetailsList = this.waterConnectionDetailsService.getAllConnectionDetailsExceptInactiveStatusByPropertyID(propertyIdentifier);
        for (WaterConnectionDetails connectionDetails : connectionDetailsList) {
            if (!"INPROGRESS".equals(connectionDetails.getConnectionStatus().toString())) continue;
            waterTaxDue.setIsInWorkFlow(true);
        }
        return waterTaxDue;
    }

    @Transactional
    public String updateWaterConnectionDetails(WaterTaxDetailRequest waterTaxDetailRequest) {
        block8: {
            WaterConnectionDetails waterConnectionDetailsRetainerObj;
            ApplicationType additionAppType;
            WaterConnection waterConnection;
            block7: {
                List<WaterConnection> waterConnections = this.waterConnectionService.findByPropertyIdentifier(waterTaxDetailRequest.getAssessmentNumber());
                waterConnection = this.waterConnectionService.findParentWaterConnection(waterTaxDetailRequest.getAssessmentNumber());
                Boolean parentConnection = false;
                WaterConnectionDetails waterConnectionDetailsRetainer = null;
                additionAppType = this.applicationTypeService.findByCode("ADDNLCONNECTION");
                if (!waterConnections.isEmpty()) break block7;
                for (String childAssessmentNumber : waterTaxDetailRequest.getChildAssessmentNumber()) {
                    if (waterConnectionDetailsRetainer == null && !parentConnection.booleanValue()) {
                        waterConnectionDetailsRetainer = this.waterConnectionDetailsService.getPrimaryConnectionDetailsByPropertyAssessmentNumbers(waterTaxDetailRequest.getChildAssessmentNumber());
                        WaterConnection connectiontemp = waterConnectionDetailsRetainer.getConnection();
                        connectiontemp.setOldPropertyIdentifier(childAssessmentNumber);
                        connectiontemp.setPropertyIdentifier(waterTaxDetailRequest.getAssessmentNumber());
                        this.waterConnectionRepository.save((Object)connectiontemp);
                        parentConnection = Boolean.TRUE;
                        continue;
                    }
                    List<WaterConnectionDetails> waterConnectionDetailslist = this.waterConnectionDetailsService.getAllConnectionDetailsExceptInactiveStatusByPropertyID(childAssessmentNumber);
                    for (WaterConnectionDetails waterConnectionDetailObj : waterConnectionDetailslist) {
                        WaterConnection connectiontemp;
                        if (waterConnectionDetailObj != null && waterConnectionDetailObj.getApplicationType().getCode().equals("NEWCONNECTION")) {
                            connectiontemp = waterConnectionDetailObj.getConnection();
                            connectiontemp.setOldPropertyIdentifier(childAssessmentNumber);
                            connectiontemp.setPropertyIdentifier(waterTaxDetailRequest.getAssessmentNumber());
                            connectiontemp.setParentConnection(waterConnectionDetailsRetainer.getConnection());
                            waterConnectionDetailObj.setApplicationType(additionAppType);
                            waterConnectionDetailObj.setConnection(connectiontemp);
                            this.waterConnectionDetailsRepository.save((Object)waterConnectionDetailObj);
                            continue;
                        }
                        if (waterConnectionDetailObj == null) continue;
                        connectiontemp = waterConnectionDetailObj.getConnection();
                        connectiontemp.setOldPropertyIdentifier(connectiontemp.getPropertyIdentifier());
                        connectiontemp.setPropertyIdentifier(waterTaxDetailRequest.getAssessmentNumber());
                        connectiontemp.setParentConnection(waterConnectionDetailsRetainer.getConnection());
                        this.waterConnectionRepository.save((Object)connectiontemp);
                    }
                }
                break block8;
            }
            if (waterConnection == null || (waterConnectionDetailsRetainerObj = this.waterConnectionDetailsService.findParentConnectionDetailsByConsumerCodeAndConnectionStatus(waterConnection.getConsumerCode(), ConnectionStatus.ACTIVE)) == null || waterTaxDetailRequest.getChildAssessmentNumber().isEmpty()) break block8;
            for (String childAssessmentNumber : waterTaxDetailRequest.getChildAssessmentNumber()) {
                WaterConnectionDetails waterConnectionDetails = this.waterConnectionDetailsService.getPrimaryConnectionDetailsByPropertyIdentifier(childAssessmentNumber);
                if (waterConnectionDetails != null) {
                    WaterConnection connectiontemp = waterConnectionDetails.getConnection();
                    connectiontemp.setOldPropertyIdentifier(connectiontemp.getPropertyIdentifier());
                    connectiontemp.setPropertyIdentifier(waterTaxDetailRequest.getAssessmentNumber());
                    connectiontemp.setParentConnection(waterConnectionDetailsRetainerObj.getConnection());
                    waterConnectionDetails.setApplicationType(additionAppType);
                    waterConnectionDetails.setConnection(connectiontemp);
                    this.waterConnectionDetailsRepository.save((Object)waterConnectionDetails);
                    continue;
                }
                List<WaterConnectionDetails> waterConnectionDetailslist = this.waterConnectionDetailsService.getChildConnectionDetailsByPropertyID(childAssessmentNumber);
                for (WaterConnectionDetails tempconn : waterConnectionDetailslist) {
                    WaterConnection connectiontemp = tempconn.getConnection();
                    connectiontemp.setOldPropertyIdentifier(connectiontemp.getPropertyIdentifier());
                    connectiontemp.setPropertyIdentifier(childAssessmentNumber);
                    this.waterConnectionRepository.save((Object)connectiontemp);
                }
            }
        }
        return waterTaxDetailRequest.getAssessmentNumber();
    }

    public List<WaterChargesDetails> getWaterTaxDetailsByPropertyId(String propertyIdentifier, String ulbCode, String consumerNumber) {
        ArrayList<WaterChargesDetails> waterChargesDetailsList = new ArrayList<WaterChargesDetails>();
        if (consumerNumber != null) {
            WaterConnection waterConnection = this.waterConnectionService.findByConsumerCode(consumerNumber);
            if (waterConnection != null) {
                waterChargesDetailsList.add(this.getWaterChargesDetailsList(consumerNumber, waterConnection.getPropertyIdentifier(), ulbCode));
            }
            return waterChargesDetailsList;
        }
        List<WaterConnection> waterConnections = this.waterConnectionService.findByPropertyIdentifier(propertyIdentifier);
        if (waterConnections.isEmpty()) {
            return waterChargesDetailsList;
        }
        for (WaterConnection connection : waterConnections) {
            if (connection.getConsumerCode() == null) continue;
            waterChargesDetailsList.add(this.getWaterChargesDetailsList(connection.getConsumerCode(), propertyIdentifier, ulbCode));
        }
        return waterChargesDetailsList;
    }

    private WaterChargesDetails getWaterChargesDetailsList(String consumerNumber, String propertyIdentifier, String ulbCode) {
        WaterChargesDetails waterChargesDetails = new WaterChargesDetails();
        WaterConnectionDetails waterConnectionDetails = this.waterConnectionDetailsService.findByConsumerCodeAndConnectionStatus(consumerNumber, ConnectionStatus.ACTIVE);
        if (waterConnectionDetails != null) {
            waterChargesDetails = this.getWatertaxDetails(waterConnectionDetails, consumerNumber, propertyIdentifier, ulbCode);
        } else {
            waterConnectionDetails = this.waterConnectionDetailsService.findByConsumerCodeAndConnectionStatus(consumerNumber, ConnectionStatus.INACTIVE);
            if (waterConnectionDetails != null) {
                waterChargesDetails = this.getWatertaxDetails(waterConnectionDetails, consumerNumber, propertyIdentifier, ulbCode);
            }
        }
        return waterChargesDetails;
    }

    public WaterChargesDetails getWatertaxDetails(WaterConnectionDetails waterConnectionDetails, String consumerCode, String propertyIdentifier, String ulbCode) {
        WaterChargesDetails waterChargesDetails = new WaterChargesDetails();
        waterChargesDetails.setTotalTaxDue(this.getDueInfo(waterConnectionDetails).getTotalTaxDue());
        waterChargesDetails.setConnectionType(waterConnectionDetails.getConnectionType().name());
        waterChargesDetails.setConsumerCode(consumerCode);
        waterChargesDetails.setPropertyID(propertyIdentifier);
        waterChargesDetails.setConnectionStatus(waterConnectionDetails.getConnectionStatus().name());
        waterChargesDetails.setNoOfPerson(waterConnectionDetails.getNumberOfPerson());
        waterChargesDetails.setPipesize(waterConnectionDetails.getPipeSize().getCode());
        waterChargesDetails.setWaterSource(waterConnectionDetails.getWaterSource().getDescription());
        waterChargesDetails.setUlbCode(ulbCode);
        waterChargesDetails.setWaterSupplyType(waterConnectionDetails.getWaterSupply() != null ? waterConnectionDetails.getWaterSupply().getDescription() : "");
        waterChargesDetails.setCategory(waterConnectionDetails.getCategory().getDescription());
        waterChargesDetails.setSumpCapacity(waterConnectionDetails.getSumpCapacity());
        waterChargesDetails.setUsageType(waterConnectionDetails.getUsageType().getDescription());
        waterChargesDetails.setPropertytype(waterConnectionDetails.getPropertyType().getName());
        waterChargesDetails.setConnectionStatus(waterConnectionDetails.getConnectionStatus().toString());
        if (waterConnectionDetails.getApplicationType() != null && waterConnectionDetails.getApplicationType().getCode().equals("NEWCONNECTION")) {
            waterChargesDetails.setIsPrimaryConnection(true);
        } else {
            waterChargesDetails.setIsPrimaryConnection(false);
        }
        return waterChargesDetails;
    }

    private WaterTaxDue getDueInfo(WaterConnectionDetails waterConnectionDetails) {
        Map<String, BigDecimal> resultmap = this.getDemandCollMap(waterConnectionDetails);
        WaterTaxDue waterTaxDue = new WaterTaxDue();
        if (null != resultmap && !resultmap.isEmpty()) {
            BigDecimal currDmd = resultmap.get("CURR_DMD");
            waterTaxDue.setCurrentDemand(currDmd);
            BigDecimal arrDmd = resultmap.get("ARR_DMD");
            waterTaxDue.setArrearDemand(arrDmd);
            BigDecimal currCollection = resultmap.get("CURR_COLL");
            waterTaxDue.setCurrentCollection(currCollection);
            BigDecimal arrCollection = resultmap.get("ARR_COLL");
            waterTaxDue.setArrearCollection(arrCollection);
            BigDecimal taxDue = currDmd.add(arrDmd).subtract(currCollection).subtract(arrCollection);
            waterTaxDue.setTotalTaxDue(taxDue);
            BigDecimal currentInstDemand = this.waterConnectionDetailsService.getCurrentDue(waterConnectionDetails);
            waterTaxDue.setCurrentInstDemand(currentInstDemand);
        }
        return waterTaxDue;
    }

    public Map<String, BigDecimal> getDemandCollMap(WaterConnectionDetails waterConnectionDetails) {
        EgDemand currDemand = this.waterTaxUtils.getCurrentDemand(waterConnectionDetails).getDemand();
        List<Object> dmdCollList = new ArrayList(0);
        BigDecimal currDmd = BigDecimal.ZERO;
        BigDecimal arrDmd = BigDecimal.ZERO;
        BigDecimal currCollection = BigDecimal.ZERO;
        BigDecimal arrCollection = BigDecimal.ZERO;
        HashMap<String, BigDecimal> retMap = new HashMap<String, BigDecimal>(0);
        if (currDemand != null) {
            dmdCollList = this.connectionDemandService.getDmdCollAmtInstallmentWise(currDemand);
        }
        Installment currFirstHalf = (Installment)this.propertyTaxUtil.getInstallmentsForCurrYear(new Date()).get("Current 1st Half");
        Installment currSecondHalf = (Installment)this.propertyTaxUtil.getInstallmentsForCurrYear(new Date()).get("Current 2nd Half");
        for (Object object : dmdCollList) {
            Object[] listObj = (Object[])object;
            Integer instId = Integer.valueOf(listObj[1].toString());
            Installment installment = this.installmentDao.findById(instId.intValue(), false);
            if (currFirstHalf.equals((Object)installment) || currSecondHalf.equals((Object)installment)) {
                if (listObj[3] != null && new BigDecimal((Double)listObj[3]).compareTo(BigDecimal.ZERO) == 1) {
                    currCollection = currCollection.add(new BigDecimal((Double)listObj[3]));
                }
                currDmd = currDmd.add(new BigDecimal((Double)listObj[2]));
                continue;
            }
            if (listObj[2] == null) continue;
            arrDmd = arrDmd.add(new BigDecimal((Double)listObj[2]));
            if (new BigDecimal((Double)listObj[3]).compareTo(BigDecimal.ZERO) != 1) continue;
            arrCollection = arrCollection.add(new BigDecimal((Double)listObj[3]));
        }
        retMap.put("CURR_DMD", currDmd);
        retMap.put("ARR_DMD", arrDmd);
        retMap.put("CURR_COLL", currCollection);
        retMap.put("ARR_COLL", arrCollection);
        return retMap;
    }

    public Installment getCurrentInstallment(String moduleName, String installmentType, Date date) {
        return this.connectionDemandService.getCurrentInstallment(moduleName, installmentType, date);
    }

    public Map<String, BigDecimal> getDemandCollMapForPtisIntegration(WaterConnectionDetails waterConnectionDetails, String moduleName, String installmentType) {
        EgDemand currDemand = this.waterTaxUtils.getCurrentDemand(waterConnectionDetails).getDemand();
        List<Object> dmdCollList = new ArrayList(0);
        BigDecimal curDue = BigDecimal.ZERO;
        BigDecimal arrDue = BigDecimal.ZERO;
        BigDecimal arrearInstallmentfrom = BigDecimal.ZERO;
        HashMap<String, BigDecimal> retMap = new HashMap<String, BigDecimal>(0);
        if (currDemand != null) {
            dmdCollList = this.connectionDemandService.getDmdCollAmtInstallmentWiseWithIsDmdTrue(currDemand);
        }
        Installment currInst = this.getCurrentInstallment(moduleName, null, new Date());
        for (Object object : dmdCollList) {
            Object[] listObj = (Object[])object;
            Integer instId = Integer.valueOf(listObj[2].toString());
            Installment installment = this.installmentDao.findById(instId.intValue(), false);
            if (currInst.equals((Object)installment)) {
                curDue = new BigDecimal(listObj[6].toString());
                continue;
            }
            arrDue = new BigDecimal(listObj[6].toString());
            if (arrDue.signum() <= 0 || BigDecimal.ZERO != arrearInstallmentfrom && null != arrearInstallmentfrom) continue;
            arrearInstallmentfrom = BigDecimal.valueOf(instId.intValue());
        }
        retMap.put("ArrearDue", arrDue);
        retMap.put("CurrentDue", curDue);
        retMap.put("ARR_INSTALL_FROM", arrearInstallmentfrom);
        return retMap;
    }

    public Map<String, BigDecimal> getDemandCollMapForBill(WaterConnectionDetails waterConnectionDetails, String moduleName, String installmentType) {
        EgDemand currDemand = this.waterTaxUtils.getCurrentDemand(waterConnectionDetails).getDemand();
        List<Object> dmdCollList = new ArrayList(0);
        HashMap<String, BigDecimal> retMap = new HashMap<String, BigDecimal>(0);
        if (currDemand != null) {
            dmdCollList = this.connectionDemandService.getDmdCollAmtInstallmentWiseWithIsDmdTrue(currDemand);
        }
        for (Object object : dmdCollList) {
            Object[] listObj = (Object[])object;
            Double balance = (Double)listObj[6];
            if (BigDecimal.valueOf(balance).signum() <= 0) continue;
            Integer val = Integer.valueOf(listObj[0].toString());
            Integer instId = Integer.valueOf(listObj[2].toString());
            retMap.put("wcdid", BigDecimal.valueOf(val.intValue()));
            retMap.put("inst", BigDecimal.valueOf(instId.intValue()));
        }
        return retMap;
    }

    public boolean validApplicationDocument(ApplicationDocuments applicationDocument) {
        return applicationDocument.getDocumentNames().isRequired() || applicationDocument.getDocumentNumber() != null || applicationDocument.getDocumentDate() != null;
    }
}

