/*
 * Decompiled with CFR 0.152.
 */
package org.egov.wtms.application.service;

import java.text.ParseException;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.apache.commons.lang.StringUtils;
import org.egov.infra.config.persistence.datasource.routing.annotation.ReadOnly;
import org.egov.wtms.application.entity.BaseRegisterResult;
import org.egov.wtms.masters.entity.enums.ConnectionStatus;
import org.hibernate.SQLQuery;
import org.hibernate.Session;
import org.hibernate.transform.AliasToBeanResultTransformer;
import org.hibernate.transform.ResultTransformer;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class BaseRegisterReportService {
    @PersistenceContext
    private EntityManager entityManager;

    public Session getCurrentSession() {
        return (Session)this.entityManager.unwrap(Session.class);
    }

    @ReadOnly
    public List<BaseRegisterResult> getBaseRegisterReportDetails(String ward) throws ParseException {
        StringBuilder queryStr = new StringBuilder();
        queryStr.append("select dcbinfo.hscno as \"consumerNo\", dcbinfo.oldhscno as \"oldConsumerNo\", dcbinfo.propertyid as \"assementNo\", ");
        queryStr.append("dcbinfo.username as \"ownerName\",dcbinfo.categorytype as \"categoryType\",dcbinfo.username as \"period\",dcbinfo.houseno as \"doorNo\",");
        queryStr.append(" dcbinfo.connectiontype as \"connectionType\" , dcbinfo.arr_demand as \"arrears\" ,  dcbinfo.curr_demand as \"current\" , ");
        queryStr.append(" dcbinfo.arr_coll as \"arrearsCollection\" ,  dcbinfo.curr_coll as \"currentCollection\" , ");
        queryStr.append(" dcbinfo.arr_demand+dcbinfo.curr_demand as \"totalDemand\" , dcbinfo.usagetype as \"usageType\" , dcbinfo.waterSource as \"waterSource\" ,");
        queryStr.append(" dcbinfo.pipesize as \"pipeSize\" , dcbinfo.arr_coll+dcbinfo.curr_coll as \"totalCollection\" , wrd.monthlyrate as \"monthlyRate\" ");
        queryStr.append(" from  egwtr_usage_type ut, egwtr_water_source wt, egwtr_pipesize ps, egwtr_water_rates_header wrh,egwtr_water_rates_details wrd ,");
        queryStr.append(" egwtr_mv_dcb_view dcbinfo INNER JOIN eg_boundary wardboundary on dcbinfo.wardid = wardboundary.id ");
        queryStr.append(" INNER JOIN eg_boundary localboundary on dcbinfo.locality = localboundary.id");
        queryStr.append(" where ut.id=wrh.usagetype and wt.id=wrh.watersource and ps.id=wrh.pipesize and dcbinfo.usagetype =ut.name and  dcbinfo.watersource = wt.watersourcetype and dcbinfo.pipesize = ps.code and wrd.waterratesheader=wrh.id and wrh.active=true  and wrd.fromdate <= now() and  wrd.todate >= now() and dcbinfo.connectionstatus = '" + ConnectionStatus.ACTIVE.toString() + "'");
        if (StringUtils.isNotBlank((String)ward)) {
            queryStr.append(" and wardboundary.id = :ward");
        }
        queryStr.append(" UNION select dcbinfo.hscno as \"consumerNo\", dcbinfo.oldhscno as \"oldConsumerNo\", dcbinfo.propertyid as \"assementNo\", ");
        queryStr.append("dcbinfo.username as \"ownerName\",dcbinfo.categorytype as \"categoryType\",dcbinfo.username as \"period\",dcbinfo.houseno as \"doorNo\",");
        queryStr.append(" dcbinfo.connectiontype as \"connectionType\" , dcbinfo.arr_demand as \"arrears\" ,  dcbinfo.curr_demand as \"current\" , ");
        queryStr.append(" dcbinfo.arr_coll as \"arrearsCollection\" ,  dcbinfo.curr_coll as \"currentCollection\" , ");
        queryStr.append(" dcbinfo.arr_demand+dcbinfo.curr_demand as \"totalDemand\" , dcbinfo.usagetype as \"usageType\" , dcbinfo.waterSource as \"waterSource\" ,");
        queryStr.append(" dcbinfo.pipesize as \"pipeSize\" , dcbinfo.arr_coll+dcbinfo.curr_coll as \"totalCollection\" , 0 as \"monthlyRate\" ");
        queryStr.append(" from  egwtr_usage_type ut, egwtr_water_source wt, egwtr_pipesize ps, egwtr_water_rates_header wrh,egwtr_water_rates_details wrd ,");
        queryStr.append(" egwtr_mv_dcb_view dcbinfo INNER JOIN eg_boundary wardboundary on dcbinfo.wardid = wardboundary.id ");
        queryStr.append(" INNER JOIN eg_boundary localboundary on dcbinfo.locality = localboundary.id");
        queryStr.append(" where ut.id=wrh.usagetype and wt.id=wrh.watersource and ps.id=wrh.pipesize and dcbinfo.usagetype =ut.name and  dcbinfo.watersource = wt.watersourcetype and dcbinfo.pipesize = ps.code and wrd.waterratesheader=wrh.id and wrh.active=false and dcbinfo.connectionstatus = '" + ConnectionStatus.ACTIVE.toString() + "'" + " and dcbinfo.hscno not in (");
        queryStr.append(" select dcbinfo.hscno from  egwtr_usage_type ut, egwtr_water_source wt, egwtr_pipesize ps, egwtr_water_rates_header wrh,egwtr_water_rates_details wrd ,");
        queryStr.append(" egwtr_mv_dcb_view dcbinfo INNER JOIN eg_boundary wardboundary on dcbinfo.wardid = wardboundary.id ");
        queryStr.append(" INNER JOIN eg_boundary localboundary on dcbinfo.locality = localboundary.id");
        queryStr.append(" where ut.id=wrh.usagetype and wt.id=wrh.watersource and ps.id=wrh.pipesize and dcbinfo.usagetype =ut.name and  dcbinfo.watersource = wt.watersourcetype and dcbinfo.pipesize = ps.code and wrd.waterratesheader=wrh.id and wrh.active=true  and wrd.fromdate <= now() and  wrd.todate >= now() and dcbinfo.connectionstatus = '" + ConnectionStatus.ACTIVE.toString() + "')");
        if (StringUtils.isNotBlank((String)ward)) {
            queryStr.append(" and wardboundary.id = :ward");
        }
        SQLQuery query = this.getCurrentSession().createSQLQuery(queryStr.toString());
        if (StringUtils.isNotBlank((String)ward)) {
            query.setLong("ward", Long.valueOf(ward).longValue());
        }
        query.setResultTransformer((ResultTransformer)new AliasToBeanResultTransformer(BaseRegisterResult.class));
        return query.list();
    }
}

