/*
 * Decompiled with CFR 0.152.
 */
package org.egov.wtms.application.service;

import java.math.BigDecimal;
import org.egov.ptis.domain.model.AssessmentDetails;
import org.egov.ptis.domain.model.enums.BasicPropertyStatus;
import org.egov.ptis.domain.service.property.PropertyExternalService;
import org.egov.wtms.application.entity.WaterConnectionDetails;
import org.egov.wtms.application.repository.WaterConnectionDetailsRepository;
import org.egov.wtms.application.service.WaterConnectionDetailsService;
import org.egov.wtms.masters.entity.enums.ConnectionStatus;
import org.egov.wtms.utils.PropertyExtnUtils;
import org.egov.wtms.utils.WaterTaxUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class AdditionalConnectionService {
    @Autowired
    private WaterConnectionDetailsRepository waterConnectionDetailsRepository;
    @Autowired
    @Qualifier(value="parentMessageSource")
    private MessageSource wcmsMessageSource;
    @Autowired
    private WaterConnectionDetailsService waterConnectionDetailsService;
    @Autowired
    private PropertyExtnUtils propertyExtnUtils;
    @Autowired
    private WaterTaxUtils waterTaxUtils;
    public static final String ADDCONNALLOWEDIFWTDUE = "ADDCONNECTIONALLOWEDIFWTDUE";

    public String validateAdditionalConnection(WaterConnectionDetails parentWaterConnectionDetail) {
        String validationMessage = "";
        String propertyID = parentWaterConnectionDetail.getConnection().getPropertyIdentifier();
        WaterConnectionDetails inWorkflow = this.waterConnectionDetailsRepository.getConnectionDetailsInWorkflow(propertyID, ConnectionStatus.INPROGRESS);
        AssessmentDetails assessmentDetails = this.propertyExtnUtils.getAssessmentDetailsForFlag(propertyID, PropertyExternalService.FLAG_FULL_DETAILS, BasicPropertyStatus.ACTIVE);
        if (parentWaterConnectionDetail.getConnectionStatus().equals((Object)ConnectionStatus.HOLDING)) {
            validationMessage = this.wcmsMessageSource.getMessage("err.validate.primary.connection.holding", (Object[])new String[]{parentWaterConnectionDetail.getConnection().getConsumerCode(), propertyID}, null);
        } else if (parentWaterConnectionDetail.getConnectionStatus().equals((Object)ConnectionStatus.DISCONNECTED)) {
            validationMessage = this.wcmsMessageSource.getMessage("err.validate.primary.connection.disconnected", (Object[])new String[]{parentWaterConnectionDetail.getConnection().getConsumerCode(), propertyID}, null);
        } else if (null != assessmentDetails.getErrorDetails() && null != assessmentDetails.getErrorDetails().getErrorCode()) {
            validationMessage = assessmentDetails.getErrorDetails().getErrorMessage();
        } else if (null != inWorkflow) {
            validationMessage = this.wcmsMessageSource.getMessage("err.validate.addconnection.application.inprocess", (Object[])new String[]{parentWaterConnectionDetail.getConnection().getConsumerCode(), inWorkflow.getApplicationNumber()}, null);
        } else {
            if (null != assessmentDetails.getPropertyDetails() && null != assessmentDetails.getPropertyDetails().getTaxDue() && assessmentDetails.getPropertyDetails().getTaxDue().doubleValue() > 0.0 && !this.waterTaxUtils.isNewConnectionAllowedIfPTDuePresent().booleanValue()) {
                validationMessage = this.wcmsMessageSource.getMessage("err.validate.property.taxdue", (Object[])new String[]{assessmentDetails.getPropertyDetails().getTaxDue().toString(), parentWaterConnectionDetail.getConnection().getPropertyIdentifier(), "additional"}, null);
            }
            if (!this.waterTaxUtils.isConnectionAllowedIfWTDuePresent(ADDCONNALLOWEDIFWTDUE).booleanValue()) {
                BigDecimal waterTaxDueforParent = this.waterConnectionDetailsService.getCurrentDue(parentWaterConnectionDetail);
                if (waterTaxDueforParent.doubleValue() > 0.0) {
                    validationMessage = validationMessage.equalsIgnoreCase("") ? this.wcmsMessageSource.getMessage("err.validate.primary.connection.watertax.due", null, null) : validationMessage + " and " + this.wcmsMessageSource.getMessage("err.validate.primary.connection.watertax.due", null, null);
                }
                if (parentWaterConnectionDetail.getConnection().getId() != null && this.waterTaxUtils.waterConnectionDue(parentWaterConnectionDetail.getConnection().getId()) > 0.0) {
                    validationMessage = validationMessage.equalsIgnoreCase("") ? this.wcmsMessageSource.getMessage("err.validate.additional.connection.watertax.due", null, null) : validationMessage + " and " + this.wcmsMessageSource.getMessage("err.validate.additional.connection.watertax.due", null, null);
                }
            }
        }
        return validationMessage;
    }
}

