/*
 * Decompiled with CFR 0.152.
 */
package org.egov.wtms.masters.service;

import java.util.List;
import org.egov.wtms.masters.entity.SecurityDeposit;
import org.egov.wtms.masters.entity.UsageType;
import org.egov.wtms.masters.repository.SecurityDepositRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class SecurityDepositService {
    private final SecurityDepositRepository securityDepositRepository;

    @Autowired
    public SecurityDepositService(SecurityDepositRepository securityDepositRepository) {
        this.securityDepositRepository = securityDepositRepository;
    }

    public SecurityDeposit findBy(Long securityDepositId) {
        return (SecurityDeposit)((Object)this.securityDepositRepository.findOne(securityDepositId));
    }

    @Transactional
    public SecurityDeposit createSecurityDeposit(SecurityDeposit securityDeposit) {
        return (SecurityDeposit)((Object)this.securityDepositRepository.save((Object)securityDeposit));
    }

    @Transactional
    public void updateSecurityDeposit(SecurityDeposit securityDeposit) {
        this.securityDepositRepository.save((Object)securityDeposit);
    }

    public List<SecurityDeposit> findAll() {
        return this.securityDepositRepository.findAll(new Sort(Sort.Direction.ASC, new String[]{""}));
    }

    public List<SecurityDeposit> findAllByUsageType(UsageType usageType) {
        return this.securityDepositRepository.findAllByUsageType(usageType);
    }

    public SecurityDeposit load(Long id) {
        return (SecurityDeposit)((Object)this.securityDepositRepository.getOne(id));
    }

    public SecurityDeposit findByUsageTypeAndNoOfMonths(UsageType usageType, Long noOfMonths) {
        return this.securityDepositRepository.findByUsageTypeAndNoOfMonths(usageType, noOfMonths);
    }
}

