/*
 * Decompiled with CFR 0.152.
 */
package org.egov.wtms.application.service;

import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.egov.wtms.application.entity.WaterConnection;
import org.egov.wtms.application.repository.WaterConnectionRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class WaterConnectionService {
    private final WaterConnectionRepository waterConnectionRepository;
    @PersistenceContext
    private EntityManager entityManager;

    @Autowired
    public WaterConnectionService(WaterConnectionRepository waterConnectionRepository) {
        this.waterConnectionRepository = waterConnectionRepository;
    }

    public WaterConnection findBy(Long waterConnectionId) {
        return (WaterConnection)((Object)this.waterConnectionRepository.findOne(waterConnectionId));
    }

    public List<WaterConnection> findAll() {
        return this.waterConnectionRepository.findAll(new Sort(Sort.Direction.ASC, new String[]{"consumerCode"}));
    }

    public WaterConnection findByConsumerCode(String consumerCode) {
        return this.waterConnectionRepository.findByConsumerCode(consumerCode);
    }

    public WaterConnection load(Long id) {
        return (WaterConnection)((Object)this.waterConnectionRepository.getOne(id));
    }

    public Page<WaterConnection> getListWaterConnections(Integer pageNumber, Integer pageSize) {
        PageRequest pageable = new PageRequest(pageNumber - 1, pageSize.intValue(), Sort.Direction.ASC, new String[]{"consumerCode"});
        return this.waterConnectionRepository.findAll((Pageable)pageable);
    }

    public List<WaterConnection> findByPropertyIdentifier(String propertyIdentifier) {
        return this.waterConnectionRepository.findByPropertyIdentifier(propertyIdentifier);
    }

    public WaterConnection findParentWaterConnection(String propertyIdentifer) {
        return this.waterConnectionRepository.findParentWaterConnection(propertyIdentifer);
    }
}

