/*
 * Decompiled with CFR 0.152.
 */
package org.egov.wtms.application.service;

import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.egov.wtms.application.entity.LegacyReceipts;
import org.egov.wtms.application.entity.WaterConnectionDetails;
import org.egov.wtms.application.repository.LegacyReceiptsRepository;
import org.hibernate.Session;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class LegacyReceiptsSevice {
    protected LegacyReceiptsRepository legacyReceiptsRepository;
    @PersistenceContext
    private EntityManager entityManager;

    @Autowired
    public LegacyReceiptsSevice(LegacyReceiptsRepository legacyReceiptsRepository) {
        this.legacyReceiptsRepository = legacyReceiptsRepository;
    }

    public List<LegacyReceipts> findByWaterConnectionDetails(WaterConnectionDetails waterConnectionDetails) {
        return this.legacyReceiptsRepository.findByWaterConnectionDetails(waterConnectionDetails);
    }

    public List<LegacyReceipts> findAll() {
        return this.legacyReceiptsRepository.findAll(new Sort(Sort.Direction.ASC, new String[]{"id"}));
    }

    public LegacyReceipts load(Long id) {
        return (LegacyReceipts)((Object)this.legacyReceiptsRepository.getOne(id));
    }

    public Session getCurrentSession() {
        return (Session)this.entityManager.unwrap(Session.class);
    }

    @Transactional
    public List<LegacyReceipts> createLegacyReceipts(List<LegacyReceipts> legacyReceipts) {
        return this.legacyReceiptsRepository.save(legacyReceipts);
    }

    @Transactional
    public void updateLegacyReceipts(LegacyReceipts legacyReceipts) {
        this.legacyReceiptsRepository.save((Object)legacyReceipts);
    }

    public LegacyReceipts findByReceiptNumber(String receiptNumber) {
        return this.legacyReceiptsRepository.findByReceiptNumber(receiptNumber);
    }
}

