/*
 * Decompiled with CFR 0.152.
 */
package org.egov.wtms.application.service;

import java.math.BigInteger;
import java.text.ParseException;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.egov.infra.config.persistence.datasource.routing.annotation.ReadOnly;
import org.egov.wtms.application.entity.DefaultersReport;
import org.egov.wtms.masters.entity.enums.ConnectionStatus;
import org.hibernate.SQLQuery;
import org.hibernate.Session;
import org.hibernate.transform.AliasToBeanResultTransformer;
import org.hibernate.transform.ResultTransformer;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class DefaultersWTReportService {
    @PersistenceContext
    private EntityManager entityManager;

    public Session getCurrentSession() {
        return (Session)this.entityManager.unwrap(Session.class);
    }

    @ReadOnly
    public List<DefaultersReport> getDefaultersReportDetails(String fromAmount, String toAmount, String ward, String topDefaulters, int startsFrom, int maxResults) throws ParseException {
        StringBuilder queryStr = new StringBuilder();
        queryStr = queryStr.append("select dcbinfo.hscno as \"hscNo\", dcbinfo.demand as \"demandId\", dcbinfo.username as \"ownerName\",wardboundary.name as \"wardName\", ").append("dcbinfo.houseno as \"houseNo\" , localboundary.localname as \"locality\", dcbinfo.mobileno as \"mobileNumber\", ").append("dcbinfo.arr_balance as \"arrearsDue\" ,  dcbinfo.curr_balance as \"currentDue\" , dcbinfo.arr_balance+dcbinfo.curr_balance as \"totalDue\" ").append("from egwtr_mv_dcb_view dcbinfo INNER JOIN eg_boundary wardboundary on dcbinfo.wardid = wardboundary.id INNER JOIN eg_boundary localboundary on dcbinfo.locality = localboundary.id");
        if (Double.parseDouble(toAmount) == 0.0) {
            queryStr.append(" where dcbinfo.arr_balance+dcbinfo.curr_balance >=" + fromAmount);
        } else {
            queryStr.append(" where dcbinfo.arr_balance+dcbinfo.curr_balance >=" + fromAmount + " and dcbinfo.arr_balance+dcbinfo.curr_balance <=" + toAmount);
        }
        queryStr.append(" and dcbinfo.connectionstatus = '" + ConnectionStatus.ACTIVE.toString() + "'");
        if (ward != null && !ward.isEmpty()) {
            queryStr.append(" and wardboundary.id = '" + ward + "'");
        }
        queryStr.append(" and dcbinfo.demand IS NOT NULL");
        if (!topDefaulters.isEmpty()) {
            queryStr.append(" order by dcbinfo.arr_balance+dcbinfo.curr_balance desc ");
        }
        SQLQuery finalQuery = this.getCurrentSession().createSQLQuery(queryStr.toString());
        finalQuery.setFirstResult(startsFrom);
        finalQuery.setMaxResults(maxResults);
        finalQuery.setResultTransformer((ResultTransformer)new AliasToBeanResultTransformer(DefaultersReport.class));
        return finalQuery.list();
    }

    public long getTotalCount(String fromAmount, String toAmount, String ward) throws ParseException {
        StringBuilder queryStr = new StringBuilder();
        queryStr = queryStr.append("select count(dcbinfo.hscno) from egwtr_mv_dcb_view dcbinfo").append(" INNER JOIN eg_boundary wardboundary on dcbinfo.wardid = wardboundary.id INNER JOIN eg_boundary localboundary").append(" on dcbinfo.locality = localboundary.id");
        if (Double.parseDouble(toAmount) == 0.0) {
            queryStr.append(" where dcbinfo.arr_balance+dcbinfo.curr_balance >=" + fromAmount);
        } else {
            queryStr.append(" where dcbinfo.arr_balance+dcbinfo.curr_balance >=" + fromAmount + " and dcbinfo.arr_balance+dcbinfo.curr_balance <=" + toAmount);
        }
        queryStr.append(" and dcbinfo.connectionstatus = '" + ConnectionStatus.ACTIVE.toString() + "'");
        if (ward != null && !ward.isEmpty()) {
            queryStr.append(" and wardboundary.id = '" + ward + "'");
        }
        SQLQuery finalQuery = this.getCurrentSession().createSQLQuery(queryStr.toString());
        Long count = ((BigInteger)finalQuery.uniqueResult()).longValue();
        return count;
    }

    public long getTotalCountFromLimit(String fromAmount, String toAmount, String ward, String topDefaulters) throws ParseException {
        StringBuilder queryStr = new StringBuilder();
        queryStr = queryStr.append("select count(*) from (select * from egwtr_mv_dcb_view dcbinfo").append(" INNER JOIN eg_boundary wardboundary on dcbinfo.wardid = wardboundary.id INNER JOIN eg_boundary localboundary").append(" on dcbinfo.locality = localboundary.id");
        if (Double.parseDouble(toAmount) == 0.0) {
            queryStr.append(" where dcbinfo.arr_balance+dcbinfo.curr_balance >=" + fromAmount);
        } else {
            queryStr.append(" where dcbinfo.arr_balance+dcbinfo.curr_balance >=" + fromAmount + " and dcbinfo.arr_balance+dcbinfo.curr_balance <=" + toAmount);
        }
        queryStr.append(" and dcbinfo.connectionstatus = '" + ConnectionStatus.ACTIVE.toString() + "'");
        if (ward != null && !ward.isEmpty()) {
            queryStr.append(" and wardboundary.id = '" + ward + "'");
        }
        if (!topDefaulters.isEmpty()) {
            queryStr.append(" limit " + topDefaulters);
        }
        queryStr.append(") as count");
        SQLQuery finalQuery = this.getCurrentSession().createSQLQuery(queryStr.toString());
        Long count = ((BigInteger)finalQuery.uniqueResult()).longValue();
        return count;
    }
}

