/*
 * Decompiled with CFR 0.152.
 */
package org.egov.wtms.application.repository;

import java.util.Date;
import java.util.List;
import org.egov.commons.Installment;
import org.egov.demand.model.EgDemand;
import org.egov.demand.model.EgDemandDetails;
import org.egov.demand.model.EgDemandReason;
import org.egov.wtms.application.entity.MeterReadingConnectionDetails;
import org.egov.wtms.application.entity.WaterConnection;
import org.egov.wtms.application.entity.WaterConnectionDetails;
import org.egov.wtms.masters.entity.ApplicationType;
import org.egov.wtms.masters.entity.enums.ConnectionStatus;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@Repository
public interface WaterConnectionDetailsRepository
extends JpaRepository<WaterConnectionDetails, Long> {
    public WaterConnectionDetails findByApplicationNumber(String var1);

    public WaterConnectionDetails findByApplicationNumberAndConnectionStatus(String var1, ConnectionStatus var2);

    public List<WaterConnectionDetails> findAllByApplicationDateOrderByApplicationNumberAsc(Date var1);

    public List<WaterConnectionDetails> findAllByApplicationDateAndConnectionStatusOrderByApplicationNumberAsc(Date var1, ConnectionStatus var2);

    public List<WaterConnectionDetails> findAllByApplicationTypeOrderByApplicationNumberAsc(ApplicationType var1);

    public List<WaterConnectionDetails> findAllByApplicationTypeAndConnectionStatusOrderByApplicationNumberAsc(ApplicationType var1, ConnectionStatus var2);

    @Query(value="select wcd from WaterConnectionDetails wcd where wcd.applicationNumber =:applicationNumber or (wcd.connection.consumerCode =:consumerCode and wcd.connectionStatus =:connectionStatus)")
    public WaterConnectionDetails findConnectionDetailsByApplicationNumberOrConsumerCodeAndConnectionStatus(@Param(value="consumerCode") String var1, @Param(value="applicationNumber") String var2, @Param(value="connectionStatus") ConnectionStatus var3);

    @Query(value="select wcd from WaterConnectionDetails wcd where wcd.connection.consumerCode =:consumerCode or wcd.applicationNumber =:applicationNumber")
    public WaterConnectionDetails findConnectionDetailsByApplicationNumberOrConsumerCode(@Param(value="consumerCode") String var1, @Param(value="applicationNumber") String var2);

    @Query(value="select wcd from WaterConnectionDetails wcd where wcd.connection.consumerCode =:consumerCode and wcd.connectionStatus =:connectionStatus")
    public WaterConnectionDetails findConnectionDetailsByConsumerCodeAndConnectionStatus(@Param(value="consumerCode") String var1, @Param(value="connectionStatus") ConnectionStatus var2);

    @Query(value="select wcd from WaterConnectionDetails wcd where  wcd.connection.parentConnection is null and wcd.connection.consumerCode =:consumerCode and wcd.connectionStatus =:connectionStatus")
    public WaterConnectionDetails findParentConnectionDetailsByConsumerCodeAndConnectionStatus(@Param(value="consumerCode") String var1, @Param(value="connectionStatus") ConnectionStatus var2);

    public WaterConnectionDetails findByConnection(WaterConnection var1);

    public WaterConnectionDetails findByConnectionAndConnectionStatus(WaterConnection var1, ConnectionStatus var2);

    @Query(value="select wcd.waterConnectionDetails from org.egov.wtms.application.entity.WaterDemandConnection wcd where wcd.waterConnectionDetails.applicationNumber=:applicationNumber and wcd.demand.egInstallmentMaster=:installment")
    public WaterConnectionDetails findByApplicationNumberAndInstallment(@Param(value="installment") Installment var1, @Param(value="applicationNumber") String var2);

    @Query(value="select wcd from WaterConnectionDetails wcd where wcd.connection.parentConnection is null and wcd.connectionStatus not in ('INACTIVE') and wcd.connection.propertyIdentifier =:propertyIdentifier")
    public WaterConnectionDetails getPrimaryConnectionDetailsByPropertyID(@Param(value="propertyIdentifier") String var1);

    @Query(value="select wcd from WaterConnectionDetails wcd where wcd.connection.parentConnection is null and wcd.connectionStatus in ('ACTIVE') and wcd.connection.propertyIdentifier =:propertyIdentifier) order by wcd.applicationDate asc ")
    public WaterConnectionDetails getPrimaryConnectionDetailsByPropertyAssessmentNumber(@Param(value="propertyIdentifier") String var1);

    @Query(value="select wcd from WaterConnectionDetails wcd where wcd.applicationType.code not in ('NEWCONNECTION') and  wcd.connectionStatus not in ('INACTIVE') and wcd.connection.propertyIdentifier =:propertyIdentifier")
    public List<WaterConnectionDetails> getChildConnectionDetailsByPropertyID(@Param(value="propertyIdentifier") String var1);

    @Query(value="select wcd from WaterConnectionDetails wcd where wcd.connectionStatus not in ('INACTIVE') and wcd.connection.propertyIdentifier =:propertyIdentifier")
    public List<WaterConnectionDetails> getAllConnectionDetailsExceptInactiveStatusByPropertyID(@Param(value="propertyIdentifier") String var1);

    @Query(value=" from WaterConnectionDetails WCD where WCD.connectionStatus in(:status) and WCD.connection.propertyIdentifier =:propertyIdentifier")
    public WaterConnectionDetails getConnectionDetailsInWorkflow(@Param(value="propertyIdentifier") String var1, @Param(value="status") ConnectionStatus var2);

    public WaterConnectionDetails findByConnection_PropertyIdentifierAndConnectionStatusAndConnection_ParentConnectionIsNull(String var1, ConnectionStatus var2);

    public WaterConnectionDetails findByConnection_ConsumerCodeAndConnectionStatusAndConnection_ParentConnectionIsNotNull(String var1, ConnectionStatus var2);

    @Query(value="select wcd.waterConnectionDetails from org.egov.wtms.application.entity.WaterDemandConnection wcd where wcd.demand=:demand")
    public WaterConnectionDetails findByDemand(@Param(value="demand") EgDemand var1);

    @Query(value="select wcd from MeterReadingConnectionDetails wcd where wcd.waterConnectionDetails.id=:waterConnDetId order by currentReadingDate desc")
    public List<MeterReadingConnectionDetails> findPreviousMeterReadingReading(@Param(value="waterConnDetId") Long var1);

    @Query(value="select wcd from WaterConnectionDetails wcd  where wcd.connection.id  in (select wc.id from WaterConnection wc where wc.parentConnection.id = :parentId) ")
    public List<WaterConnectionDetails> getAllConnectionDetailsByParentConnection(@Param(value="parentId") Long var1);

    public WaterConnectionDetails findByConnectionAndConnectionStatusAndIsHistory(WaterConnection var1, ConnectionStatus var2, Boolean var3);

    @Query(value="select dr from org.egov.demand.model.EgDemandReason dr where dr.egDemandReasonMaster.code =:code")
    public List<EgDemandReason> findDemandReasonByCode(@Param(value="code") String var1);

    @Query(value="select D from EgDemandDetails D where D.id =:detId")
    public EgDemandDetails findEgDemandDetailById(@Param(value="detId") Long var1);

    public WaterConnectionDetails findByConnectionOldConsumerNumberAndConnectionStatus(String var1, ConnectionStatus var2);

    @Query(value="select wcd from WaterConnectionDetails wcd  where wcd.connection.id  in (select wc.id from WaterConnection wc where wc.propertyIdentifier = :propertyId) ")
    public List<WaterConnectionDetails> getAllConnectionDetailsByPropertyID(@Param(value="propertyId") String var1);
}

