/*
 * Decompiled with CFR 0.152.
 */
package org.egov.wtms.masters.service;

import java.util.List;
import org.egov.wtms.masters.entity.PipeSize;
import org.egov.wtms.masters.entity.PropertyPipeSize;
import org.egov.wtms.masters.entity.PropertyType;
import org.egov.wtms.masters.repository.PropertyPipeSizeRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class PropertyPipeSizeService {
    private final PropertyPipeSizeRepository propertyPipeSizeRepository;

    @Autowired
    public PropertyPipeSizeService(PropertyPipeSizeRepository propertyPipeSizeRepository) {
        this.propertyPipeSizeRepository = propertyPipeSizeRepository;
    }

    public PropertyPipeSize findOne(Long propertyPipeSizeId) {
        return (PropertyPipeSize)((Object)this.propertyPipeSizeRepository.findOne(propertyPipeSizeId));
    }

    @Transactional
    public PropertyPipeSize createPropertyPipeSize(PropertyPipeSize propertyPipeSize) {
        propertyPipeSize.setActive(true);
        return (PropertyPipeSize)((Object)this.propertyPipeSizeRepository.save((Object)propertyPipeSize));
    }

    @Transactional
    public void updatePropertyPipeSize(PropertyPipeSize propertyPipeSize) {
        this.propertyPipeSizeRepository.save((Object)propertyPipeSize);
    }

    public PropertyPipeSize findByPropertyTypecodeAndPipeSizecode(String propertyType, String code) {
        return this.propertyPipeSizeRepository.findByPropertyType_codeAndPipeSize_code(propertyType, code);
    }

    public PropertyPipeSize findByPropertyTypeAndPipeSizeInmm(PropertyType propertyType, double sizeInMilimeter) {
        return this.propertyPipeSizeRepository.findByPropertyTypeAndPipeSize_sizeInMilimeter(propertyType, sizeInMilimeter);
    }

    public PropertyPipeSize findByPropertyTypeAndPipeSizecode(PropertyType propertyType, String code) {
        return this.propertyPipeSizeRepository.findByPropertyTypeAndPipeSize_code(propertyType, code);
    }

    public PropertyPipeSize findByPropertyTypeAndPipeSize(PropertyType propertyType, PipeSize pipeSize) {
        return this.propertyPipeSizeRepository.findByPropertyTypeAndPipeSize(propertyType, pipeSize);
    }

    public List<PropertyPipeSize> findAll() {
        return this.propertyPipeSizeRepository.findAll(new Sort(Sort.Direction.DESC, new String[]{"id"}));
    }
}

