/*
 * Decompiled with CFR 0.152.
 */
package org.egov.wtms.application.service;

import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Iterator;
import org.egov.ptis.domain.model.AssessmentDetails;
import org.egov.ptis.domain.model.OwnerName;
import org.egov.ptis.domain.model.enums.BasicPropertyStatus;
import org.egov.ptis.domain.service.property.PropertyExternalService;
import org.egov.wtms.application.entity.WaterConnectionDetails;
import org.egov.wtms.utils.PropertyExtnUtils;
import org.egov.wtms.utils.WaterTaxUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.MessageSource;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Service;

@Service
@Scope(value="prototype")
public class WaterConnectionSmsAndEmailService {
    @Autowired
    private PropertyExtnUtils propertyExtnUtils;
    @Autowired
    private WaterTaxUtils waterTaxUtils;
    private String applicantName;
    @Autowired
    @Qualifier(value="parentMessageSource")
    private MessageSource wcmsMessageSource;

    public void setApplicantName(String applicantName) {
        this.applicantName = applicantName;
    }

    public String getApplicantNameBYAssessmentDetail(WaterConnectionDetails waterConnectionDetails) {
        AssessmentDetails assessmentDetailsfullFlag = this.propertyExtnUtils.getAssessmentDetailsForFlag(waterConnectionDetails.getConnection().getPropertyIdentifier(), PropertyExternalService.FLAG_FULL_DETAILS, BasicPropertyStatus.ALL);
        Iterator ownerNameItr = null;
        if (null != assessmentDetailsfullFlag.getOwnerNames()) {
            ownerNameItr = assessmentDetailsfullFlag.getOwnerNames().iterator();
        }
        StringBuilder consumerName = new StringBuilder();
        if (null != ownerNameItr && ownerNameItr.hasNext()) {
            consumerName.append(((OwnerName)ownerNameItr.next()).getOwnerName());
            while (ownerNameItr.hasNext()) {
                consumerName.append(", ".concat(((OwnerName)ownerNameItr.next()).getOwnerName()));
            }
        }
        this.applicantName = consumerName.toString();
        return this.applicantName;
    }

    public void sendSmsAndEmail(WaterConnectionDetails waterConnectionDetails, String workFlowAction) {
        AssessmentDetails assessmentDetails = this.propertyExtnUtils.getAssessmentDetailsForFlag(waterConnectionDetails.getConnection().getPropertyIdentifier(), PropertyExternalService.FLAG_MOBILE_EMAIL, BasicPropertyStatus.ALL);
        String email = assessmentDetails.getPrimaryEmail();
        String mobileNumber = assessmentDetails.getPrimaryMobileNo();
        if (waterConnectionDetails != null && waterConnectionDetails.getApplicationType() != null && waterConnectionDetails.getApplicationType().getCode() != null && waterConnectionDetails.getStatus() != null && waterConnectionDetails.getStatus().getCode() != null) {
            this.getApplicantNameBYAssessmentDetail(waterConnectionDetails);
            if ("NEWCONNECTION".equalsIgnoreCase(waterConnectionDetails.getApplicationType().getCode())) {
                this.getSmsAndEmailForNewConnection(waterConnectionDetails, email, mobileNumber);
            } else if ("ADDNLCONNECTION".equalsIgnoreCase(waterConnectionDetails.getApplicationType().getCode())) {
                this.getSmsAndEmailForAdditionalConnection(waterConnectionDetails, email, mobileNumber);
            } else if ("CHANGEOFUSE".equalsIgnoreCase(waterConnectionDetails.getApplicationType().getCode())) {
                this.getSmsAndEmailForChangeOfUsageConnection(waterConnectionDetails, email, mobileNumber);
            } else if ("CLOSINGCONNECTION".equalsIgnoreCase(waterConnectionDetails.getApplicationType().getCode())) {
                this.getSmsAndEmailForClosingConnection(waterConnectionDetails, email, mobileNumber);
            } else if ("RECONNECTION".equalsIgnoreCase(waterConnectionDetails.getApplicationType().getCode())) {
                this.getSmsAndEmailForReConnection(waterConnectionDetails, email, mobileNumber);
            }
        }
    }

    private void getSmsAndEmailForChangeOfUsageConnection(WaterConnectionDetails waterConnectionDetails, String email, String mobileNumber) {
        String smsMsg = null;
        String body = "";
        String subject = "";
        if (waterConnectionDetails.getState().getHistory().isEmpty() && "CREATED".equalsIgnoreCase(waterConnectionDetails.getStatus().getCode())) {
            smsMsg = this.smsBodyByCodeAndArgsWithType("msg.changeofuseconncetioncreate.sms", waterConnectionDetails, this.applicantName, "changeofusecreate");
            body = this.emailBodyByCodeAndArgsWithType("msg.changeofuseconncetioncreate.email.body", waterConnectionDetails, this.applicantName, "changeofusecreate");
            subject = this.waterTaxUtils.emailSubjectforEmailByCodeAndArgs("msg.changeofuseconncetioncreate.email.subject", waterConnectionDetails.getApplicationNumber());
        } else if ("APPROVED".equalsIgnoreCase(waterConnectionDetails.getStatus().getCode())) {
            smsMsg = this.smsBodyByCodeAndArgsWithType("msg.changeofuseconnection.approval.sms", waterConnectionDetails, this.applicantName, "changeofuseapprove");
            body = this.emailBodyByCodeAndArgsWithType("msg.changeofuseconnection.approval.email.body", waterConnectionDetails, this.applicantName, "changeofuseapprove");
            subject = this.waterTaxUtils.emailSubjectforEmailByCodeAndArgs("msg.changeofuseconnection.approval.subject", waterConnectionDetails.getApplicationNumber());
        } else if ("ESTIMATIONNOTICEGENERATED".equalsIgnoreCase(waterConnectionDetails.getStatus().getCode())) {
            if (!"BPL".equalsIgnoreCase(waterConnectionDetails.getCategory().getName())) {
                smsMsg = this.smsBodyByCodeAndArgsWithType("msg.changeofuseconnection.notice.gen", waterConnectionDetails, this.applicantName, "changeofusenotice");
                body = this.emailBodyByCodeAndArgsWithType("msg.changeofuseconnection.notice.email.body", waterConnectionDetails, this.applicantName, "changeofusenotice");
                subject = this.waterTaxUtils.emailSubjectforEmailByCodeAndArgs("msg.changeofuseconnection.notice.email.subject", waterConnectionDetails.getApplicationNumber());
            } else {
                body = this.emailBodyByCodeAndArgsWithType("msg.noticegen.for.bpl.email.body", waterConnectionDetails, this.applicantName, "changeofusenotice");
                subject = this.waterTaxUtils.emailSubjectforEmailByCodeAndArgs("msg.noticegen.for.bpl.email.subject", waterConnectionDetails.getApplicationNumber());
                smsMsg = this.smsBodyByCodeAndArgsWithType("msg.noticegen.for.bpl.sms", waterConnectionDetails, this.applicantName, "changeofusenotice");
            }
        } else if ("ESTIMATIONAMOUNTPAID".equalsIgnoreCase(waterConnectionDetails.getStatus().getCode())) {
            smsMsg = this.smsBodyByCodeAndArgsWithType("msg.newconncetionOnFeesPaid.sms", waterConnectionDetails, this.applicantName, "changeofusefeepaid");
            body = this.emailBodyByCodeAndArgsWithType("msg.addconncetionOnfeespaid.email.body", waterConnectionDetails, this.applicantName, "changeofusefeepaid");
            StringBuilder emailSubject = new StringBuilder(" Demand and donation amount received for water tax application ");
            emailSubject.append(waterConnectionDetails.getApplicationNumber());
            subject = emailSubject.toString();
        } else if ("SANCTIONED".equalsIgnoreCase(waterConnectionDetails.getStatus().getCode())) {
            if (!"Metered".toUpperCase().equalsIgnoreCase(waterConnectionDetails.getConnectionType().toString())) {
                smsMsg = this.smsBodyByCodeAndArgsWithType("msg.newconncetionOnExecutionDate.sms", waterConnectionDetails, this.applicantName, "changeofuseexecution");
                body = this.emailBodyByCodeAndArgsWithType("msg.newconncetionOnExecutionDate.email.body", waterConnectionDetails, this.applicantName, "changeofuseexecution");
            } else {
                body = this.emailBodyByCodeAndArgsWithType("msg.conncetionexeuction.metered.email.body", waterConnectionDetails, this.applicantName, "changeofuseexecution");
                smsMsg = this.smsBodyByCodeAndArgsWithType("msg.conncetionexeuction.metered.sms", waterConnectionDetails, this.applicantName, "changeofuseexecution");
            }
            subject = this.waterTaxUtils.emailSubjectforEmailByCodeAndArgs("msg.newconncetionOnExecutionDate.email.subject", waterConnectionDetails.getConnection().getConsumerCode());
        }
        if (mobileNumber != null && smsMsg != null) {
            this.waterTaxUtils.sendSMSOnWaterConnection(mobileNumber, smsMsg);
        }
        if (email != null && body != null) {
            this.waterTaxUtils.sendEmailOnWaterConnection(email, body, subject);
        }
    }

    private void getSmsAndEmailForAdditionalConnection(WaterConnectionDetails waterConnectionDetails, String email, String mobileNumber) {
        String smsMsg = null;
        String body = "";
        String subject = "";
        if (waterConnectionDetails.getState().getHistory().isEmpty() && "CREATED".equalsIgnoreCase(waterConnectionDetails.getStatus().getCode())) {
            smsMsg = this.smsBodyByCodeAndArgsWithType("msg.additionalconncetioncreate.sms", waterConnectionDetails, this.applicantName, "additionalconncreate");
            body = this.emailBodyByCodeAndArgsWithType("msg.additionalconnectioncreate.email.body", waterConnectionDetails, this.applicantName, "additionalconncreate");
            subject = this.waterTaxUtils.emailSubjectforEmailByCodeAndArgs("msg.additionalconnectioncreate.email.subject", waterConnectionDetails.getApplicationNumber());
        } else if ("APPROVED".equalsIgnoreCase(waterConnectionDetails.getStatus().getCode())) {
            smsMsg = this.smsBodyByCodeAndArgsWithType("msg.additionalconncetionapproval.sms", waterConnectionDetails, this.applicantName, "additionalconnapprove");
            body = this.emailBodyByCodeAndArgsWithType("msg.additionalconncetionapproval.email.body", waterConnectionDetails, this.applicantName, "additionalconnapprove");
            subject = this.waterTaxUtils.emailSubjectforEmailByCodeAndArgs("msg.additionalconncetionapproval.email.subject", waterConnectionDetails.getApplicationNumber());
        } else if ("ESTIMATIONNOTICEGENERATED".equalsIgnoreCase(waterConnectionDetails.getStatus().getCode())) {
            if (!"BPL".equalsIgnoreCase(waterConnectionDetails.getCategory().getName())) {
                smsMsg = this.smsBodyByCodeAndArgsWithType("msg.addconncetionOnGenerateNotice.sms", waterConnectionDetails, this.applicantName, "addconnestnotice");
                body = this.emailBodyByCodeAndArgsWithType("msg.addconncetionOnGenerateNotice.email.body", waterConnectionDetails, this.applicantName, "addconnestnotice");
                subject = this.waterTaxUtils.emailSubjectforEmailByCodeAndArgs("msg.conncetionOnGenerateNotice.email.subject", waterConnectionDetails.getApplicationNumber());
            } else {
                smsMsg = this.smsBodyByCodeAndArgsWithType("msg.noticegen.for.bpl.sms", waterConnectionDetails, this.applicantName, "addconnestnotice");
                body = this.emailBodyByCodeAndArgsWithType("msg.noticegen.for.bpl.email.body", waterConnectionDetails, this.applicantName, "addconnestnotice");
                subject = this.waterTaxUtils.emailSubjectforEmailByCodeAndArgs("msg.noticegen.for.bpl.email.subject", waterConnectionDetails.getApplicationNumber());
            }
        } else if ("ESTIMATIONAMOUNTPAID".equalsIgnoreCase(waterConnectionDetails.getStatus().getCode())) {
            smsMsg = this.smsBodyByCodeAndArgsWithType("msg.newconncetionOnFeesPaid.sms", waterConnectionDetails, this.applicantName, "newconnfeepaid");
            body = this.emailBodyByCodeAndArgsWithType("msg.addconncetionOnfeespaid.email.body", waterConnectionDetails, this.applicantName, "newconnfeepaid");
            StringBuilder emailSubject = new StringBuilder(" Demand and donation amount received for water tax application ");
            emailSubject.append(waterConnectionDetails.getApplicationNumber());
            subject = emailSubject.toString();
        } else if ("SANCTIONED".equalsIgnoreCase(waterConnectionDetails.getStatus().getCode())) {
            if (!"Metered".toUpperCase().equalsIgnoreCase(waterConnectionDetails.getConnectionType().toString())) {
                smsMsg = this.smsBodyByCodeAndArgsWithType("msg.newconncetionOnExecutionDate.sms", waterConnectionDetails, this.applicantName, "newconnexecutiondate");
                body = this.emailBodyByCodeAndArgsWithType("msg.newconncetionOnExecutionDate.email.body", waterConnectionDetails, this.applicantName, "newconnexecutiondate");
            } else {
                body = this.emailBodyByCodeAndArgsWithType("msg.conncetionexeuction.metered.email.body", waterConnectionDetails, this.applicantName, "newconnexecutiondate");
                smsMsg = this.smsBodyByCodeAndArgsWithType("msg.conncetionexeuction.metered.sms", waterConnectionDetails, this.applicantName, "newconnexecutiondate");
            }
            subject = this.waterTaxUtils.emailSubjectforEmailByCodeAndArgs("msg.newconncetionOnExecutionDate.email.subject", waterConnectionDetails.getConnection().getConsumerCode());
        }
        if (mobileNumber != null && smsMsg != null) {
            this.waterTaxUtils.sendSMSOnWaterConnection(mobileNumber, smsMsg);
        }
        if (email != null && body != null) {
            this.waterTaxUtils.sendEmailOnWaterConnection(email, body, subject);
        }
    }

    public void getSmsAndEmailForNewConnection(WaterConnectionDetails waterConnectionDetails, String email, String mobileNumber) {
        String smsMsg = null;
        String body = "";
        String subject = "";
        if (waterConnectionDetails.getState().getHistory().isEmpty() && "CREATED".equalsIgnoreCase(waterConnectionDetails.getStatus().getCode())) {
            smsMsg = this.smsBodyByCodeAndArgsWithType("msg.newconncetioncreate.sms", waterConnectionDetails, this.applicantName, "newconncreate");
            body = this.emailBodyByCodeAndArgsWithType("msg.newconncetioncreate.email.body", waterConnectionDetails, this.applicantName, "newconncreate");
            subject = this.waterTaxUtils.emailSubjectforEmailByCodeAndArgs("msg.newconncetioncreate.email.subject", waterConnectionDetails.getApplicationNumber());
        } else if ("APPROVED".equalsIgnoreCase(waterConnectionDetails.getStatus().getCode())) {
            smsMsg = this.smsBodyByCodeAndArgsWithType("msg.newconncetionapproval.sms", waterConnectionDetails, this.applicantName, "newconnapprove");
            body = this.emailBodyByCodeAndArgsWithType("msg.newconncetionapproval.email.body", waterConnectionDetails, this.applicantName, "newconnapprove");
            subject = this.waterTaxUtils.emailSubjectforEmailByCodeAndArgs("msg.newconncetionapprove.email.subject", waterConnectionDetails.getApplicationNumber());
        } else if ("ESTIMATIONNOTICEGENERATED".equalsIgnoreCase(waterConnectionDetails.getStatus().getCode())) {
            if (!"BPL".equalsIgnoreCase(waterConnectionDetails.getCategory().getName())) {
                smsMsg = this.smsBodyByCodeAndArgsWithType("msg.newconncetionOnGenerateNotice.sms", waterConnectionDetails, this.applicantName, "newconnestnotice");
                body = this.emailBodyByCodeAndArgsWithType("msg.newconncetionOnGenerateNotice.email.body", waterConnectionDetails, this.applicantName, "newconnestnotice");
                subject = this.waterTaxUtils.emailSubjectforEmailByCodeAndArgs("msg.conncetionOnGenerateNotice.email.subject", waterConnectionDetails.getApplicationNumber());
            } else {
                smsMsg = this.smsBodyByCodeAndArgsWithType("msg.noticegen.for.bpl.sms", waterConnectionDetails, this.applicantName, "newconnestnotice");
                body = this.emailBodyByCodeAndArgsWithType("msg.noticegen.for.bpl.email.body", waterConnectionDetails, this.applicantName, "newconnestnotice");
                subject = this.waterTaxUtils.emailSubjectforEmailByCodeAndArgs("msg.noticegen.for.bpl.email.subject", waterConnectionDetails.getApplicationNumber());
            }
        } else if ("ESTIMATIONAMOUNTPAID".equalsIgnoreCase(waterConnectionDetails.getStatus().getCode())) {
            smsMsg = this.smsBodyByCodeAndArgsWithType("msg.newconncetionOnFeesPaid.sms", waterConnectionDetails, this.applicantName, "newconnfeepaid");
            body = this.emailBodyByCodeAndArgsWithType("msg.addconncetionOnfeespaid.email.body", waterConnectionDetails, this.applicantName, "newconnfeepaid");
            StringBuilder emailSubject = new StringBuilder(" Demand and donation amount received for water tax application ");
            emailSubject.append(waterConnectionDetails.getApplicationNumber());
            subject = emailSubject.toString();
        } else if ("SANCTIONED".equalsIgnoreCase(waterConnectionDetails.getStatus().getCode())) {
            if (!"Metered".toUpperCase().equalsIgnoreCase(waterConnectionDetails.getConnectionType().toString())) {
                smsMsg = this.smsBodyByCodeAndArgsWithType("msg.newconncetionOnExecutionDate.sms", waterConnectionDetails, this.applicantName, "newconnexecutiondate");
                body = this.emailBodyByCodeAndArgsWithType("msg.newconncetionOnExecutionDate.email.body", waterConnectionDetails, this.applicantName, "newconnexecutiondate");
            } else {
                smsMsg = this.smsBodyByCodeAndArgsWithType("msg.conncetionexeuction.metered.sms", waterConnectionDetails, this.applicantName, "newconnexecutiondate");
                body = this.emailBodyByCodeAndArgsWithType("msg.conncetionexeuction.metered.email.body", waterConnectionDetails, this.applicantName, "newconnexecutiondate");
            }
            subject = this.waterTaxUtils.emailSubjectforEmailByCodeAndArgs("msg.newconncetionOnExecutionDate.email.subject", waterConnectionDetails.getConnection().getConsumerCode());
        }
        if (mobileNumber != null && smsMsg != null) {
            this.waterTaxUtils.sendSMSOnWaterConnection(mobileNumber, smsMsg);
        }
        if (email != null && body != null) {
            this.waterTaxUtils.sendEmailOnWaterConnection(email, body, subject);
        }
    }

    public void sendSmsAndEmailOnRejection(WaterConnectionDetails waterConnectionDetails, String approvalComent) {
        if ((waterConnectionDetails.getApplicationType().getCode().equals("NEWCONNECTION") || waterConnectionDetails.getApplicationType().getCode().equalsIgnoreCase("ADDNLCONNECTION") || waterConnectionDetails.getApplicationType().getCode().equalsIgnoreCase("CHANGEOFUSE")) && waterConnectionDetails.getStatus().getCode().equals("CANCELLED")) {
            AssessmentDetails assessmentDetails = this.propertyExtnUtils.getAssessmentDetailsForFlag(waterConnectionDetails.getConnection().getPropertyIdentifier(), PropertyExternalService.FLAG_MOBILE_EMAIL, BasicPropertyStatus.ALL);
            String email = assessmentDetails.getPrimaryEmail();
            String mobileNumber = assessmentDetails.getPrimaryMobileNo();
            this.getApplicantNameBYAssessmentDetail(waterConnectionDetails);
            String smsMsg = "";
            String body = "";
            String subject = "";
            if (this.waterTaxUtils.isSmsEnabled().booleanValue() && mobileNumber != null) {
                StringBuilder smsBody;
                if (waterConnectionDetails.getApplicationType().getCode().equals("NEWCONNECTION")) {
                    smsBody = new StringBuilder().append("Dear ").append(this.applicantName).append(",Your new water tap connection application is being rejected and ").append("the reason for rejection ").append(approvalComent).append(" Please get in touch with ULB official to raise a new application with proper information to get a water connection.").append("\nThanks,").append(this.waterTaxUtils.getMunicipalityName());
                    smsMsg = smsBody.toString();
                } else if (waterConnectionDetails.getApplicationType().getCode().equals("ADDNLCONNECTION")) {
                    smsBody = new StringBuilder().append("Dear ").append(this.applicantName).append(",Your additional water tap connection application is being rejected and ").append("the reason for rejection ").append(approvalComent).append(" Please get in touch with ULB official to raise a new application with proper information to get a water connection.").append("\nThanks,").append(this.waterTaxUtils.getMunicipalityName());
                    smsMsg = smsBody.toString();
                } else if (waterConnectionDetails.getApplicationType().getCode().equals("CHANGEOFUSE")) {
                    smsBody = new StringBuilder().append("Dear ").append(this.applicantName).append(",Your change of use  connection application is being rejected and ").append("the reason for rejection ").append(approvalComent).append(" Please get in touch with ULB official to raise a new application with proper information to get a water connection.").append("\nThanks,").append(this.waterTaxUtils.getMunicipalityName());
                    smsMsg = smsBody.toString();
                }
                this.waterTaxUtils.sendSMSOnWaterConnection(mobileNumber, smsMsg);
            }
            if (this.waterTaxUtils.isSmsEnabled().booleanValue() && email != null) {
                StringBuilder bodyMsg;
                if (waterConnectionDetails.getApplicationType().getCode().equals("NEWCONNECTION")) {
                    bodyMsg = new StringBuilder().append("Dear ").append(this.applicantName).append(",\n\nYour new water tap connection application is being rejected and the reason for rejection ").append(approvalComent).append("\n \n Please get in touch with ULB official to raise a new application with proper information to get a water connection.").append("\n\nThis is computer generated email and does not need any signature and also please  do not reply to this email.").append("\n\nThanks ,\n").append(this.waterTaxUtils.getMunicipalityName());
                    StringBuilder subjectMsg = new StringBuilder().append("Water tap connection application").append(waterConnectionDetails.getApplicationNumber()).append("rejected.");
                    body = bodyMsg.toString();
                    subject = subjectMsg.toString();
                } else if (waterConnectionDetails.getApplicationType().getCode().equals("ADDNLCONNECTION")) {
                    bodyMsg = new StringBuilder().append("Dear ").append(this.applicantName).append(",\n\nYour Additional water tap connection application is being rejected and the reason for rejection ").append(approvalComent).append("\n \n Please get in touch with ULB official to raise a new application with proper information to get a water connection.").append("\n\nThis is computer generated email and does not need any signature and also please  do not reply to this email.").append("\n\nThanks ,\n").append(this.waterTaxUtils.getMunicipalityName());
                    body = bodyMsg.toString();
                    StringBuilder subjectMsg = new StringBuilder().append("Water tap connection application").append(waterConnectionDetails.getApplicationNumber()).append("rejected.");
                    subject = subjectMsg.toString();
                } else if (waterConnectionDetails.getApplicationType().getCode().equals("CHANGEOFUSE")) {
                    bodyMsg = new StringBuilder().append("Dear ").append(this.applicantName).append(",\n\nYour Change Of use water tap connection application is being rejected and the reason for rejection ").append(approvalComent).append("\n \n Please get in touch with ULB official to raise a new application with proper information to get a water connection.").append("\n\nThis is computer generated email and does not need any signature and also please  do not reply to this email.").append("\n\nThanks ,\n").append(this.waterTaxUtils.getMunicipalityName());
                    body = bodyMsg.toString();
                    StringBuilder subjectMsg = new StringBuilder().append("Water tap connection application").append(waterConnectionDetails.getApplicationNumber()).append("rejected.");
                    subject = subjectMsg.toString();
                }
                this.waterTaxUtils.sendEmailOnWaterConnection(email, body, subject);
            }
        }
    }

    public String smsAndEmailBodyByCodeAndArgs(String code, WaterConnectionDetails waterConnectionDetails, String applicantName) {
        String smsMsg = this.wcmsMessageSource.getMessage(code, (Object[])new String[]{applicantName, waterConnectionDetails.getApplicationNumber(), this.waterTaxUtils.getMunicipalityName()}, null);
        return smsMsg;
    }

    public String emailBodyByCodeAndArgsWithType(String code, WaterConnectionDetails waterConnectionDetails, String applicantName, String type) {
        String emailBody = "";
        DecimalFormat amountFormat = new DecimalFormat("#.00");
        if (type.equalsIgnoreCase("newconncreate") || type.equalsIgnoreCase("additionalconncreate")) {
            emailBody = this.wcmsMessageSource.getMessage(code, (Object[])new String[]{applicantName, waterConnectionDetails.getApplicationNumber(), this.waterTaxUtils.getMunicipalityName()}, null);
        } else if (type.equalsIgnoreCase("newconnapprove") || type.equalsIgnoreCase("additionalconnapprove")) {
            emailBody = this.wcmsMessageSource.getMessage(code, (Object[])new String[]{applicantName, waterConnectionDetails.getApplicationNumber(), waterConnectionDetails.getConnection().getConsumerCode(), this.waterTaxUtils.getMunicipalityName()}, null);
        } else if (type.equalsIgnoreCase("newconnestnotice") || type.equalsIgnoreCase("addconnestnotice")) {
            emailBody = !"BPL".equalsIgnoreCase(waterConnectionDetails.getCategory().getName()) ? this.wcmsMessageSource.getMessage(code, (Object[])new String[]{applicantName, waterConnectionDetails.getApplicationNumber(), String.valueOf(amountFormat.format(waterConnectionDetails.getDonationCharges())), String.valueOf(amountFormat.format(waterConnectionDetails.getFieldInspectionDetails().getEstimationCharges())), String.valueOf(amountFormat.format(waterConnectionDetails.getDonationCharges() + waterConnectionDetails.getFieldInspectionDetails().getEstimationCharges())), this.waterTaxUtils.getMunicipalityName()}, null) : this.wcmsMessageSource.getMessage(code, (Object[])new String[]{applicantName, "NEWCONNECTION".equalsIgnoreCase(waterConnectionDetails.getApplicationType().getCode()) ? "new water" : "additioanl water", waterConnectionDetails.getApplicationNumber(), String.valueOf(amountFormat.format(waterConnectionDetails.getFieldInspectionDetails().getEstimationCharges())), this.waterTaxUtils.getMunicipalityName()}, null);
        } else if (type.equalsIgnoreCase("newconnexecutiondate") || type.equalsIgnoreCase("changeofuseexecution")) {
            SimpleDateFormat formatter = new SimpleDateFormat("dd/MM/yyyy");
            emailBody = !"Metered".toUpperCase().equalsIgnoreCase(waterConnectionDetails.getConnectionType().toString()) ? this.wcmsMessageSource.getMessage(code, (Object[])new String[]{applicantName, waterConnectionDetails.getConnection().getConsumerCode(), formatter.format(waterConnectionDetails.getExecutionDate()).toString(), amountFormat.format(this.waterTaxUtils.getCurrentDemand(waterConnectionDetails).getDemand().getBaseDemand()).toString(), this.waterTaxUtils.getMunicipalityName()}, null) : this.wcmsMessageSource.getMessage(code, (Object[])new String[]{applicantName, waterConnectionDetails.getConnection().getConsumerCode(), formatter.format(waterConnectionDetails.getExecutionDate()).toString(), this.waterTaxUtils.getMunicipalityName()}, null);
        } else if (type.equalsIgnoreCase("newconnfeepaid") || type.equalsIgnoreCase("addconnfeepaid") || type.equalsIgnoreCase("changeofusefeepaid")) {
            String amountToDisplay = String.valueOf(amountFormat.format(waterConnectionDetails.getDonationCharges() + waterConnectionDetails.getFieldInspectionDetails().getEstimationCharges()));
            StringBuilder emailBodyBuilder = new StringBuilder().append("Dear ").append(applicantName).append(",").append("\n\nWe have received Estimation and donation amount of Rs.").append(amountToDisplay).append("/- against your water connection application number ").append(waterConnectionDetails.getApplicationNumber()).append(".We will be now processing your application to issue an work order.\n\nThis is computer generated email and does not need any signature and also please do not reply to this email.\n\nRegards,").append("\n").append(this.waterTaxUtils.getMunicipalityName());
            emailBody = emailBodyBuilder.toString();
        } else if ("changeofusecreate".equalsIgnoreCase(type)) {
            emailBody = this.wcmsMessageSource.getMessage(code, (Object[])new String[]{applicantName, waterConnectionDetails.getConnection().getConsumerCode(), waterConnectionDetails.getApplicationNumber(), this.waterTaxUtils.getMunicipalityName()}, null);
        } else if ("changeofuseapprove".equalsIgnoreCase(type)) {
            emailBody = this.wcmsMessageSource.getMessage(code, (Object[])new String[]{applicantName, waterConnectionDetails.getConnection().getConsumerCode(), this.waterTaxUtils.getMunicipalityName()}, null);
        } else if ("changeofusenotice".equalsIgnoreCase(type)) {
            emailBody = !"BPL".equalsIgnoreCase(waterConnectionDetails.getCategory().getName()) ? this.wcmsMessageSource.getMessage(code, (Object[])new String[]{applicantName, waterConnectionDetails.getApplicationNumber(), String.valueOf(amountFormat.format(waterConnectionDetails.getDonationCharges())), String.valueOf(amountFormat.format(waterConnectionDetails.getFieldInspectionDetails().getEstimationCharges())), String.valueOf(amountFormat.format(waterConnectionDetails.getDonationCharges() + waterConnectionDetails.getFieldInspectionDetails().getEstimationCharges())), this.waterTaxUtils.getMunicipalityName()}, null) : this.wcmsMessageSource.getMessage(code, (Object[])new String[]{applicantName, "change of", waterConnectionDetails.getApplicationNumber(), String.valueOf(amountFormat.format(waterConnectionDetails.getFieldInspectionDetails().getEstimationCharges())), this.waterTaxUtils.getMunicipalityName()}, null);
        } else if ("closureofconnectionapprove".equalsIgnoreCase(type)) {
            emailBody = this.wcmsMessageSource.getMessage(code, (Object[])new String[]{applicantName, waterConnectionDetails.getApplicationNumber(), this.waterTaxUtils.getMunicipalityName()}, null);
        } else if ("closureofconnectionsanctioned".equalsIgnoreCase(type)) {
            emailBody = this.wcmsMessageSource.getMessage(code, (Object[])new String[]{applicantName, waterConnectionDetails.getApplicationNumber(), this.waterTaxUtils.getMunicipalityName()}, null);
        } else if ("reconnectionofconnectionapprove".equalsIgnoreCase(type)) {
            emailBody = this.wcmsMessageSource.getMessage(code, (Object[])new String[]{applicantName, waterConnectionDetails.getApplicationNumber(), this.waterTaxUtils.getMunicipalityName()}, null);
        } else if ("reconnectionofconnectionsanctioned".equalsIgnoreCase(type)) {
            emailBody = this.wcmsMessageSource.getMessage(code, (Object[])new String[]{applicantName, waterConnectionDetails.getApplicationNumber(), this.waterTaxUtils.getMunicipalityName()}, null);
        }
        return emailBody;
    }

    public String smsBodyByCodeAndArgsWithType(String code, WaterConnectionDetails waterConnectionDetails, String applicantName, String type) {
        String smsMsg = "";
        DecimalFormat amountFormat = new DecimalFormat("#.00");
        if (type.equalsIgnoreCase("newconncreate") || type.equalsIgnoreCase("additionalconncreate")) {
            smsMsg = this.wcmsMessageSource.getMessage(code, (Object[])new String[]{applicantName, waterConnectionDetails.getApplicationNumber(), this.waterTaxUtils.getMunicipalityName()}, null);
        } else if (type.equalsIgnoreCase("newconnapprove") || type.equalsIgnoreCase("additionalconnapprove")) {
            smsMsg = this.wcmsMessageSource.getMessage(code, (Object[])new String[]{applicantName, waterConnectionDetails.getApplicationNumber(), waterConnectionDetails.getConnection().getConsumerCode(), this.waterTaxUtils.getMunicipalityName()}, null);
        } else if (type.equalsIgnoreCase("newconnestnotice") || type.equalsIgnoreCase("addconnestnotice")) {
            smsMsg = !"BPL".equalsIgnoreCase(waterConnectionDetails.getCategory().getName()) ? this.wcmsMessageSource.getMessage(code, (Object[])new String[]{applicantName, waterConnectionDetails.getApplicationNumber(), String.valueOf(amountFormat.format(waterConnectionDetails.getDonationCharges())), String.valueOf(amountFormat.format(waterConnectionDetails.getFieldInspectionDetails().getEstimationCharges())), String.valueOf(amountFormat.format(waterConnectionDetails.getDonationCharges() + waterConnectionDetails.getFieldInspectionDetails().getEstimationCharges())), this.waterTaxUtils.getMunicipalityName()}, null) : this.wcmsMessageSource.getMessage(code, (Object[])new String[]{applicantName, "NEWCONNECTION".equalsIgnoreCase(waterConnectionDetails.getApplicationType().getCode()) ? "new water" : "additional water", waterConnectionDetails.getApplicationNumber(), String.valueOf(amountFormat.format(waterConnectionDetails.getFieldInspectionDetails().getEstimationCharges())), this.waterTaxUtils.getMunicipalityName()}, null);
        } else if (type.equalsIgnoreCase("newconnexecutiondate") || type.equalsIgnoreCase("changeofuseexecution")) {
            SimpleDateFormat formatter = new SimpleDateFormat("dd/MM/yyyy");
            smsMsg = !"Metered".toUpperCase().equalsIgnoreCase(waterConnectionDetails.getConnectionType().toString()) ? this.wcmsMessageSource.getMessage(code, (Object[])new String[]{applicantName, waterConnectionDetails.getConnection().getConsumerCode(), formatter.format(waterConnectionDetails.getExecutionDate()).toString(), amountFormat.format(this.waterTaxUtils.getCurrentDemand(waterConnectionDetails).getDemand().getBaseDemand()).toString(), this.waterTaxUtils.getMunicipalityName()}, null) : this.wcmsMessageSource.getMessage(code, (Object[])new String[]{applicantName, waterConnectionDetails.getConnection().getConsumerCode(), formatter.format(waterConnectionDetails.getExecutionDate()).toString(), this.waterTaxUtils.getMunicipalityName()}, null);
        } else if (type.equalsIgnoreCase("newconnfeepaid") || type.equalsIgnoreCase("addconnfeepaid") || type.equalsIgnoreCase("changeofusefeepaid")) {
            String amountToDisplay = String.valueOf(amountFormat.format(waterConnectionDetails.getDonationCharges() + waterConnectionDetails.getFieldInspectionDetails().getEstimationCharges()));
            StringBuilder smsBody = new StringBuilder().append("Dear ").append(applicantName).append(",We have received Estimation and donation amount of Rs.").append(amountToDisplay).append("/- against your water connection application number ").append(waterConnectionDetails.getApplicationNumber()).append(".We will be now processing your application to issue an work order.\nThanks,\n").append(this.waterTaxUtils.getMunicipalityName());
            smsMsg = smsBody.toString();
        } else if ("changeofusecreate".equalsIgnoreCase(type)) {
            smsMsg = this.wcmsMessageSource.getMessage(code, (Object[])new String[]{applicantName, waterConnectionDetails.getConnection().getConsumerCode(), waterConnectionDetails.getApplicationNumber(), this.waterTaxUtils.getMunicipalityName()}, null);
        } else if ("changeofuseapprove".equalsIgnoreCase(type)) {
            smsMsg = this.wcmsMessageSource.getMessage(code, (Object[])new String[]{applicantName, waterConnectionDetails.getConnection().getConsumerCode(), this.waterTaxUtils.getMunicipalityName()}, null);
        } else if ("changeofusenotice".equalsIgnoreCase(type)) {
            smsMsg = !"BPL".equalsIgnoreCase(waterConnectionDetails.getCategory().getName()) ? this.wcmsMessageSource.getMessage(code, (Object[])new String[]{applicantName, waterConnectionDetails.getApplicationNumber(), String.valueOf(amountFormat.format(waterConnectionDetails.getDonationCharges())), String.valueOf(amountFormat.format(waterConnectionDetails.getFieldInspectionDetails().getEstimationCharges())), String.valueOf(amountFormat.format(waterConnectionDetails.getDonationCharges() + waterConnectionDetails.getFieldInspectionDetails().getEstimationCharges())), this.waterTaxUtils.getMunicipalityName()}, null) : this.wcmsMessageSource.getMessage(code, (Object[])new String[]{applicantName, "change of", waterConnectionDetails.getApplicationNumber(), String.valueOf(amountFormat.format(waterConnectionDetails.getFieldInspectionDetails().getEstimationCharges())), this.waterTaxUtils.getMunicipalityName()}, null);
        } else if ("closureofconnectionapprove".equalsIgnoreCase(type)) {
            smsMsg = this.wcmsMessageSource.getMessage(code, (Object[])new String[]{applicantName, waterConnectionDetails.getApplicationNumber(), this.waterTaxUtils.getMunicipalityName()}, null);
        } else if ("closureofconnectionsanctioned".equalsIgnoreCase(type)) {
            smsMsg = this.wcmsMessageSource.getMessage(code, (Object[])new String[]{applicantName, waterConnectionDetails.getApplicationNumber(), this.waterTaxUtils.getMunicipalityName()}, null);
        } else if ("reconnectionofconnectionapprove".equalsIgnoreCase(type)) {
            smsMsg = this.wcmsMessageSource.getMessage(code, (Object[])new String[]{applicantName, waterConnectionDetails.getApplicationNumber(), this.waterTaxUtils.getMunicipalityName()}, null);
        } else if ("reconnectionofconnectionsanctioned".equalsIgnoreCase(type)) {
            smsMsg = this.wcmsMessageSource.getMessage(code, (Object[])new String[]{applicantName, waterConnectionDetails.getApplicationNumber(), this.waterTaxUtils.getMunicipalityName()}, null);
        }
        return smsMsg;
    }

    public void getSmsAndEmailForClosingConnection(WaterConnectionDetails waterConnectionDetails, String email, String mobileNumber) {
        String smsMsg = null;
        String body = "";
        String subject = "";
        if ("CLOSERAPPROVED".equalsIgnoreCase(waterConnectionDetails.getStatus().getCode())) {
            smsMsg = this.smsBodyByCodeAndArgsWithType("msg.closeconnection.approve.sms", waterConnectionDetails, this.applicantName, "closureofconnectionapprove");
            body = this.emailBodyByCodeAndArgsWithType("msg.closeconnection.approve.body", waterConnectionDetails, this.applicantName, "closureofconnectionapprove");
            subject = this.waterTaxUtils.emailSubjectforEmailByCodeAndArgs("msg.closeofconnectionapprove.email.subject", waterConnectionDetails.getApplicationNumber());
        } else if ("CLOSERSANCTIONED".equalsIgnoreCase(waterConnectionDetails.getStatus().getCode())) {
            smsMsg = this.smsBodyByCodeAndArgsWithType("msg.closeconnection.sanctioned.sms", waterConnectionDetails, this.applicantName, "closureofconnectionsanctioned");
            body = this.emailBodyByCodeAndArgsWithType("msg.closeconnection.sanctioned.body", waterConnectionDetails, this.applicantName, "closureofconnectionsanctioned");
            subject = this.waterTaxUtils.emailSubjectforEmailByCodeAndArgs("msg.closeofconnectionsanctioned.email.subject", waterConnectionDetails.getApplicationNumber());
        }
        if (mobileNumber != null && smsMsg != null) {
            this.waterTaxUtils.sendSMSOnWaterConnection(mobileNumber, smsMsg);
        }
        if (email != null && body != null) {
            this.waterTaxUtils.sendEmailOnWaterConnection(email, body, subject);
        }
    }

    public void getSmsAndEmailForReConnection(WaterConnectionDetails waterConnectionDetails, String email, String mobileNumber) {
        String smsMsg = null;
        String body = "";
        String subject = "";
        if ("RECONNECTIONAPPROVED".equalsIgnoreCase(waterConnectionDetails.getStatus().getCode())) {
            smsMsg = this.smsBodyByCodeAndArgsWithType("msg.reconnection.approve.sms", waterConnectionDetails, this.applicantName, "reconnectionofconnectionapprove");
            body = this.emailBodyByCodeAndArgsWithType("msg.reconnection.approve.body", waterConnectionDetails, this.applicantName, "reconnectionofconnectionapprove");
            subject = this.waterTaxUtils.emailSubjectforEmailByCodeAndArgs("msg.reconnectionapprove.email.subject", waterConnectionDetails.getApplicationNumber());
        } else if ("RECONNECTIONSANCTIONED".equalsIgnoreCase(waterConnectionDetails.getStatus().getCode())) {
            smsMsg = this.smsBodyByCodeAndArgsWithType("msg.reconnection.sanctioned.sms", waterConnectionDetails, this.applicantName, "reconnectionofconnectionsanctioned");
            body = this.emailBodyByCodeAndArgsWithType("msg.reconnection.sanctioned.body", waterConnectionDetails, this.applicantName, "reconnectionofconnectionsanctioned");
            subject = this.waterTaxUtils.emailSubjectforEmailByCodeAndArgs("msg.reconnectionsanctioned.email.subject", waterConnectionDetails.getApplicationNumber());
        }
        if (mobileNumber != null && smsMsg != null) {
            this.waterTaxUtils.sendSMSOnWaterConnection(mobileNumber, smsMsg);
        }
        if (email != null && body != null) {
            this.waterTaxUtils.sendEmailOnWaterConnection(email, body, subject);
        }
    }
}

