/*
 * Decompiled with CFR 0.152.
 */
package org.egov.wtms.application.service;

import java.math.BigDecimal;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.apache.commons.lang.StringUtils;
import org.egov.collection.entity.ReceiptDetail;
import org.egov.collection.entity.ReceiptHeader;
import org.egov.commons.EgwStatus;
import org.egov.commons.dao.EgwStatusHibernateDAO;
import org.egov.commons.entity.Source;
import org.egov.eis.service.AssignmentService;
import org.egov.infra.admin.master.entity.User;
import org.egov.infra.admin.master.service.AppConfigValueService;
import org.egov.model.instrument.InstrumentHeader;
import org.egov.services.instrument.InstrumentService;
import org.egov.wtms.application.entity.DailyWTCollectionReport;
import org.egov.wtms.application.entity.DefaultersReport;
import org.egov.wtms.application.entity.WaterConnectionDetails;
import org.egov.wtms.application.service.ConnectionDemandService;
import org.egov.wtms.application.service.WaterConnectionDetailsService;
import org.egov.wtms.masters.entity.enums.ConnectionType;
import org.egov.wtms.utils.constants.WaterTaxConstants;
import org.hibernate.Query;
import org.hibernate.SQLQuery;
import org.hibernate.Session;
import org.hibernate.transform.AliasToBeanResultTransformer;
import org.hibernate.transform.ResultTransformer;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class DailyWTCollectionReportService {
    @Autowired
    public InstrumentService instrumentService;
    @Autowired
    public AssignmentService assignmentService;
    @Autowired
    public AppConfigValueService appConfigValueService;
    @Autowired
    public EgwStatusHibernateDAO egwStatusHibernateDAO;
    @Autowired
    public WaterConnectionDetailsService waterConnectionDetailsService;
    @PersistenceContext
    private EntityManager entityManager;
    @Autowired
    private ConnectionDemandService connectionDemandService;

    public Session getCurrentSession() {
        return (Session)this.entityManager.unwrap(Session.class);
    }

    public Set<User> getUsers() {
        String operatorDesignation = this.appConfigValueService.getAppConfigValueByDate("Collection", "COLLECTIONDESIGNATIONFORCSCOPERATORASCLERK", new Date()).getValue();
        return this.assignmentService.getUsersByDesignations(operatorDesignation.split(","));
    }

    public List<EgwStatus> getStatusByModule() {
        return this.egwStatusHibernateDAO.getStatusByModule("ReceiptHeader");
    }

    public List<DailyWTCollectionReport> getCollectionDetails(Date fromDate, Date toDate, String collectionMode, String collectionOperator, String status) throws ParseException {
        StringBuilder queryStr = new StringBuilder(500);
        queryStr.append("select distinct receiptheader from ReceiptHeader receiptheader inner join fetch receiptheader.receiptInstrument instHeader inner join fetch instHeader.instrumentType instType where receiptheader.service.name =:service and (receiptdate between :fromDate and :toDate) ");
        if (StringUtils.isNotBlank((String)collectionMode)) {
            queryStr.append(" and receiptheader.source =:mode ");
        }
        if (StringUtils.isNotBlank((String)collectionOperator)) {
            queryStr.append(" and receiptheader.createdBy.id =:operator ");
        }
        if (StringUtils.isNotBlank((String)status)) {
            queryStr.append(" and receiptheader.status.id =:status ");
        }
        queryStr.append(" order by instHeader ");
        Query query = this.getCurrentSession().createQuery(queryStr.toString());
        query.setString("service", "Water Charges");
        query.setDate("fromDate", new DateTime((Object)fromDate).withTimeAtStartOfDay().toDate());
        query.setDate("toDate", new DateTime((Object)toDate).plusDays(1).toDate());
        if (StringUtils.isNotBlank((String)collectionMode)) {
            query.setString("mode", collectionMode);
        }
        if (StringUtils.isNotBlank((String)collectionOperator)) {
            query.setLong("operator", Long.valueOf(collectionOperator).longValue());
        }
        if (StringUtils.isNotBlank((String)status)) {
            query.setLong("status", Long.valueOf(status).longValue());
        }
        List receiptHeaderList = query.list();
        ArrayList<DailyWTCollectionReport> dailyWTCollectionReportList = new ArrayList<DailyWTCollectionReport>(0);
        for (ReceiptHeader receiptHeader : receiptHeaderList) {
            String instDesc;
            int hashIndex;
            int index;
            BigDecimal currCollection = BigDecimal.ZERO;
            BigDecimal arrCollection = BigDecimal.ZERO;
            DailyWTCollectionReport result = new DailyWTCollectionReport();
            result.setReceiptNumber(receiptHeader.getReceiptnumber());
            result.setReceiptDate(receiptHeader.getReceiptdate());
            result.setConsumerCode(receiptHeader.getConsumerCode());
            result.setConsumerName(receiptHeader.getPayeeName());
            result.setPaidAt(receiptHeader.getSource());
            WaterConnectionDetails waterConnection = this.waterConnectionDetailsService.findByApplicationNumberOrConsumerCode(receiptHeader.getConsumerCode());
            if (null != waterConnection) {
                result.setConnectionType(waterConnection.getConnectionType().toString());
            }
            StringBuilder queryString = new StringBuilder();
            queryString.append("select wardboundary.name as \"wardName\",dcbinfo.houseno as \"houseNo\" from egwtr_mv_dcb_view dcbinfo INNER JOIN eg_boundary wardboundary on dcbinfo.wardid = wardboundary.id  where dcbinfo.hscno = '" + receiptHeader.getConsumerCode() + "'");
            SQLQuery finalQuery = this.getCurrentSession().createSQLQuery(queryString.toString());
            finalQuery.setResultTransformer((ResultTransformer)new AliasToBeanResultTransformer(DefaultersReport.class));
            List listforWardAndHsc = new ArrayList();
            listforWardAndHsc = finalQuery.list();
            if (!listforWardAndHsc.isEmpty()) {
                result.setDoorNumber(((DefaultersReport)listforWardAndHsc.get(0)).getHouseNo());
                result.setWardName(((DefaultersReport)listforWardAndHsc.get(0)).getWardName());
            }
            result.setTotal(receiptHeader.getTotalAmount());
            result.setStatus(receiptHeader.getStatus().getDescription());
            if ("CANCELLED".equalsIgnoreCase(receiptHeader.getStatus().getCode())) {
                result.setCancellationDetails(receiptHeader.getReasonForCancellation());
            } else {
                result.setCancellationDetails("N/A");
            }
            StringBuilder paymentMode = new StringBuilder(30);
            int count = 0;
            for (InstrumentHeader instrument : receiptHeader.getReceiptInstrument()) {
                int instrumentSize = receiptHeader.getReceiptInstrument().size();
                paymentMode.append(instrument.getInstrumentType().getType());
                if (instrumentSize <= 1 || count >= instrumentSize - 1) continue;
                paymentMode.append(",");
                ++count;
            }
            result.setPaidAt(receiptHeader.getSource());
            result.setPaymentMode(paymentMode.toString());
            ArrayList receiptDetailsList = new ArrayList(receiptHeader.getReceiptDetails());
            int lastindex = receiptDetailsList.size() - 2;
            if (null != ((ReceiptDetail)receiptDetailsList.get(0)).getDescription()) {
                index = ((ReceiptDetail)receiptDetailsList.get(0)).getDescription().indexOf("-");
                hashIndex = ((ReceiptDetail)receiptDetailsList.get(0)).getDescription().indexOf("#");
                instDesc = ((ReceiptDetail)receiptDetailsList.get(0)).getDescription().substring(index + 1, hashIndex);
                result.setFromInstallment(instDesc);
            }
            if (null != ((ReceiptDetail)receiptDetailsList.get(lastindex)).getDescription()) {
                index = ((ReceiptDetail)receiptDetailsList.get(lastindex)).getDescription().indexOf("-");
                hashIndex = ((ReceiptDetail)receiptDetailsList.get(lastindex)).getDescription().indexOf("#");
                instDesc = ((ReceiptDetail)receiptDetailsList.get(lastindex)).getDescription().substring(index + 1, hashIndex);
                result.setToInstallment(instDesc);
            }
            for (ReceiptDetail receiptDetail : receiptHeader.getReceiptDetails()) {
                String rdesc = receiptDetail.getDescription();
                if (null == rdesc) continue;
                String receiptDmdRsnDesc = rdesc.substring(0, receiptDetail.getDescription().indexOf("-")).trim();
                String currentInstallment = null;
                if (Arrays.asList(WaterTaxConstants.CREATECONNECTIONDMDDESC).contains(receiptDmdRsnDesc)) {
                    currentInstallment = this.connectionDemandService.getCurrentInstallment("Water Tax Management", "Yearly", new Date()).getDescription();
                } else if (Arrays.asList(WaterTaxConstants.WATERCHARGESDMDDESC).contains(receiptDmdRsnDesc)) {
                    if (ConnectionType.METERED.equals((Object)waterConnection.getConnectionType())) {
                        currentInstallment = this.connectionDemandService.getCurrentInstallment("Water Tax Management", "Monthly", new Date()).getDescription();
                    } else if (ConnectionType.NON_METERED.equals((Object)waterConnection.getConnectionType())) {
                        currentInstallment = this.connectionDemandService.getCurrentInstallment("Property Tax", null, new Date()).getDescription();
                    }
                }
                if (null != rdesc && rdesc.substring(rdesc.indexOf("-") + 1, rdesc.indexOf("#")).trim().equals(currentInstallment)) {
                    currCollection = currCollection.add(receiptDetail.getCramount());
                    continue;
                }
                if (null == rdesc || rdesc.substring(rdesc.indexOf("-") + 1, rdesc.indexOf("#")).trim().equals(currentInstallment)) continue;
                arrCollection = arrCollection.add(receiptDetail.getCramount());
            }
            result.setArrearTotal(null != arrCollection ? arrCollection : new BigDecimal(0));
            result.setCurrentTotal(currCollection);
            result.setTotal(currCollection.add(arrCollection));
            dailyWTCollectionReportList.add(result);
        }
        return dailyWTCollectionReportList;
    }

    public Map<String, String> getCollectionModeMap() {
        LinkedHashMap<String, String> collectionModeMap = new LinkedHashMap<String, String>(0);
        collectionModeMap.put(Source.ESEVA.toString(), Source.ESEVA.toString());
        collectionModeMap.put(Source.MEESEVA.toString(), Source.MEESEVA.toString());
        collectionModeMap.put(Source.APONLINE.toString(), Source.APONLINE.toString());
        collectionModeMap.put(Source.SOFTTECH.toString(), Source.SOFTTECH.toString());
        collectionModeMap.put(Source.SYSTEM.toString(), Source.SYSTEM.toString());
        return collectionModeMap;
    }
}

