/*
 * Decompiled with CFR 0.152.
 */
package org.egov.wtms.application.service;

import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.validation.ValidationException;
import org.egov.commons.CFinancialYear;
import org.egov.commons.Installment;
import org.egov.commons.dao.FinancialYearDAO;
import org.egov.commons.dao.InstallmentHibDao;
import org.egov.demand.dao.DemandGenericDao;
import org.egov.demand.dao.EgBillDao;
import org.egov.demand.model.EgBill;
import org.egov.demand.model.EgBillType;
import org.egov.demand.model.EgDemand;
import org.egov.demand.model.EgDemandDetails;
import org.egov.demand.model.EgDemandReason;
import org.egov.infra.admin.master.service.ModuleService;
import org.egov.infra.config.core.ApplicationThreadLocals;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infra.utils.DateUtils;
import org.egov.infra.utils.autonumber.AutonumberServiceBeanResolver;
import org.egov.ptis.client.util.PropertyTaxUtil;
import org.egov.ptis.domain.model.AssessmentDetails;
import org.egov.ptis.domain.model.enums.BasicPropertyStatus;
import org.egov.ptis.domain.service.property.PropertyExternalService;
import org.egov.wtms.application.entity.DemandDetail;
import org.egov.wtms.application.entity.FieldInspectionDetails;
import org.egov.wtms.application.entity.WaterConnectionDetails;
import org.egov.wtms.application.entity.WaterDemandConnection;
import org.egov.wtms.application.repository.WaterConnectionDetailsRepository;
import org.egov.wtms.application.service.WaterConnectionDetailsService;
import org.egov.wtms.application.service.WaterDemandConnectionService;
import org.egov.wtms.application.service.collection.ConnectionBillService;
import org.egov.wtms.application.service.collection.WaterConnectionBillable;
import org.egov.wtms.autonumber.BillReferenceNumberGenerator;
import org.egov.wtms.autonumber.MeterDemandNoticeNumberGenerator;
import org.egov.wtms.masters.entity.DonationDetails;
import org.egov.wtms.masters.entity.DonationHeader;
import org.egov.wtms.masters.entity.WaterRatesDetails;
import org.egov.wtms.masters.entity.WaterRatesHeader;
import org.egov.wtms.masters.entity.enums.ConnectionStatus;
import org.egov.wtms.masters.entity.enums.ConnectionType;
import org.egov.wtms.masters.service.DonationDetailsService;
import org.egov.wtms.masters.service.DonationHeaderService;
import org.egov.wtms.masters.service.WaterRatesDetailsService;
import org.egov.wtms.masters.service.WaterRatesHeaderService;
import org.egov.wtms.utils.PropertyExtnUtils;
import org.egov.wtms.utils.WaterTaxUtils;
import org.hibernate.Query;
import org.hibernate.Session;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class ConnectionDemandService {
    @PersistenceContext
    private EntityManager entityManager;
    @Autowired
    private AutonumberServiceBeanResolver beanResolver;
    @Autowired
    private DonationDetailsService donationDetailsService;
    @Autowired
    private DonationHeaderService donationHeaderService;
    @Autowired
    private FinancialYearDAO financialYearDAO;
    @Autowired
    private ModuleService moduleService;
    @Autowired
    private InstallmentHibDao installmentDao;
    @Autowired
    private DemandGenericDao demandGenericDao;
    @Autowired
    private WaterConnectionDetailsService waterConnectionDetailsService;
    @Autowired
    private WaterDemandConnectionService waterDemandConnectionService;
    @Autowired
    private ApplicationContext context;
    @Autowired
    private EgBillDao egBillDAO;
    @Autowired
    private ConnectionBillService connectionBillService;
    @Autowired
    private PropertyExtnUtils propertyExtnUtils;
    @Autowired
    private WaterConnectionDetailsRepository waterConnectionDetailsRepository;
    @Autowired
    private WaterRatesDetailsService waterRatesDetailsService;
    @Autowired
    private WaterRatesHeaderService waterRatesHeaderService;
    @Autowired
    private WaterTaxUtils waterTaxUtils;
    @Autowired
    private PropertyTaxUtil propertyTaxUtil;

    public Session getCurrentSession() {
        return (Session)this.entityManager.unwrap(Session.class);
    }

    public EgDemand createDemand(WaterConnectionDetails waterConnectionDetails) {
        HashSet<EgDemandDetails> dmdDetailSet;
        Installment installment;
        HashMap<String, Double> feeDetails = new HashMap<String, Double>();
        DonationDetails donationDetails = null;
        FieldInspectionDetails fieldInspectionDetails = waterConnectionDetails.getFieldInspectionDetails();
        if (fieldInspectionDetails != null) {
            feeDetails.put("WTAXSECURITY", fieldInspectionDetails.getSecurityDeposit());
            feeDetails.put("WTAXROADCUTTING", fieldInspectionDetails.getRoadCuttingCharges());
            feeDetails.put("WTAXSUPERVISION", fieldInspectionDetails.getSupervisionCharges());
            waterConnectionDetails.getFieldInspectionDetails().setEstimationCharges(fieldInspectionDetails.getSecurityDeposit() + fieldInspectionDetails.getRoadCuttingCharges() + fieldInspectionDetails.getSupervisionCharges());
        }
        if (waterConnectionDetails.getConnectionType().equals((Object)ConnectionType.NON_METERED) && !"CHANGEOFUSE".equalsIgnoreCase(waterConnectionDetails.getApplicationType().getCode())) {
            donationDetails = this.getDonationDetails(waterConnectionDetails);
        }
        if (waterConnectionDetails.getConnectionType().equals((Object)ConnectionType.METERED) && waterConnectionDetails.getDonationCharges() > 0.0) {
            feeDetails.put("WTAXDONATION", waterConnectionDetails.getDonationCharges());
        }
        if (donationDetails != null) {
            feeDetails.put("WTAXDONATION", donationDetails.getAmount());
            waterConnectionDetails.setDonationCharges(donationDetails.getAmount());
        }
        if ((installment = this.installmentDao.getInsatllmentByModuleForGivenDateAndInstallmentType(this.moduleService.getModuleByName("Water Tax Management"), new Date(), "Yearly")) != null) {
            dmdDetailSet = new HashSet<EgDemandDetails>();
            for (String demandReason : feeDetails.keySet()) {
                dmdDetailSet.add(this.createDemandDetails((Double)feeDetails.get(demandReason), demandReason, installment));
            }
        } else {
            throw new ValidationException("err.water.installment.not.found");
        }
        EgDemand egDemand = new EgDemand();
        egDemand.setEgInstallmentMaster(installment);
        egDemand.getEgDemandDetails().addAll(dmdDetailSet);
        egDemand.setIsHistory("N");
        egDemand.setCreateDate(new Date());
        egDemand.setModifiedDate(new Date());
        return egDemand;
    }

    public DonationDetails getDonationDetails(WaterConnectionDetails waterConnectionDetails) {
        DonationHeader donationHeaderTemp;
        DonationDetails donationDetails = null;
        List<DonationHeader> donationHeaderTempList = this.donationHeaderService.findDonationDetailsByPropertyAndCategoryAndUsageandPipeSize(waterConnectionDetails.getPropertyType(), waterConnectionDetails.getCategory(), waterConnectionDetails.getUsageType(), waterConnectionDetails.getPipeSize().getSizeInInch(), waterConnectionDetails.getPipeSize().getSizeInInch());
        Iterator<DonationHeader> iterator = donationHeaderTempList.iterator();
        while (iterator.hasNext() && (donationDetails = this.donationDetailsService.findByDonationHeaderAndFromDateAndToDate(donationHeaderTemp = iterator.next(), new Date(), new Date())) == null) {
        }
        return donationDetails;
    }

    private EgDemandDetails createDemandDetails(Double amount, String demandReason, Installment installment) {
        EgDemandReason demandReasonObj = this.getDemandReasonByCodeAndInstallment(demandReason, installment);
        EgDemandDetails demandDetail = new EgDemandDetails();
        demandDetail.setAmount(BigDecimal.valueOf(amount));
        demandDetail.setAmtCollected(BigDecimal.ZERO);
        demandDetail.setAmtRebate(BigDecimal.ZERO);
        demandDetail.setEgDemandReason(demandReasonObj);
        demandDetail.setCreateDate(new Date());
        demandDetail.setModifiedDate(new Date());
        return demandDetail;
    }

    private EgDemandDetails createDemandDetailsrForDataEntry(BigDecimal amount, BigDecimal collectAmount, String demandReason, String installment, DemandDetail demandTempObj, WaterConnectionDetails waterConnectionDetails) {
        EgDemandDetails demandDetailBean;
        Installment installObj = !waterConnectionDetails.getConnectionType().toString().equalsIgnoreCase("Metered") ? this.installmentDao.getInsatllmentByModuleAndDescription(this.moduleService.getModuleByName("Property Tax"), installment) : this.installmentDao.getInsatllmentByModuleAndDescription(this.moduleService.getModuleByName("Water Tax Management"), installment);
        EgDemandDetails demandDetailsObj = this.waterConnectionDetailsRepository.findEgDemandDetailById(demandTempObj.getId());
        EgDemandReason demandReasonObj = this.getDemandReasonByCodeAndInstallment(demandReason, installObj);
        if (demandDetailsObj != null && demandTempObj.getId() != null) {
            demandDetailBean = demandDetailsObj;
            if (demandDetailsObj.getAmount().compareTo(amount) != 0) {
                demandDetailBean.setAmount(amount);
            }
            if (demandDetailsObj.getAmtCollected().compareTo(collectAmount) != 0) {
                demandDetailBean.setAmtCollected(collectAmount);
            }
            demandDetailBean.setEgDemandReason(demandReasonObj);
            demandDetailBean.setModifiedDate(new Date());
        } else {
            demandDetailBean = new EgDemandDetails();
            demandDetailBean.setAmount(amount);
            demandDetailBean.setAmtCollected(collectAmount);
            demandDetailBean.setAmtRebate(BigDecimal.ZERO);
            demandDetailBean.setEgDemandReason(demandReasonObj);
            demandDetailBean.setCreateDate(new Date());
            demandDetailBean.setModifiedDate(new Date());
        }
        return demandDetailBean;
    }

    public EgDemandReason getDemandReasonByCodeAndInstallment(String demandReason, Installment installment) {
        Query demandQuery = this.getCurrentSession().getNamedQuery("DEMANDREASONBY_CODE_AND_INSTALLMENTID");
        demandQuery.setParameter(0, (Object)demandReason);
        demandQuery.setParameter(1, (Object)installment.getId());
        EgDemandReason demandReasonObj = (EgDemandReason)demandQuery.uniqueResult();
        return demandReasonObj;
    }

    public Map<String, Double> getSplitFee(WaterConnectionDetails waterConnectionDetails) {
        EgDemand demand = this.waterTaxUtils.getCurrentDemand(waterConnectionDetails).getDemand();
        HashMap<String, Double> splitAmount = new HashMap<String, Double>();
        if (demand != null && demand.getEgDemandDetails() != null && demand.getEgDemandDetails().size() > 0) {
            for (EgDemandDetails detail : demand.getEgDemandDetails()) {
                if ("WTAXFIELDINSPEC".equals(detail.getEgDemandReason().getEgDemandReasonMaster().getCode())) {
                    splitAmount.put("WTAXFIELDINSPEC", detail.getAmount().doubleValue());
                    continue;
                }
                if ("WTAXDONATION".equals(detail.getEgDemandReason().getEgDemandReasonMaster().getCode())) {
                    splitAmount.put("WTAXDONATION", detail.getAmount().doubleValue());
                    continue;
                }
                if ("WTAXSECURITY".equals(detail.getEgDemandReason().getEgDemandReasonMaster().getCode())) {
                    splitAmount.put("WTAXSECURITY", detail.getAmount().doubleValue());
                    continue;
                }
                if ("WTAXROADCUTTING".equals(detail.getEgDemandReason().getEgDemandReasonMaster().getCode())) {
                    splitAmount.put("WTAXROADCUTTING", detail.getAmount().doubleValue());
                    continue;
                }
                if (!"WTAXSUPERVISION".equals(detail.getEgDemandReason().getEgDemandReasonMaster().getCode())) continue;
                splitAmount.put("WTAXSUPERVISION", detail.getAmount().doubleValue());
            }
        }
        return splitAmount;
    }

    public List<Object> getDmdCollAmtInstallmentWise(EgDemand egDemand) {
        StringBuilder queryStringBuilder = new StringBuilder();
        queryStringBuilder.append("select dmdRes.id,dmdRes.id_installment, sum(dmdDet.amount) as amount, sum(dmdDet.amt_collected) as amt_collected, sum(dmdDet.amt_rebate) as amt_rebate, inst.start_date from eg_demand_details dmdDet,eg_demand_reason dmdRes, eg_installment_master inst,eg_demand_reason_master dmdresmas where dmdDet.id_demand_reason=dmdRes.id and dmdDet.id_demand =:dmdId and dmdRes.id_installment = inst.id and dmdresmas.id = dmdres.id_demand_reason_master group by dmdRes.id,dmdRes.id_installment, inst.start_date order by inst.start_date ");
        return this.getCurrentSession().createSQLQuery(queryStringBuilder.toString()).setLong("dmdId", egDemand.getId().longValue()).list();
    }

    public List<Object> getDmdCollAmtInstallmentWiseUptoCurrentInstallmemt(EgDemand egDemand, WaterConnectionDetails waterConnectionDetails) {
        Installment currInstallment = waterConnectionDetails.getConnectionType().equals((Object)ConnectionType.NON_METERED) ? this.getCurrentInstallment("Property Tax", null, new Date()) : this.getCurrentInstallment("Water Tax Management", "Monthly", new Date());
        StringBuffer strBuf = new StringBuffer(2000);
        strBuf.append("select dmdRes.id,dmdRes.id_installment, sum(dmdDet.amount) as amount, sum(dmdDet.amt_collected) as amt_collected, sum(dmdDet.amt_rebate) as amt_rebate, inst.start_date from eg_demand_details dmdDet,eg_demand_reason dmdRes, eg_installment_master inst,eg_demand_reason_master dmdresmas where dmdDet.id_demand_reason=dmdRes.id and dmdDet.id_demand =:dmdId and inst.start_date<=:currInstallmentDate and dmdRes.id_installment = inst.id and dmdresmas.id = dmdres.id_demand_reason_master group by dmdRes.id,dmdRes.id_installment, inst.start_date order by inst.start_date ");
        Query query = this.getCurrentSession().createSQLQuery(strBuf.toString()).setParameter("dmdId", (Object)egDemand.getId()).setParameter("currInstallmentDate", (Object)currInstallment.getToDate());
        return query.list();
    }

    public List<Object> getDmdCollAmtInstallmentWiseUptoCurrentFinYear(EgDemand egDemand, WaterConnectionDetails waterConnectionDetails) {
        CFinancialYear financialyear = this.financialYearDAO.getFinancialYearByDate(new Date());
        StringBuffer strBuf = new StringBuffer(2000);
        strBuf.append("select dmdRes.id,dmdRes.id_installment, sum(dmdDet.amount) as amount, sum(dmdDet.amt_collected) as amt_collected, sum(dmdDet.amt_rebate) as amt_rebate, inst.start_date from eg_demand_details dmdDet,eg_demand_reason dmdRes, eg_installment_master inst,eg_demand_reason_master dmdresmas where dmdDet.id_demand_reason=dmdRes.id and dmdDet.id_demand =:dmdId and inst.start_date<=:currFinEndDate and dmdRes.id_installment = inst.id and dmdresmas.id = dmdres.id_demand_reason_master group by dmdRes.id,dmdRes.id_installment, inst.start_date order by inst.start_date ");
        Query query = this.getCurrentSession().createSQLQuery(strBuf.toString()).setParameter("dmdId", (Object)egDemand.getId()).setParameter("currFinEndDate", (Object)financialyear.getEndingDate());
        return query.list();
    }

    @Transactional
    public String generateBill(String consumerCode, String applicationTypeCode) {
        String collectXML;
        SimpleDateFormat formatYear = new SimpleDateFormat("yyyy");
        String currentInstallmentYear = null;
        WaterConnectionBillable waterConnectionBillable = (WaterConnectionBillable)((Object)this.context.getBean("waterConnectionBillable"));
        BillReferenceNumberGenerator billRefeNumber = (BillReferenceNumberGenerator)this.beanResolver.getAutoNumberServiceFor(BillReferenceNumberGenerator.class);
        WaterConnectionDetails waterConnectionDetails = applicationTypeCode != null && (applicationTypeCode.equals("CHANGEOFUSE") || applicationTypeCode.equals("RECONNECTION")) ? this.waterConnectionDetailsService.findByApplicationNumberOrConsumerCodeAndStatus(consumerCode, ConnectionStatus.ACTIVE) : this.waterConnectionDetailsService.findByApplicationNumberOrConsumerCode(consumerCode);
        if (ConnectionStatus.INPROGRESS.equals((Object)waterConnectionDetails.getConnectionStatus())) {
            currentInstallmentYear = formatYear.format(this.getCurrentInstallment("Water Tax Management", "Yearly", new Date()).getInstallmentYear());
        } else if (ConnectionStatus.ACTIVE.equals((Object)waterConnectionDetails.getConnectionStatus()) && ConnectionType.NON_METERED.equals((Object)waterConnectionDetails.getConnectionType())) {
            currentInstallmentYear = formatYear.format(this.getCurrentInstallment("Property Tax", null, new Date()).getInstallmentYear());
        } else if (ConnectionStatus.ACTIVE.equals((Object)waterConnectionDetails.getConnectionStatus()) && ConnectionType.METERED.equals((Object)waterConnectionDetails.getConnectionType())) {
            currentInstallmentYear = formatYear.format(this.getCurrentInstallment("Water Tax Management", "Monthly", new Date()).getInstallmentYear());
        }
        AssessmentDetails assessmentDetails = this.propertyExtnUtils.getAssessmentDetailsForFlag(waterConnectionDetails.getConnection().getPropertyIdentifier(), PropertyExternalService.FLAG_FULL_DETAILS, BasicPropertyStatus.ALL);
        waterConnectionBillable.setWaterConnectionDetails(waterConnectionDetails);
        waterConnectionBillable.setAssessmentDetails(assessmentDetails);
        waterConnectionBillable.setUserId(ApplicationThreadLocals.getUserId());
        waterConnectionBillable.setReferenceNumber(billRefeNumber.generateBillNumber(currentInstallmentYear));
        waterConnectionBillable.setBillType(this.getBillTypeByCode("AUTO"));
        String billXml = this.connectionBillService.getBillXML(waterConnectionBillable);
        try {
            collectXML = URLEncoder.encode(billXml, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new ApplicationRuntimeException(e.getMessage());
        }
        return collectXML;
    }

    public EgBillType getBillTypeByCode(String typeCode) {
        return this.egBillDAO.getBillTypeByCode(typeCode);
    }

    public EgDemand getDemandByInstAndApplicationNumber(Installment installment, String consumerCode) {
        WaterConnectionDetails waterConnectionDetails = this.waterConnectionDetailsRepository.findByApplicationNumberAndInstallment(installment, consumerCode);
        return this.waterTaxUtils.getCurrentDemand(waterConnectionDetails).getDemand();
    }

    @Transactional
    public WaterConnectionDetails updateDemandForMeteredConnection(WaterConnectionDetails waterConnectionDetails, BigDecimal billAmount, Date currentDate) {
        Installment installment = this.getCurrentInstallment("Water Tax Management", "Monthly", currentDate);
        if (installment != null) {
            List billlist;
            EgDemand demandObj = this.waterTaxUtils.getCurrentDemand(waterConnectionDetails).getDemand();
            HashSet<EgDemandDetails> dmdDetailSet = new HashSet<EgDemandDetails>();
            dmdDetailSet.add(this.createDemandDetails(Double.parseDouble(billAmount.toString()), "WTAXCHARGES", installment));
            demandObj.setBaseDemand(demandObj.getBaseDemand().add(billAmount));
            demandObj.setEgInstallmentMaster(installment);
            demandObj.getEgDemandDetails().addAll(dmdDetailSet);
            demandObj.setModifiedDate(new Date());
            WaterDemandConnection waterDemandConnection = this.waterDemandConnectionService.findByWaterConnectionDetailsAndDemand(waterConnectionDetails, demandObj);
            if (demandObj.getId() != null && waterDemandConnection == null) {
                WaterDemandConnection waterdemandConnection = new WaterDemandConnection();
                waterdemandConnection.setDemand(demandObj);
                waterdemandConnection.setWaterConnectionDetails(waterConnectionDetails);
                waterConnectionDetails.addWaterDemandConnection(waterdemandConnection);
                this.waterDemandConnectionService.createWaterDemandConnection(waterdemandConnection);
            }
            if (!(billlist = this.demandGenericDao.getAllBillsForDemand(demandObj, "N", "N")).isEmpty()) {
                EgBill billObj = (EgBill)billlist.get(0);
                billObj.setIs_History("Y");
                billObj.setModifiedDate(new Date());
                this.egBillDAO.create(billObj);
            }
        } else {
            throw new ValidationException("err.water.meteredinstallment.not.found");
        }
        this.generateBillForMeterAndMonthly(waterConnectionDetails.getConnection().getConsumerCode());
        return waterConnectionDetails;
    }

    @Transactional
    public WaterConnectionDetails updateDemandForNonMeteredConnectionDataEntry(WaterConnectionDetails waterConnectionDetails, String sourceChannel) {
        Installment installObj;
        ArrayList<String> installmentList = new ArrayList<String>();
        this.propertyTaxUtil.getInstallmentsForCurrYear(new Date()).get("Current 2nd Half");
        EgDemand demandObj = this.waterTaxUtils.getCurrentDemand(waterConnectionDetails).getDemand() == null ? new EgDemand() : this.waterTaxUtils.getCurrentDemand(waterConnectionDetails).getDemand();
        HashSet<EgDemandDetails> dmdDetailSet = new HashSet<EgDemandDetails>();
        for (DemandDetail demanddetailBean : waterConnectionDetails.getDemandDetailBeanList()) {
            if (demanddetailBean.getActualAmount().compareTo(BigDecimal.ZERO) != 1 || demanddetailBean.getActualCollection().compareTo(BigDecimal.ZERO) < 0 || demanddetailBean.getActualCollection().compareTo(demanddetailBean.getActualAmount()) >= 1) continue;
            demandObj.setBaseDemand(this.getTotalAmountForBaseDemand(demanddetailBean, demandObj.getBaseDemand()));
            demandObj.setAmtCollected(this.getTotalCollectedAmountForDemand(demanddetailBean, demandObj.getAmtCollected()));
            dmdDetailSet.add(this.createDemandDetailsrForDataEntry(demanddetailBean.getActualAmount(), demanddetailBean.getActualCollection(), demanddetailBean.getReasonMaster(), demanddetailBean.getInstallment(), demanddetailBean, waterConnectionDetails));
            installmentList.add(demanddetailBean.getInstallment());
        }
        demandObj.getEgDemandDetails().clear();
        demandObj.getEgDemandDetails().addAll(dmdDetailSet);
        int listlength = demandObj.getEgDemandDetails().size() - 1;
        if (!waterConnectionDetails.getConnectionType().toString().equalsIgnoreCase("Metered")) {
            installObj = this.installmentDao.getInsatllmentByModuleAndDescription(this.moduleService.getModuleByName("Property Tax"), waterConnectionDetails.getDemandDetailBeanList().get(listlength).getInstallment());
        } else {
            listlength = installmentList.size() - 1;
            installObj = this.installmentDao.getInsatllmentByModuleAndDescription(this.moduleService.getModuleByName("Water Tax Management"), waterConnectionDetails.getDemandDetailBeanList().get(listlength).getInstallment());
        }
        demandObj.setEgInstallmentMaster(installObj);
        demandObj.setModifiedDate(new Date());
        if (demandObj.getIsHistory() == null) {
            demandObj.setIsHistory("N");
        }
        if (demandObj.getCreateDate() == null) {
            demandObj.setCreateDate(new Date());
        }
        if (demandObj.getId() == null) {
            WaterDemandConnection waterdemandConnection = new WaterDemandConnection();
            waterdemandConnection.setDemand(demandObj);
            waterdemandConnection.setWaterConnectionDetails(waterConnectionDetails);
            waterConnectionDetails.addWaterDemandConnection(waterdemandConnection);
            this.waterDemandConnectionService.createWaterDemandConnection(waterdemandConnection);
        }
        this.waterConnectionDetailsService.updateIndexes(waterConnectionDetails, sourceChannel);
        return waterConnectionDetails;
    }

    public BigDecimal getTotalAmountForBaseDemand(DemandDetail demanddetailBean, BigDecimal baseDemandAmount) {
        BigDecimal currentTotalAmount = BigDecimal.ZERO;
        EgDemandDetails demandDetailsObj = this.waterConnectionDetailsRepository.findEgDemandDetailById(demanddetailBean.getId());
        if (demanddetailBean.getId() == null) {
            currentTotalAmount = baseDemandAmount.add(demanddetailBean.getActualAmount());
        } else if (demanddetailBean.getActualAmount().compareTo(demandDetailsObj.getAmount()) == -1) {
            BigDecimal diffExtraless = demandDetailsObj.getAmount().subtract(demanddetailBean.getActualAmount());
            currentTotalAmount = baseDemandAmount.subtract(diffExtraless);
        } else if (demanddetailBean.getActualAmount().compareTo(demandDetailsObj.getAmount()) == 1) {
            BigDecimal diffExtra = demanddetailBean.getActualAmount().subtract(demandDetailsObj.getAmount());
            currentTotalAmount = baseDemandAmount.add(diffExtra);
        } else if (demanddetailBean.getActualAmount().compareTo(demandDetailsObj.getAmount()) == 0) {
            currentTotalAmount = baseDemandAmount;
        }
        return currentTotalAmount;
    }

    public BigDecimal getTotalCollectedAmountForDemand(DemandDetail demanddetailBean, BigDecimal demandAmountCollected) {
        BigDecimal currentTotalAmount = BigDecimal.ZERO;
        EgDemandDetails demandDetailsObj = this.waterConnectionDetailsRepository.findEgDemandDetailById(demanddetailBean.getId());
        if (demanddetailBean.getId() == null) {
            currentTotalAmount = demandAmountCollected.add(demanddetailBean.getActualCollection());
        } else if (demanddetailBean.getActualCollection().compareTo(demandDetailsObj.getAmtCollected()) == -1) {
            BigDecimal diffExtraless = demandDetailsObj.getAmtCollected().subtract(demanddetailBean.getActualCollection());
            currentTotalAmount = demandAmountCollected.subtract(diffExtraless);
        } else if (demanddetailBean.getActualCollection().compareTo(demandDetailsObj.getAmtCollected()) == 1) {
            BigDecimal diffExtra = demanddetailBean.getActualCollection().subtract(demandDetailsObj.getAmtCollected());
            currentTotalAmount = demandAmountCollected.add(diffExtra);
        } else if (demanddetailBean.getActualCollection().compareTo(demandDetailsObj.getAmtCollected()) == 0) {
            currentTotalAmount = demandAmountCollected;
        }
        return currentTotalAmount;
    }

    @Transactional
    public String generateBillForMeterAndMonthly(String consumerCode) {
        WaterConnectionBillable waterConnectionBillable = (WaterConnectionBillable)((Object)this.context.getBean("waterConnectionBillable"));
        WaterConnectionDetails waterConnectionDetails = this.waterConnectionDetailsService.findByConsumerCodeAndConnectionStatus(consumerCode, ConnectionStatus.ACTIVE);
        AssessmentDetails assessmentDetails = this.propertyExtnUtils.getAssessmentDetailsForFlag(waterConnectionDetails.getConnection().getPropertyIdentifier(), PropertyExternalService.FLAG_FULL_DETAILS, BasicPropertyStatus.ACTIVE);
        MeterDemandNoticeNumberGenerator meterDemandNotice = (MeterDemandNoticeNumberGenerator)this.beanResolver.getAutoNumberServiceFor(MeterDemandNoticeNumberGenerator.class);
        waterConnectionBillable.setWaterConnectionDetails(waterConnectionDetails);
        waterConnectionBillable.setAssessmentDetails(assessmentDetails);
        waterConnectionBillable.setUserId(ApplicationThreadLocals.getUserId());
        waterConnectionBillable.setReferenceNumber(meterDemandNotice.generateMeterDemandNoticeNumber());
        waterConnectionBillable.setBillType(this.getBillTypeByCode("MANUAL"));
        return this.connectionBillService.getBillXML(waterConnectionBillable);
    }

    public WaterConnectionDetails updateDemandForNonmeteredConnection(WaterConnectionDetails waterConnectionDetails, Installment installment, Boolean reconnInSameInstallment, String workFlowAction) throws ValidationException {
        EgDemandDetails existingDemandDtlObject = null;
        List<Object> installmentList = new ArrayList<Installment>();
        if (installment == null) {
            installment = this.getCurrentInstallment("Property Tax", null, new Date());
        }
        Date installemntStartDate = workFlowAction != null && workFlowAction.equals("Execute Tap") ? new Date() : (reconnInSameInstallment != null ? (reconnInSameInstallment.booleanValue() ? installment.getFromDate() : waterConnectionDetails.getReconnectionApprovalDate()) : new Date());
        CFinancialYear finYear = this.financialYearDAO.getFinancialYearByDate(new Date());
        int numberOfMonths = DateUtils.noOfMonthsBetween((Date)installemntStartDate, (Date)finYear.getEndingDate());
        if (numberOfMonths >= 6) {
            installmentList = this.waterTaxUtils.getInstallmentsForCurrYear(finYear.getStartingDate());
        } else {
            installmentList.add(installment);
        }
        WaterRatesDetails waterRatesDetails = this.getWaterRatesDetailsForDemandUpdate(waterConnectionDetails);
        EgDemand currentDemand = this.waterTaxUtils.getCurrentDemand(waterConnectionDetails).getDemand();
        WaterDemandConnection demandConnection = this.waterDemandConnectionService.findByWaterConnectionDetailsAndDemand(waterConnectionDetails, currentDemand);
        for (Installment installment2 : installmentList) {
            for (EgDemandDetails demandDtls : currentDemand.getEgDemandDetails()) {
                if (!"WTAXCHARGES".equalsIgnoreCase(demandDtls.getEgDemandReason().getEgDemandReasonMaster().getCode()) || !installment2.getDescription().equalsIgnoreCase(demandDtls.getEgDemandReason().getEgInstallmentMaster().getDescription())) continue;
                existingDemandDtlObject = demandDtls;
            }
            Integer noofmonths = DateUtils.noOfMonthsBetween((Date)installemntStartDate, (Date)installment2.getToDate());
            if (existingDemandDtlObject != null) continue;
            if (null != waterRatesDetails) {
                double totalWaterRate = noofmonths > 0 ? waterRatesDetails.getMonthlyRate() * (double)(noofmonths + 1) : waterRatesDetails.getMonthlyRate();
                EgDemandDetails demandDetails = this.createDemandDetails(totalWaterRate, "WTAXCHARGES", installment2);
                currentDemand.setBaseDemand(currentDemand.getBaseDemand().add(BigDecimal.valueOf(totalWaterRate)));
                currentDemand.setEgInstallmentMaster(installment2);
                currentDemand.getEgDemandDetails().add(demandDetails);
                currentDemand.setModifiedDate(new Date());
                if (currentDemand.getId() != null && demandConnection == null) {
                    WaterDemandConnection waterdemandConnection = new WaterDemandConnection();
                    waterdemandConnection.setDemand(currentDemand);
                    waterdemandConnection.setWaterConnectionDetails(waterConnectionDetails);
                    waterConnectionDetails.addWaterDemandConnection(waterdemandConnection);
                    this.waterDemandConnectionService.createWaterDemandConnection(waterdemandConnection);
                }
            } else {
                throw new ValidationException("err.water.rate.not.found");
            }
            installemntStartDate = new DateTime((Object)installment2.getToDate()).plusDays(1).toDate();
        }
        return waterConnectionDetails;
    }

    public WaterRatesDetails getWaterRatesDetailsForDemandUpdate(WaterConnectionDetails waterConnectionDetails) {
        WaterRatesDetails waterRatesDetails;
        block1: {
            WaterRatesHeader waterRatesHeadertemp;
            List<WaterRatesHeader> waterRatesHeaderList = this.waterRatesHeaderService.findByConnectionTypeAndUsageTypeAndWaterSourceAndPipeSize(waterConnectionDetails.getConnectionType(), waterConnectionDetails.getUsageType(), waterConnectionDetails.getWaterSource(), waterConnectionDetails.getPipeSize());
            waterRatesDetails = null;
            if (waterRatesHeaderList.isEmpty()) break block1;
            Iterator<WaterRatesHeader> iterator = waterRatesHeaderList.iterator();
            while (iterator.hasNext() && (waterRatesDetails = this.waterRatesDetailsService.findByWaterRatesHeaderAndFromDateAndToDate(waterRatesHeadertemp = iterator.next(), new Date(), new Date())) == null) {
            }
        }
        return waterRatesDetails;
    }

    public Installment getCurrentInstallment(String moduleName, String installmentType, Date date) {
        if (null == installmentType) {
            return this.installmentDao.getInsatllmentByModuleForGivenDate(this.moduleService.getModuleByName(moduleName), date);
        }
        return this.installmentDao.getInsatllmentByModuleForGivenDateAndInstallmentType(this.moduleService.getModuleByName(moduleName), date, installmentType);
    }

    public List<Object> getDmdCollAmtInstallmentWiseWithIsDmdTrue(EgDemand egDemand) {
        StringBuffer strBuf = new StringBuffer(2000);
        strBuf.append("SELECT wcdid,dmdResId,installment,amount,amt_collected,amt_rebate,amount-amt_collected AS balance,instStartDate FROM (SELECT wcd.id AS wcdid,dmdRes.id AS dmdResId,dmdRes.id_installment AS installment,SUM(dmdDet.amount) AS amount,SUM(dmdDet.amt_collected) AS amt_collected,SUM(dmdDet.amt_rebate) AS amt_rebate,inst.start_date AS inststartdate FROM eg_demand_details dmdDet,eg_demand_reason dmdRes,eg_installment_master inst,eg_demand_reason_master dmdresmas,egwtr_connectiondetails wcd WHERE dmdDet.id_demand_reason=dmdRes.id AND dmdDet.id_demand =:dmdId AND dmdRes.id_installment = inst.id AND dmdresmas.id = dmdres.id_demand_reason_master AND dmdresmas.isdemand=TRUE AND wcd.demand = dmdDet.id_demand GROUP BY dmdRes.id, dmdRes.id_installment,inst.start_date,wcd.id ORDER BY inst.start_date) AS dcb");
        return this.getCurrentSession().createSQLQuery(strBuf.toString()).setLong("dmdId", egDemand.getId().longValue()).list();
    }

    public Boolean meterEntryAllReadyExistForCurrentMonth(WaterConnectionDetails waterConnectionDetails, Date givenDate) {
        Boolean currrentInstallMentExist = false;
        Installment installment = this.getCurrentInstallment("Water Tax Management", "Monthly", givenDate);
        if (this.waterTaxUtils.getCurrentDemand(waterConnectionDetails).getDemand() != null && this.waterTaxUtils.getCurrentDemand(waterConnectionDetails).getDemand() != null && installment != null && installment.getInstallmentNumber().equals(this.waterTaxUtils.getCurrentDemand(waterConnectionDetails).getDemand().getEgInstallmentMaster().getInstallmentNumber())) {
            currrentInstallMentExist = true;
        }
        return currrentInstallMentExist;
    }

    public List<Object> getDmdCollAmtInstallmentWiseUptoPreviousFinYear(EgDemand egDemand, WaterConnectionDetails waterConnectionDetails) {
        CFinancialYear financialyear = this.financialYearDAO.getFinancialYearByDate(new Date());
        StringBuffer strBuf = new StringBuffer(2000);
        strBuf.append("select dmdRes.id,dmdRes.id_installment, sum(dmdDet.amount) as amount, sum(dmdDet.amt_collected) as amt_collected, sum(dmdDet.amt_rebate) as amt_rebate, inst.start_date from eg_demand_details dmdDet,eg_demand_reason dmdRes, eg_installment_master inst,eg_demand_reason_master dmdresmas where dmdDet.id_demand_reason=dmdRes.id and dmdDet.id_demand =:dmdId and inst.start_date<:currFinStartDate and dmdRes.id_installment = inst.id and dmdresmas.id = dmdres.id_demand_reason_master group by dmdRes.id,dmdRes.id_installment, inst.start_date order by inst.start_date ");
        Query query = this.getCurrentSession().createSQLQuery(strBuf.toString()).setParameter("dmdId", (Object)egDemand.getId()).setParameter("currFinStartDate", (Object)financialyear.getStartingDate());
        return query.list();
    }

    public Map<String, Installment> getInstallmentsForPreviousYear(Date currDate) {
        HashMap<String, Installment> currYearInstMap = new HashMap<String, Installment>();
        String query = "select installment from Installment installment,CFinancialYear finYear where installment.module.name = 'Property Tax'  and cast(installment.toDate as date) <= cast(finYear.startingDate as date) order by installment.id desc";
        Query qry = this.getCurrentSession().createQuery("select installment from Installment installment,CFinancialYear finYear where installment.module.name = 'Property Tax'  and cast(installment.toDate as date) <= cast(finYear.startingDate as date) order by installment.id desc");
        List installments = qry.list();
        currYearInstMap.put("Previous 2nd Half", (Installment)installments.get(0));
        return currYearInstMap;
    }
}

