/*
 * Decompiled with CFR 0.152.
 */
package org.egov.wtms.scheduler;

import org.egov.infra.scheduler.quartz.AbstractQuartzJob;
import org.egov.wtms.service.bill.WaterConnectionBillService;
import org.egov.wtms.utils.WaterTaxUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;

public class BulkWaterConnBillGenerationJob
extends AbstractQuartzJob {
    private static final long serialVersionUID = 6652765005378915324L;
    private static final Logger LOGGER = LoggerFactory.getLogger(BulkWaterConnBillGenerationJob.class);
    private Integer billsCount;
    private Integer modulo;
    @Autowired
    private ApplicationContext beanProvider;
    @Autowired
    private WaterTaxUtils waterTaxUtils;

    public void executeJob() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Starting water tax bulk bill generation for {}", (Object)this.waterTaxUtils.getCityCode());
        }
        long startTimeMillis = System.currentTimeMillis();
        WaterConnectionBillService waterConnectionBillService = null;
        try {
            waterConnectionBillService = (WaterConnectionBillService)this.beanProvider.getBean("waterConnectionBillService");
        }
        catch (NoSuchBeanDefinitionException e) {
            LOGGER.warn("waterConnectionBillService implementation not found");
        }
        if (waterConnectionBillService != null && this.waterTaxUtils.getAppconfigValueForSchedulearEnabled().booleanValue()) {
            waterConnectionBillService.bulkBillGeneration(this.modulo, this.billsCount);
        }
        if (LOGGER.isDebugEnabled()) {
            long elapsedTimeMillis = System.currentTimeMillis() - startTimeMillis;
            LOGGER.debug("Water tax bulk bill generation completed for {} in {} seconds", (Object)this.waterTaxUtils.getCityCode(), (Object)elapsedTimeMillis);
        }
    }

    public void setBillsCount(Integer billsCount) {
        this.billsCount = billsCount;
    }

    public void setModulo(Integer modulo) {
        this.modulo = modulo;
    }
}

