/*
 * Decompiled with CFR 0.152.
 */
package org.egov.wtms.entity.es;

import com.fasterxml.jackson.annotation.JsonFormat;
import java.util.Date;
import org.egov.infra.config.core.ApplicationThreadLocals;
import org.springframework.data.annotation.Id;
import org.springframework.data.elasticsearch.annotations.DateFormat;
import org.springframework.data.elasticsearch.annotations.Document;
import org.springframework.data.elasticsearch.annotations.Field;
import org.springframework.data.elasticsearch.annotations.FieldIndex;
import org.springframework.data.elasticsearch.annotations.FieldType;
import org.springframework.data.elasticsearch.annotations.GeoPointField;
import org.springframework.data.elasticsearch.core.geo.GeoPoint;

@Document(indexName="waterchargeconsumer", type="waterchargeconsumer")
public class WaterChargeDocument {
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd")
    @Field(type=FieldType.Date, format=DateFormat.date_optional_time, pattern="yyyy-MM-dd")
    private Date createdDate;
    @Field(index=FieldIndex.not_analyzed)
    @GeoPointField
    private GeoPoint wardlocation;
    @Field(index=FieldIndex.not_analyzed)
    @GeoPointField
    private GeoPoint propertylocation;
    @Id
    private String id;
    @Field(type=FieldType.String)
    private String closureType;
    @Field(type=FieldType.String, index=FieldIndex.not_analyzed)
    private String waterSource;
    @Field(type=FieldType.Boolean)
    private boolean legacy;
    @Field(type=FieldType.Long)
    private Long sumpCapacity;
    @Field(type=FieldType.String, index=FieldIndex.not_analyzed)
    private String mobileNumber;
    @Field(type=FieldType.Long)
    private Long numberOfPerson;
    @Field(type=FieldType.Long)
    private Long totalDue;
    @Field(type=FieldType.String, index=FieldIndex.not_analyzed)
    private String usage;
    @Field(type=FieldType.String, index=FieldIndex.not_analyzed)
    private String propertyType;
    @Field(type=FieldType.String, index=FieldIndex.not_analyzed)
    private String consumerCode;
    @Field(type=FieldType.String, index=FieldIndex.not_analyzed)
    private String oldConsumerCode;
    @Field(type=FieldType.String, index=FieldIndex.not_analyzed)
    private String applicationCode;
    @Field(type=FieldType.String, index=FieldIndex.not_analyzed)
    private String districtName;
    @Field(type=FieldType.String, index=FieldIndex.not_analyzed)
    private String cityGrade;
    @Field(type=FieldType.String, index=FieldIndex.not_analyzed)
    private String cityName;
    @Field(type=FieldType.String, index=FieldIndex.not_analyzed)
    private String cityCode;
    @Field(type=FieldType.String, index=FieldIndex.not_analyzed)
    private String zone;
    @Field(type=FieldType.String, index=FieldIndex.not_analyzed)
    private String adminWard;
    @Field(type=FieldType.String)
    private String bpaid;
    @Field(type=FieldType.String, index=FieldIndex.not_analyzed)
    private String regionName;
    @Field(type=FieldType.String, index=FieldIndex.not_analyzed)
    private String pipeSize;
    @Field(type=FieldType.String, index=FieldIndex.not_analyzed)
    private String doorNo;
    @Field(type=FieldType.String, index=FieldIndex.not_analyzed)
    private String category;
    @Field(type=FieldType.String, index=FieldIndex.not_analyzed)
    private String connectionType;
    @Field(type=FieldType.String, index=FieldIndex.not_analyzed)
    private String propertyId;
    @Field(type=FieldType.String, index=FieldIndex.not_analyzed)
    private String status;
    @Field(type=FieldType.Long)
    private Long monthlyRate;
    @Field(type=FieldType.String, index=FieldIndex.not_analyzed)
    private String aadhaarNumber;
    @Field(type=FieldType.Long)
    private Long waterTaxDue;
    @Field(type=FieldType.String, index=FieldIndex.not_analyzed)
    private String locality;
    @Field(type=FieldType.Long)
    private Long arrearsDue;
    @Field(type=FieldType.String, index=FieldIndex.not_analyzed)
    private String consumerName;
    @Field(type=FieldType.Long)
    private Long currentDue;
    @Field(type=FieldType.Long)
    private Long arrearsDemand;
    @Field(type=FieldType.Long)
    private Long currentDemand;
    @Field(type=FieldType.Long)
    private Long totalCollection;
    @Field(type=FieldType.Long)
    private Long totalDemand;
    @Field(type=FieldType.String, index=FieldIndex.not_analyzed)
    private String revenueWard;
    @Field(type=FieldType.String, index=FieldIndex.not_analyzed)
    private String duePeriod;
    @Field(type=FieldType.String, index=FieldIndex.not_analyzed)
    private String billCollector;

    public static Builder builder() {
        return new Builder();
    }

    public Date getCreatedDate() {
        return this.createdDate;
    }

    public void setCreatedDate(Date createdDate) {
        this.createdDate = createdDate;
    }

    public String getBpaid() {
        return this.bpaid;
    }

    public void setBpaid(String bpaid) {
        this.bpaid = bpaid;
    }

    public String getZone() {
        return this.zone;
    }

    public void setZone(String zone) {
        this.zone = zone;
    }

    public String getDoorNo() {
        return this.doorNo;
    }

    public void setDoorNo(String doorNo) {
        this.doorNo = doorNo;
    }

    public String getCategory() {
        return this.category;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public Long getMonthlyRate() {
        return this.monthlyRate;
    }

    public void setMonthlyRate(Long monthlyRate) {
        this.monthlyRate = monthlyRate;
    }

    public Long getWaterTaxDue() {
        return this.waterTaxDue;
    }

    public void setWaterTaxDue(Long waterTaxDue) {
        this.waterTaxDue = waterTaxDue;
    }

    public String getLocality() {
        return this.locality;
    }

    public void setLocality(String locality) {
        this.locality = locality;
    }

    public Long getArrearsDue() {
        return this.arrearsDue;
    }

    public String getRevenueWard() {
        return this.revenueWard;
    }

    public void setRevenueWard(String revenueWard) {
        this.revenueWard = revenueWard;
    }

    public Long getTotalCollection() {
        return this.totalCollection;
    }

    public void setTotalCollection(Long totalCollection) {
        this.totalCollection = totalCollection;
    }

    public Long getTotalDemand() {
        return this.totalDemand;
    }

    public void setTotalDemand(Long totalDemand) {
        this.totalDemand = totalDemand;
    }

    public void setArrearsDue(Long arrearsDue) {
        this.arrearsDue = arrearsDue;
    }

    public Long getCurrentDue() {
        return this.currentDue;
    }

    public void setCurrentDue(Long currentDue) {
        this.currentDue = currentDue;
    }

    public Long getArrearsDemand() {
        return this.arrearsDemand;
    }

    public void setArrearsDemand(Long arrearsDemand) {
        this.arrearsDemand = arrearsDemand;
    }

    public Long getCurrentDemand() {
        return this.currentDemand;
    }

    public void setCurrentDemand(Long currentDemand) {
        this.currentDemand = currentDemand;
    }

    public String getId() {
        return this.id;
    }

    public void setId() {
        this.id = ApplicationThreadLocals.getCityCode().concat("-").concat(this.consumerCode);
    }

    public String getClosureType() {
        return this.closureType;
    }

    public void setClosureType(String closureType) {
        this.closureType = closureType;
    }

    public String getWaterSource() {
        return this.waterSource;
    }

    public void setWaterSource(String waterSource) {
        this.waterSource = waterSource;
    }

    public Long getSumpCapacity() {
        return this.sumpCapacity;
    }

    public void setSumpCapacity(Long sumpCapacity) {
        this.sumpCapacity = sumpCapacity;
    }

    public String getMobileNumber() {
        return this.mobileNumber;
    }

    public void setMobileNumber(String mobileNumber) {
        this.mobileNumber = mobileNumber;
    }

    public Long getNumberOfPerson() {
        return this.numberOfPerson;
    }

    public void setNumberOfPerson(Long numberOfPerson) {
        this.numberOfPerson = numberOfPerson;
    }

    public Long getTotalDue() {
        return this.totalDue;
    }

    public void setTotalDue(Long totalDue) {
        this.totalDue = totalDue;
    }

    public String getUsage() {
        return this.usage;
    }

    public void setUsage(String usage) {
        this.usage = usage;
    }

    public String getPropertyType() {
        return this.propertyType;
    }

    public void setPropertyType(String propertyType) {
        this.propertyType = propertyType;
    }

    public String getConsumerCode() {
        return this.consumerCode;
    }

    public void setConsumerCode(String consumerCode) {
        this.consumerCode = consumerCode;
    }

    public String getApplicationCode() {
        return this.applicationCode;
    }

    public void setApplicationCode(String applicationCode) {
        this.applicationCode = applicationCode;
    }

    public String getDistrictName() {
        return this.districtName;
    }

    public void setDistrictName(String districtName) {
        this.districtName = districtName;
    }

    public String getAdminWard() {
        return this.adminWard;
    }

    public void setAdminWard(String adminWard) {
        this.adminWard = adminWard;
    }

    public String getRegionName() {
        return this.regionName;
    }

    public void setRegionName(String regionName) {
        this.regionName = regionName;
    }

    public String getPipeSize() {
        return this.pipeSize;
    }

    public void setPipeSize(String pipeSize) {
        this.pipeSize = pipeSize;
    }

    public String getConnectionType() {
        return this.connectionType;
    }

    public void setConnectionType(String connectionType) {
        this.connectionType = connectionType;
    }

    public String getPropertyId() {
        return this.propertyId;
    }

    public void setPropertyId(String propertyId) {
        this.propertyId = propertyId;
    }

    public String getAadhaarNumber() {
        return this.aadhaarNumber;
    }

    public void setAadhaarNumber(String aadhaarNumber) {
        this.aadhaarNumber = aadhaarNumber;
    }

    public String getConsumerName() {
        return this.consumerName;
    }

    public void setConsumerName(String consumerName) {
        this.consumerName = consumerName;
    }

    public GeoPoint getWardlocation() {
        return this.wardlocation;
    }

    public void setWardlocation(GeoPoint wardlocation) {
        this.wardlocation = wardlocation;
    }

    public GeoPoint getPropertylocation() {
        return this.propertylocation;
    }

    public void setPropertylocation(GeoPoint propertylocation) {
        this.propertylocation = propertylocation;
    }

    public String getCityGrade() {
        return this.cityGrade;
    }

    public void setCityGrade(String cityGrade) {
        this.cityGrade = cityGrade;
    }

    public String getCityName() {
        return this.cityName;
    }

    public void setCityName(String cityName) {
        this.cityName = cityName;
    }

    public String getCityCode() {
        return this.cityCode;
    }

    public void setCityCode(String cityCode) {
        this.cityCode = cityCode;
    }

    public Boolean getLegacy() {
        return this.legacy;
    }

    public void setLegacy(Boolean legacy) {
        this.legacy = legacy;
    }

    public String getDuePeriod() {
        return this.duePeriod;
    }

    public void setDuePeriod(String duePeriod) {
        this.duePeriod = duePeriod;
    }

    public String getBillCollector() {
        return this.billCollector;
    }

    public void setBillCollector(String billCollector) {
        this.billCollector = billCollector;
    }

    public String getOldConsumerCode() {
        return this.oldConsumerCode;
    }

    public void setOldConsumerCode(String oldConsumerCode) {
        this.oldConsumerCode = oldConsumerCode;
    }

    public static final class Builder {
        private String aadhaarNumber;
        private String adminWard;
        private String applicationCode;
        private Long arrearsDemand;
        private Long arrearsDue;
        private Long waterTaxDue;
        private Long totalDemand;
        private Long totalCollection;
        private Long totalDue;
        private String status;
        private String category;
        private String closureType;
        private String connectionType;
        private String consumerCode;
        private String oldConsumerCode;
        private String consumerName;
        private Date createdDate;
        private Long currentDemand;
        private Long currentDue;
        private String doorNo;
        private String districtName;
        private String cityName;
        private String cityGrade;
        private Boolean legacy;
        private Long sumpCapacity;
        private Long numberOfPerson;
        private String zone;
        private String regionName;
        private String pipeSize;
        private String propertyId;
        private Long monthlyRate;
        private String mobileNumber;
        private String locality;
        private String propertyType;
        private String waterSource;
        private String revenueWard;
        private String usage;
        private String cityCode;
        private GeoPoint wardLocation;
        private GeoPoint propertyLocation;
        private String duePeriod;
        private String billCollector;

        private Builder() {
        }

        public Builder withDuePeriod(String duePeriod) {
            this.duePeriod = duePeriod;
            return this;
        }

        public Builder withBillCollector(String billCollector) {
            this.billCollector = billCollector;
            return this;
        }

        public Builder withWardlocation(GeoPoint wardlocation) {
            this.wardLocation = wardlocation;
            return this;
        }

        public Builder withPropertylocation(GeoPoint propertylocation) {
            this.propertyLocation = propertylocation;
            return this;
        }

        public Builder withAadhaarnumber(String aadharNumber) {
            this.aadhaarNumber = aadharNumber;
            return this;
        }

        public Builder withUsage(String usage) {
            this.usage = usage;
            return this;
        }

        public Builder withAdminward(String adminward) {
            this.adminWard = adminward;
            return this;
        }

        public Builder withApplicationcode(String aapplicationcode) {
            this.applicationCode = aapplicationcode;
            return this;
        }

        public Builder withSumpcapacity(Long sumpcapacity) {
            this.sumpCapacity = sumpcapacity;
            return this;
        }

        public Builder withArrearsDemand(Long arrearsDemand) {
            this.arrearsDemand = arrearsDemand;
            return this;
        }

        public Builder withArrearsDue(Long arrearsDue) {
            this.arrearsDue = arrearsDue;
            return this;
        }

        public Builder withWaterTaxDue(Long waterTaxDue) {
            this.waterTaxDue = waterTaxDue;
            return this;
        }

        public Builder withTotalDemand(Long totalDemand) {
            this.totalDemand = totalDemand;
            return this;
        }

        public Builder withTotalCollection(Long totalCollection) {
            this.totalCollection = totalCollection;
            return this;
        }

        public Builder withTotaldue(Long totaldue) {
            this.totalDue = totaldue;
            return this;
        }

        public Builder withStatus(String status) {
            this.status = status;
            return this;
        }

        public Builder withCategory(String category) {
            this.category = category;
            return this;
        }

        public Builder withClosureType(String closureType) {
            this.closureType = closureType;
            return this;
        }

        public Builder withConnectiontype(String connectiontype) {
            this.connectionType = connectiontype;
            return this;
        }

        public Builder withConsumerCode(String consumerCode) {
            this.consumerCode = consumerCode;
            return this;
        }

        public Builder withOldConsumerCode(String oldConsumerCode) {
            this.oldConsumerCode = oldConsumerCode;
            return this;
        }

        public Builder withConsumername(String consumername) {
            this.consumerName = consumername;
            return this;
        }

        public Builder withCurrentDemand(Long currentDemand) {
            this.currentDemand = currentDemand;
            return this;
        }

        public Builder withCreatedDate(Date createdDate) {
            this.createdDate = createdDate;
            return this;
        }

        public Builder withCurrentDue(Long currentDue) {
            this.currentDue = currentDue;
            return this;
        }

        public Builder withDistrictName(String districtname) {
            this.districtName = districtname;
            return this;
        }

        public Builder withDoorNo(String doorNo) {
            this.doorNo = doorNo;
            return this;
        }

        public Builder withCityGrade(String cityGrade) {
            this.cityGrade = cityGrade;
            return this;
        }

        public Builder withNumberOfPerson(Long numberofperson) {
            this.numberOfPerson = numberofperson;
            return this;
        }

        public Builder withMobileNumber(String mobilenumber) {
            this.mobileNumber = mobilenumber;
            return this;
        }

        public Builder withMonthlyRate(Long monthlyRate) {
            this.monthlyRate = monthlyRate;
            return this;
        }

        public Builder withRegionname(String regionname) {
            this.regionName = regionname;
            return this;
        }

        public Builder withLegacy(Boolean legacy) {
            this.legacy = legacy;
            return this;
        }

        public Builder withLocality(String locality) {
            this.locality = locality;
            return this;
        }

        public Builder withPropertyid(String propertyid) {
            this.propertyId = propertyid;
            return this;
        }

        public Builder withPropertytype(String propertytype) {
            this.propertyType = propertytype;
            return this;
        }

        public Builder withPipesize(String pipesize) {
            this.pipeSize = pipesize;
            return this;
        }

        public Builder withCityName(String cityname) {
            this.cityName = cityname;
            return this;
        }

        public Builder withCityCode(String citycode) {
            this.cityCode = citycode;
            return this;
        }

        public Builder withWatersource(String watersource) {
            this.waterSource = watersource;
            return this;
        }

        public Builder withZone(String zone) {
            this.zone = zone;
            return this;
        }

        public Builder withRevenueWard(String revenueWard) {
            this.revenueWard = revenueWard;
            return this;
        }

        public Builder withWard(Long waterTaxDue) {
            this.waterTaxDue = waterTaxDue;
            return this;
        }

        public WaterChargeDocument build() {
            WaterChargeDocument waterChargeIndex = new WaterChargeDocument();
            waterChargeIndex.setWardlocation(this.wardLocation);
            waterChargeIndex.setConsumerCode(this.consumerCode);
            waterChargeIndex.setOldConsumerCode(this.oldConsumerCode);
            waterChargeIndex.setId();
            waterChargeIndex.setPropertylocation(this.propertyLocation);
            waterChargeIndex.setAadhaarNumber(this.aadhaarNumber);
            waterChargeIndex.setAdminWard(this.adminWard);
            waterChargeIndex.setApplicationCode(this.applicationCode);
            waterChargeIndex.setArrearsDemand(this.arrearsDemand);
            waterChargeIndex.setDuePeriod(this.duePeriod);
            waterChargeIndex.setBillCollector(this.billCollector);
            waterChargeIndex.setArrearsDue(this.arrearsDue);
            waterChargeIndex.setWaterTaxDue(this.waterTaxDue);
            waterChargeIndex.setTotalDemand(this.totalDemand);
            waterChargeIndex.setTotalCollection(this.totalCollection);
            waterChargeIndex.setTotalDue(this.totalDue);
            waterChargeIndex.setStatus(this.status);
            waterChargeIndex.setCategory(this.category);
            waterChargeIndex.setClosureType(this.closureType);
            waterChargeIndex.setConnectionType(this.connectionType);
            waterChargeIndex.setConsumerName(this.consumerName);
            waterChargeIndex.setCreatedDate(this.createdDate);
            waterChargeIndex.setCurrentDemand(this.currentDemand);
            waterChargeIndex.setCurrentDue(this.currentDue);
            waterChargeIndex.setDistrictName(this.districtName);
            waterChargeIndex.setDoorNo(this.doorNo);
            waterChargeIndex.setPipeSize(this.pipeSize);
            waterChargeIndex.setNumberOfPerson(this.numberOfPerson);
            waterChargeIndex.setCreatedDate(this.createdDate);
            waterChargeIndex.setCityName(this.cityName);
            waterChargeIndex.setCityGrade(this.cityGrade);
            waterChargeIndex.setCityCode(this.cityCode);
            waterChargeIndex.setUsage(this.usage);
            waterChargeIndex.setLegacy(this.legacy);
            waterChargeIndex.setLocality(this.locality);
            waterChargeIndex.setPropertyId(this.propertyId);
            waterChargeIndex.setPropertyType(this.propertyType);
            waterChargeIndex.setRegionName(this.regionName);
            waterChargeIndex.setMobileNumber(this.mobileNumber);
            waterChargeIndex.setMonthlyRate(this.monthlyRate);
            waterChargeIndex.setSumpCapacity(this.sumpCapacity);
            waterChargeIndex.setWaterSource(this.waterSource);
            waterChargeIndex.setRevenueWard(this.revenueWard);
            waterChargeIndex.setZone(this.zone);
            return waterChargeIndex;
        }
    }
}

