/*
 * Decompiled with CFR 0.152.
 */
package org.egov.wtms.application.service;

import java.util.Date;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.egov.commons.Installment;
import org.egov.infra.config.persistence.datasource.routing.annotation.ReadOnly;
import org.egov.wtms.application.entity.WaterChargeMaterlizeView;
import org.egov.wtms.application.service.ConnectionDemandService;
import org.hibernate.Query;
import org.hibernate.Session;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class ArrearRegisterReportService {
    @PersistenceContext
    private EntityManager entityManager;
    @Autowired
    private ConnectionDemandService connectionDemandService;

    public Session getCurrentSession() {
        return (Session)this.entityManager.unwrap(Session.class);
    }

    @ReadOnly
    public List<WaterChargeMaterlizeView> prepareQueryforArrearRegisterReport(Long zoneId, Long wardId, Long locality) {
        Installment currentInst = this.connectionDemandService.getCurrentInstallment("Property Tax", null, new Date());
        StringBuilder query = new StringBuilder();
        query.append("select distinct pmv  from WaterChargeMaterlizeView pmv,InstDmdCollResponse idc where pmv.connectiondetailsid = idc.waterMatView.connectiondetailsid and pmv.connectionstatus = 'ACTIVE' and pmv.arrearbalance > 0 and idc.installment.fromDate not between  ('" + currentInst.getFromDate() + "') and ('" + currentInst.getToDate() + "') ");
        if (locality != null && locality != -1L) {
            query.append(" and pmv.locality= :locality ");
        }
        if (zoneId != null && zoneId != -1L) {
            query.append(" and pmv.zoneid= :zoneId ");
        }
        if (wardId != null && wardId != -1L) {
            query.append("  and pmv.wardid= :wardId ");
        }
        query.append(" order by pmv.connectiondetailsid ");
        Query qry = this.getCurrentSession().createQuery(query.toString());
        if (locality != null && locality != -1L) {
            qry.setParameter("locality", (Object)locality);
        }
        if (zoneId != null && zoneId != -1L) {
            qry.setParameter("zoneId", (Object)zoneId);
        }
        if (wardId != null && wardId != -1L) {
            qry.setParameter("wardId", (Object)wardId);
        }
        List propertyViewList = qry.list();
        return propertyViewList;
    }
}

