/*
 * Decompiled with CFR 0.152.
 */
package org.egov.wtms.application.rest;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.egov.collection.entity.ReceiptDetail;
import org.egov.collection.integration.models.BillAccountDetails;
import org.egov.commons.CFinancialYear;
import org.egov.commons.dao.ChartOfAccountsHibernateDAO;
import org.egov.commons.dao.FinancialYearDAO;
import org.egov.commons.dao.FunctionHibernateDAO;
import org.egov.demand.model.EgBillDetails;
import org.egov.infra.validation.exception.ValidationError;
import org.egov.infra.validation.exception.ValidationException;

public class CollectionApportioner {
    public static final String STRING_FULLTAX = "FULLTAX";
    public static final String STRING_ADVANCE = "ADVANCE";
    private static final Logger LOGGER = Logger.getLogger(CollectionApportioner.class);

    public void apportion(BigDecimal amtPaid, List<ReceiptDetail> receiptDetails, Map<String, BigDecimal> instDmdMap) {
        LOGGER.info((Object)("receiptDetails before apportioning amount " + amtPaid + ": " + receiptDetails));
        Amount balance = new Amount(amtPaid);
        BigDecimal crAmountToBePaid = BigDecimal.ZERO;
        for (ReceiptDetail rd : receiptDetails) {
            if (balance.isZero()) {
                rd.zeroDrAndCrAmounts();
                continue;
            }
            crAmountToBePaid = rd.getCramountToBePaid();
            if (balance.isLessThanOrEqualTo(crAmountToBePaid)) {
                rd.setCramount(balance.amount);
                balance = Amount.ZERO;
                continue;
            }
            rd.setCramount(crAmountToBePaid);
            balance = balance.minus(crAmountToBePaid);
        }
        if (balance.isGreaterThanZero()) {
            LOGGER.error((Object)"Apportioning failed: excess payment!");
            throw new ValidationException(Arrays.asList(new ValidationError("Paid Amount is greater than Total Amount to be paid", "Paid Amount is greater than Total Amount to be paid")));
        }
        LOGGER.info((Object)("receiptDetails after apportioning: " + receiptDetails));
    }

    public List<ReceiptDetail> reConstruct(BigDecimal amountPaid, List<EgBillDetails> billDetails, FunctionHibernateDAO functionDAO, ChartOfAccountsHibernateDAO chartOfAccountsDAO, FinancialYearDAO financialYearDAO) {
        ArrayList<ReceiptDetail> receiptDetails = new ArrayList<ReceiptDetail>(0);
        LOGGER.info((Object)("receiptDetails before reApportion amount " + amountPaid + ": " + receiptDetails));
        LOGGER.info((Object)("billDetails before reApportion " + billDetails));
        Amount balance = new Amount(amountPaid);
        CFinancialYear finYear = financialYearDAO.getFinancialYearByDate(new Date());
        BigDecimal crAmountToBePaid = BigDecimal.ZERO;
        for (EgBillDetails billDetail : billDetails) {
            String glCode = billDetail.getGlcode();
            ReceiptDetail receiptDetail = new ReceiptDetail();
            if (billDetail.getDescription().contains("Advance")) {
                receiptDetail.setPurpose(BillAccountDetails.PURPOSE.ADVANCE_AMOUNT.toString());
            } else if (billDetail.getEgDemandReason().getEgInstallmentMaster().getToDate().compareTo(finYear.getStartingDate()) < 0) {
                receiptDetail.setPurpose(BillAccountDetails.PURPOSE.ARREAR_AMOUNT.toString());
            } else if (billDetail.getEgDemandReason().getEgInstallmentMaster().getFromDate().compareTo(finYear.getStartingDate()) >= 0 && billDetail.getEgDemandReason().getEgInstallmentMaster().getFromDate().compareTo(finYear.getEndingDate()) < 0) {
                receiptDetail.setPurpose(BillAccountDetails.PURPOSE.CURRENT_AMOUNT.toString());
            } else {
                receiptDetail.setPurpose(BillAccountDetails.PURPOSE.OTHERS.toString());
            }
            receiptDetail.setOrdernumber(Long.valueOf(billDetail.getOrderNo().intValue()));
            receiptDetail.setDescription(billDetail.getDescription());
            receiptDetail.setIsActualDemand(Boolean.valueOf(true));
            if (billDetail.getFunctionCode() != null) {
                receiptDetail.setFunction(functionDAO.getFunctionByCode(billDetail.getFunctionCode()));
            }
            receiptDetail.setAccounthead(chartOfAccountsDAO.getCChartOfAccountsByGlCode(glCode));
            receiptDetail.setCramountToBePaid(balance.amount);
            receiptDetail.setDramount(BigDecimal.ZERO);
            if (balance.isZero()) {
                receiptDetail.zeroDrAndCrAmounts();
                receiptDetails.add(receiptDetail);
                continue;
            }
            crAmountToBePaid = billDetail.getCrAmount();
            if (balance.isLessThanOrEqualTo(crAmountToBePaid)) {
                receiptDetail.setCramount(balance.amount);
                receiptDetail.setCramountToBePaid(balance.amount);
                balance = Amount.ZERO;
            } else {
                receiptDetail.setCramount(crAmountToBePaid);
                receiptDetail.setCramountToBePaid(crAmountToBePaid);
                balance = balance.minus(crAmountToBePaid);
            }
            receiptDetails.add(receiptDetail);
        }
        if (balance.isGreaterThanZero()) {
            LOGGER.error((Object)"reApportion failed: excess payment!");
            throw new ValidationException(Arrays.asList(new ValidationError("Paid Amount is greater than Total Amount to be paid", "Paid Amount is greater than Total Amount to be paid")));
        }
        LOGGER.info((Object)("receiptDetails after reApportion: " + receiptDetails));
        return receiptDetails;
    }

    private static class Amount {
        private final BigDecimal amount;
        private static Amount ZERO = new Amount(BigDecimal.ZERO);

        private Amount(BigDecimal amount) {
            this.amount = amount;
        }

        private boolean isZero() {
            return this.amount.compareTo(BigDecimal.ZERO) == 0;
        }

        private boolean isGreaterThan(BigDecimal bd) {
            return this.amount.compareTo(bd) > 0;
        }

        private boolean isGreaterThanZero() {
            return this.isGreaterThan(BigDecimal.ZERO);
        }

        private boolean isLessThanOrEqualTo(BigDecimal bd) {
            return this.amount.compareTo(bd) <= 0;
        }

        private Amount minus(BigDecimal bd) {
            return new Amount(this.amount.subtract(bd));
        }
    }
}

