/*
 * Decompiled with CFR 0.152.
 */
package org.egov.wtms.application.entity;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.OrderBy;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.egov.commons.EgwStatus;
import org.egov.commons.entity.ChairPerson;
import org.egov.commons.entity.Source;
import org.egov.infra.filestore.entity.FileStoreMapper;
import org.egov.infra.workflow.entity.StateAware;
import org.egov.wtms.application.entity.ApplicationDocuments;
import org.egov.wtms.application.entity.ConnectionEstimationDetails;
import org.egov.wtms.application.entity.DemandDetail;
import org.egov.wtms.application.entity.ExistingConnectionDetails;
import org.egov.wtms.application.entity.FieldInspectionDetails;
import org.egov.wtms.application.entity.LegacyReceipts;
import org.egov.wtms.application.entity.MeterReadingConnectionDetails;
import org.egov.wtms.application.entity.NonMeteredConnBillDetails;
import org.egov.wtms.application.entity.WaterConnection;
import org.egov.wtms.application.entity.WaterDemandConnection;
import org.egov.wtms.masters.entity.ApplicationType;
import org.egov.wtms.masters.entity.ConnectionCategory;
import org.egov.wtms.masters.entity.PipeSize;
import org.egov.wtms.masters.entity.PropertyType;
import org.egov.wtms.masters.entity.UsageType;
import org.egov.wtms.masters.entity.WaterSource;
import org.egov.wtms.masters.entity.WaterSupply;
import org.egov.wtms.masters.entity.enums.ConnectionStatus;
import org.egov.wtms.masters.entity.enums.ConnectionType;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.SafeHtml;

@Entity
@Table(name="egwtr_connectiondetails")
@SequenceGenerator(name="SEQ_EGWTR_CONNECTIONDETAILS", sequenceName="SEQ_EGWTR_CONNECTIONDETAILS", allocationSize=1)
public class WaterConnectionDetails
extends StateAware {
    private static final long serialVersionUID = -4667948558401042849L;
    public static final String SEQ_CONNECTIONDETAILS = "SEQ_EGWTR_CONNECTIONDETAILS";
    @Id
    @GeneratedValue(generator="SEQ_EGWTR_CONNECTIONDETAILS", strategy=GenerationType.SEQUENCE)
    private Long id;
    @ManyToOne
    @NotNull
    @JoinColumn(name="applicationtype", nullable=false)
    private ApplicationType applicationType;
    @ManyToOne
    @JoinColumn(name="statusid", nullable=false)
    private EgwStatus status;
    @ManyToOne(cascade={CascadeType.ALL})
    @Valid
    @NotNull
    @JoinColumn(name="connection", nullable=false)
    private WaterConnection connection;
    @Valid
    @OneToOne(mappedBy="waterConnectionDetails", cascade={CascadeType.ALL}, fetch=FetchType.LAZY)
    private ExistingConnectionDetails existingConnection;
    @SafeHtml
    private String applicationNumber;
    @Temporal(value=TemporalType.DATE)
    private Date applicationDate;
    @Temporal(value=TemporalType.DATE)
    private Date disposalDate;
    @NotNull
    @Enumerated(value=EnumType.STRING)
    private ConnectionType connectionType;
    @ManyToOne
    @NotNull
    @JoinColumn(name="category", nullable=false)
    private ConnectionCategory category;
    @ManyToOne
    @NotNull
    @JoinColumn(name="usageType", nullable=false)
    private UsageType usageType;
    @ManyToOne
    @NotNull
    @JoinColumn(name="propertyType", nullable=false)
    private PropertyType propertyType;
    @ManyToOne
    @NotNull
    @JoinColumn(name="waterSource", nullable=false)
    private WaterSource waterSource;
    @ManyToOne
    @JoinColumn(name="waterSupply")
    private WaterSupply waterSupply;
    @Length(max=1024)
    private String buildingName;
    @ManyToOne
    @NotNull
    @JoinColumn(name="pipeSize", nullable=false)
    private PipeSize pipeSize;
    private Long sumpCapacity;
    private Integer numberOfPerson;
    @Length(max=1024)
    private String connectionReason;
    private Integer numberOfRooms;
    @Length(max=150)
    private String bplCardHolderName;
    @NotNull
    @Enumerated(value=EnumType.STRING)
    private ConnectionStatus connectionStatus;
    @SafeHtml
    @Length(min=3, max=50)
    private String approvalNumber;
    @Temporal(value=TemporalType.DATE)
    private Date approvalDate;
    @Temporal(value=TemporalType.DATE)
    private Date workOrderDate;
    private String workOrderNumber;
    private String estimationNumber;
    private double donationCharges;
    private Boolean legacy = false;
    @Temporal(value=TemporalType.DATE)
    private Date executionDate;
    @Temporal(value=TemporalType.DATE)
    private Date closeApprovalDate;
    @Temporal(value=TemporalType.DATE)
    private Date reconnectionApprovalDate;
    @ManyToOne(cascade={CascadeType.ALL}, fetch=FetchType.LAZY)
    @JoinColumn(name="filestoreid")
    private FileStoreMapper fileStore;
    @ManyToOne
    @JoinColumn(name="chairPerson")
    private ChairPerson chairPerson;
    private Boolean isHistory = false;
    @Valid
    @OneToOne(mappedBy="waterConnectionDetails", cascade={CascadeType.ALL}, fetch=FetchType.LAZY)
    private FieldInspectionDetails fieldInspectionDetails;
    @OrderBy(value="id")
    @OneToMany(mappedBy="waterConnectionDetails", cascade={CascadeType.ALL}, fetch=FetchType.LAZY)
    private List<ApplicationDocuments> applicationDocs = new ArrayList<ApplicationDocuments>(0);
    @OrderBy(value="id")
    @OneToMany(mappedBy="waterConnectionDetails", cascade={CascadeType.ALL}, fetch=FetchType.LAZY)
    private List<WaterDemandConnection> waterDemandConnection = new ArrayList<WaterDemandConnection>(0);
    @OrderBy(value="id")
    @OneToMany(mappedBy="waterConnectionDetails", cascade={CascadeType.ALL}, fetch=FetchType.LAZY)
    private List<ConnectionEstimationDetails> estimationDetails = new ArrayList<ConnectionEstimationDetails>(0);
    @OrderBy(value="id")
    @OneToMany(mappedBy="waterConnectionDetails", cascade={CascadeType.ALL}, fetch=FetchType.LAZY)
    private List<LegacyReceipts> legacyReceipts = new ArrayList<LegacyReceipts>(0);
    @OrderBy(value="id desc")
    @OneToMany(mappedBy="waterConnectionDetails", cascade={CascadeType.ALL}, fetch=FetchType.LAZY)
    private List<MeterReadingConnectionDetails> meterConnection = new ArrayList<MeterReadingConnectionDetails>(0);
    @OrderBy(value="ID DESC")
    @OneToMany(mappedBy="waterConnectionDetails", cascade={CascadeType.ALL}, fetch=FetchType.LAZY)
    private Set<NonMeteredConnBillDetails> nonmeteredBillDetails = new HashSet<NonMeteredConnBillDetails>(0);
    private String closeConnectionType;
    private String previousApplicationType;
    @Length(max=1024)
    private String closeconnectionreason;
    @Length(max=1024)
    private String reConnectionReason;
    @Transient
    private String meesevaApplicationNumber;
    @Enumerated(value=EnumType.STRING)
    private Source source;
    @Transient
    private Long approvalDepartment;
    @Transient
    private String approvalComent;
    @Transient
    private List<DemandDetail> demandDetailBeanList = new ArrayList<DemandDetail>(0);
    private String referenceNumber;
    @Length(max=1024)
    private String deactivateReason;

    public List<MeterReadingConnectionDetails> getMeterConnection() {
        return this.meterConnection;
    }

    public void setMeterConnection(List<MeterReadingConnectionDetails> meterConnection) {
        this.meterConnection = meterConnection;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String myLinkId() {
        return this.applicationNumber != null ? this.applicationNumber : this.connection.getConsumerCode();
    }

    public String getPreviousApplicationType() {
        return this.previousApplicationType;
    }

    public void setPreviousApplicationType(String previousApplicationType) {
        this.previousApplicationType = previousApplicationType;
    }

    public ApplicationType getApplicationType() {
        return this.applicationType;
    }

    public void setApplicationType(ApplicationType applicationType) {
        this.applicationType = applicationType;
    }

    public WaterConnection getConnection() {
        return this.connection;
    }

    public void setConnection(WaterConnection connection) {
        this.connection = connection;
    }

    public String getApplicationNumber() {
        return this.applicationNumber;
    }

    public void setApplicationNumber(String applicationNumber) {
        this.applicationNumber = applicationNumber;
    }

    public Date getApplicationDate() {
        return this.applicationDate;
    }

    public void setApplicationDate(Date applicationDate) {
        this.applicationDate = applicationDate;
    }

    public Date getDisposalDate() {
        return this.disposalDate;
    }

    public void setDisposalDate(Date disposalDate) {
        this.disposalDate = disposalDate;
    }

    public ConnectionType getConnectionType() {
        return this.connectionType;
    }

    public void setConnectionType(ConnectionType connectionType) {
        this.connectionType = connectionType;
    }

    public ConnectionCategory getCategory() {
        return this.category;
    }

    public void setCategory(ConnectionCategory category) {
        this.category = category;
    }

    public UsageType getUsageType() {
        return this.usageType;
    }

    public void setUsageType(UsageType usageType) {
        this.usageType = usageType;
    }

    public PropertyType getPropertyType() {
        return this.propertyType;
    }

    public void setPropertyType(PropertyType propertyType) {
        this.propertyType = propertyType;
    }

    public WaterSource getWaterSource() {
        return this.waterSource;
    }

    public void setWaterSource(WaterSource waterSource) {
        this.waterSource = waterSource;
    }

    public PipeSize getPipeSize() {
        return this.pipeSize;
    }

    public void setPipeSize(PipeSize pipeSize) {
        this.pipeSize = pipeSize;
    }

    public Long getSumpCapacity() {
        return this.sumpCapacity;
    }

    public void setSumpCapacity(Long sumpCapacity) {
        this.sumpCapacity = sumpCapacity;
    }

    public Integer getNumberOfPerson() {
        return this.numberOfPerson;
    }

    public void setNumberOfPerson(Integer numberOfPerson) {
        this.numberOfPerson = numberOfPerson;
    }

    public ConnectionStatus getConnectionStatus() {
        return this.connectionStatus;
    }

    public void setConnectionStatus(ConnectionStatus connectionStatus) {
        this.connectionStatus = connectionStatus;
    }

    public String getApprovalNumber() {
        return this.approvalNumber;
    }

    public void setApprovalNumber(String approvalNumber) {
        this.approvalNumber = approvalNumber;
    }

    public Date getApprovalDate() {
        return this.approvalDate;
    }

    public void setApprovalDate(Date approvalDate) {
        this.approvalDate = approvalDate;
    }

    public String getConnectionReason() {
        return this.connectionReason;
    }

    public void setConnectionReason(String connectionReason) {
        this.connectionReason = connectionReason;
    }

    public Integer getNumberOfRooms() {
        return this.numberOfRooms;
    }

    public void setNumberOfRooms(Integer numberOfRooms) {
        this.numberOfRooms = numberOfRooms;
    }

    public FieldInspectionDetails getFieldInspectionDetails() {
        return this.fieldInspectionDetails;
    }

    public void setFieldInspectionDetails(FieldInspectionDetails fieldInspectionDetails) {
        this.fieldInspectionDetails = fieldInspectionDetails;
    }

    public List<LegacyReceipts> getLegacyReceipts() {
        return this.legacyReceipts;
    }

    public void setLegacyReceipts(List<LegacyReceipts> legacyReceipts) {
        this.legacyReceipts = legacyReceipts;
    }

    public List<ApplicationDocuments> getApplicationDocs() {
        return this.applicationDocs;
    }

    public List<WaterDemandConnection> getWaterDemandConnection() {
        return this.waterDemandConnection;
    }

    public void setWaterDemandConnection(List<WaterDemandConnection> waterDemandConnection) {
        this.waterDemandConnection = waterDemandConnection;
    }

    public void addWaterDemandConnection(WaterDemandConnection waterDemandConnection) {
        this.getWaterDemandConnection().add(waterDemandConnection);
    }

    public void setApplicationDocs(List<ApplicationDocuments> applicationDocs) {
        this.applicationDocs = applicationDocs;
    }

    public List<ConnectionEstimationDetails> getEstimationDetails() {
        return this.estimationDetails;
    }

    public void setEstimationDetails(List<ConnectionEstimationDetails> estimationDetails) {
        this.estimationDetails = estimationDetails;
    }

    public EgwStatus getStatus() {
        return this.status;
    }

    public void setStatus(EgwStatus status) {
        this.status = status;
    }

    public String getStateDetails() {
        SimpleDateFormat formatter = new SimpleDateFormat("dd-MM-yyyy");
        return String.format("Application Number %s with application date %s.", this.applicationNumber != null ? this.applicationNumber : this.connection.getConsumerCode(), this.applicationDate != null ? formatter.format(this.applicationDate) : formatter.format(new Date()));
    }

    public String getBplCardHolderName() {
        return this.bplCardHolderName;
    }

    public Date getWorkOrderDate() {
        return this.workOrderDate;
    }

    public void setWorkOrderDate(Date workOrderDate) {
        this.workOrderDate = workOrderDate;
    }

    public String getWorkOrderNumber() {
        return this.workOrderNumber;
    }

    public void setWorkOrderNumber(String workOrderNumber) {
        this.workOrderNumber = workOrderNumber;
    }

    public String getEstimationNumber() {
        return this.estimationNumber;
    }

    public void setEstimationNumber(String estimationNumber) {
        this.estimationNumber = estimationNumber;
    }

    public void setBplCardHolderName(String bplCardHolderName) {
        this.bplCardHolderName = bplCardHolderName;
    }

    public ExistingConnectionDetails getExistingConnection() {
        return this.existingConnection;
    }

    public void setExistingConnection(ExistingConnectionDetails existingConnection) {
        this.existingConnection = existingConnection;
    }

    public FileStoreMapper getFileStore() {
        return this.fileStore;
    }

    public void setFileStore(FileStoreMapper fileStore) {
        this.fileStore = fileStore;
    }

    public ChairPerson getChairPerson() {
        return this.chairPerson;
    }

    public void setChairPerson(ChairPerson chairPerson) {
        this.chairPerson = chairPerson;
    }

    public double getDonationCharges() {
        return this.donationCharges;
    }

    public void setDonationCharges(double donationCharges) {
        this.donationCharges = donationCharges;
    }

    public Date getExecutionDate() {
        return this.executionDate;
    }

    public void setExecutionDate(Date executionDate) {
        this.executionDate = executionDate;
    }

    public Boolean getLegacy() {
        return this.legacy;
    }

    public void setLegacy(Boolean legacy) {
        this.legacy = legacy;
    }

    public Boolean getIsHistory() {
        return this.isHistory;
    }

    public void setIsHistory(Boolean isHistory) {
        this.isHistory = isHistory;
    }

    public Set<NonMeteredConnBillDetails> getNonmeteredBillDetails() {
        return this.nonmeteredBillDetails;
    }

    public void setNonmeteredBillDetails(Set<NonMeteredConnBillDetails> nonmeteredBillDetails) {
        this.nonmeteredBillDetails = nonmeteredBillDetails;
    }

    public String getCloseConnectionType() {
        return this.closeConnectionType;
    }

    public void setCloseConnectionType(String closeConnectionType) {
        this.closeConnectionType = closeConnectionType;
    }

    public String getCloseconnectionreason() {
        return this.closeconnectionreason;
    }

    public void setCloseconnectionreason(String closeconnectionreason) {
        this.closeconnectionreason = closeconnectionreason;
    }

    public String getReConnectionReason() {
        return this.reConnectionReason;
    }

    public void setReConnectionReason(String reConnectionReason) {
        this.reConnectionReason = reConnectionReason;
    }

    public Date getCloseApprovalDate() {
        return this.closeApprovalDate;
    }

    public void setCloseApprovalDate(Date closeApprovalDate) {
        this.closeApprovalDate = closeApprovalDate;
    }

    public Date getReconnectionApprovalDate() {
        return this.reconnectionApprovalDate;
    }

    public void setReconnectionApprovalDate(Date reconnectionApprovalDate) {
        this.reconnectionApprovalDate = reconnectionApprovalDate;
    }

    public String getMeesevaApplicationNumber() {
        return this.meesevaApplicationNumber;
    }

    public void setMeesevaApplicationNumber(String meesevaApplicationNumber) {
        this.meesevaApplicationNumber = meesevaApplicationNumber;
    }

    public Source getSource() {
        return this.source;
    }

    public void setSource(Source source) {
        this.source = source;
    }

    public Long getApprovalDepartment() {
        return this.approvalDepartment;
    }

    public void setApprovalDepartment(Long approvalDepartment) {
        this.approvalDepartment = approvalDepartment;
    }

    public String getApprovalComent() {
        return this.approvalComent;
    }

    public void setApprovalComent(String approvalComent) {
        this.approvalComent = approvalComent;
    }

    public List<DemandDetail> getDemandDetailBeanList() {
        return this.demandDetailBeanList;
    }

    public void setDemandDetailBeanList(List<DemandDetail> demandDetailBeanList) {
        this.demandDetailBeanList = demandDetailBeanList;
    }

    public WaterSupply getWaterSupply() {
        return this.waterSupply;
    }

    public void setWaterSupply(WaterSupply waterSupply) {
        this.waterSupply = waterSupply;
    }

    public String getReferenceNumber() {
        return this.referenceNumber;
    }

    public void setReferenceNumber(String referenceNumber) {
        this.referenceNumber = referenceNumber;
    }

    public String getDeactivateReason() {
        return this.deactivateReason;
    }

    public void setDeactivateReason(String deactivateReason) {
        this.deactivateReason = deactivateReason;
    }

    public String getBuildingName() {
        return this.buildingName;
    }

    public void setBuildingName(String buildingName) {
        this.buildingName = buildingName;
    }

    public static enum WorkFlowState {
        CREATED,
        CHECKED,
        APPROVED,
        REJECTED,
        CANCELLED;

    }
}

