/*
 * Decompiled with CFR 0.152.
 */
package org.egov.wtms.scheduler;

import org.apache.log4j.Logger;
import org.egov.infra.admin.master.service.UserService;
import org.egov.infra.scheduler.quartz.AbstractQuartzJob;
import org.egov.wtms.service.bill.WaterConnectionBillService;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class BulkWaterConnBillGenerationJob
extends AbstractQuartzJob {
    private static final long serialVersionUID = 6652765005378915324L;
    private static final Logger LOGGER = Logger.getLogger(BulkWaterConnBillGenerationJob.class);
    private Integer billsCount;
    private Integer modulo;
    @Autowired
    private ApplicationContext beanProvider;
    private WaterConnectionBillService waterConnectionBillService;
    @Autowired
    private UserService userService;

    public void executeJob() {
        LOGGER.debug((Object)("Entered into executeJob" + this.modulo));
        super.prepareCityThreadLocal();
        Long jobStartTime = System.currentTimeMillis();
        WaterConnectionBillService waterConnectionBillService = null;
        try {
            waterConnectionBillService = (WaterConnectionBillService)this.beanProvider.getBean("waterConnectionBillService");
        }
        catch (NoSuchBeanDefinitionException e) {
            LOGGER.warn((Object)"waterConnectionBillService implementation not found");
        }
        if (waterConnectionBillService != null) {
            waterConnectionBillService.bulkBillGeneration(this.modulo, this.billsCount);
        }
        Long timeTaken = System.currentTimeMillis() - jobStartTime;
        System.out.println("timeTaken for job= " + timeTaken);
    }

    public Integer getBillsCount() {
        return this.billsCount;
    }

    public void setBillsCount(Integer billsCount) {
        this.billsCount = billsCount;
    }

    public Integer getModulo() {
        return this.modulo;
    }

    public void setModulo(Integer modulo) {
        this.modulo = modulo;
    }

    public WaterConnectionBillService getWaterConnectionBillService() {
        return this.waterConnectionBillService;
    }

    public void setWaterConnectionBillService(WaterConnectionBillService waterConnectionBillService) {
        this.waterConnectionBillService = waterConnectionBillService;
    }
}

