/*
 * Decompiled with CFR 0.152.
 */
package org.egov.wtms.masters.service;

import java.util.List;
import org.egov.wtms.masters.entity.ConnectionCategory;
import org.egov.wtms.masters.entity.PropertyCategory;
import org.egov.wtms.masters.entity.PropertyType;
import org.egov.wtms.masters.repository.PropertyCategoryRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class PropertyCategoryService {
    private final PropertyCategoryRepository propertyCategoryRepository;

    @Autowired
    public PropertyCategoryService(PropertyCategoryRepository propertyCategoryRepository) {
        this.propertyCategoryRepository = propertyCategoryRepository;
    }

    public PropertyCategory findOne(Long propertyCategoryId) {
        return (PropertyCategory)((Object)this.propertyCategoryRepository.findOne(propertyCategoryId));
    }

    @Transactional
    public PropertyCategory createPropertyCategory(PropertyCategory propertyCategory) {
        propertyCategory.setActive(true);
        return (PropertyCategory)((Object)this.propertyCategoryRepository.save((Object)propertyCategory));
    }

    @Transactional
    public void updatePropertyCategory(PropertyCategory propertyCategory) {
        this.propertyCategoryRepository.save((Object)propertyCategory);
    }

    public PropertyCategory getAllCategoryTypesByPropertyTypeAndCategory(String propertyType, String categoryType) {
        return this.propertyCategoryRepository.findByPropertyType_codeAndConnectionCategory_code(propertyType, categoryType);
    }

    public PropertyCategory findByPropertyTypeAndCategory(PropertyType propertyType, ConnectionCategory connectionCategory) {
        return this.propertyCategoryRepository.findByPropertyTypeAndConnectionCategory(propertyType, connectionCategory);
    }

    public PropertyCategory findByPropertyTypeAndCategoryName(PropertyType propertyType, String categoryType) {
        return this.propertyCategoryRepository.findByPropertyTypeAndConnectionCategory_name(propertyType, categoryType);
    }

    public List<PropertyCategory> findAll() {
        return this.propertyCategoryRepository.findAll(new Sort(Sort.Direction.DESC, new String[]{"id"}));
    }

    public List<PropertyCategory> findAllByPropertyTypeAndConnectionCategory(PropertyType propertyType, ConnectionCategory connectionCategory) {
        return this.propertyCategoryRepository.findAllByPropertyTypeAndConnectionCategory(propertyType, connectionCategory);
    }
}

