/*
 * Decompiled with CFR 0.152.
 */
package org.egov.wtms.masters.service;

import org.apache.commons.lang.StringUtils;
import org.egov.infstr.services.PersistenceService;
import org.hibernate.SQLQuery;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class BoundaryWiseReportService {
    @Qualifier(value="entityQueryService")
    @Autowired
    private PersistenceService entityQueryService;

    public SQLQuery getDrillDownReportQuery(String ward, String block) {
        StringBuffer query = new StringBuffer();
        query.append("SELECT bndry.name as name, ");
        query.append("   COUNT(CASE WHEN cs.code IN ('NEWCONNECTION') THEN 1 END) newconnection ,  COUNT(CASE WHEN cs.code IN ('ADDNLCONNECTION') THEN 1 END) addconnection,  COUNT(CASE WHEN cs.code IN ('CHANGEOFUSE') THEN 1 END) changeofusage,  COUNT(CASE WHEN cs.code IN ('CLOSINGCONNECTION') THEN 1 END) closeconnection,  COUNT(CASE WHEN cs.code IN ('RECONNECTION') THEN 1 END) reconnection ");
        query.append("FROM egwtr_connection con  INNER JOIN egwtr_connectiondetails cd ON con.id = cd.connection INNER JOIN egwtr_application_type cs ON cd.applicationtype=cs.id INNER JOIN egpt_basic_property bp ON con.propertyidentifier = bp.propertyid INNER JOIN EGPT_PROPERTYID ptid ON bp.ID_PROPERTYID= ptid.id INNER JOIN eg_boundary bndry ON bndry.id=ptid.WARD_ADM_ID");
        this.buildWhereClause(ward, block, query);
        this.buildGroupByClause(ward, block, query);
        return this.setParameterForDrillDownReportQuery(query.toString(), ward, block);
    }

    private void buildGroupByClause(String ward, String block, StringBuffer query) {
        query.append("  group by bndry.name ");
    }

    private StringBuffer buildWhereClause(String ward, String block, StringBuffer queryStr) {
        if (StringUtils.isNotBlank((String)ward)) {
            queryStr.append(" WHERE ptid.WARD_ADM_ID=:ward ");
        }
        if (StringUtils.isNotBlank((String)block)) {
            queryStr.append(" and ptid.ADM1=:block ");
        }
        return queryStr;
    }

    private SQLQuery setParameterForDrillDownReportQuery(String querykey, String ward, String block) {
        SQLQuery qry = this.entityQueryService.getSession().createSQLQuery(querykey);
        if (StringUtils.isNotBlank((String)ward)) {
            qry.setLong("ward", Long.valueOf(ward).longValue());
        }
        if (StringUtils.isNotBlank((String)block)) {
            qry.setLong("block", Long.valueOf(block).longValue());
        }
        return qry;
    }
}

