/*
 * Decompiled with CFR 0.152.
 */
package org.egov.wtms.elasticSearch.service;

import java.math.BigDecimal;
import java.util.Iterator;
import org.egov.config.search.Index;
import org.egov.config.search.IndexType;
import org.egov.infra.admin.master.entity.Boundary;
import org.egov.infra.admin.master.entity.City;
import org.egov.infra.admin.master.service.BoundaryService;
import org.egov.infra.admin.master.service.CityService;
import org.egov.infra.config.core.ApplicationThreadLocals;
import org.egov.infra.search.elastic.annotation.Indexing;
import org.egov.ptis.domain.model.AssessmentDetails;
import org.egov.ptis.domain.model.OwnerName;
import org.egov.wtms.application.entity.WaterConnectionDetails;
import org.egov.wtms.elasticSearch.entity.ConsumerSearch;
import org.elasticsearch.common.geo.GeoPoint;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class ConsumerIndexService {
    @Autowired
    private CityService cityService;
    @Autowired
    private BoundaryService boundaryService;

    @Indexing(name=Index.WATERCHARGES, type=IndexType.CONNECTIONSEARCH)
    public ConsumerSearch createConsumerIndex(WaterConnectionDetails waterConnectionDetails, AssessmentDetails assessmentDetails, BigDecimal amountTodisplayInIndex) {
        Boundary adminBoundary;
        String mobileNumber = null;
        Iterator ownerNameItr = assessmentDetails.getOwnerNames().iterator();
        if (ownerNameItr != null && ownerNameItr.hasNext()) {
            mobileNumber = ((OwnerName)ownerNameItr.next()).getMobileNumber();
        }
        City cityWebsite = this.cityService.getCityByURL(ApplicationThreadLocals.getDomainName());
        ConsumerSearch consumerSearch = new ConsumerSearch(waterConnectionDetails.getConnection().getConsumerCode(), mobileNumber, waterConnectionDetails.getUsageType().getName(), cityWebsite.getName(), waterConnectionDetails.getCreatedDate(), cityWebsite.getDistrictName(), cityWebsite.getRegionName(), cityWebsite.getGrade());
        consumerSearch.setZone(assessmentDetails.getBoundaryDetails().getZoneName());
        consumerSearch.setWard(assessmentDetails.getBoundaryDetails().getWardName());
        consumerSearch.setAdminWard(assessmentDetails.getBoundaryDetails().getAdminWardName());
        consumerSearch.setDoorno(assessmentDetails.getHouseNo());
        consumerSearch.setTotalDue(assessmentDetails.getPropertyDetails().getTaxDue());
        consumerSearch.setIslegacy(waterConnectionDetails.getLegacy());
        consumerSearch.setClosureType(waterConnectionDetails.getCloseConnectionType());
        consumerSearch.setLocality(assessmentDetails.getBoundaryDetails().getLocalityName() != null ? assessmentDetails.getBoundaryDetails().getLocalityName() : "");
        consumerSearch.setPropertyId(waterConnectionDetails.getConnection().getPropertyIdentifier());
        consumerSearch.setApplicationCode(waterConnectionDetails.getApplicationType().getCode());
        consumerSearch.setStatus(waterConnectionDetails.getConnectionStatus().name());
        consumerSearch.setConnectionType(waterConnectionDetails.getConnectionType().name());
        consumerSearch.setWaterTaxDue(amountTodisplayInIndex);
        consumerSearch.setWaterSourceType(waterConnectionDetails.getWaterSource().getWaterSourceType());
        consumerSearch.setPropertyType(waterConnectionDetails.getPropertyType().getName());
        consumerSearch.setCategory(waterConnectionDetails.getCategory().getName());
        consumerSearch.setSumpCapacity(waterConnectionDetails.getSumpCapacity());
        consumerSearch.setPipeSize(waterConnectionDetails.getPipeSize().getCode());
        consumerSearch.setNumberOfPerson(waterConnectionDetails.getNumberOfPerson());
        if (assessmentDetails.getLatitude() != 0.0 && assessmentDetails.getLongitude() != 0.0) {
            consumerSearch.setPropertyLocation(new GeoPoint(assessmentDetails.getLatitude(), assessmentDetails.getLongitude()));
        }
        if (assessmentDetails.getBoundaryDetails().getAdminWardId() != null && (adminBoundary = this.boundaryService.getBoundaryById(assessmentDetails.getBoundaryDetails().getAdminWardId())).getLatitude() != null && adminBoundary.getLongitude() != null) {
            consumerSearch.setWardLocation(new GeoPoint((double)adminBoundary.getLatitude().floatValue(), (double)adminBoundary.getLongitude().floatValue()));
        }
        if ((ownerNameItr = assessmentDetails.getOwnerNames().iterator()).hasNext()) {
            OwnerName ownerName = (OwnerName)ownerNameItr.next();
            consumerSearch.setConsumerName(ownerName.getOwnerName());
            consumerSearch.setAadhaarNumber(ownerName.getAadhaarNumber() != null ? ownerName.getAadhaarNumber() : "");
            while (ownerNameItr.hasNext()) {
                OwnerName multipleOwner = (OwnerName)ownerNameItr.next();
                consumerSearch.setConsumerName(consumerSearch.getConsumerName().concat(",".concat(multipleOwner.getOwnerName())));
                consumerSearch.setAadhaarNumber(consumerSearch.getAadhaarNumber().concat(",".concat(multipleOwner.getAadhaarNumber() != null ? multipleOwner.getAadhaarNumber() : "")));
            }
        }
        return consumerSearch;
    }
}

