/*
 * Decompiled with CFR 0.152.
 */
package org.egov.wtms.application.workflow;

import java.math.BigDecimal;
import java.util.Date;
import org.egov.eis.entity.Assignment;
import org.egov.eis.service.AssignmentService;
import org.egov.eis.service.EisCommonService;
import org.egov.eis.service.PositionMasterService;
import org.egov.infra.admin.master.entity.Role;
import org.egov.infra.admin.master.entity.User;
import org.egov.infra.admin.master.service.UserService;
import org.egov.infra.security.utils.SecurityUtils;
import org.egov.infra.workflow.entity.StateHistory;
import org.egov.infra.workflow.matrix.entity.WorkFlowMatrix;
import org.egov.infra.workflow.service.SimpleWorkflowService;
import org.egov.pims.commons.Position;
import org.egov.ptis.domain.model.AssessmentDetails;
import org.egov.ptis.domain.model.enums.BasicPropertyStatus;
import org.egov.ptis.domain.service.property.PropertyExternalService;
import org.egov.wtms.application.entity.WaterConnectionDetails;
import org.egov.wtms.application.repository.WaterConnectionDetailsRepository;
import org.egov.wtms.application.service.WaterConnectionDetailsService;
import org.egov.wtms.application.service.WaterConnectionSmsAndEmailService;
import org.egov.wtms.application.workflow.ApplicationWorkflowCustom;
import org.egov.wtms.elasticSearch.service.ConsumerIndexService;
import org.egov.wtms.masters.entity.enums.ConnectionStatus;
import org.egov.wtms.utils.PropertyExtnUtils;
import org.egov.wtms.utils.WaterTaxUtils;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public abstract class ApplicationWorkflowCustomImpl
implements ApplicationWorkflowCustom {
    private static final Logger LOG = LoggerFactory.getLogger(ApplicationWorkflowCustomImpl.class);
    @Autowired
    private WaterConnectionDetailsRepository waterConnectionDetailsRepository;
    @Autowired
    private PropertyExtnUtils propertyExtnUtils;
    @Autowired
    private EisCommonService eisCommonService;
    @Autowired
    private SecurityUtils securityUtils;
    @Autowired
    private AssignmentService assignmentService;
    @Autowired
    private PositionMasterService positionMasterService;
    @Autowired
    private WaterTaxUtils waterTaxUtils;
    @Autowired
    private ConsumerIndexService consumerIndexService;
    @Autowired
    private UserService userService;
    @Autowired
    private WaterConnectionSmsAndEmailService waterConnectionSmsAndEmailService;
    @Autowired
    @Qualifier(value="workflowService")
    private SimpleWorkflowService<WaterConnectionDetails> waterConnectionWorkflowService;
    @Autowired
    private WaterConnectionDetailsService waterConnectionDetailsService;

    @Autowired
    public ApplicationWorkflowCustomImpl() {
    }

    @Override
    public void createCommonWorkflowTransition(WaterConnectionDetails waterConnectionDetails, Long approvalPosition, String approvalComent, String additionalRule, String workFlowAction) {
        if (LOG.isDebugEnabled()) {
            LOG.debug(" Create WorkFlow Transition Started  ...");
        }
        User user = this.securityUtils.getCurrentUser();
        DateTime currentDate = new DateTime();
        User currentUser = null;
        Assignment userAssignment = this.assignmentService.getPrimaryAssignmentForUser(user.getId());
        Position pos = null;
        Object wfInitiator = null;
        Boolean recordCreatedBYNonEmployee = this.waterTaxUtils.getCurrentUserRole(waterConnectionDetails.getCreatedBy());
        String currState = "";
        String natureOfwork = this.getNatureOfTask(waterConnectionDetails);
        if (recordCreatedBYNonEmployee.booleanValue()) {
            currState = "Created";
            if (!waterConnectionDetails.getStateHistory().isEmpty()) {
                wfInitiator = this.assignmentService.getPrimaryAssignmentForPositon(((StateHistory)waterConnectionDetails.getStateHistory().get(0)).getOwnerPosition().getId());
            }
        } else if (null != waterConnectionDetails.getId()) {
            currentUser = this.userService.getUserById(waterConnectionDetails.getCreatedBy().getId());
            if (currentUser != null && waterConnectionDetails.getLegacy().equals(true)) {
                for (Role userrole : currentUser.getRoles()) {
                    if (!userrole.getName().equals("Super User")) continue;
                    Position positionuser = this.waterTaxUtils.getZonalLevelClerkForLoggedInUser(waterConnectionDetails.getConnection().getPropertyIdentifier());
                    if (positionuser != null) {
                        wfInitiator = this.assignmentService.getPrimaryAssignmentForPositionAndDate(positionuser.getId(), new Date());
                    }
                    break;
                }
            } else {
                wfInitiator = this.assignmentService.getPrimaryAssignmentForUser(waterConnectionDetails.getCreatedBy().getId());
            }
        }
        if ("Reject".equalsIgnoreCase(workFlowAction)) {
            if (wfInitiator.equals(userAssignment)) {
                waterConnectionDetails.setConnectionStatus(ConnectionStatus.INACTIVE);
                waterConnectionDetails.setStatus(this.waterTaxUtils.getStatusByCodeAndModuleType("CANCELLED", "WATERTAXAPPLICATION"));
                waterConnectionDetails.transition(true).end().withSenderName(user.getUsername() + "::" + user.getName()).withComments(approvalComent).withDateInfo(currentDate.toDate()).withNatureOfTask(natureOfwork);
                this.waterConnectionSmsAndEmailService.sendSmsAndEmailOnRejection(waterConnectionDetails, approvalComent);
                this.waterConnectionDetailsService.updateIndexes(waterConnectionDetails, null);
            } else {
                String stateValue = "Rejected";
                waterConnectionDetails.transition(true).withSenderName(user.getUsername() + "::" + user.getName()).withComments(approvalComent).withStateValue("Rejected").withDateInfo(currentDate.toDate()).withOwner(wfInitiator.getPosition()).withNextAction("Application Rejected").withNatureOfTask(natureOfwork);
            }
        } else {
            if (null != approvalPosition && approvalPosition != -1L && !approvalPosition.equals(0L)) {
                pos = this.positionMasterService.getPositionById(approvalPosition);
            }
            WorkFlowMatrix wfmatrix = null;
            if (null == waterConnectionDetails.getState()) {
                wfmatrix = this.waterConnectionWorkflowService.getWfMatrix(waterConnectionDetails.getStateType(), null, null, additionalRule, currState, null);
                waterConnectionDetails.transition().start().withSenderName(user.getUsername() + "::" + user.getName()).withComments(approvalComent).withStateValue(wfmatrix.getNextState()).withDateInfo(new Date()).withOwner(pos).withNextAction(wfmatrix.getNextAction()).withNatureOfTask(natureOfwork);
            } else if ("Execute Tap".equalsIgnoreCase(workFlowAction)) {
                if (null != workFlowAction && !workFlowAction.isEmpty() && workFlowAction.equalsIgnoreCase("Execute Tap") && waterConnectionDetails.getApplicationType().getCode().equalsIgnoreCase("CHANGEOFUSE")) {
                    WaterConnectionDetails connectionToBeDeactivated = this.waterConnectionDetailsRepository.findByConnection_ConsumerCodeAndConnectionStatus(waterConnectionDetails.getConnection().getConsumerCode(), ConnectionStatus.ACTIVE);
                    connectionToBeDeactivated.setConnectionStatus(ConnectionStatus.INACTIVE);
                    connectionToBeDeactivated.setIsHistory(true);
                    this.waterConnectionDetailsRepository.saveAndFlush((Object)connectionToBeDeactivated);
                }
                wfmatrix = this.waterConnectionWorkflowService.getWfMatrix(waterConnectionDetails.getStateType(), null, null, additionalRule, waterConnectionDetails.getCurrentState().getValue(), null);
                AssessmentDetails assessmentDetailsFullFlag = this.propertyExtnUtils.getAssessmentDetailsForFlag(waterConnectionDetails.getConnection().getPropertyIdentifier(), PropertyExternalService.FLAG_FULL_DETAILS, BasicPropertyStatus.ALL);
                waterConnectionDetails.setStatus(this.waterTaxUtils.getStatusByCodeAndModuleType("SANCTIONED", "WATERTAXAPPLICATION"));
                this.waterConnectionDetailsService.updateIndexes(waterConnectionDetails, null);
                if (waterConnectionDetails.getApplicationType().getCode().equalsIgnoreCase("CHANGEOFUSE")) {
                    BigDecimal amountTodisplayInIndex = this.waterConnectionDetailsService.getTotalAmount(waterConnectionDetails);
                    waterConnectionDetails.setConnectionStatus(ConnectionStatus.ACTIVE);
                    this.consumerIndexService.createConsumerIndex(waterConnectionDetails, assessmentDetailsFullFlag, amountTodisplayInIndex);
                }
                if (wfmatrix.getNextAction().equalsIgnoreCase("END")) {
                    waterConnectionDetails.transition(true).end().withSenderName(user.getUsername() + "::" + user.getName()).withComments(approvalComent).withDateInfo(currentDate.toDate()).withNatureOfTask(natureOfwork);
                }
            } else if (null != approvalComent && "Receipt Cancelled".equalsIgnoreCase(approvalComent)) {
                wfmatrix = this.waterConnectionWorkflowService.getWfMatrix(waterConnectionDetails.getStateType(), null, null, additionalRule, "Asst engg approved", null);
                waterConnectionDetails.transition(true).withSenderName(user.getUsername() + "::" + user.getName()).withComments(approvalComent).withStateValue(wfmatrix.getNextState()).withDateInfo(currentDate.toDate()).withOwner(pos).withNextAction(wfmatrix.getNextAction()).withNatureOfTask(natureOfwork);
            } else if ((additionalRule.equals("CLOSECONNECTION") || additionalRule.equals("RECONNECTION")) && (waterConnectionDetails.getCurrentState().getValue().equals("Closed") || waterConnectionDetails.getCurrentState().getValue().equals("END"))) {
                wfmatrix = this.waterConnectionWorkflowService.getWfMatrix(waterConnectionDetails.getStateType(), null, null, additionalRule, null, null);
                if (wfmatrix != null && !wfmatrix.getNextAction().equalsIgnoreCase("END")) {
                    waterConnectionDetails.transition(true).withSenderName(user.getUsername() + "::" + user.getName()).withComments(approvalComent).withStateValue(wfmatrix.getNextState()).withDateInfo(currentDate.toDate()).withOwner(pos).withNextAction(wfmatrix.getNextAction()).withNatureOfTask(natureOfwork);
                }
            } else {
                wfmatrix = this.waterConnectionWorkflowService.getWfMatrix(waterConnectionDetails.getStateType(), null, null, additionalRule, waterConnectionDetails.getCurrentState().getValue(), null);
                if ((additionalRule.equals("CLOSECONNECTION") || additionalRule.equals("RECONNECTION")) && wfmatrix != null && wfmatrix.getNextAction().equalsIgnoreCase("END")) {
                    waterConnectionDetails.transition(true).end().withSenderName(user.getUsername() + "::" + user.getName()).withComments(approvalComent).withDateInfo(currentDate.toDate()).withNatureOfTask(natureOfwork);
                } else {
                    waterConnectionDetails.transition(true).withSenderName(user.getUsername() + "::" + user.getName()).withComments(approvalComent).withStateValue(wfmatrix.getNextState()).withDateInfo(currentDate.toDate()).withOwner(pos).withNextAction(wfmatrix.getNextAction()).withNatureOfTask(natureOfwork);
                }
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(" WorkFlow Transition Completed  ...");
        }
    }

    public String getNatureOfTask(WaterConnectionDetails waterConnectionDetails) {
        String wfTypeDisplayNmae = "Water Tap Connection";
        if (waterConnectionDetails.getStatus().getCode().equals("CLOSERINPROGRESS") || waterConnectionDetails.getStatus().getCode().equals("CLOSERINITIATED") || waterConnectionDetails.getStatus().getCode().equals("CLOSUREDIGSIGNPENDING") || waterConnectionDetails.getStatus().getCode().equals("CLOSERAPPROVED") || waterConnectionDetails.getStatus().getCode().equals("CLOSERSANCTIONED")) {
            return "Water Tap Connection::Closure Connection";
        }
        if (waterConnectionDetails.getStatus().getCode().equals("RECONNECTIONINITIATED") || waterConnectionDetails.getStatus().getCode().equals("RECONNECTIONINPROGRESS") || waterConnectionDetails.getStatus().getCode().equals("RECONNECTIONAPPROVED") || waterConnectionDetails.getStatus().getCode().equals("RECONNDIGSIGNPENDING") || waterConnectionDetails.getStatus().getCode().equals("RECONNECTIONSANCTIONED")) {
            return "Water Tap Connection::Reconnection";
        }
        return "Water Tap Connection::" + waterConnectionDetails.getApplicationType().getName();
    }
}

