/*
 * Decompiled with CFR 0.152.
 */
package org.egov.wtms.application.service.collection;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.apache.log4j.Logger;
import org.egov.collection.entity.ReceiptDetail;
import org.egov.collection.integration.models.BillReceiptInfo;
import org.egov.collection.integration.models.BillReceiptInfoImpl;
import org.egov.collection.integration.models.ReceiptAccountInfo;
import org.egov.collection.integration.models.ReceiptAmountInfo;
import org.egov.collection.integration.models.ReceiptInstrumentInfo;
import org.egov.collection.integration.services.CollectionIntegrationService;
import org.egov.commons.CFinancialYear;
import org.egov.commons.Installment;
import org.egov.commons.dao.ChartOfAccountsHibernateDAO;
import org.egov.commons.dao.FinancialYearDAO;
import org.egov.commons.dao.FunctionHibernateDAO;
import org.egov.demand.dao.DemandGenericDao;
import org.egov.demand.dao.EgBillDao;
import org.egov.demand.integration.TaxCollection;
import org.egov.demand.model.EgBill;
import org.egov.demand.model.EgBillDetails;
import org.egov.demand.model.EgDemand;
import org.egov.demand.model.EgDemandDetails;
import org.egov.demand.model.EgDemandReason;
import org.egov.demand.model.EgDemandReasonMaster;
import org.egov.infra.admin.master.entity.Module;
import org.egov.infra.admin.master.service.ModuleService;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infra.workflow.entity.StateHistory;
import org.egov.infra.workflow.matrix.entity.WorkFlowMatrix;
import org.egov.infra.workflow.service.SimpleWorkflowService;
import org.egov.infstr.services.PersistenceService;
import org.egov.pims.commons.Position;
import org.egov.wtms.application.entity.WaterConnectionDetails;
import org.egov.wtms.application.entity.WaterDemandConnection;
import org.egov.wtms.application.repository.WaterConnectionDetailsRepository;
import org.egov.wtms.application.rest.CollectionApportioner;
import org.egov.wtms.application.service.WaterConnectionDetailsService;
import org.egov.wtms.application.service.WaterConnectionSmsAndEmailService;
import org.egov.wtms.application.service.collection.ConnectionBillService;
import org.egov.wtms.application.workflow.ApplicationWorkflowCustomDefaultImpl;
import org.egov.wtms.masters.entity.enums.ConnectionStatus;
import org.egov.wtms.masters.entity.enums.ConnectionType;
import org.egov.wtms.utils.WaterTaxUtils;
import org.egov.wtms.utils.constants.WaterTaxConstants;
import org.hibernate.Session;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class WaterTaxCollection
extends TaxCollection {
    private static final Logger LOGGER = Logger.getLogger(WaterTaxCollection.class);
    @Autowired
    private EgBillDao egBillDAO;
    @Autowired
    private ModuleService moduleService;
    @Autowired
    private WaterConnectionDetailsService waterConnectionDetailsService;
    @Autowired
    private WaterConnectionDetailsRepository waterConnectionDetailsRepository;
    @Autowired
    private WaterTaxUtils waterTaxUtils;
    @Autowired
    @Qualifier(value="workflowService")
    private SimpleWorkflowService<WaterConnectionDetails> waterConnectionWorkflowService;
    @Autowired
    private WaterConnectionSmsAndEmailService waterConnectionSmsAndEmailService;
    @Autowired
    private ConnectionBillService connectionBillService;
    @Autowired
    private CollectionIntegrationService collectionService;
    @PersistenceContext
    private EntityManager entityManager;
    @Autowired
    private FinancialYearDAO financialYearDAO;
    @Autowired
    private FunctionHibernateDAO functionDAO;
    @Autowired
    @Qualifier(value="persistenceService")
    private PersistenceService persistenceService;
    @Autowired
    private DemandGenericDao demandGenericDAO;
    @Autowired
    private ChartOfAccountsHibernateDAO chartOfAccountsDAO;

    public Session getCurrentSession() {
        return (Session)this.entityManager.unwrap(Session.class);
    }

    @Transactional
    public void updateDemandDetails(BillReceiptInfo billRcptInfo) throws ApplicationRuntimeException {
        BigDecimal totalAmount = billRcptInfo.getTotalAmount();
        EgDemand demand = this.getCurrentDemand(Long.valueOf(billRcptInfo.getBillReferenceNum()));
        String indexNo = ((BillReceiptInfoImpl)billRcptInfo).getReceiptMisc().getReceiptHeader().getConsumerCode();
        try {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("updateDemandDetails : Demand before proceeding : " + demand));
                LOGGER.debug((Object)("updateDemandDetails : collection back update started for property : " + indexNo + " and receipt event is " + billRcptInfo.getEvent() + ". Total Receipt amount is." + totalAmount + " with receipt no." + billRcptInfo.getReceiptNum()));
            }
            if (billRcptInfo.getEvent().equals("RECEIPT_CREATED")) {
                this.updateCollForRcptCreate(demand, billRcptInfo, totalAmount);
                this.updateWaterConnectionDetails(demand);
                this.updateWaterTaxIndexes(demand);
            } else if (billRcptInfo.getEvent().equals("RECEIPT_CANCELLED")) {
                this.updateCollectionForRcptCancel(demand, billRcptInfo);
                this.updateWaterConnDetailsStatus(demand, billRcptInfo);
                this.updateWaterTaxIndexes(demand);
            } else if (billRcptInfo.getEvent().equals("INSTRUMENT_BOUNCED")) {
                this.updateCollForChequeBounce(demand, billRcptInfo);
                this.updateWaterTaxIndexes(demand);
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("updateDemandDetails : Demand after processed : " + demand));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ApplicationRuntimeException("Error occured during back update of DCB : " + e.getMessage(), (Throwable)e);
        }
    }

    private void updateCollForChequeBounce(EgDemand demand, BillReceiptInfo billRcptInfo) {
        LOGGER.debug((Object)("reconcileCollForChequeBounce : Updating Collection Started For Demand : " + demand + " with BillReceiptInfo - " + billRcptInfo));
        this.cancelBill(Long.valueOf(billRcptInfo.getBillReferenceNum()));
        demand.setStatus(WaterTaxConstants.DMD_STATUS_CHEQUE_BOUNCED);
        this.updateDmdDetForRcptCancelAndCheckBounce(demand, billRcptInfo);
        LOGGER.debug((Object)("reconcileCollForChequeBounce : Updating Collection finished For Demand : " + demand));
    }

    @Transactional
    private void updateDmdDetForRcptCancelAndCheckBounce(EgDemand demand, BillReceiptInfo billRcptInfo) {
        LOGGER.debug((Object)"Entering method updateDmdDetForRcptCancelAndCheckBounce");
        String installment = "";
        block0: for (ReceiptAccountInfo rcptAccInfo : billRcptInfo.getAccountDetails()) {
            if (rcptAccInfo.getCrAmount() == null || rcptAccInfo.getCrAmount().compareTo(BigDecimal.ZERO) != 1 || rcptAccInfo.getIsRevenueAccount()) continue;
            String[] desc = rcptAccInfo.getDescription().split("-", 2);
            String reason = desc[0].trim();
            String[] installsplit = desc[1].split("#");
            installment = installsplit[0].trim();
            for (EgDemandDetails demandDetail : demand.getEgDemandDetails()) {
                if (!reason.equalsIgnoreCase(demandDetail.getEgDemandReason().getEgDemandReasonMaster().getReasonMaster()) || !installment.equalsIgnoreCase(demandDetail.getEgDemandReason().getEgInstallmentMaster().getDescription())) continue;
                Iterator iterator = billRcptInfo.getInstrumentDetails().iterator();
                if (!iterator.hasNext()) break block0;
                ReceiptInstrumentInfo instrumentHeader = (ReceiptInstrumentInfo)iterator.next();
                if (instrumentHeader != null) {
                    demandDetail.setAmtCollected(demandDetail.getAmtCollected().subtract(instrumentHeader.getInstrumentAmount()));
                    if (demand.getAmtCollected() != null && demand.getAmtCollected().compareTo(BigDecimal.ZERO) > 0 && demandDetail.getEgDemandReason().getEgDemandReasonMaster().getIsDemand().booleanValue()) {
                        demand.setAmtCollected(demand.getAmtCollected().subtract(instrumentHeader.getInstrumentAmount()));
                    }
                }
                LOGGER.info((Object)("Deducted Collected amount Rs." + rcptAccInfo.getCrAmount() + " for tax : " + reason + " and installment : " + installment));
                break block0;
            }
        }
        this.updateReceiptStatusWhenCancelled(billRcptInfo.getReceiptNum());
        LOGGER.debug((Object)"Exiting method updateDmdDetForRcptCancelAndCheckBounce");
    }

    @Transactional
    public void updateWaterConnectionDetails(EgDemand demand) {
        WaterConnectionDetails waterConnectionDetails = this.waterConnectionDetailsService.getWaterConnectionDetailsByDemand(demand);
        if (!waterConnectionDetails.getConnectionStatus().equals((Object)ConnectionStatus.ACTIVE)) {
            waterConnectionDetails.setStatus(this.waterTaxUtils.getStatusByCodeAndModuleType("ESTIMATIONAMOUNTPAID", "WATERTAXAPPLICATION"));
            Long approvalPosition = 0L;
            WorkFlowMatrix wfmatrix = this.waterConnectionWorkflowService.getWfMatrix(waterConnectionDetails.getStateType(), null, null, "NEWCONNECTION", waterConnectionDetails.getCurrentState().getValue(), null);
            Position posobj = this.waterTaxUtils.getCityLevelCommissionerPosition(wfmatrix.getNextDesignation(), waterConnectionDetails.getConnection().getPropertyIdentifier());
            if (posobj != null) {
                approvalPosition = posobj.getId();
            }
            ApplicationWorkflowCustomDefaultImpl applicationWorkflowCustomDefaultImpl = this.waterConnectionDetailsService.getInitialisedWorkFlowBean();
            applicationWorkflowCustomDefaultImpl.createCommonWorkflowTransition(waterConnectionDetails, approvalPosition, "Water connection fee collected", "NEWCONNECTION", null);
            this.waterConnectionSmsAndEmailService.sendSmsAndEmail(waterConnectionDetails, null);
            this.waterConnectionDetailsRepository.saveAndFlush((Object)waterConnectionDetails);
        }
    }

    @Transactional
    private void updateCollForRcptCreate(EgDemand demand, BillReceiptInfo billRcptInfo, BigDecimal totalAmount) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("updateCollForRcptCreate : Updating Collection Started For Demand : " + demand + " with BillReceiptInfo - " + billRcptInfo));
        }
        try {
            this.updateDemandDetailForReceiptCreate(billRcptInfo.getAccountDetails(), demand, billRcptInfo, totalAmount);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ApplicationRuntimeException("Error occured during back update of DCB : updateCollForRcptCreate() " + e.getMessage(), (Throwable)e);
        }
    }

    @Transactional
    private void updateDemandDetailForReceiptCreate(Set<ReceiptAccountInfo> accountDetails, EgDemand demand, BillReceiptInfo billRcptInfo, BigDecimal totalAmount) {
        StringBuilder query = new StringBuilder("select dmdet FROM EgDemandDetails dmdet left join fetch dmdet.egDemandReason dmdRsn ").append("left join fetch dmdRsn.egDemandReasonMaster dmdRsnMstr left join fetch dmdRsn.egInstallmentMaster installment ").append("WHERE dmdet.egDemand.id = :demand");
        List demandDetailList = this.getCurrentSession().createQuery(query.toString()).setLong("demand", demand.getId().longValue()).list();
        HashMap installmentWiseDemandDetailsByReason = new HashMap();
        HashMap<String, EgDemandDetails> demandDetailByReason = null;
        EgDemandReason dmdRsn = null;
        String installmentDesc = null;
        for (EgDemandDetails dmdDtls : demandDetailList) {
            if (dmdDtls.getAmount().compareTo(BigDecimal.ZERO) > 0 || dmdDtls.getEgDemandReason().getEgDemandReasonMaster().getCode().equalsIgnoreCase("WTADVANCE")) {
                dmdRsn = dmdDtls.getEgDemandReason();
                installmentDesc = dmdRsn.getEgInstallmentMaster().getDescription();
                demandDetailByReason = new HashMap<String, EgDemandDetails>(0);
                if (installmentWiseDemandDetailsByReason.get(installmentDesc) == null) {
                    demandDetailByReason.put(dmdRsn.getEgDemandReasonMaster().getReasonMaster(), dmdDtls);
                    installmentWiseDemandDetailsByReason.put(installmentDesc, demandDetailByReason);
                }
                ((Map)installmentWiseDemandDetailsByReason.get(installmentDesc)).put(dmdRsn.getEgDemandReasonMaster().getReasonMaster(), dmdDtls);
                continue;
            }
            if (!LOGGER.isDebugEnabled()) continue;
            LOGGER.debug((Object)("saveCollectionDetails - demand detail amount is zero " + dmdDtls));
        }
        EgDemandDetails demandDetail = null;
        HashMap<String, Installment> currInstallments = new HashMap<String, Installment>();
        List<Installment> currInstallmentList = this.waterTaxUtils.getInstallmentsForCurrYear(new Date());
        currInstallments.put("Current 1st Half", currInstallmentList.get(0));
        currInstallments.put("Current 1st Half", currInstallmentList.get(1));
        for (ReceiptAccountInfo rcptAccInfo : accountDetails) {
            if (rcptAccInfo.getDescription() == null || rcptAccInfo.getDescription().isEmpty() || rcptAccInfo.getCrAmount() == null || rcptAccInfo.getCrAmount().compareTo(BigDecimal.ZERO) != 1) continue;
            String[] desc = rcptAccInfo.getDescription().split("-", 2);
            String[] installsplit = desc[1].split("#");
            String reason = desc[0].trim();
            String instDesc = installsplit[0].trim();
            demandDetail = reason.equalsIgnoreCase("Advance") ? (EgDemandDetails)((Map)installmentWiseDemandDetailsByReason.get(((Installment)currInstallments.get("Current 1st Half")).getDescription())).get(reason) : (EgDemandDetails)((Map)installmentWiseDemandDetailsByReason.get(instDesc)).get(reason);
            if (rcptAccInfo.getGlCode().equalsIgnoreCase("3504106")) {
                if (demandDetail != null) {
                    demandDetail.setAmtCollected(demandDetail.getAmtCollected().add(rcptAccInfo.getCrAmount()));
                } else {
                    demandDetail = this.insertAdvanceCollection("WTADVANCE", rcptAccInfo.getCrAmount(), (Installment)currInstallments.get("Current 1st Half"));
                    demand.addEgDemandDetails(demandDetail);
                    this.persistenceService.getSession().flush();
                    if (installmentWiseDemandDetailsByReason.get(((Installment)currInstallments.get("Current 1st Half")).getDescription()) == null) {
                        HashMap<String, EgDemandDetails> reasonAndDemandDetail = new HashMap<String, EgDemandDetails>();
                        reasonAndDemandDetail.put("Advance", demandDetail);
                        installmentWiseDemandDetailsByReason.put(((Installment)currInstallments.get("Current 1st Half")).getDescription(), reasonAndDemandDetail);
                    } else {
                        ((Map)installmentWiseDemandDetailsByReason.get(((Installment)currInstallments.get("Current 1st Half")).getDescription())).put("Advance", demandDetail);
                    }
                }
            } else {
                demandDetail.addCollectedWithOnePaisaTolerance(rcptAccInfo.getCrAmount());
                if (demandDetail.getEgDemandReason().getEgDemandReasonMaster().getIsDemand().booleanValue()) {
                    demand.addCollected(rcptAccInfo.getCrAmount());
                }
            }
            this.persistCollectedReceipts(demandDetail, billRcptInfo.getReceiptNum(), totalAmount, billRcptInfo.getReceiptDate(), demandDetail.getAmtCollected());
            if (!LOGGER.isDebugEnabled()) continue;
            LOGGER.debug((Object)("Persisted demand and receipt details for tax : " + reason + " installment : " + instDesc + " with receipt No : " + billRcptInfo.getReceiptNum() + " for Rs. " + rcptAccInfo.getCrAmount()));
        }
    }

    public EgDemandDetails insertAdvanceCollection(String demandReason, BigDecimal advanceCollectionAmount, Installment installment) {
        EgDemandDetails demandDetail = null;
        if (advanceCollectionAmount != null && advanceCollectionAmount.compareTo(BigDecimal.ZERO) > 0) {
            EgDemandReasonMaster egDemandReasonMaster = this.demandGenericDAO.getDemandReasonMasterByCode("WTADVANCE", this.module());
            if (egDemandReasonMaster == null) {
                throw new ApplicationRuntimeException(" Advance Demand reason Master is null in method  insertAdvanceCollection");
            }
            EgDemandReason egDemandReason = this.demandGenericDAO.getDmdReasonByDmdReasonMsterInstallAndMod(egDemandReasonMaster, installment, this.module());
            if (egDemandReason == null) {
                throw new ApplicationRuntimeException(" Advance Demand reason is null in method  insertAdvanceCollection ");
            }
            demandDetail = this.createDemandDetails(egDemandReason, advanceCollectionAmount, BigDecimal.ZERO);
        }
        return demandDetail;
    }

    public EgDemandDetails createDemandDetails(EgDemandReason egDemandReason, BigDecimal amtCollected, BigDecimal dmdAmount) {
        return EgDemandDetails.fromReasonAndAmounts((BigDecimal)dmdAmount, (EgDemandReason)egDemandReason, (BigDecimal)amtCollected);
    }

    protected Module module() {
        return this.moduleService.getModuleByName("Water Tax Management");
    }

    public EgDemand getCurrentDemand(Long billId) {
        EgBill egBill = this.egBillDAO.findById(billId, false);
        WaterConnectionDetails waterconndet = null;
        EgDemand demand = null;
        if (egBill.getEgDemand() != null && egBill.getEgDemand().getIsHistory() != null && egBill.getEgDemand().getIsHistory().equals("N")) {
            demand = egBill.getEgDemand();
        } else {
            waterconndet = this.waterConnectionDetailsService.getWaterConnectionDetailsByDemand(egBill.getEgDemand());
            for (WaterDemandConnection waterDemand : waterconndet.getWaterDemandConnection()) {
                if (waterDemand == null || waterDemand.getDemand() == null || !waterDemand.getDemand().getIsHistory().equals("N")) continue;
                demand = waterDemand.getDemand();
            }
        }
        return demand;
    }

    @Transactional
    private void updateCollectionForRcptCancel(EgDemand demand, BillReceiptInfo billRcptInfo) {
        LOGGER.debug((Object)("reconcileCollForRcptCancel : Updating Collection Started For Demand : " + demand + " with BillReceiptInfo - " + billRcptInfo));
        try {
            this.cancelBill(Long.valueOf(billRcptInfo.getBillReferenceNum()));
            this.updateDmdDetForRcptCancel(demand, billRcptInfo);
            LOGGER.debug((Object)("reconcileCollForRcptCancel : Updating Collection finished For Demand : " + demand));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ApplicationRuntimeException("Error occured during back update of DCB : " + e.getMessage(), (Throwable)e);
        }
    }

    @Transactional
    private void cancelBill(Long billId) {
        if (billId != null) {
            EgBill egBill = this.egBillDAO.findById(billId, false);
            egBill.setIs_Cancelled("Y");
        }
    }

    @Transactional
    private void updateDmdDetForRcptCancel(EgDemand demand, BillReceiptInfo billRcptInfo) {
        LOGGER.debug((Object)"Entering method updateDmdDetForRcptCancel");
        String installment = "";
        for (ReceiptAccountInfo rcptAccInfo : billRcptInfo.getAccountDetails()) {
            if (rcptAccInfo.getCrAmount() == null || rcptAccInfo.getCrAmount().compareTo(BigDecimal.ZERO) != 1 || rcptAccInfo.getIsRevenueAccount()) continue;
            String[] desc = rcptAccInfo.getDescription().split("-", 2);
            String reason = desc[0].trim();
            String[] installsplit = desc[1].split("#");
            installment = installsplit[0].trim();
            for (EgDemandDetails demandDetail : demand.getEgDemandDetails()) {
                if (!reason.equalsIgnoreCase(demandDetail.getEgDemandReason().getEgDemandReasonMaster().getReasonMaster()) || !installment.equalsIgnoreCase(demandDetail.getEgDemandReason().getEgInstallmentMaster().getDescription())) continue;
                if (demandDetail.getAmtCollected().compareTo(rcptAccInfo.getCrAmount()) < 0) {
                    throw new ApplicationRuntimeException("updateDmdDetForRcptCancel : Exception while updating cancel receipt, to be deducted amount " + rcptAccInfo.getCrAmount() + " is greater than the collected amount " + demandDetail.getAmtCollected() + " for demandDetail " + demandDetail);
                }
                demandDetail.setAmtCollected(demandDetail.getAmtCollected().subtract(rcptAccInfo.getCrAmount()));
                if (demand.getAmtCollected() != null && demand.getAmtCollected().compareTo(BigDecimal.ZERO) > 0 && demandDetail.getEgDemandReason().getEgDemandReasonMaster().getIsDemand().booleanValue()) {
                    demand.setAmtCollected(demand.getAmtCollected().subtract(rcptAccInfo.getCrAmount()));
                }
                LOGGER.info((Object)("Deducted Collected amount Rs." + rcptAccInfo.getCrAmount() + " for tax : " + reason + " and installment : " + installment));
            }
        }
        this.updateReceiptStatusWhenCancelled(billRcptInfo.getReceiptNum());
        LOGGER.debug((Object)"Exiting method updateDmdDetForRcptCancel");
    }

    @Transactional
    private void updateWaterConnDetailsStatus(EgDemand demand, BillReceiptInfo billRcptInfo) {
        WaterConnectionDetails waterConnectionDetails = this.waterConnectionDetailsService.getWaterConnectionDetailsByDemand(demand);
        StateHistory stateHistory = null;
        if (waterConnectionDetails.getStatus().getCode().equalsIgnoreCase("ESTIMATIONAMOUNTPAID")) {
            Position owner;
            waterConnectionDetails.setStatus(this.waterTaxUtils.getStatusByCodeAndModuleType("ESTIMATIONNOTICEGENERATED", "WATERTAXAPPLICATION"));
            Long approvalPosition = 0L;
            if (!waterConnectionDetails.getStateHistory().isEmpty() && waterConnectionDetails.getStateHistory() != null) {
                Collections.reverse(waterConnectionDetails.getStateHistory());
            }
            if ((owner = (stateHistory = (StateHistory)waterConnectionDetails.getStateHistory().get(0)).getOwnerPosition()) != null) {
                approvalPosition = owner.getId();
            }
            ApplicationWorkflowCustomDefaultImpl applicationWorkflowCustomDefaultImpl = this.waterConnectionDetailsService.getInitialisedWorkFlowBean();
            applicationWorkflowCustomDefaultImpl.createCommonWorkflowTransition(waterConnectionDetails, approvalPosition, "Receipt Cancelled", "NEWCONNECTION", null);
        }
    }

    private void updateWaterTaxIndexes(EgDemand demand) {
        WaterConnectionDetails waterConnectionDetails = this.waterConnectionDetailsService.getWaterConnectionDetailsByDemand(demand);
        String sourceChannel = null;
        this.waterConnectionDetailsService.updateIndexes(waterConnectionDetails, sourceChannel);
    }

    @Transactional
    public void apportionCollection(String billRefNo, BigDecimal amtPaid, List<ReceiptDetail> receiptDetails) {
        CollectionApportioner apportioner = new CollectionApportioner();
        Map<String, BigDecimal> instDemand = this.getInstDemand(receiptDetails);
        apportioner.apportion(amtPaid, receiptDetails, instDemand);
    }

    public Map<String, BigDecimal> getInstDemand(List<ReceiptDetail> receiptDetails) {
        HashMap<String, BigDecimal> retMap = new HashMap<String, BigDecimal>();
        String installment = "";
        for (ReceiptDetail rd : receiptDetails) {
            String glCode = rd.getAccounthead().getGlcode();
            installment = "";
            String[] desc = rd.getDescription().split("-", 2);
            String[] installsplit = desc[1].split("#");
            installment = installsplit[0].trim();
            if (WaterTaxConstants.GLCODEMAP_FOR_CURRENTTAX.containsValue(glCode)) {
                if (retMap.get(installment) == null) {
                    retMap.put(installment, rd.getCramountToBePaid());
                } else {
                    retMap.put(installment, ((BigDecimal)retMap.get(installment)).add(rd.getCramountToBePaid()));
                }
            }
            if (!WaterTaxConstants.GLCODES_FOR_CURRENTTAX.contains(glCode)) continue;
            this.prepareTaxMap(retMap, installment, rd, "FULLTAX");
        }
        return retMap;
    }

    private void prepareTaxMap(Map<String, BigDecimal> retMap, String installment, ReceiptDetail rd, String type) {
        if (retMap.get(installment + type) == null) {
            retMap.put(installment + type, rd.getCramountToBePaid());
        } else {
            retMap.put(installment + type, retMap.get(installment + type).add(rd.getCramountToBePaid()));
        }
    }

    public List<ReceiptDetail> reconstructReceiptDetail(String billReferenceNumber, BigDecimal actualAmountPaid, List<ReceiptDetail> receiptDetailList) {
        Long billID = Long.valueOf(billReferenceNumber);
        ArrayList<EgBillDetails> billDetails = new ArrayList<EgBillDetails>(0);
        EgBill bill = this.connectionBillService.updateBillWithLatest(billID);
        LOGGER.debug((Object)("Reconstruct consumer code :" + bill.getConsumerId() + ", with bill reference number: " + billReferenceNumber + ", for Amount Paid :" + actualAmountPaid));
        CollectionApportioner apportioner = new CollectionApportioner();
        billDetails.addAll(bill.getEgBillDetails());
        return apportioner.reConstruct(actualAmountPaid, billDetails, this.functionDAO, this.chartOfAccountsDAO);
    }

    public String constructAdditionalInfoForReceipt(BillReceiptInfo billReceiptInfo) {
        StringBuilder additionalInfo = new StringBuilder("Paid From");
        SimpleDateFormat formatter = new SimpleDateFormat("dd/MM/yyyy");
        EgBill egBill = this.egBillDAO.findById(Long.valueOf(billReceiptInfo.getBillReferenceNum()), false);
        BigDecimal amounttobeCalc = egBill.getTotalAmount().subtract(egBill.getTotalCollectedAmount());
        List reciptDetailList = this.collectionService.getReceiptDetailListByReceiptNumber(billReceiptInfo.getReceiptNum());
        for (EgBillDetails billDet : egBill.getEgBillDetails()) {
            if (billDet.getOrderNo() == 1) {
                additionalInfo.append(" ").append(formatter.format(billDet.getEgDemandReason().getEgInstallmentMaster().getFromDate())).append(" To ");
                if (egBill.getEgBillDetails().size() == 1) {
                    additionalInfo.append(formatter.format(billDet.getEgDemandReason().getEgInstallmentMaster().getToDate()));
                    break;
                }
            }
            if (egBill.getEgBillDetails().size() <= 1 || billDet.getCrAmount().compareTo(BigDecimal.ZERO) != 1 || !((ReceiptDetail)reciptDetailList.get(0)).getOrdernumber().equals(billDet.getOrderNo())) continue;
            additionalInfo.append(formatter.format(billDet.getEgDemandReason().getEgInstallmentMaster().getToDate()));
            break;
        }
        if (amounttobeCalc.compareTo(BigDecimal.ZERO) == 1) {
            additionalInfo = additionalInfo.append(" (Partialy)");
        }
        return additionalInfo.toString();
    }

    public ReceiptAmountInfo receiptAmountBifurcation(BillReceiptInfo billReceiptInfo) {
        ReceiptAmountInfo receiptAmountInfo = new ReceiptAmountInfo();
        SimpleDateFormat formatter = new SimpleDateFormat("dd/MM/yyyy");
        EgBill egBill = this.egBillDAO.findById(Long.valueOf(billReceiptInfo.getBillReferenceNum()), false);
        ArrayList billDetails = new ArrayList(egBill.getEgBillDetails());
        CFinancialYear financialyear = this.financialYearDAO.getFinancialYearByDate(new Date());
        BigDecimal currentInstallmentAmount = BigDecimal.ZERO;
        BigDecimal advanceInstallmentAmount = BigDecimal.ZERO;
        BigDecimal arrearAmount = BigDecimal.ZERO;
        WaterConnectionDetails waterConnectionDetails = this.waterConnectionDetailsService.getWaterConnectionDetailsByDemand(egBill.getEgDemand());
        List reciptDetailList = this.collectionService.getReceiptDetailListByReceiptNumber(billReceiptInfo.getReceiptNum());
        for (ReceiptAccountInfo rcptAccInfo : billReceiptInfo.getAccountDetails()) {
            if (rcptAccInfo.getCrAmount() == null || rcptAccInfo.getCrAmount().compareTo(BigDecimal.ZERO) != 1) continue;
            String[] desc = rcptAccInfo.getDescription().split("-", 2);
            String[] installsplit = desc[1].split("#");
            String[] installsplit1 = installsplit[0].split("-");
            if (waterConnectionDetails != null && (waterConnectionDetails.getConnectionType().equals((Object)ConnectionType.NON_METERED) || waterConnectionDetails.getConnectionStatus().equals((Object)ConnectionStatus.INPROGRESS))) {
                if (installsplit1[0].trim().equals(financialyear != null ? financialyear.getFinYearRange().split("-")[0] : null)) {
                    currentInstallmentAmount = currentInstallmentAmount.add(rcptAccInfo.getCrAmount());
                    continue;
                }
                if (rcptAccInfo.getDescription().contains("Advance")) {
                    advanceInstallmentAmount = advanceInstallmentAmount.add(rcptAccInfo.getCrAmount());
                    continue;
                }
                arrearAmount = arrearAmount.add(rcptAccInfo.getCrAmount());
                continue;
            }
            if (installsplit[0].split("/")[1].split("-")[1].trim().equals(financialyear.getFinYearRange().split("-")[1].trim())) {
                currentInstallmentAmount = currentInstallmentAmount.add(rcptAccInfo.getCrAmount());
                continue;
            }
            if (rcptAccInfo.getDescription().contains("Advance")) {
                advanceInstallmentAmount = advanceInstallmentAmount.add(rcptAccInfo.getCrAmount());
                continue;
            }
            arrearAmount = arrearAmount.add(rcptAccInfo.getCrAmount());
        }
        for (EgBillDetails billDet : egBill.getEgBillDetails()) {
            if (billDet.getOrderNo() == 1) {
                receiptAmountInfo.setInstallmentFrom(formatter.format(billDet.getEgDemandReason().getEgInstallmentMaster().getFromDate()));
                if (billDetails.size() == 1) {
                    receiptAmountInfo.setInstallmentTo(formatter.format(billDet.getEgDemandReason().getEgInstallmentMaster().getToDate()));
                    break;
                }
            }
            if (egBill.getEgBillDetails().size() <= 1 || billDet.getCrAmount().compareTo(BigDecimal.ZERO) != 1 || !((ReceiptDetail)reciptDetailList.get(0)).getOrdernumber().equals(billDet.getOrderNo())) continue;
            receiptAmountInfo.setInstallmentTo(formatter.format(billDet.getEgDemandReason().getEgInstallmentMaster().getToDate()));
            break;
        }
        receiptAmountInfo.setArrearsAmount(arrearAmount);
        receiptAmountInfo.setAdvanceAmount(advanceInstallmentAmount);
        receiptAmountInfo.setCurrentInstallmentAmount(currentInstallmentAmount);
        return receiptAmountInfo;
    }
}

