/*
 * Decompiled with CFR 0.152.
 */
package org.egov.wtms.application.entity;

import java.util.Collections;
import java.util.Date;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.validation.constraints.NotNull;
import org.egov.infra.filestore.entity.FileStoreMapper;
import org.egov.infra.persistence.entity.AbstractAuditable;
import org.egov.wtms.application.entity.WaterConnectionDetails;
import org.egov.wtms.masters.entity.DocumentNames;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.SafeHtml;
import org.springframework.web.multipart.MultipartFile;

@Entity
@Table(name="egwtr_application_documents")
@SequenceGenerator(name="SEQ_EGWTR_APPLICATION_DOCUMENTS", sequenceName="SEQ_EGWTR_APPLICATION_DOCUMENTS", allocationSize=1)
public class ApplicationDocuments
extends AbstractAuditable {
    private static final long serialVersionUID = -4555037259173138199L;
    public static final String SEQ_APPLICATIONDOCUMENTS = "SEQ_EGWTR_APPLICATION_DOCUMENTS";
    @Id
    @GeneratedValue(generator="SEQ_EGWTR_APPLICATION_DOCUMENTS", strategy=GenerationType.SEQUENCE)
    private Long id;
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="connectiondetailsid", nullable=false)
    private WaterConnectionDetails waterConnectionDetails;
    @ManyToOne
    @NotNull
    @JoinColumn(name="documentnamesid", nullable=false)
    private DocumentNames documentNames;
    @NotNull
    @SafeHtml
    @Length(max=50)
    private String documentNumber;
    @NotNull
    @Temporal(value=TemporalType.DATE)
    private Date documentDate;
    @SafeHtml
    @Length(max=255)
    private String description;
    @OneToMany(fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @JoinTable(name="egwtr_documents", joinColumns={@JoinColumn(name="applicationdocumentsid")}, inverseJoinColumns={@JoinColumn(name="filestoreid")})
    private Set<FileStoreMapper> supportDocs = Collections.emptySet();
    private transient MultipartFile[] files;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public WaterConnectionDetails getWaterConnectionDetails() {
        return this.waterConnectionDetails;
    }

    public void setWaterConnectionDetails(WaterConnectionDetails waterConnectionDetails) {
        this.waterConnectionDetails = waterConnectionDetails;
    }

    public DocumentNames getDocumentNames() {
        return this.documentNames;
    }

    public void setDocumentNames(DocumentNames documentNames) {
        this.documentNames = documentNames;
    }

    public String getDocumentNumber() {
        return this.documentNumber;
    }

    public void setDocumentNumber(String documentNumber) {
        this.documentNumber = documentNumber;
    }

    public Date getDocumentDate() {
        return this.documentDate;
    }

    public void setDocumentDate(Date documentDate) {
        this.documentDate = documentDate;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Set<FileStoreMapper> getSupportDocs() {
        return this.supportDocs;
    }

    public void setSupportDocs(Set<FileStoreMapper> supportDocs) {
        this.supportDocs = supportDocs;
    }

    public MultipartFile[] getFiles() {
        return this.files;
    }

    public void setFiles(MultipartFile[] files) {
        this.files = files;
    }
}

