/*
 * Decompiled with CFR 0.152.
 */
package org.egov.wtms.utils;

import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.egov.infra.utils.autonumber.AutonumberServiceBeanResolver;
import org.egov.wtms.application.service.WaterConnectionService;
import org.egov.wtms.autonumber.ConsumerNumberGenerator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class WaterTaxNumberGenerator {
    @PersistenceContext
    private EntityManager entityManager;
    @Autowired
    private WaterConnectionService waterConnectionService;
    @Autowired
    private AutonumberServiceBeanResolver beanResolver;

    @Transactional
    public String getNextConsumerNumber() {
        Boolean cosumerCodeExists = true;
        String consumerCode = null;
        ConsumerNumberGenerator consumerGen = (ConsumerNumberGenerator)this.beanResolver.getAutoNumberServiceFor(ConsumerNumberGenerator.class);
        while (cosumerCodeExists.booleanValue()) {
            consumerCode = consumerGen.generateConsumerNumber();
            if (this.waterConnectionService.findByConsumerCode(consumerCode) != null) {
                cosumerCodeExists = true;
                continue;
            }
            cosumerCodeExists = false;
            break;
        }
        return consumerCode;
    }
}

