/*
 * Decompiled with CFR 0.152.
 */
package org.egov.wtms.masters.service;

import java.util.List;
import org.egov.wtms.masters.entity.MeterCost;
import org.egov.wtms.masters.entity.PipeSize;
import org.egov.wtms.masters.repository.MeterCostRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class MeterCostService {
    private final MeterCostRepository meterCostRepository;

    @Autowired
    public MeterCostService(MeterCostRepository meterCostRepository) {
        this.meterCostRepository = meterCostRepository;
    }

    public MeterCost findOne(Long meterCostId) {
        return (MeterCost)((Object)this.meterCostRepository.findOne(meterCostId));
    }

    @Transactional
    public MeterCost createMeterCost(MeterCost meterCost) {
        meterCost.setActive(true);
        return (MeterCost)((Object)this.meterCostRepository.save((Object)meterCost));
    }

    @Transactional
    public void updateMeterCost(MeterCost MeterCost2) {
        this.meterCostRepository.save((Object)MeterCost2);
    }

    public List<MeterCost> findAll() {
        return this.meterCostRepository.findAll(new Sort(Sort.Direction.DESC, new String[]{"meterMake"}));
    }

    public List<MeterCost> findByMeterMake(String meterMake) {
        return this.meterCostRepository.findByMeterMake(meterMake);
    }

    public List<MeterCost> findByPipeSize(PipeSize pipeSize) {
        return this.meterCostRepository.findByPipeSize(pipeSize);
    }

    public MeterCost load(Long id) {
        return (MeterCost)((Object)this.meterCostRepository.getOne(id));
    }

    public Page<MeterCost> getListOfMeterMake(Integer pageNumber, Integer pageSize) {
        PageRequest pageable = new PageRequest(pageNumber - 1, pageSize.intValue(), Sort.Direction.ASC, new String[]{"meterMake"});
        return this.meterCostRepository.findAll((Pageable)pageable);
    }

    public MeterCost findByMeterMakeandPipeSize(String meterMake, PipeSize pipeSize) {
        return this.meterCostRepository.findByMeterMakeAndPipeSize(meterMake, pipeSize);
    }
}

